import os
import pytest

import pandas as pd
import numpy as np

from astrocabtools.mrs_subviz.src.io.miri_cube_load import get_miri_cube_data


DATA = os.path.join(os.path.dirname(__file__), 'templates')

FVALUES_RECTANGLE= [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.03617441621875757, 0.07582003582215296, 0.08560150174140917, 0.08874506164574608, 0.08668456792044625, 0.0830509573023318, 0.08276943441033349, 0.08154520035076128, 0.0840620181651114, 0.08398320363926874, 0.08560022347617136, 0.0856499281301497, 0.08369258863496766, 0.0850499225633143, 0.08376596895933137, 0.08076342638301837, 0.08330151675200448, 0.08460754662060724, 0.08519840683794007, 0.08424540657973276, 0.08369397509193406, 0.08436067313146577, 0.08447671820569025, 0.08409534293484675, 0.08347546787118898, 0.08583384662699685, 0.08634398665571198, 0.08669140975928293, 0.08916534930253014, 0.09003681135106072, 0.08899477216243729, 0.08602978928923592, 0.08448512624859796, 0.082833081486225, 0.08472572976946817, 0.08785931256461128, 0.08939498252558693, 0.08927256730556474, 0.08752824129557595, 0.08705706460022912, 0.08863386917090402, 0.08759724414825425, 0.0863866136243342, 0.08511799233388886, 0.08563268729162202, 0.0862303200821875, 0.08676291132569298, 0.08686592473483071, 0.08736619756340966, 0.08610226286387429, 0.0868699135177134, 0.08668088138747201, 0.08682991806960091, 0.08665605567908273, 0.08890147883558258, 0.08930343514990792, 0.08761658012819276, 0.08782832050013528, 0.08925199885582909, 0.08943595742368683, 0.08888144333028779, 0.0870036035752295, 0.086964287616968, 0.08857574044561371, 0.08867119531726822, 0.08713062238192544, 0.08707744929575906, 0.08602163312125191, 0.08585373730421052, 0.08535529629325853, 0.08853604781985268, 0.08644088179397569, 0.0865881719524859, 0.08463457108259187, 0.08560933791375146, 0.0853604866340159, 0.08773859578299507, 0.08532753395223604, 0.08322530684185014, 0.08524312265110001, 0.08531978650856004, 0.08792970817112908, 0.08798082847666726, 0.08602852533507332, 0.08698769481158242, 0.08675778567099557, 0.08663563606452927, 0.08644003858542428, 0.08665559429001794, 0.08757894657993302, 0.08755024028038964, 0.08671061007022843, 0.08723203924751267, 0.08941749098467812, 0.08772740509462341, 0.08887330032849297, 0.08769727054977403, 0.08827212010860429, 0.08800526492381082, 0.08915064839363084, 0.09087068106722816, 0.09019137783265099, 0.0895829121305941, 0.09043541200447068, 0.09045794622349725, 0.0893810956306456, 0.08989192430829987, 0.08991008449029908, 0.09168236518216118, 0.09148722737479195, 0.09172527665495857, 0.09207933036589608, 0.09335302235651001, 0.09259152546501144, 0.09330967868924125, 0.09275497969675049, 0.09181036343884452, 0.09017621095514282, 0.09028261265444741, 0.09004085108137116, 0.08952710351681695, 0.08843320786094651, 0.0905031663589476, 0.09098062905096993, 0.08964780369758592, 0.09056350643157944, 0.08976896183276162, 0.08806638180160507, 0.08727903968071923, 0.08834400463938698, 0.08840460288381562, 0.08928352958917603, 0.08875300257515893, 0.09015189701080308, 0.09098904453563675, 0.09138513101935372, 0.09464414122962936, 0.09183746231842026, 0.0908468617136477, 0.09115135960578903, 0.09106170987868294, 0.09152632694959625, 0.0899667740938662, 0.08840454506707177, 0.08941346270322785, 0.08981115603446946, 0.08885144330954536, 0.08982355858468995, 0.08931143904805168, 0.09067062253975854, 0.09266642734289154, 0.09027880132889733, 0.08940210657882676, 0.08993718565964684, 0.09081320549941048, 0.0937024278302191, 0.09357771539640411, 0.09276831761884674, 0.09182435795307144, 0.0922508984048365, 0.0919737856137751, 0.09264686295819267, 0.09229742428278907, 0.09222417676520332, 0.09126315200090393, 0.09101782296299919, 0.09228284186959251, 0.09230136498045906, 0.09353416564965232, 0.09182629510021194, 0.09193093596482262, 0.09051436048197731, 0.09057585746192917, 0.09119082096457466, 0.09043505880713448, 0.09259366010498986, 0.09038490764760956, 0.08895709453606591, 0.0910257684719561, 0.0901873415369986, 0.09156491533279404, 0.0923790632424353, 0.09158035068607315, 0.09134641269159302, 0.09096245627522453, 0.09134138320732102, 0.0918261016144751, 0.09315381963133797, 0.0939790843842028, 0.09262838278055176, 0.09131835096287712, 0.08955965548849092, 0.0912527180821894, 0.0925724247591494, 0.09240016921615585, 0.09105447877860054, 0.09131293851423249, 0.09019517255735382, 0.09068971236920342, 0.0909582946145533, 0.09030148266577706, 0.092784239548683, 0.09241083955383285, 0.0926859980244635, 0.09187649148273452, 0.09168030896687493, 0.09296706181716903, 0.09412719256377204, 0.0916319518437384, 0.09318622849225983, 0.09284978083848938, 0.0960501036190985, 0.09554387738323196, 0.09723896585273727, 0.09237040046238884, 0.09482993791198714, 0.0942854009277819, 0.09322240460062012, 0.09222152062964424, 0.09421789444112762, 0.09391367074918731, 0.09473416647934899, 0.09421345113849625, 0.09383993207550033, 0.09533051528024658, 0.09532421840715392, 0.09390729545140251, 0.09248583187770829, 0.09321054987835868, 0.09340424455690369, 0.09239045142364487, 0.09179673242592797, 0.09398408467388138, 0.09352103037238106, 0.09579280422544463, 0.09492126718687996, 0.09385562560057624, 0.09507189583301529, 0.09516002915859206, 0.09687129028797134, 0.0954760320103167, 0.09553435937333091, 0.09825033583474142, 0.0961740747392176, 0.09453345479440674, 0.09475430788660033, 0.0949369635741709, 0.09484813129568084, 0.09452334545087798, 0.09375998754715904, 0.0941449142544268, 0.09582234285712227, 0.09508769754981979, 0.09529638336586936, 0.09460542919874175, 0.09675140927314742, 0.09643883134794219, 0.0966627023596762, 0.09713552998065933, 0.0961901890099047, 0.09807008612513526, 0.0995190143694876, 0.09759485138130172, 0.09640723650097831, 0.09761684578657134, 0.09751077782154068, 0.09626846772909148, 0.09592209792065605, 0.0964659765954016, 0.09687103841304763, 0.09845934336376173, 0.09813549174594863, 0.09608880191135391, 0.09810982340145095, 0.0991728512129782, 0.09608409414005263, 0.09814182983493788, 0.09726511161470397, 0.09807572068166716, 0.09847844922161086, 0.09820333425664886, 0.09763152551507934, 0.09622215022039397, 0.09718180627346022, 0.09886528674364073, 0.09834247339916213, 0.0975260311379431, 0.09758735237789137, 0.09785666735029204, 0.09828809589290603, 0.09763684809017165, 0.09955788439464552, 0.09791053767204269, 0.09664445745611175, 0.09734812272024139, 0.10049381840944273, 0.09845874573326094, 0.09853422806835158, 0.09881259679937346, 0.09900367369604095, 0.09906765565109237, 0.10139648203659041, 0.10145568523740751, 0.10393411044406874, 0.09924736955404265, 0.09945923643589004, 0.1000003427691458, 0.1000671308398245, 0.09993798082780822, 0.10016223881101592, 0.10016210714912398, 0.10032821293687803, 0.10085428004741652, 0.10115395625209792, 0.10046448185014709, 0.10055075244617445, 0.10154080980253202, 0.10005062730789167, 0.10056895269918426, 0.10253512384510023, 0.10075862138605102, 0.10162159410476668, 0.09967733722209914, 0.09897076623725874, 0.09819904665851577, 0.10071662925672514, 0.10084234804534896, 0.10021518291997893, 0.09879185833406431, 0.09923803529834731, 0.10041755640697463, 0.10168663393449766, 0.10205446119666083, 0.1001948394403456, 0.1005006602482794, 0.09986136047601683, 0.10009677422857267, 0.10051307310247405, 0.10069144977855665, 0.10123112500429136, 0.10091777428102476, 0.10171432758235914, 0.10148297703027709, 0.10172875200128538, 0.10254146994829161, 0.1002694837188719, 0.10059707338953001, 0.10142588614416105, 0.09823958421015723, 0.1017799364204405, 0.10006366870450957, 0.09862247359275801, 0.10071360561275465, 0.10112114839839918, 0.10009615541768058, 0.09936304883718475, 0.10138742598819715, 0.10147905236101133, 0.1046423174710272, 0.10140747065258009, 0.09865795933485015, 0.09999886014175398, 0.0992612375583647, 0.09642650893974289, 0.09704767600727066, 0.09935762551212295, 0.10045862117862685, 0.10049859945344908, 0.10102295266962034, 0.0989759216589926, 0.10434010534381849, 0.10338154265689832, 0.10368822212934477, 0.1046315795850752, 0.10246359365653974, 0.1024586706466673, 0.10262460584640486, 0.10269870286941511, 0.10195864797568305, 0.10256474204635603, 0.10086935018205626, 0.10110486926412565, 0.10181588584136946, 0.10032560316920264, 0.10298065623855573, 0.10280225323009475, 0.10317917031478865, 0.10401165929841978, 0.10159379283761961, 0.10477456096506102, 0.10265827694416028, 0.10199481435251219, 0.10328048471307738, 0.10302166491079313, 0.10448814711999876, 0.10394801851940137, 0.10296731602668745, 0.10391603154897673, 0.10334427776193601, 0.10414292162513715, 0.10400867458057386, 0.1029253113036154, 0.10312763212585432, 0.10344916763925535, 0.10357052784681303, 0.10254289418649656, 0.10199412627601606, 0.10447666276836377, 0.10500704266452772, 0.10532893080282194, 0.1044538554940222, 0.1045278609261511, 0.10598850879621488, 0.10446866802930814, 0.1062072965140341, 0.10635872715282423, 0.10697023596191388, 0.11053536522293073, 0.1093705307121275, 0.10758803706455213, 0.1069486376872061, 0.10657869753789884, 0.1042544587106703, 0.10491341045141203, 0.10617874191188795, 0.10354063258314115, 0.10319809070110304, 0.10561115207529051, 0.10572883490896208, 0.10607289834451658, 0.1116225146379469, 0.11749150489997845, 0.122291708573818, 0.12901239328241326, 0.13450091502332664, 0.1367793194837568, 0.1402838911437986, 0.13823617320156076, 0.13334048832368828, 0.12383663264846781, 0.11471076223659496, 0.1112185702290533, 0.10700800689649564, 0.1059054793725012, 0.10441363335847838, 0.10411573516178114, 0.10472024986219389, 0.1047156428408621, 0.10559665781831724, 0.10487634591150266, 0.10439838805627806, 0.10553883649492246, 0.10764913734149915, 0.10538668114328367, 0.10423161594486219, 0.10280772349548323, 0.10371289900255186, 0.10341348841142638, 0.10421255359268171, 0.10463058124446852, 0.1045226551294325, 0.10324944227361663, 0.10482203137397748, 0.10479056990623457, 0.10471055382251722, 0.10312076166486724, 0.10317127403593046, 0.10277023191308958, 0.10502774792814237, 0.10603802282667142, 0.10741921560716611, 0.10633564854049665, 0.10805370342349988, 0.10638138559198362, 0.10622580932092648, 0.10770246498727781, 0.10839967996358854, 0.10587984651947004, 0.10747342596006376, 0.106322283141136, 0.10754372883081419, 0.10644324263858777, 0.10390709342384322, 0.10641521926355345, 0.10667561786365491, 0.10240111150217039, 0.10390595884180051, 0.10614779678773863, 0.10575967584848386, 0.10700039225959761, 0.10781366433143598, 0.10562733503913863, 0.10410250943851454, 0.10442043741607648, 0.10568809642982466, 0.10526997833204252, 0.1089831413550375, 0.10851049462604505, 0.10588052085733396, 0.1067877079291342, 0.10908441797208768, 0.1048579372892378, 0.10615551102972014, 0.10673397842836363, 0.1058230475792883, 0.106332002078533, 0.11007343577194195, 0.10676955690622313, 0.10615895599174482, 0.10724384654664976, 0.10850378444910032, 0.10773516522169095, 0.10611436611604673, 0.1078698644962309, 0.10852672567510586, 0.10851568210458737, 0.10748023116254789, 0.10886553637361508, 0.10857890385532361, 0.10956855706691723, 0.11041065965843182, 0.10783913232088072, 0.10849775089979154, 0.10978862362241727, 0.10884438345956784, 0.10790455683231336, 0.10835654867267591, 0.1082548747801779, 0.1083981824526785, 0.10965550429058057, 0.1075544884696005, 0.10875998246240598, 0.10858311131143553, 0.10823812738752348, 0.10864520649433118, 0.11018128517961484, 0.10996581076192838, 0.10997504999208432, 0.1087873395137785, 0.10852385773563367, 0.10832880808448773, 0.10797424718904478, 0.10706538858365995, 0.1064168610301016, 0.10856234765863401, 0.10880780549621565, 0.10792080619955045, 0.10976199586343748, 0.10868147533845883, 0.10805631948804838, 0.10867800633382779, 0.1075832777733801, 0.10855817683887464, 0.10791217948341351, 0.10757854939413053, 0.10955855763244611, 0.10740047382307034, 0.10763549144506436, 0.10838030276775343, 0.10724334852123242, 0.10889997111034375, 0.10947913230991345, 0.10774922213220578, 0.10635731321859342, 0.10981414771127683, 0.10718250240898114, 0.10710416243839246, 0.10632452368307097, 0.10604382052946074, 0.10818207834768277, 0.10860748707962019, 0.10747314660787564, 0.10699911113214475, 0.10605681155109388, 0.1069376009860037, 0.10694111235141736, 0.1079620358347891, 0.10689417316961271, 0.10767580402660352, 0.10811084010505659, 0.10861935611295682, 0.10916444893932324, 0.10905505279064161, 0.110224724444866, 0.10993639406061154, 0.1099976866784094, 0.11228679925775509, 0.11043881355047208, 0.11093053980493527, 0.11032591977500897, 0.11239914119815808, 0.1112765827484129, 0.11212669839715939, 0.11235009542608243, 0.10983894823217374, 0.11038391054153424, 0.10978736768245678, 0.11016042421150189, 0.11081217232942563, 0.10920961125802976, 0.10671948417139035, 0.10731379221296293, 0.10761515368986112, 0.10569487072038633, 0.10565160891246778, 0.1066496827607153, 0.10725715355682355, 0.10996880005931836, 0.10799701095771772, 0.10778828907775861, 0.10954277308893186, 0.1099816067543028, 0.10912521941995602, 0.11029914318084698, 0.10949047698545437, 0.10929215868473034, 0.11076027808094006, 0.11394701907873135, 0.11000919507265072, 0.11170664315223676, 0.1089322912425993, 0.10989424622678738, 0.1087306985678671, 0.10848803196239454, 0.1086361275482176, 0.10933891125011426, 0.1097992481646536, 0.10748313917303068, 0.11018138821935636, 0.11126290708494167, 0.11115921819305402, 0.1112067985110281, 0.11135176054382306, 0.11133120640516263, 0.11182760150480252, 0.11105612807655316, 0.1104342065291403, 0.11399834546375255, 0.11322002905178051, 0.11456064592695217, 0.11732039252567272, 0.1165225180258749, 0.11734924479818325, 0.11716920116806011, 0.11983012464046458, 0.11473385458755474, 0.11509556415128688, 0.11382428042840939, 0.11081222842884045, 0.11367960461711865, 0.11238013036584836, 0.11239926484584789, 0.11332836503601056, 0.11503112309694272, 0.11225827327775936, 0.10997098335695249, 0.1120392096424101, 0.11020623224592191, 0.10909677014732343, 0.11008774799203855, 0.10984442651176435, 0.10987890246438962, 0.11023916603708249, 0.11101766105127316, 0.11190245300769787, 0.11063682273197156, 0.1112591163673399, 0.1114721395840643, 0.1118606303215025, 0.1118940209221838, 0.11150468983840923, 0.11097631234788877, 0.11247941717100125, 0.11507144598245601, 0.1134759362640379, 0.11251282265520077, 0.11328464183902721, 0.11243955567455273, 0.11358836292600613, 0.11372723302030545, 0.11024275182008725, 0.11087090727186184, 0.11144978224992734, 0.10883326547145826, 0.1118042755970953, 0.11070343563508969, 0.10988965637874586, 0.10841482795047742, 0.10957759937667828, 0.11031956565761548, 0.11096178030967695, 0.11010831815910321, 0.11105898571205121, 0.10904855327272397, 0.11138563428640347, 0.1102400224118231, 0.11035128243494015, 0.11013847789144497, 0.11139536352777463, 0.11078477177238447, 0.111351892205715, 0.11518743667459469, 0.11116961375808697, 0.11013012823772413, 0.11082153062772733, 0.1102095215034483, 0.10980191574907285, 0.11194710356235485, 0.11121858396768551, 0.11008460413503629, 0.11143680496692639, 0.11119062356138211, 0.11045041353559476, 0.10888398163223248, 0.11048407776403409, 0.1116993674015997, 0.1117899141469, 0.11447526719713193, 0.11073453646373731, 0.1102897791581152, 0.11228180183029156, 0.11180164464902859, 0.111436846182823, 0.11369307305622083, 0.11274328248596173, 0.11452788043403607, 0.11271961425733548, 0.11326847146892528, 0.11020882770252209, 0.11047762747621517, 0.10989538424348813, 0.10864995433664304, 0.10901469212388974, 0.10899023850345593, 0.11066760757207852, 0.11028009571218472, 0.11266239399909954, 0.11263805715703945, 0.1149635255918501, 0.11519052443218213, 0.11215416192293148, 0.11342344896459561, 0.11272931029701214, 0.11377982221460324, 0.1113519528846739, 0.11416680513715725, 0.11334846694469433, 0.1134440271458624, 0.11213934251832944, 0.11239454448080044, 0.11279651510620098, 0.11292832468843442, 0.11261369970703106, 0.11219885941791516, 0.11146162724065763, 0.11246802097558957, 0.11473467661571483, 0.11341875149726849, 0.11514112603521327, 0.11287871448755246, 0.11393112462615948, 0.11385682266855221, 0.1147710691075323, 0.11278354583740216, 0.1116200004682539, 0.11394932487916927, 0.1157118001947401, 0.11550299130344371, 0.1141026720571516, 0.11357958966445904, 0.11801563028383236, 0.11832770331430416, 0.11859601994609813, 0.11799723768997172, 0.11621355908536891, 0.1191343052802084, 0.11887291406393032, 0.11481616387796383, 0.1151974143562315, 0.11903024315547923, 0.11809841813659648, 0.11760110025882702, 0.11654110410547237, 0.11472686276864986, 0.11373811058235149, 0.11615878430366497, 0.11673143224668484, 0.11695286121654491, 0.11799918743085841, 0.11690475997543316, 0.11955358658218364, 0.12121279890346506, 0.12073309280729273, 0.12277186232042292, 0.1181675990190504, 0.11910600255298595, 0.11622444008207301, 0.11108418121862393, 0.07574756968927371, 0.07654482938528048]

WVALUES_RECTANGLE = [8.0, 8.002000000094995, 8.00400000018999, 8.006000000284985, 8.00800000037998, 8.010000000474975, 8.01200000056997, 8.014000000664964, 8.01600000075996, 8.018000000854954, 8.020000000949949, 8.022000001044944, 8.024000001139939, 8.026000001234934, 8.028000001329929, 8.030000001424924, 8.032000001519918, 8.034000001614913, 8.036000001709908, 8.038000001804903, 8.040000001899898, 8.042000001994893, 8.044000002089888, 8.046000002184883, 8.048000002279878, 8.050000002374873, 8.052000002469867, 8.054000002564862, 8.056000002659857, 8.058000002754852, 8.060000002849847, 8.062000002944842, 8.064000003039837, 8.066000003134832, 8.068000003229827, 8.070000003324822, 8.072000003419816, 8.074000003514811, 8.076000003609806, 8.078000003704801, 8.080000003799796, 8.082000003894791, 8.084000003989786, 8.08600000408478, 8.088000004179776, 8.09000000427477, 8.092000004369766, 8.09400000446476, 8.096000004559755, 8.09800000465475, 8.100000004749745, 8.10200000484474, 8.104000004939735, 8.10600000503473, 8.108000005129725, 8.11000000522472, 8.112000005319715, 8.11400000541471, 8.116000005509704, 8.1180000056047, 8.120000005699694, 8.122000005794689, 8.124000005889684, 8.126000005984679, 8.128000006079674, 8.130000006174669, 8.132000006269664, 8.134000006364658, 8.136000006459653, 8.138000006554648, 8.140000006649643, 8.142000006744638, 8.144000006839633, 8.146000006934628, 8.148000007029623, 8.150000007124618, 8.152000007219613, 8.154000007314608, 8.156000007409602, 8.158000007504597, 8.160000007599592, 8.162000007694587, 8.164000007789582, 8.166000007884577, 8.168000007979572, 8.170000008074567, 8.172000008169562, 8.174000008264557, 8.176000008359551, 8.178000008454546, 8.180000008549541, 8.182000008644536, 8.184000008739531, 8.186000008834526, 8.18800000892952, 8.190000009024516, 8.19200000911951, 8.194000009214506, 8.1960000093095, 8.198000009404495, 8.20000000949949, 8.202000009594485, 8.20400000968948, 8.206000009784475, 8.20800000987947, 8.210000009974465, 8.21200001006946, 8.214000010164455, 8.21600001025945, 8.218000010354444, 8.22000001044944, 8.222000010544434, 8.224000010639429, 8.226000010734424, 8.228000010829419, 8.230000010924414, 8.232000011019409, 8.234000011114404, 8.236000011209399, 8.238000011304393, 8.240000011399388, 8.242000011494383, 8.244000011589378, 8.246000011684373, 8.248000011779368, 8.250000011874363, 8.252000011969358, 8.254000012064353, 8.256000012159348, 8.258000012254342, 8.260000012349337, 8.262000012444332, 8.264000012539327, 8.266000012634322, 8.268000012729317, 8.270000012824312, 8.272000012919307, 8.274000013014302, 8.276000013109297, 8.278000013204291, 8.280000013299286, 8.282000013394281, 8.284000013489276, 8.286000013584271, 8.288000013679266, 8.29000001377426, 8.292000013869256, 8.29400001396425, 8.296000014059246, 8.29800001415424, 8.300000014249235, 8.30200001434423, 8.304000014439225, 8.30600001453422, 8.308000014629215, 8.31000001472421, 8.312000014819205, 8.3140000149142, 8.316000015009195, 8.31800001510419, 8.320000015199184, 8.32200001529418, 8.324000015389174, 8.32600001548417, 8.328000015579164, 8.330000015674159, 8.332000015769154, 8.334000015864149, 8.336000015959144, 8.338000016054139, 8.340000016149133, 8.342000016244128, 8.344000016339123, 8.346000016434118, 8.348000016529113, 8.350000016624108, 8.352000016719103, 8.354000016814098, 8.356000016909093, 8.358000017004088, 8.360000017099082, 8.362000017194077, 8.364000017289072, 8.366000017384067, 8.368000017479062, 8.370000017574057, 8.372000017669052, 8.374000017764047, 8.376000017859042, 8.378000017954037, 8.380000018049031, 8.382000018144026, 8.384000018239021, 8.386000018334016, 8.388000018429011, 8.390000018524006, 8.392000018619001, 8.394000018713996, 8.39600001880899, 8.398000018903986, 8.40000001899898, 8.402000019093975, 8.40400001918897, 8.406000019283965, 8.40800001937896, 8.410000019473955, 8.41200001956895, 8.414000019663945, 8.41600001975894, 8.418000019853935, 8.42000001994893, 8.422000020043924, 8.42400002013892, 8.426000020233914, 8.42800002032891, 8.430000020423904, 8.432000020518899, 8.434000020613894, 8.436000020708889, 8.438000020803884, 8.440000020898879, 8.442000020993873, 8.444000021088868, 8.446000021183863, 8.448000021278858, 8.450000021373853, 8.452000021468848, 8.454000021563843, 8.456000021658838, 8.458000021753833, 8.460000021848828, 8.462000021943823, 8.464000022038817, 8.466000022133812, 8.468000022228807, 8.470000022323802, 8.472000022418797, 8.474000022513792, 8.476000022608787, 8.478000022703782, 8.480000022798777, 8.482000022893772, 8.484000022988766, 8.486000023083761, 8.488000023178756, 8.490000023273751, 8.492000023368746, 8.494000023463741, 8.496000023558736, 8.49800002365373, 8.500000023748726, 8.50200002384372, 8.504000023938715, 8.50600002403371, 8.508000024128705, 8.5100000242237, 8.512000024318695, 8.51400002441369, 8.516000024508685, 8.51800002460368, 8.520000024698675, 8.52200002479367, 8.524000024888664, 8.52600002498366, 8.528000025078654, 8.53000002517365, 8.532000025268644, 8.534000025363639, 8.536000025458634, 8.538000025553629, 8.540000025648624, 8.542000025743619, 8.544000025838614, 8.546000025933608, 8.548000026028603, 8.550000026123598, 8.552000026218593, 8.554000026313588, 8.556000026408583, 8.558000026503578, 8.560000026598573, 8.562000026693568, 8.564000026788563, 8.566000026883557, 8.568000026978552, 8.570000027073547, 8.572000027168542, 8.574000027263537, 8.576000027358532, 8.578000027453527, 8.580000027548522, 8.582000027643517, 8.584000027738512, 8.586000027833506, 8.588000027928501, 8.590000028023496, 8.592000028118491, 8.594000028213486, 8.596000028308481, 8.598000028403476, 8.60000002849847, 8.602000028593466, 8.60400002868846, 8.606000028783455, 8.60800002887845, 8.610000028973445, 8.61200002906844, 8.614000029163435, 8.61600002925843, 8.618000029353425, 8.62000002944842, 8.622000029543415, 8.62400002963841, 8.626000029733405, 8.6280000298284, 8.630000029923394, 8.63200003001839, 8.634000030113384, 8.636000030208379, 8.638000030303374, 8.640000030398369, 8.642000030493364, 8.644000030588359, 8.646000030683354, 8.648000030778348, 8.650000030873343, 8.652000030968338, 8.654000031063333, 8.656000031158328, 8.658000031253323, 8.660000031348318, 8.662000031443313, 8.664000031538308, 8.666000031633303, 8.668000031728297, 8.670000031823292, 8.672000031918287, 8.674000032013282, 8.676000032108277, 8.678000032203272, 8.680000032298267, 8.682000032393262, 8.684000032488257, 8.686000032583252, 8.688000032678246, 8.690000032773241, 8.692000032868236, 8.694000032963231, 8.696000033058226, 8.698000033153221, 8.700000033248216, 8.70200003334321, 8.704000033438206, 8.7060000335332, 8.708000033628196, 8.71000003372319, 8.712000033818185, 8.71400003391318, 8.716000034008175, 8.71800003410317, 8.720000034198165, 8.72200003429316, 8.724000034388155, 8.72600003448315, 8.728000034578145, 8.73000003467314, 8.732000034768134, 8.73400003486313, 8.736000034958124, 8.738000035053119, 8.740000035148114, 8.742000035243109, 8.744000035338104, 8.746000035433099, 8.748000035528094, 8.750000035623088, 8.752000035718083, 8.754000035813078, 8.756000035908073, 8.758000036003068, 8.760000036098063, 8.762000036193058, 8.764000036288053, 8.766000036383048, 8.768000036478043, 8.770000036573038, 8.772000036668032, 8.774000036763027, 8.776000036858022, 8.778000036953017, 8.780000037048012, 8.782000037143007, 8.784000037238002, 8.786000037332997, 8.788000037427992, 8.790000037522987, 8.792000037617981, 8.794000037712976, 8.796000037807971, 8.798000037902966, 8.800000037997961, 8.802000038092956, 8.80400003818795, 8.806000038282946, 8.80800003837794, 8.810000038472936, 8.81200003856793, 8.814000038662925, 8.81600003875792, 8.818000038852915, 8.82000003894791, 8.822000039042905, 8.8240000391379, 8.826000039232895, 8.82800003932789, 8.830000039422885, 8.83200003951788, 8.834000039612874, 8.83600003970787, 8.838000039802864, 8.840000039897859, 8.842000039992854, 8.844000040087849, 8.846000040182844, 8.848000040277839, 8.850000040372834, 8.852000040467829, 8.854000040562823, 8.856000040657818, 8.858000040752813, 8.860000040847808, 8.862000040942803, 8.864000041037798, 8.866000041132793, 8.868000041227788, 8.870000041322783, 8.872000041417778, 8.874000041512772, 8.876000041607767, 8.878000041702762, 8.880000041797757, 8.882000041892752, 8.884000041987747, 8.886000042082742, 8.888000042177737, 8.890000042272732, 8.892000042367727, 8.894000042462721, 8.896000042557716, 8.898000042652711, 8.900000042747706, 8.902000042842701, 8.904000042937696, 8.90600004303269, 8.908000043127686, 8.91000004322268, 8.912000043317676, 8.91400004341267, 8.916000043507665, 8.91800004360266, 8.920000043697655, 8.92200004379265, 8.924000043887645, 8.92600004398264, 8.928000044077635, 8.93000004417263, 8.932000044267625, 8.93400004436262, 8.936000044457614, 8.93800004455261, 8.940000044647604, 8.9420000447426, 8.944000044837594, 8.946000044932589, 8.948000045027584, 8.950000045122579, 8.952000045217574, 8.954000045312569, 8.956000045407563, 8.958000045502558, 8.960000045597553, 8.962000045692548, 8.964000045787543, 8.966000045882538, 8.968000045977533, 8.970000046072528, 8.972000046167523, 8.974000046262518, 8.976000046357512, 8.978000046452507, 8.980000046547502, 8.982000046642497, 8.984000046737492, 8.986000046832487, 8.988000046927482, 8.990000047022477, 8.992000047117472, 8.994000047212467, 8.996000047307462, 8.998000047402456, 9.000000047497451, 9.002000047592446, 9.004000047687441, 9.006000047782436, 9.008000047877431, 9.010000047972426, 9.01200004806742, 9.014000048162416, 9.01600004825741, 9.018000048352405, 9.0200000484474, 9.022000048542395, 9.02400004863739, 9.026000048732385, 9.02800004882738, 9.030000048922375, 9.03200004901737, 9.034000049112365, 9.03600004920736, 9.038000049302354, 9.04000004939735, 9.042000049492344, 9.04400004958734, 9.046000049682334, 9.048000049777329, 9.050000049872324, 9.052000049967319, 9.054000050062314, 9.056000050157309, 9.058000050252303, 9.060000050347298, 9.062000050442293, 9.064000050537288, 9.066000050632283, 9.068000050727278, 9.070000050822273, 9.072000050917268, 9.074000051012263, 9.076000051107258, 9.078000051202253, 9.080000051297247, 9.082000051392242, 9.084000051487237, 9.086000051582232, 9.088000051677227, 9.090000051772222, 9.092000051867217, 9.094000051962212, 9.096000052057207, 9.098000052152202, 9.100000052247196, 9.102000052342191, 9.104000052437186, 9.106000052532181, 9.108000052627176, 9.110000052722171, 9.112000052817166, 9.11400005291216, 9.116000053007156, 9.11800005310215, 9.120000053197145, 9.12200005329214, 9.124000053387135, 9.12600005348213, 9.128000053577125, 9.13000005367212, 9.132000053767115, 9.13400005386211, 9.136000053957105, 9.1380000540521, 9.140000054147094, 9.14200005424209, 9.144000054337084, 9.14600005443208, 9.148000054527074, 9.150000054622069, 9.152000054717064, 9.154000054812059, 9.156000054907054, 9.158000055002049, 9.160000055097044, 9.162000055192038, 9.164000055287033, 9.166000055382028, 9.168000055477023, 9.170000055572018, 9.172000055667013, 9.174000055762008, 9.176000055857003, 9.178000055951998, 9.180000056046993, 9.182000056141987, 9.184000056236982, 9.186000056331977, 9.188000056426972, 9.190000056521967, 9.192000056616962, 9.194000056711957, 9.196000056806952, 9.198000056901947, 9.200000056996942, 9.202000057091936, 9.204000057186931, 9.206000057281926, 9.208000057376921, 9.210000057471916, 9.212000057566911, 9.214000057661906, 9.2160000577569, 9.218000057851896, 9.22000005794689, 9.222000058041885, 9.22400005813688, 9.226000058231875, 9.22800005832687, 9.230000058421865, 9.23200005851686, 9.234000058611855, 9.23600005870685, 9.238000058801845, 9.24000005889684, 9.242000058991835, 9.24400005908683, 9.246000059181824, 9.24800005927682, 9.250000059371814, 9.252000059466809, 9.254000059561804, 9.256000059656799, 9.258000059751794, 9.260000059846789, 9.262000059941784, 9.264000060036778, 9.266000060131773, 9.268000060226768, 9.270000060321763, 9.272000060416758, 9.274000060511753, 9.276000060606748, 9.278000060701743, 9.280000060796738, 9.282000060891733, 9.284000060986727, 9.286000061081722, 9.288000061176717, 9.290000061271712, 9.292000061366707, 9.294000061461702, 9.296000061556697, 9.298000061651692, 9.300000061746687, 9.302000061841682, 9.304000061936677, 9.306000062031671, 9.308000062126666, 9.310000062221661, 9.312000062316656, 9.314000062411651, 9.316000062506646, 9.31800006260164, 9.320000062696636, 9.32200006279163, 9.324000062886626, 9.32600006298162, 9.328000063076615, 9.33000006317161, 9.332000063266605, 9.3340000633616, 9.336000063456595, 9.33800006355159, 9.340000063646585, 9.34200006374158, 9.344000063836575, 9.34600006393157, 9.348000064026564, 9.35000006412156, 9.352000064216554, 9.354000064311549, 9.356000064406544, 9.358000064501539, 9.360000064596534, 9.362000064691529, 9.364000064786524, 9.366000064881518, 9.368000064976513, 9.370000065071508, 9.372000065166503, 9.374000065261498, 9.376000065356493, 9.378000065451488, 9.380000065546483, 9.382000065641478, 9.384000065736473, 9.386000065831468, 9.388000065926462, 9.390000066021457, 9.392000066116452, 9.394000066211447, 9.396000066306442, 9.398000066401437, 9.400000066496432, 9.402000066591427, 9.404000066686422, 9.406000066781417, 9.408000066876411, 9.410000066971406, 9.412000067066401, 9.414000067161396, 9.416000067256391, 9.418000067351386, 9.42000006744638, 9.422000067541376, 9.42400006763637, 9.426000067731366, 9.42800006782636, 9.430000067921355, 9.43200006801635, 9.434000068111345, 9.43600006820634, 9.438000068301335, 9.44000006839633, 9.442000068491325, 9.44400006858632, 9.446000068681315, 9.44800006877631, 9.450000068871304, 9.4520000689663, 9.454000069061294, 9.456000069156289, 9.458000069251284, 9.460000069346279, 9.462000069441274, 9.464000069536269, 9.466000069631264, 9.468000069726259, 9.470000069821253, 9.472000069916248, 9.474000070011243, 9.476000070106238, 9.478000070201233, 9.480000070296228, 9.482000070391223, 9.484000070486218, 9.486000070581213, 9.488000070676208, 9.490000070771202, 9.492000070866197, 9.494000070961192, 9.496000071056187, 9.498000071151182, 9.500000071246177, 9.502000071341172, 9.504000071436167, 9.506000071531162, 9.508000071626157, 9.510000071721151, 9.512000071816146, 9.514000071911141, 9.516000072006136, 9.518000072101131, 9.520000072196126, 9.52200007229112, 9.524000072386116, 9.52600007248111, 9.528000072576106, 9.5300000726711, 9.532000072766095, 9.53400007286109, 9.536000072956085, 9.53800007305108, 9.540000073146075, 9.54200007324107, 9.544000073336065, 9.54600007343106, 9.548000073526055, 9.55000007362105, 9.552000073716044, 9.55400007381104, 9.556000073906034, 9.55800007400103, 9.560000074096024, 9.562000074191019, 9.564000074286014, 9.566000074381009, 9.568000074476004, 9.570000074570999, 9.572000074665993, 9.574000074760988, 9.576000074855983, 9.578000074950978, 9.580000075045973, 9.582000075140968, 9.584000075235963, 9.586000075330958, 9.588000075425953, 9.590000075520948, 9.592000075615942, 9.594000075710937, 9.596000075805932, 9.598000075900927, 9.600000075995922, 9.602000076090917, 9.604000076185912, 9.606000076280907, 9.608000076375902, 9.610000076470897, 9.612000076565892, 9.614000076660886, 9.616000076755881, 9.618000076850876, 9.620000076945871, 9.622000077040866, 9.624000077135861, 9.626000077230856, 9.62800007732585, 9.630000077420846, 9.63200007751584, 9.634000077610835, 9.63600007770583, 9.638000077800825, 9.64000007789582]

FVALUES_ELLIPSE = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.010092846647291197, 0.020962850559281366, 0.03194196819330222, 0.032874993424188995, 0.03211552172670122, 0.03128433884873505, 0.031417646401676776, 0.030803281340202507, 0.03133418354189647, 0.03125638578069272, 0.031790626299758214, 0.03197643452670299, 0.030849121390384725, 0.031783051011148936, 0.031333953788622936, 0.02988700087238585, 0.03120128688753021, 0.03168207651607443, 0.031927894491273735, 0.03179738861288245, 0.0312511565697792, 0.03172219145962564, 0.03176543628589696, 0.031745259528102726, 0.03160704079715319, 0.032303699979851504, 0.03197609493954143, 0.03245950463049681, 0.03310440139913543, 0.03352830559464325, 0.03334398561301, 0.03193098083092587, 0.03166407619139267, 0.03159466782870127, 0.03162037400699359, 0.03319852731518769, 0.033650435442469, 0.03379272288350797, 0.03285899309887606, 0.03205354549644747, 0.033236986382344, 0.03263219316932441, 0.03259872993873892, 0.031691853664640154, 0.032086582645865835, 0.032045623625561744, 0.03233363647820119, 0.03253582125584962, 0.032248488560361915, 0.03199151213409553, 0.032043605179840916, 0.032447017266722916, 0.03257859702945737, 0.0323360851381838, 0.03374068108442476, 0.033532857196478555, 0.033001302612183425, 0.03294367044653073, 0.03299478029641981, 0.03412032932483005, 0.03285947985189317, 0.032791920280885595, 0.03264033642140535, 0.03289111766450938, 0.03301363585381944, 0.032511233764459364, 0.03250150746236778, 0.031884550079075646, 0.03172788957464329, 0.031675742257187035, 0.03222035045957329, 0.032790597038912093, 0.031833668327432646, 0.0304289580245682, 0.03198534830245417, 0.031931454991355926, 0.03380512652649572, 0.031849176613897044, 0.031007562448417902, 0.03161473565860744, 0.03153864201547761, 0.03268154305386837, 0.03269818990024214, 0.0318615620586943, 0.032737100101676256, 0.03254312786894387, 0.03255644396359572, 0.03215645148184055, 0.03226766845507885, 0.03258442360153758, 0.03273098181713742, 0.03256590048446246, 0.03292432214602104, 0.03349364798724631, 0.03332957939655954, 0.033301296474881954, 0.0324409099308645, 0.032913139604470065, 0.032600035575485256, 0.032900621588266996, 0.03349777980470503, 0.03350529563356993, 0.03326622147581521, 0.03354641800474854, 0.033761649996440046, 0.03318566351147075, 0.0335244002998671, 0.03367085210230146, 0.03389855681263047, 0.03361925313934549, 0.03444929373031591, 0.034743210397870206, 0.0347370186249419, 0.03479769188046538, 0.035790626595886076, 0.034814516496311704, 0.034574128484885586, 0.033553471248093505, 0.033714845282249196, 0.03328659974949141, 0.033386727702671606, 0.032730472630946014, 0.03355608067913016, 0.033919062071301, 0.03301139283044475, 0.033590257881562405, 0.03300695404871667, 0.032576299156747056, 0.03254517587122674, 0.032878918720877975, 0.03337466230488156, 0.033435385499825956, 0.033329118950478936, 0.03363486938245502, 0.0340649228172429, 0.03472032933986684, 0.03599503621876119, 0.03411978381172451, 0.0341335753432083, 0.03421374426258617, 0.03413062214283452, 0.03407321753232036, 0.03361932030493454, 0.03268904635098913, 0.03293360358887832, 0.03318497445766858, 0.032693174613301866, 0.03273686518644659, 0.03305770928856853, 0.03337662200610957, 0.03448973500480936, 0.03375949318548421, 0.03369277355483882, 0.03366708737893408, 0.03424739427438198, 0.03524764698201602, 0.035182350602156034, 0.03516168426640994, 0.03445744762216982, 0.03441958482310677, 0.03473703713593295, 0.03431428775837369, 0.03450983899857838, 0.034181446172500615, 0.03418245821423396, 0.03374068404405756, 0.03405214391789866, 0.03385533126784194, 0.03456112943643374, 0.03366009072116697, 0.03401281519919407, 0.03370918190247568, 0.03368870943732102, 0.03392014683143351, 0.03356392829216164, 0.034131752026986074, 0.03373032906053523, 0.03328312083641888, 0.03369076349929789, 0.033585275139442296, 0.034178009763643116, 0.034133303612876566, 0.034192136119967236, 0.033890008549905114, 0.03410008468500791, 0.03392337375404697, 0.03424540236580483, 0.035032763984324235, 0.03456908708096144, 0.034117759341819834, 0.03373950116797601, 0.03347759167841058, 0.033560471305942106, 0.03411540833022522, 0.03440433590571172, 0.033894749204311944, 0.03382845578812763, 0.033329344364360754, 0.03357685786910421, 0.033972396552980996, 0.033551881242558965, 0.03444205406264604, 0.0344724644135753, 0.034541725291648416, 0.03421508212163509, 0.0342357191415562, 0.03450812269504902, 0.035240038199134203, 0.03416148573446609, 0.034914598919600734, 0.0344626422651702, 0.03587960131037882, 0.03596998777766628, 0.035659654707120944, 0.034552732198280825, 0.03494670552749983, 0.03506785138037006, 0.034568447484366285, 0.03394238470105114, 0.03461492210610661, 0.03420431777321802, 0.034790716696251035, 0.03437779418801166, 0.0343292667055044, 0.03515656691699389, 0.035083585383627866, 0.0348568287879361, 0.034214992270294384, 0.03475394791993891, 0.03494552235248705, 0.034254818908480825, 0.03421863547598232, 0.03490935030004516, 0.03526616950517815, 0.03535052830668788, 0.03558769907473832, 0.03492713041117537, 0.035767524870244524, 0.035717592941544314, 0.036486855673048484, 0.03587432623076709, 0.03544524119395748, 0.03676147042302145, 0.03624774949684842, 0.035408262151672934, 0.035417351766502604, 0.03519540534024032, 0.03527957135148339, 0.03522687694633645, 0.034530605105493925, 0.0346433208956391, 0.035350004499249785, 0.034902689806119346, 0.03503231635401069, 0.034654541793067664, 0.03591523096200995, 0.0358675907531044, 0.03598157861733399, 0.03620505967598652, 0.03560074069074709, 0.03647367907063863, 0.03658049048318204, 0.03623237980671095, 0.03530197253452814, 0.03592741749532008, 0.03601369178614673, 0.035665801588243146, 0.03619148383024875, 0.03571386933571812, 0.03589953822880176, 0.03656752056715008, 0.03702177010194439, 0.03608729089366515, 0.03667994411423971, 0.03686198988118011, 0.03569484915118601, 0.036892080230124254, 0.0363008717179458, 0.03615029400732472, 0.03627137275168455, 0.03664423163624992, 0.035810837902991347, 0.0355103234413274, 0.03585074245458927, 0.03590121452678985, 0.035823874252224525, 0.03597849817469318, 0.036032100084853066, 0.03585699545364699, 0.036032122590984005, 0.03599954874804701, 0.03629260705938636, 0.03599713838540297, 0.03609747847661721, 0.03583209319643607, 0.036911634945703924, 0.03615325172438484, 0.036021723688404256, 0.036476865997016744, 0.03688795521106703, 0.03662064192575522, 0.03744634961663062, 0.037377821620221956, 0.038250017907387225, 0.03610605569388354, 0.037126901072597446, 0.03712870158727005, 0.037356750212373904, 0.03730860955557032, 0.03753414128032441, 0.03717120070481133, 0.037581755001809596, 0.03776433864521215, 0.03768378191761417, 0.03730360138665597, 0.03750511289606206, 0.03822228207799818, 0.037348730958931084, 0.037291353183052614, 0.03914675238364999, 0.038492818026838196, 0.03799756115385522, 0.03735165839687646, 0.0370441722013938, 0.036499615550539606, 0.03705574523879751, 0.036845055253171374, 0.03749961028972393, 0.03678797650207582, 0.03661261789844261, 0.03731974991482349, 0.03801535934470946, 0.0381309940648725, 0.03713770374092799, 0.03700466226679232, 0.03702429593570553, 0.03670362640922972, 0.036763541588873516, 0.0364425343680117, 0.03659684510262208, 0.03742391668753671, 0.03769436354659579, 0.03742163437166531, 0.03730436518309827, 0.038025878346463045, 0.03688176629206049, 0.03725387296614009, 0.036780029648623695, 0.035974373235716374, 0.037346028111385765, 0.0366413266594216, 0.03614828126380867, 0.03712108694020793, 0.03692776831737541, 0.036818476573771734, 0.03613435939215601, 0.03722066396961023, 0.03699498976290685, 0.038558806194084, 0.03707601882862946, 0.036522322953975124, 0.03682416925180546, 0.036234850359008565, 0.0351494302109673, 0.03545481779446254, 0.03696859053582137, 0.0368844088988772, 0.03720216517000991, 0.03720983470361724, 0.03628779781188152, 0.03837920061166792, 0.038598345855222746, 0.0390079974687216, 0.03897269384628316, 0.03816727687984148, 0.038415026091905585, 0.03804311136432782, 0.038299471082157976, 0.038014390291208774, 0.03815942955789139, 0.03794541746279968, 0.03769487715936457, 0.03803036336651055, 0.03774826849860772, 0.03811269025090695, 0.0383922087115177, 0.0387711251472914, 0.039324371037671974, 0.03807861290931527, 0.03929028566051516, 0.038919762610896975, 0.03809576337383309, 0.03797122602980818, 0.03884790899971942, 0.03948930830322856, 0.038584702882148776, 0.038031334221468274, 0.039467320556464534, 0.03855036162110423, 0.039260342112427314, 0.03822726927400192, 0.03828668471549966, 0.038218258182933486, 0.03794137598347586, 0.03804193986831928, 0.03762821671889932, 0.037895686022706765, 0.0380881719348195, 0.03837941273065264, 0.038987317949755455, 0.03829494607344628, 0.038791340883791006, 0.039499711818814516, 0.03846863126510733, 0.03964581456834149, 0.03912879373862902, 0.0399722037302313, 0.041064434781703615, 0.04080789133880065, 0.04015465002949074, 0.039728956239522335, 0.03974057434538965, 0.03870209442787512, 0.038801725103892334, 0.03932003943642896, 0.03818885392651091, 0.03816087503373146, 0.03883041244254729, 0.03914973337809774, 0.03937792741084377, 0.0413309434061832, 0.043684029171261615, 0.04588851615813349, 0.04876464614449682, 0.050933782944404184, 0.052199730657456006, 0.05336159714332148, 0.05274906893729589, 0.05029307059879069, 0.04651034945721888, 0.04286214578256771, 0.041158714442279816, 0.03918193590553964, 0.03921557133236806, 0.038399066714552996, 0.03824915895511953, 0.0386071960943026, 0.03891014419441455, 0.03905309759279177, 0.038664327302022045, 0.03863345997707925, 0.03894990218501355, 0.03951895987078929, 0.038797062828683324, 0.0384349393193891, 0.03842306214649911, 0.03818342128390482, 0.037958398695368586, 0.03820744442185535, 0.037900884221855766, 0.03835942509512332, 0.0379512791862437, 0.03888810775801767, 0.03872181560191778, 0.0385289101981303, 0.03825575499101385, 0.03803590113533521, 0.03768980457603983, 0.03845810090147164, 0.039111953949788114, 0.039688820738546154, 0.03916036507120316, 0.03978318560951925, 0.03912893460844799, 0.03929867071906384, 0.03958391635122013, 0.03944990502550461, 0.039031860723958436, 0.039356689852589756, 0.039484362256527905, 0.04016126022659321, 0.039569804058029096, 0.038082304229969235, 0.03957073495628159, 0.039499017538518456, 0.03787734698684688, 0.03903785271065376, 0.0394077815604526, 0.03884297040843984, 0.038806252065736326, 0.039396385815294775, 0.03863732478462236, 0.03804235604004339, 0.03839511023622605, 0.03821504498808936, 0.038097364968886244, 0.040625541071549906, 0.040078860086464836, 0.039068864918394626, 0.03993260044736292, 0.04028823461887317, 0.03974990044030722, 0.03969455659960293, 0.03939818143091728, 0.03945273608798608, 0.039510730624405625, 0.04059833300088732, 0.039585861758631956, 0.03958199661302353, 0.03978168770279337, 0.04020382982190889, 0.04047940917792588, 0.039748518413396196, 0.04010061050683356, 0.04021090519209233, 0.040204609831686694, 0.03984555537381525, 0.04076438749891672, 0.04052499041645431, 0.04090792228622649, 0.04170910676526001, 0.040409245953546356, 0.04044533241637726, 0.040829418238434084, 0.04015691209364968, 0.040030992935228576, 0.040718337586270206, 0.04033035855328442, 0.0402117657524215, 0.040830104522929934, 0.039823842515164756, 0.0398776049976047, 0.039953732372217554, 0.040053347183216216, 0.04018266044256333, 0.04089091936710342, 0.04058388992297816, 0.04057431798358001, 0.04015656077865734, 0.039897019818915115, 0.03950439835088871, 0.04027950144103694, 0.03949717614551711, 0.039211311444779386, 0.039644975809559405, 0.03990793565603155, 0.039715469862930605, 0.039616182610192535, 0.04030589334658206, 0.04031952799161823, 0.039582974580627955, 0.039791473601414516, 0.039733015022902954, 0.03921614272029852, 0.0396982859658518, 0.04028843606782592, 0.03938234079340882, 0.03949554480955696, 0.03938651144319949, 0.03881860487236886, 0.039817618985166135, 0.03999812938919178, 0.03911782640179379, 0.039114467585423675, 0.04088621171185674, 0.03978935820725462, 0.0392749531272621, 0.03909901362726703, 0.0391705655875111, 0.04001960172875077, 0.04071686034611261, 0.039787045040632414, 0.03969856136400574, 0.039677153530859884, 0.03964273008043434, 0.03963374164195067, 0.039974068460158683, 0.03896476908844025, 0.0396624592411767, 0.04024581344674445, 0.0403699840499425, 0.04091851264087411, 0.04077811926875584, 0.04109846190195555, 0.040462125240249835, 0.0404262254190915, 0.04163076024972283, 0.040805136677644606, 0.041050236430736534, 0.04025995499468896, 0.04074526256841142, 0.040542398904564736, 0.04073032423898045, 0.040629009045337845, 0.039937587855700916, 0.04035937221462179, 0.04015465978084278, 0.039753543512246706, 0.040565296922779215, 0.03936809560279295, 0.038909761346396905, 0.039365824322779866, 0.03958461902719418, 0.038717565471680385, 0.03810749320178386, 0.038894010754994865, 0.03952277754772959, 0.04078301008614101, 0.04012586208577933, 0.039773096080646414, 0.04021184414285939, 0.04020597626816629, 0.04021495424294508, 0.040947939739797455, 0.04033994058568186, 0.04091840008484183, 0.041120753729258275, 0.04273774877018582, 0.0412856378231973, 0.041588408310728756, 0.04041076777859847, 0.0397060574130525, 0.03940019925978727, 0.03968743091378914, 0.03938462573018258, 0.039946153664122575, 0.03994228525300423, 0.03962447496515709, 0.04076345960317029, 0.04041817246310941, 0.04049613209126382, 0.04006204756076825, 0.040165440751404935, 0.04070496347782049, 0.0408931155799415, 0.04081152216264357, 0.04030489354174019, 0.042164341195789254, 0.04163747082644683, 0.04225954236835871, 0.04308284766345338, 0.04340983719791629, 0.04414198086755447, 0.04343687950115994, 0.0449328825520969, 0.04228103393456307, 0.042795899626800624, 0.04281994486764422, 0.04123309570565456, 0.04197546122645584, 0.04107417205894721, 0.04124600263573975, 0.04138943152200715, 0.04194088716187559, 0.041041052517296436, 0.04028102666303728, 0.040788547901359405, 0.039850837035974626, 0.03966919692857343, 0.04029526076499145, 0.03984679711049013, 0.0402140038349669, 0.040609652124004664, 0.040795975196347214, 0.04133178236448775, 0.04086188557318154, 0.04135563237553526, 0.041520202420152925, 0.041188318649572175, 0.04138357127090798, 0.04134871094438821, 0.040657127421380876, 0.04161557603451732, 0.042615069842180255, 0.041309234729884264, 0.041172758291132025, 0.04172400116115363, 0.04110182081199006, 0.041323124665111885, 0.04162612080324686, 0.04084406384958139, 0.04023582441708737, 0.04010480010685866, 0.03979157153053311, 0.041095549496003955, 0.040874388247045465, 0.04030697872106762, 0.03992268162020028, 0.040273144992437566, 0.040045756807290105, 0.04094878840474165, 0.04088892041247345, 0.04126795074092358, 0.0405610216205754, 0.0416525212333966, 0.04110996321082191, 0.04032705454094387, 0.04013369549711471, 0.040491314570430786, 0.040918283853702934, 0.040667388138344626, 0.04160150712036022, 0.040423454204866364, 0.040332379241726994, 0.04057464676256658, 0.039731594860657624, 0.04040783239407043, 0.04112516977069094, 0.04067787899294078, 0.040426525988400026, 0.041389352690524434, 0.04154695625829463, 0.04097931817496777, 0.03987501149034593, 0.04055410453783239, 0.040640293853750585, 0.04057778113836789, 0.04181710171797914, 0.04013515911693426, 0.04005520584967482, 0.0409010437043965, 0.04065230460435914, 0.04069853125330624, 0.04156484110614654, 0.04164248143065489, 0.04214405754556382, 0.04155899638141437, 0.0416433042244914, 0.040636271036484144, 0.04113234837640776, 0.04058070774587722, 0.040079869322075745, 0.04049270444264659, 0.03939932239426947, 0.039969049893603406, 0.040143408848682616, 0.04081401414661752, 0.0411155509657775, 0.04108768610369829, 0.042170263329369545, 0.04114011526476759, 0.040898344201417774, 0.04138420393842056, 0.04170321039760183, 0.04014062328731644, 0.04156551964716787, 0.04147199250246499, 0.04129923007849766, 0.04116425534677426, 0.04158014517835936, 0.041208474108614744, 0.04221576230643809, 0.041746947831021876, 0.04148973515520952, 0.040300975614989354, 0.04063886654821571, 0.04187126660543945, 0.041791277725006994, 0.04176339087574796, 0.041429258077976275, 0.041745275716869444, 0.04165299975714694, 0.04237509951777269, 0.04136736821314693, 0.0413212858675168, 0.04172280392894358, 0.04214286761135474, 0.04173575904859309, 0.04203862795337234, 0.042164591538165756, 0.042857333497776456, 0.043098785477189906, 0.0426643158740485, 0.04216728509329326, 0.04204049569652941, 0.04400217917330093, 0.04456841461388554, 0.04224801824766068, 0.04182956096989703, 0.043632604585319056, 0.04410862019537983, 0.042739312332869935, 0.042468000925677984, 0.041711565910078977, 0.041881834547330424, 0.04161433059294781, 0.04209341424205713, 0.04260275352651442, 0.042469008648071495, 0.04284083354619156, 0.04360417721038782, 0.04423613338000069, 0.04486961832318969, 0.045520552187321754, 0.042981184083614704, 0.04333089937684636, 0.04306859696156151, 0.03996343758893196, 0.032918144608649995, 0.03329714208502971]
WVALUES_ELLIPSE = [8.0, 8.002000000094995, 8.00400000018999, 8.006000000284985, 8.00800000037998, 8.010000000474975, 8.01200000056997, 8.014000000664964, 8.01600000075996, 8.018000000854954, 8.020000000949949, 8.022000001044944, 8.024000001139939, 8.026000001234934, 8.028000001329929, 8.030000001424924, 8.032000001519918, 8.034000001614913, 8.036000001709908, 8.038000001804903, 8.040000001899898, 8.042000001994893, 8.044000002089888, 8.046000002184883, 8.048000002279878, 8.050000002374873, 8.052000002469867, 8.054000002564862, 8.056000002659857, 8.058000002754852, 8.060000002849847, 8.062000002944842, 8.064000003039837, 8.066000003134832, 8.068000003229827, 8.070000003324822, 8.072000003419816, 8.074000003514811, 8.076000003609806, 8.078000003704801, 8.080000003799796, 8.082000003894791, 8.084000003989786, 8.08600000408478, 8.088000004179776, 8.09000000427477, 8.092000004369766, 8.09400000446476, 8.096000004559755, 8.09800000465475, 8.100000004749745, 8.10200000484474, 8.104000004939735, 8.10600000503473, 8.108000005129725, 8.11000000522472, 8.112000005319715, 8.11400000541471, 8.116000005509704, 8.1180000056047, 8.120000005699694, 8.122000005794689, 8.124000005889684, 8.126000005984679, 8.128000006079674, 8.130000006174669, 8.132000006269664, 8.134000006364658, 8.136000006459653, 8.138000006554648, 8.140000006649643, 8.142000006744638, 8.144000006839633, 8.146000006934628, 8.148000007029623, 8.150000007124618, 8.152000007219613, 8.154000007314608, 8.156000007409602, 8.158000007504597, 8.160000007599592, 8.162000007694587, 8.164000007789582, 8.166000007884577, 8.168000007979572, 8.170000008074567, 8.172000008169562, 8.174000008264557, 8.176000008359551, 8.178000008454546, 8.180000008549541, 8.182000008644536, 8.184000008739531, 8.186000008834526, 8.18800000892952, 8.190000009024516, 8.19200000911951, 8.194000009214506, 8.1960000093095, 8.198000009404495, 8.20000000949949, 8.202000009594485, 8.20400000968948, 8.206000009784475, 8.20800000987947, 8.210000009974465, 8.21200001006946, 8.214000010164455, 8.21600001025945, 8.218000010354444, 8.22000001044944, 8.222000010544434, 8.224000010639429, 8.226000010734424, 8.228000010829419, 8.230000010924414, 8.232000011019409, 8.234000011114404, 8.236000011209399, 8.238000011304393, 8.240000011399388, 8.242000011494383, 8.244000011589378, 8.246000011684373, 8.248000011779368, 8.250000011874363, 8.252000011969358, 8.254000012064353, 8.256000012159348, 8.258000012254342, 8.260000012349337, 8.262000012444332, 8.264000012539327, 8.266000012634322, 8.268000012729317, 8.270000012824312, 8.272000012919307, 8.274000013014302, 8.276000013109297, 8.278000013204291, 8.280000013299286, 8.282000013394281, 8.284000013489276, 8.286000013584271, 8.288000013679266, 8.29000001377426, 8.292000013869256, 8.29400001396425, 8.296000014059246, 8.29800001415424, 8.300000014249235, 8.30200001434423, 8.304000014439225, 8.30600001453422, 8.308000014629215, 8.31000001472421, 8.312000014819205, 8.3140000149142, 8.316000015009195, 8.31800001510419, 8.320000015199184, 8.32200001529418, 8.324000015389174, 8.32600001548417, 8.328000015579164, 8.330000015674159, 8.332000015769154, 8.334000015864149, 8.336000015959144, 8.338000016054139, 8.340000016149133, 8.342000016244128, 8.344000016339123, 8.346000016434118, 8.348000016529113, 8.350000016624108, 8.352000016719103, 8.354000016814098, 8.356000016909093, 8.358000017004088, 8.360000017099082, 8.362000017194077, 8.364000017289072, 8.366000017384067, 8.368000017479062, 8.370000017574057, 8.372000017669052, 8.374000017764047, 8.376000017859042, 8.378000017954037, 8.380000018049031, 8.382000018144026, 8.384000018239021, 8.386000018334016, 8.388000018429011, 8.390000018524006, 8.392000018619001, 8.394000018713996, 8.39600001880899, 8.398000018903986, 8.40000001899898, 8.402000019093975, 8.40400001918897, 8.406000019283965, 8.40800001937896, 8.410000019473955, 8.41200001956895, 8.414000019663945, 8.41600001975894, 8.418000019853935, 8.42000001994893, 8.422000020043924, 8.42400002013892, 8.426000020233914, 8.42800002032891, 8.430000020423904, 8.432000020518899, 8.434000020613894, 8.436000020708889, 8.438000020803884, 8.440000020898879, 8.442000020993873, 8.444000021088868, 8.446000021183863, 8.448000021278858, 8.450000021373853, 8.452000021468848, 8.454000021563843, 8.456000021658838, 8.458000021753833, 8.460000021848828, 8.462000021943823, 8.464000022038817, 8.466000022133812, 8.468000022228807, 8.470000022323802, 8.472000022418797, 8.474000022513792, 8.476000022608787, 8.478000022703782, 8.480000022798777, 8.482000022893772, 8.484000022988766, 8.486000023083761, 8.488000023178756, 8.490000023273751, 8.492000023368746, 8.494000023463741, 8.496000023558736, 8.49800002365373, 8.500000023748726, 8.50200002384372, 8.504000023938715, 8.50600002403371, 8.508000024128705, 8.5100000242237, 8.512000024318695, 8.51400002441369, 8.516000024508685, 8.51800002460368, 8.520000024698675, 8.52200002479367, 8.524000024888664, 8.52600002498366, 8.528000025078654, 8.53000002517365, 8.532000025268644, 8.534000025363639, 8.536000025458634, 8.538000025553629, 8.540000025648624, 8.542000025743619, 8.544000025838614, 8.546000025933608, 8.548000026028603, 8.550000026123598, 8.552000026218593, 8.554000026313588, 8.556000026408583, 8.558000026503578, 8.560000026598573, 8.562000026693568, 8.564000026788563, 8.566000026883557, 8.568000026978552, 8.570000027073547, 8.572000027168542, 8.574000027263537, 8.576000027358532, 8.578000027453527, 8.580000027548522, 8.582000027643517, 8.584000027738512, 8.586000027833506, 8.588000027928501, 8.590000028023496, 8.592000028118491, 8.594000028213486, 8.596000028308481, 8.598000028403476, 8.60000002849847, 8.602000028593466, 8.60400002868846, 8.606000028783455, 8.60800002887845, 8.610000028973445, 8.61200002906844, 8.614000029163435, 8.61600002925843, 8.618000029353425, 8.62000002944842, 8.622000029543415, 8.62400002963841, 8.626000029733405, 8.6280000298284, 8.630000029923394, 8.63200003001839, 8.634000030113384, 8.636000030208379, 8.638000030303374, 8.640000030398369, 8.642000030493364, 8.644000030588359, 8.646000030683354, 8.648000030778348, 8.650000030873343, 8.652000030968338, 8.654000031063333, 8.656000031158328, 8.658000031253323, 8.660000031348318, 8.662000031443313, 8.664000031538308, 8.666000031633303, 8.668000031728297, 8.670000031823292, 8.672000031918287, 8.674000032013282, 8.676000032108277, 8.678000032203272, 8.680000032298267, 8.682000032393262, 8.684000032488257, 8.686000032583252, 8.688000032678246, 8.690000032773241, 8.692000032868236, 8.694000032963231, 8.696000033058226, 8.698000033153221, 8.700000033248216, 8.70200003334321, 8.704000033438206, 8.7060000335332, 8.708000033628196, 8.71000003372319, 8.712000033818185, 8.71400003391318, 8.716000034008175, 8.71800003410317, 8.720000034198165, 8.72200003429316, 8.724000034388155, 8.72600003448315, 8.728000034578145, 8.73000003467314, 8.732000034768134, 8.73400003486313, 8.736000034958124, 8.738000035053119, 8.740000035148114, 8.742000035243109, 8.744000035338104, 8.746000035433099, 8.748000035528094, 8.750000035623088, 8.752000035718083, 8.754000035813078, 8.756000035908073, 8.758000036003068, 8.760000036098063, 8.762000036193058, 8.764000036288053, 8.766000036383048, 8.768000036478043, 8.770000036573038, 8.772000036668032, 8.774000036763027, 8.776000036858022, 8.778000036953017, 8.780000037048012, 8.782000037143007, 8.784000037238002, 8.786000037332997, 8.788000037427992, 8.790000037522987, 8.792000037617981, 8.794000037712976, 8.796000037807971, 8.798000037902966, 8.800000037997961, 8.802000038092956, 8.80400003818795, 8.806000038282946, 8.80800003837794, 8.810000038472936, 8.81200003856793, 8.814000038662925, 8.81600003875792, 8.818000038852915, 8.82000003894791, 8.822000039042905, 8.8240000391379, 8.826000039232895, 8.82800003932789, 8.830000039422885, 8.83200003951788, 8.834000039612874, 8.83600003970787, 8.838000039802864, 8.840000039897859, 8.842000039992854, 8.844000040087849, 8.846000040182844, 8.848000040277839, 8.850000040372834, 8.852000040467829, 8.854000040562823, 8.856000040657818, 8.858000040752813, 8.860000040847808, 8.862000040942803, 8.864000041037798, 8.866000041132793, 8.868000041227788, 8.870000041322783, 8.872000041417778, 8.874000041512772, 8.876000041607767, 8.878000041702762, 8.880000041797757, 8.882000041892752, 8.884000041987747, 8.886000042082742, 8.888000042177737, 8.890000042272732, 8.892000042367727, 8.894000042462721, 8.896000042557716, 8.898000042652711, 8.900000042747706, 8.902000042842701, 8.904000042937696, 8.90600004303269, 8.908000043127686, 8.91000004322268, 8.912000043317676, 8.91400004341267, 8.916000043507665, 8.91800004360266, 8.920000043697655, 8.92200004379265, 8.924000043887645, 8.92600004398264, 8.928000044077635, 8.93000004417263, 8.932000044267625, 8.93400004436262, 8.936000044457614, 8.93800004455261, 8.940000044647604, 8.9420000447426, 8.944000044837594, 8.946000044932589, 8.948000045027584, 8.950000045122579, 8.952000045217574, 8.954000045312569, 8.956000045407563, 8.958000045502558, 8.960000045597553, 8.962000045692548, 8.964000045787543, 8.966000045882538, 8.968000045977533, 8.970000046072528, 8.972000046167523, 8.974000046262518, 8.976000046357512, 8.978000046452507, 8.980000046547502, 8.982000046642497, 8.984000046737492, 8.986000046832487, 8.988000046927482, 8.990000047022477, 8.992000047117472, 8.994000047212467, 8.996000047307462, 8.998000047402456, 9.000000047497451, 9.002000047592446, 9.004000047687441, 9.006000047782436, 9.008000047877431, 9.010000047972426, 9.01200004806742, 9.014000048162416, 9.01600004825741, 9.018000048352405, 9.0200000484474, 9.022000048542395, 9.02400004863739, 9.026000048732385, 9.02800004882738, 9.030000048922375, 9.03200004901737, 9.034000049112365, 9.03600004920736, 9.038000049302354, 9.04000004939735, 9.042000049492344, 9.04400004958734, 9.046000049682334, 9.048000049777329, 9.050000049872324, 9.052000049967319, 9.054000050062314, 9.056000050157309, 9.058000050252303, 9.060000050347298, 9.062000050442293, 9.064000050537288, 9.066000050632283, 9.068000050727278, 9.070000050822273, 9.072000050917268, 9.074000051012263, 9.076000051107258, 9.078000051202253, 9.080000051297247, 9.082000051392242, 9.084000051487237, 9.086000051582232, 9.088000051677227, 9.090000051772222, 9.092000051867217, 9.094000051962212, 9.096000052057207, 9.098000052152202, 9.100000052247196, 9.102000052342191, 9.104000052437186, 9.106000052532181, 9.108000052627176, 9.110000052722171, 9.112000052817166, 9.11400005291216, 9.116000053007156, 9.11800005310215, 9.120000053197145, 9.12200005329214, 9.124000053387135, 9.12600005348213, 9.128000053577125, 9.13000005367212, 9.132000053767115, 9.13400005386211, 9.136000053957105, 9.1380000540521, 9.140000054147094, 9.14200005424209, 9.144000054337084, 9.14600005443208, 9.148000054527074, 9.150000054622069, 9.152000054717064, 9.154000054812059, 9.156000054907054, 9.158000055002049, 9.160000055097044, 9.162000055192038, 9.164000055287033, 9.166000055382028, 9.168000055477023, 9.170000055572018, 9.172000055667013, 9.174000055762008, 9.176000055857003, 9.178000055951998, 9.180000056046993, 9.182000056141987, 9.184000056236982, 9.186000056331977, 9.188000056426972, 9.190000056521967, 9.192000056616962, 9.194000056711957, 9.196000056806952, 9.198000056901947, 9.200000056996942, 9.202000057091936, 9.204000057186931, 9.206000057281926, 9.208000057376921, 9.210000057471916, 9.212000057566911, 9.214000057661906, 9.2160000577569, 9.218000057851896, 9.22000005794689, 9.222000058041885, 9.22400005813688, 9.226000058231875, 9.22800005832687, 9.230000058421865, 9.23200005851686, 9.234000058611855, 9.23600005870685, 9.238000058801845, 9.24000005889684, 9.242000058991835, 9.24400005908683, 9.246000059181824, 9.24800005927682, 9.250000059371814, 9.252000059466809, 9.254000059561804, 9.256000059656799, 9.258000059751794, 9.260000059846789, 9.262000059941784, 9.264000060036778, 9.266000060131773, 9.268000060226768, 9.270000060321763, 9.272000060416758, 9.274000060511753, 9.276000060606748, 9.278000060701743, 9.280000060796738, 9.282000060891733, 9.284000060986727, 9.286000061081722, 9.288000061176717, 9.290000061271712, 9.292000061366707, 9.294000061461702, 9.296000061556697, 9.298000061651692, 9.300000061746687, 9.302000061841682, 9.304000061936677, 9.306000062031671, 9.308000062126666, 9.310000062221661, 9.312000062316656, 9.314000062411651, 9.316000062506646, 9.31800006260164, 9.320000062696636, 9.32200006279163, 9.324000062886626, 9.32600006298162, 9.328000063076615, 9.33000006317161, 9.332000063266605, 9.3340000633616, 9.336000063456595, 9.33800006355159, 9.340000063646585, 9.34200006374158, 9.344000063836575, 9.34600006393157, 9.348000064026564, 9.35000006412156, 9.352000064216554, 9.354000064311549, 9.356000064406544, 9.358000064501539, 9.360000064596534, 9.362000064691529, 9.364000064786524, 9.366000064881518, 9.368000064976513, 9.370000065071508, 9.372000065166503, 9.374000065261498, 9.376000065356493, 9.378000065451488, 9.380000065546483, 9.382000065641478, 9.384000065736473, 9.386000065831468, 9.388000065926462, 9.390000066021457, 9.392000066116452, 9.394000066211447, 9.396000066306442, 9.398000066401437, 9.400000066496432, 9.402000066591427, 9.404000066686422, 9.406000066781417, 9.408000066876411, 9.410000066971406, 9.412000067066401, 9.414000067161396, 9.416000067256391, 9.418000067351386, 9.42000006744638, 9.422000067541376, 9.42400006763637, 9.426000067731366, 9.42800006782636, 9.430000067921355, 9.43200006801635, 9.434000068111345, 9.43600006820634, 9.438000068301335, 9.44000006839633, 9.442000068491325, 9.44400006858632, 9.446000068681315, 9.44800006877631, 9.450000068871304, 9.4520000689663, 9.454000069061294, 9.456000069156289, 9.458000069251284, 9.460000069346279, 9.462000069441274, 9.464000069536269, 9.466000069631264, 9.468000069726259, 9.470000069821253, 9.472000069916248, 9.474000070011243, 9.476000070106238, 9.478000070201233, 9.480000070296228, 9.482000070391223, 9.484000070486218, 9.486000070581213, 9.488000070676208, 9.490000070771202, 9.492000070866197, 9.494000070961192, 9.496000071056187, 9.498000071151182, 9.500000071246177, 9.502000071341172, 9.504000071436167, 9.506000071531162, 9.508000071626157, 9.510000071721151, 9.512000071816146, 9.514000071911141, 9.516000072006136, 9.518000072101131, 9.520000072196126, 9.52200007229112, 9.524000072386116, 9.52600007248111, 9.528000072576106, 9.5300000726711, 9.532000072766095, 9.53400007286109, 9.536000072956085, 9.53800007305108, 9.540000073146075, 9.54200007324107, 9.544000073336065, 9.54600007343106, 9.548000073526055, 9.55000007362105, 9.552000073716044, 9.55400007381104, 9.556000073906034, 9.55800007400103, 9.560000074096024, 9.562000074191019, 9.564000074286014, 9.566000074381009, 9.568000074476004, 9.570000074570999, 9.572000074665993, 9.574000074760988, 9.576000074855983, 9.578000074950978, 9.580000075045973, 9.582000075140968, 9.584000075235963, 9.586000075330958, 9.588000075425953, 9.590000075520948, 9.592000075615942, 9.594000075710937, 9.596000075805932, 9.598000075900927, 9.600000075995922, 9.602000076090917, 9.604000076185912, 9.606000076280907, 9.608000076375902, 9.610000076470897, 9.612000076565892, 9.614000076660886, 9.616000076755881, 9.618000076850876, 9.620000076945871, 9.622000077040866, 9.624000077135861, 9.626000077230856, 9.62800007732585, 9.630000077420846, 9.63200007751584, 9.634000077610835, 9.63600007770583, 9.638000077800825, 9.64000007789582]


def test_rectangle_aperture():
    units, cubeObj= get_miri_cube_data(os.path.join(DATA,'dither_ch2-medium_s3d.fits'))

    #Set center of ellipse, the center of the image
    fValues, wValues, aperture = transform_xy_rectangle(centerX = 20., centerY = 15., width = 3., height= 3., cubeObj = cubeObj )

    assert fValues == pytest.approx(FVALUES_RECTANGLE)
    assert wValues == pytest.approx(WVALUES_RECTANGLE)

def test_ellipse_aperture():
    units, cubeObj= get_miri_cube_data(os.path.join(DATA,'dither_ch2-medium_s3d.fits'))

    #Set center of ellipse, the center of the image
    fValues, wValues, aperture = transform_xy_ellipse(centerX = 20., centerY = 15.,aAxis = 2., bAxis= 2., cubeObj = cubeObj )

    assert fValues == pytest.approx(FVALUES_ELLIPSE)
    assert wValues == pytest.approx(WVALUES_ELLIPSE)
