use crate::allocator::{Allocator, NodePtr, SExp};
use crate::core_ops::{op_cons, op_eq, op_first, op_if, op_listp, op_raise, op_rest};
use crate::cost::Cost;
use crate::more_ops::{
    op_add, op_all, op_any, op_ash, op_concat, op_div, op_div_deprecated, op_divmod, op_gr,
    op_gr_bytes, op_logand, op_logior, op_lognot, op_logxor, op_lsh, op_multiply, op_not,
    op_point_add, op_pubkey_for_exp, op_sha256, op_softfork, op_strlen, op_substr, op_subtract,
};
use crate::number::{ptr_from_number, Number};
use crate::reduction::{EvalErr, Reduction, Response};
use hex::FromHex;
use num_traits::Num;
use std::cmp::min;
use std::collections::HashMap;

// the format of these test cases is the following. expected-cost is optional
// and is not relevant for FAIL cases

// expression => expected result | expected-cost
static TEST_CASES: &str = r#"
lognot ( 1 2 3 ) => FAIL
lognot 0xff => 0 | 334
lognot 0xffffff => 0 | 340
lognot 0x0000ff => 0xff00 | 360
lognot 0x0000000001 => 0xfe | 356
lognot 0xff00 => 0x00ff | 357
lognot 0x0c => 0xf3 | 344
lognot 0 => 0xff | 341
lognot 0xcccccc => 0x333333 | 370
lognot 0x333333 => 0xcccccc | 370
; requires exactly one argument
lognot 0x00 0x00 => FAIL
lognot => FAIL

; tests ported from clvm
lognot 12 => -13 | 344
lognot -1 => ( ) | 334
lognot 0 => -1 | 341
lognot 734671943749191 => 0xfd63d1dbc431b8 | 422
lognot => FAIL
lognot ( "foo" ) => FAIL
lognot 1 2 => FAIL
lognot 0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001 => -2 | 14873

logior ( 1 2 3 ) => FAIL
logior => 0 | 100
logior 0xbaadf00d => 0xbaadf00d | 416
logior 0xf0 0x0f => 0xff | 644
logior 0xcc 0x33 => 0xff | 644
logior 0x800000 0x01 => 0x800001 | 670
logior 0x400000 0x01 => 0x400001 | 670
logior 0x000040 0x01 => 0x41 | 650
logior 0x000080 0x01 => 0x0081 | 660
logior 0x000080 0xff => 0xff | 650
logior 0x000070 0xff => 0xff | 650
logior 0x000080 0x7f => 0x00ff | 660
logior 0xffff80 0x01 => 0x81 | 650
logior 0x01 0x02 0x04 0x08 0x10 0x20 0x40 0x80 => 0xff | 2246
logior 0x01 0x01 => 0x01 | 644
logior 0x01 0x01 0x01 => 0x01 | 911

; tests ported from clvm
logior 12 5 => 13 | 644
logior 12 5 7 => 15 | 911
logior 0x00000000000000000000000000000000000000000000000000000000000000000000000000000c 0x000005 0x000000000000000000000000000000000000000000000000000000000000000007 => 15 | 1127
logior -128 0x07ffff => -1 | 650

logxor ( 1 2 3 ) => FAIL
logxor => 0 | 100
logxor 0xbaadf00d => 0xbaadf00d | 416
logxor 0xf0 0x0f => 0xff | 644
logxor 0xcc 0x33 => 0xff | 644
logxor 0x800000 0x01 => 0x800001 | 670
logxor 0x400000 0x01 => 0x400001 | 670
logxor 0x000040 0x01 => 0x41 | 650
logxor 0x000080 0x01 => 0x0081 | 660
logxor 0x000080 0xff => 0xff7f | 660
logxor 0x000080 0x7f => 0x00ff | 660
logxor 0x000070 0xff => 0x8f | 650
logxor 0xffff80 0x01 => 0x81 | 650
logxor 0x01 0x02 0x04 0x08 0x10 0x20 0x40 0x80 => 0xff | 2246
logxor 0x01 0x01 => 0 | 634
logxor 0x01 0x01 0x01 => 0x01 | 911

; tests ported from clvm
logxor 12 5 => 9 | 644
logxor 12 5 7 => 14 | 911
logxor 0x0000000000000000000000000000000000000000000000000000000000000000000000000c 0x000005 0x00000000000000000000000000000000000000000000000000000000000000000007 => 14 | 1124
logxor -128 0x07ffff => 0xf8007f | 670

logand ( 1 2 3 ) => FAIL
logand => 0xff | 110
logand 0xbaadf00d => 0xbaadf00d | 416
logand 0xf0 0x0f => 0 | 634
logand 0xcc 0x33 => 0 | 634
logand 0x800000 0x01 => 0 | 640
logand 0x400000 0x01 => 0 | 640
logand 0x000040 0x01 => 0 | 640
logand 0x000080 0x01 => 0 | 640
; 0x000080 -> 0x0080, 0xff -> 0xffff
logand 0x000080 0xff => 0x0080 | 660
logand 0x000040 0xff => 0x40 | 650
logand 0x000080 0x7f => 0 | 640
logand 0x000070 0xff => 0x70 | 650
logand 0xffff80 0x01 => 0 | 640
logand 0x01 0x02 0x04 0x08 0x10 0x20 0x40 0x80 => 0 | 2236
logand 0x01 0x01 => 0x01 | 644
logand 0x01 0x01 0x01 => 0x01 | 911

; tests ported from clvm
logand 13 12 => 12 | 644
logand 13 12 4 => 4 | 911
logand => -1 | 110
logand 0x000000000000000000000000000000000000000000000000000000000000fffe 0x000000000000000000000000000000000000000000000000000000000000005D => 92 | 830
logand -128 0x07ffff => 0x07ff80 | 670

ash => FAIL
ash ( 1 2 3 ) 1 => FAIL
ash ( "foo" ) 1 => FAIL
ash 0xffff ( 1 2 3 ) => FAIL
ash 1 => FAIL
ash 0xff => FAIL
ash 0xff 1 => 0xfe | 612
ash 0xff 1 1 => FAIL

ash 0xff -1 => 0xff | 612
ash 0x80 -1 => 0xc0 | 612
ash 0x80 -2 => 0xe0 | 612
ash 0x80 -3 => 0xf0 | 612
ash 0x80 -4 => 0xf8 | 612
ash 0x80 -5 => 0xfc | 612
ash 0x80 -6 => 0xfe | 612
ash 0x80 -7 => 0xff | 612
ash 0x80 -8 => 0xff | 612

ash 0x7f -1 => 0x3f | 612
ash 0x7f -2 => 0x1f | 612
ash 0x7f -3 => 0x0f | 612
ash 0x7f -4 => 0x07 | 612
ash 0x7f -5 => 0x03 | 612
ash 0x7f -6 => 0x01 | 612
ash 0x7f -7 => 0 | 599
ash 0x7f -8 => 0 | 599

ash 0x80 1 => 0xff00 | 625
ash 0x80 2 => 0xfe00 | 625
ash 0x80 3 => 0xfc00 | 625
ash 0x80 4 => 0xf800 | 625
ash 0x80 5 => 0xf000 | 625
ash 0x80 6 => 0xe000 | 625
ash 0x80 7 => 0xc000 | 625
ash 0x80 8 => 0x8000 | 625

ash 0x7f 1 => 0x00fe | 622
ash 0x7f 2 => 0x01fc | 625
ash 0x7f 3 => 0x03f8 | 625
ash 0x7f 4 => 0x07f0 | 625
ash 0x7f 5 => 0x0fe0 | 625
ash 0x7f 6 => 0x1fc0 | 625
ash 0x7f 7 => 0x3f80 | 625
ash 0x7f 8 => 0x7f00 | 625

ash 0x90000000000000000000000000 -100 => -7 | 648
ash 7 100 => 0x70000000000000000000000000 | 768
ash -7 100 => 0x90000000000000000000000000 | 768
ash 7 1 => 14 | 612
ash 0xcc 1 => 0x98 | 612
ash 0xcc 2 => 0xff30 | 622
ash 0xcc 3 => 0xfe60 | 625
ash 0xcc 4 => 0xfcc0 | 625
ash 0xcc 5 => 0xf980 | 625
ash 0xcc 6 => 0xf300 | 625

ash 0xcc -1 => 0xe6 | 612
ash 0xcc -2 => 0xf3 | 612
ash 0xcc -3 => 0xf9 | 612
ash 0xcc -4 => 0xfc | 612
ash 0xcc -5 => 0xfe | 612
ash 0xcc -6 => 0xff | 612

; shift count is limited to 65535 bits
ash 0xcc -214783648 => FAIL
ash 0xcc -214783647 => FAIL
ash 0xcc 214783648 => FAIL
ash 0xcc 214783647 => FAIL
ash 0xcc 65536 => FAIL
ash 0xcc -65536 => FAIL
ash 0xcc 256 => 0xcc0000000000000000000000000000000000000000000000000000000000000000 | 1028
ash 0xcc 255 => 0xe60000000000000000000000000000000000000000000000000000000000000000 | 1028
ash 0xcc -256 => 0xff | 612
ash 500 65535 => 0x00fa0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000 | 107121
ash 500 -65535 => 0 | 602
ash 0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007 0x0000000000000000000000000000000000000000000000000000000000000001 => FAIL

; parameter isn't allowed to be wider than 32 bits
ash 0xcc 0x0000000001 => FAIL
ash 0xcc "foo" => FAIL

lsh ( 1 2 3 ) 1 => FAIL
lsh 0xffff ( 1 2 3 ) => FAIL
lsh => FAIL
lsh 0xff => FAIL
lsh 0xff 1 => 0x01fe | 306
lsh 0xff 1 1 => FAIL

lsh 0xff -1 => 0x7f | 293
lsh 0x80 -1 => 0x40 | 293
lsh 0x80 -2 => 0x20 | 293
lsh 0x80 -3 => 0x10 | 293
lsh 0x80 -4 => 0x08 | 293
lsh 0x80 -5 => 0x04 | 293
lsh 0x80 -6 => 0x02 | 293
lsh 0x80 -7 => 0x01 | 293
lsh 0x80 -8 => 0 | 280

lsh 0x7f -1 => 0x3f | 293
lsh 0x7f -2 => 0x1f | 293
lsh 0x7f -3 => 0x0f | 293
lsh 0x7f -4 => 0x07 | 293
lsh 0x7f -5 => 0x03 | 293
lsh 0x7f -6 => 0x01 | 293
lsh 0x7f -7 => 0 | 280
lsh 0x7f -8 => 0 | 280

lsh 0x80 1 => 0x0100 | 306
lsh 0x80 2 => 0x0200 | 306
lsh 0x80 3 => 0x0400 | 306
lsh 0x80 4 => 0x0800 | 306
lsh 0x80 5 => 0x1000 | 306
lsh 0x80 6 => 0x2000 | 306
lsh 0x80 7 => 0x4000 | 306
lsh 0x80 8 => 0x008000 | 316

lsh 0x7f 1 => 0x00fe | 303
lsh 0x7f 2 => 0x01fc | 306
lsh 0x7f 3 => 0x03f8 | 306
lsh 0x7f 4 => 0x07f0 | 306
lsh 0x7f 5 => 0x0fe0 | 306
lsh 0x7f 6 => 0x1fc0 | 306
lsh 0x7f 7 => 0x3f80 | 306
lsh 0x7f 8 => 0x7f00 | 306

lsh 0x90000000000000000000000000 -100 => 0x09 | 329
lsh 0xf9 100 => 0x0f90000000000000000000000000 | 462
lsh 0xcc 1 => 0x0198 | 306
lsh 0xcc 2 => 0x0330 | 306
lsh 0xcc 3 => 0x0660 | 306
lsh 0xcc 4 => 0x0cc0 | 306
lsh 0xcc 5 => 0x1980 | 306
lsh 0xcc 6 => 0x3300 | 306

lsh 0xcc -1 => 0x66 | 293
lsh 0xcc -2 => 0x33 | 293
lsh 0xcc -3 => 0x19 | 293
lsh 0xcc -4 => 0x0c | 293
lsh 0xcc -5 => 0x06 | 293
lsh 0xcc -6 => 0x03 | 293

; shift count is limited to 65535 bits
lsh 0xcc -214783648 => FAIL
lsh 0xcc -214783647 => FAIL
lsh 0xcc 214783648 => FAIL
lsh 0xcc 214783647 => FAIL
lsh 0xcc 65536 => FAIL
lsh 0xcc -65536 => FAIL
lsh 0xcc 256 => 0x00cc0000000000000000000000000000000000000000000000000000000000000000 | 719
lsh 0xcc 255 => 0x660000000000000000000000000000000000000000000000000000000000000000 | 709
lsh 0xcc -256 => 0 | 280

; parameter isn't allowed to be wider than 32 bits
lsh 0xcc 0x0000000001 => FAIL
lsh 0xcc "foo" => FAIL

; tests ported from clvm
lsh 7 1 => 14 | 293
lsh 7 100 => 0x70000000000000000000000000 | 449
lsh -7 100 => 0x0f90000000000000000000000000 | 462
lsh 0x90000000000000000000000000 -100 => 9 | 329
lsh 1 => FAIL
lsh 1 1 1 => FAIL
lsh ( "foo" ) 1 => FAIL
lsh 500 65535 => 0x00fa0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000 | 106802
lsh 500 -65535 => ( ) | 283
lsh 500 65536 => FAIL
lsh 500 -65536 => FAIL
lsh 0x00000000000000000000000000000000000000000000000000000000000000000007 0x0000000000000000000000000000000000000000000000000000000000000000000001 => FAIL
lsh 0xffffff 0 => 0x00ffffff | 335
lsh 0xffffff 1 => 0x01fffffe | 338
lsh 0x00ffffff -1 => 0x7fffff | 328
lsh 0xffffff 8 => 0x00ffffff00 | 348

not => FAIL
not 1 2 => FAIL
not 0 => 1 | 200
not 1 => 0 | 200
not 0xffff => 0 | 200
; a sigle zero-byte counts as true
not 0x00 => 0 | 200
not ( "foo" "bar" ) => ( ) | 200

; a non-empty list counts as "true"
not ( 1 2 3 ) => 0 | 200
not ( ) => 1 | 200

any => 0 | 200
any 0 => 0 | 500
any 0 0 => 0 | 800
any 1 0 => 1 | 800
any 0 1 => 1 | 800
any 1 ( "foo" ) => 1 | 800
; a sigle zero-byte counts as true
any 0x00 => 1 | 500

; a non-empty list counts as "true"
any 0 ( 1 2 ) => 1 | 800
any ( ) ( 1 2 ) => 1 | 800
any ( ) 0 => 0 | 800

all => 1 | 200
all 1 => 1 | 500
all 0 => 0 | 500
all 1 0 => 0 | 800
all 0 1 => 0 | 800
all 1 2 3 => 1 | 1100
all 1 1 0 => 0 | 1100
all 1 ( "foo" ) => 1 | 800
all 0x00 => 1 | 500
all 0x00 0 => 0 | 800

; a non-empty list counts as "true"
all ( 1 ) 2 3 => 1 | 1100
all ( 1 ) 2 ( ) => 0 | 1100

x => FAIL
x ( "msg" ) => FAIL
x "error_message" => FAIL

> => FAIL
> 0 => FAIL
> 0 0 => 0 | 498

> ( 1 0 ) => FAIL
> ( 1 ) 0 => FAIL
> 0 ( 1 ) => FAIL
> 1 0 => 1 | 500
> 0 1 => 0 | 500
> 0 -1 => 1 | 500
> -1 0 => 0 | 500
> 0x0000000000000000000000000000000000000000000000000000000000000000000493e0 0x000000000000000000000000000000000000000000000000000000000000005a => 1 | 634
> 3 300 => 0 | 504
> 300 3 => 1 | 504
> "foobar" "foo" => 1 | 516
> "foo" "boo" => 1 | 510
> "bar" "foo" => 0 | 510

; tests ported from clvm
> 10 => FAIL
> 11 10 => 1 | 502
> 9 10 => ( ) | 502
> ( 0 ) 0 => FAIL
> 3 300 => ( ) | 504
> 0x5a 0x0493e0 => ( ) | 506
> 0x0493e0 0x5a => 1 | 506

>s => FAIL
>s 0x00 => FAIL
>s 0x00 0x00 => 0 | 119
>s 0x00 0x00 0x00 => FAIL
>s ( 1 ) ( 2 ) => FAIL
>s "foo" ( 2 ) => FAIL
>s ( 2 ) "foo" => FAIL

; -1 is 0xff which compares greater than 0, an empty atom
>s -1 0 => 1 | 118
>s 0 -1 => 0 | 118
>s 0x01 0x00 => 1 | 119
>s 0x1001 0x1000 => 1 | 121
>s 0x1000 0x1001 => 0 | 121
>s "foo" "bar" => 1 | 123
>s "bar" "foo" => 0 | 123
>s "foo" "foo" => 0 | 123

; tests ported from clvm
>s 0x001004 ( 100 200 ) => FAIL
>s 0x00 "" => 1 | 118
>s 0x01 0x00 => 1 | 119
>s 0x00 0x01 => ( ) | 119
>s 0x1000 0x1001 => ( ) | 121
>s 0x1000 0x01 => 1 | 120
>s 0x1000 0x1000 => ( ) | 121
>s 0x001004 0x1005 => ( ) | 122
>s 0x1005 0x001004 => 1 | 122
>s ( 100 200 ) 0x001004 => FAIL


= => FAIL
= 0x00 => FAIL
= 0x00 0x00 0x00 => FAIL
= ( "foo" ) "foo" => FAIL
= "foo" ( "foo" ) => FAIL
= 0 ( 0 ) => FAIL
= ( 0 ) 0 => FAIL
= 10 => FAIL

= 0 0 => 1 | 117
= 1 1 => 1 | 119
= 0 0 => 1 | 117
= 0 0x00 => 0 | 118
= 0x00 0 => 0 | 118
= 0xff 0xffff => 0 | 120
= -1 -1 => 1 | 119
= 1 1 => 1 | 119
= 10 10 => 1 | 119
= 2 3 => 0 | 119
= 256 256 => 1 | 121
= 255 -1 => 0 | 120
= 65535 -1 => 0 | 121
= 65535 65535 => 1 | 123
= 65536 65536 => 1 | 123
= 4294967295 4294967295 => 1 | 127
= 4294967296 4294967296 => 1 | 127
= 2147483647 2147483647 => 1 | 125
= 2147483648 2147483648 => 1 | 127
= 0x00000000000000000000000000000000000000000000000000000010 0x00000000000000000000000000000000000000000000000000000010 => 1 | 173
= 0x00000000000000000000000000000000000000000000000000000010 0x00000000000000000000000000000000000000000000000000000020 => 0 | 173
= 0x000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010 0x000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010 => 1 | 807

; invalid arguments
+ ( 1 ) => FAIL
+ 1 ( 2 ) => FAIL
+ ( 2 ) 1 => FAIL

+ => 0 | 99
+ 0 => 0 | 419
+ 0 0 => 0 | 739
+ 0 0 0 => 0 | 1059
+ 7 1 => 8 | 755
+ 1 => 1 | 432
+ -1 1 => 0 | 745
+ 1 2 3 4 => 10 | 1401
+ 10 20 => 30 | 755
+ -100 100 => 0 | 745
+ 100 -100 => 0 | 745
+ 32768 32768 => 65536 | 787
+ -32768 -32768 => -65536 | 781
+ 65536 65536 => 131072 | 787
+ -65536 -65536 => -131072 | 787
+ -32768 -32768 => -65536 | 781
+ 2147483648 2147483648 => 4294967296 | 819
+ -2147483648 -2147483648 => -4294967296 | 813
+ 0x010000000000000000 0x010000000000000000 => 0x020000000000000000 | 883
+ 18446744073709551616 18446744073709551616 => 36893488147419103232 | 883
+ -18446744073709551616 -18446744073709551616 => -36893488147419103232 | 883
+ 18446744073709551616 -18446744073709551616 => 0 | 793
+ -18446744073709551616 18446744073709551616 => 0 | 793
+ 0x00cccccccc 0x33333333 => 0x00ffffffff | 816
; -3355444 + 3355443 = -1
+ 0xcccccccc 0x33333333 => 0xff | 773
+ 0x00000000000000000000000000000003 0x00000000000000000000000000000002 => 5 | 845

; invalid arguments
- ( 1 ) => FAIL
- 1 ( 1 ) => FAIL
- ( 2 ) 2 => FAIL

- => 0 | 99
- 0 => 0 | 419
- 0 0 => 0 | 739
- 0 0 0 => 0 | 1059
- -1 1 => -2 | 755
- 1 -1 => 2 | 755
- 1 2 3 4 => -8 | 1401
- -100 100 => -200 | 765
- 100 -100 => 200 | 765
- 32768 32768 => 0 | 757
- -32768 -32768 => 0 | 751
- 32768 -32768 => 65536 | 784
- 65536 65536 => 0 | 757
- 65536 -65536 => 131072 | 787
- -65536 -65536 => 0 | 757
- -32768 -32768 => 0 | 751
- 2147483648 2147483648 => 0 | 769
- 2147483648 -2147483648 => 4294967296 | 816
- -2147483648 -2147483648 => 0 | 763
- 0x010000000000000000 0x010000000000000000 => 0 | 793
- 18446744073709551616 -18446744073709551616 => 36893488147419103232 | 883
- 0 18446744073709551616 18446744073709551616 => -36893488147419103232 | 1203
- -18446744073709551616 -18446744073709551616 => 0 | 793
- 18446744073709551616 18446744073709551616 => 0 | 793
- 0x00cccccccc 0x33333333 => 0x0099999999 | 816
; -3355444 - 3355443 = -6710887
- 0xcccccccc 0x33333333 => 0x99999999 | 803
- 0x00000000000000000000000000000003 0x00000000000000000000000000000002 => 1 | 845
- 0 35768 => -35768 | 778
- 0 65536 => -65536 | 778
- 0 2147483648 => -2147483648 | 794
- 0 4294967296 => -4294967296 | 804
- 0 18446744073709551616 => -18446744073709551616 | 856

; tests ported from clvm
- 7 1 => 6 | 755
- 1 => 1 | 432
- ( ) => ( ) | 419
- => ( ) | 99
- 0x000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007 0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001 => 6 | 1088

; invalid arguments
* ( 2 ) => FAIL
* 1 ( 2 ) => FAIL
* ( 2 ) 1 => FAIL

* => 1 | 102
* 0 => 0 | 92
* "foobar" => "foobar" | 152
* 1337 => 1337 | 112
* 7 2 => 14 | 999
* 1 2 3 4 => 24 | 2793
* 2 2 2 2 2 2 2 2 => 256 | 6391
* 10 10 10 10 => 10000 | 2809
* 7 -1 => -7 | 999
* -1 7 => -7 | 999
* 1337 -1 => -1337 | 1015
* -1 1337 => -1337 | 1015
* -1 -1 => 1 | 999
* -1 1 => -1 | 999
* 1 -1 => -1 | 999
* 1 1 => 1 | 999
* -1 -1 -1 -1 -1 -1 -1 -1 => 1 | 6381
* -1 -1 -1 -1 -1 -1 -1 -1 -1 => -1 | 7278
* 0x000000000000000007 0x000000000000000002 => 14 | 1095
* 0x000000000000000007 0xffffffffffffffffff => -7 | 1095
* 0x000000000000000007 0xffffffffffffffffff 0 => 0 | 1976
* 0x010000 0x010000 => 0x0100000000 | 1063
* 0x0100000000 0x0100000000 => 0x010000000000000000 | 1127
* 4294967296 4294967296 4294967296 => 79228162514264337593543950336 | 2136
* 4294967296 4294967296 -4294967296 => -79228162514264337593543950336 | 2136
* 4294967296 -4294967296 -4294967296 => 79228162514264337593543950336 | 2136
* 65536 65536 65536 => 281474976710656 | 2016
* 65536 65536 -65536 => -281474976710656 | 2016
* 65536 -65536 -65536 => 281474976710656 | 2016
* 10000000000000000000000000000000000 10000000000000000000000000000000000 10000000000000000000000000000000000 10000000000000000000000000000000000 10000000000000000000000000000000000 10000000000000000000000000000000000 10000000000000000000000000000000000 10000000000000000000000000000000000 10000000000000000000000000000000000 10000000000000000000000000000000000 => 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000 | 14198

; tests ported from clvm
* 7 2 => 14 | 999
* 1 => 1 | 102
* ( ) => ( ) | 92
* => 1 | 102
* 0x00000000000000000000000000000000000000000000000000000000000000000000000007 0x0000000000000000000000000000000000000000000000000000000000000000000000000000000002 => 14 | 1466
* 7 -1 => -7 | 999

; wrong number of arguments
/ => FAIL
/ 1 => FAIL
/ 1 2 3 => FAIL

; division by zero
/ 0 0 => FAIL
/ 10 0 => FAIL
/ -10 0 => FAIL

; division round towards negative infinity
/ 10 3 => 3 | 1006
/ -10 3 => -4 | 1006
/ -10 -3 => 3 | 1006
/ 10 -3 => -4 | 1006

/ 80001 73 => 1095 | 1024
/ -80001 73 => -1096 | 1024
/ 80001 -73 => -1096 | 1024
/ 0x00000000000000000a 0x000000000000000005 => 2 | 1070

/ 1 10 => 0 | 996
/ -1 -10 => 0 | 996

/ 1 1 => 1 | 1006
/ 1 -1 => -1 | 1006
/ -1 -1 => 1 | 1006
/ -1 1 => -1 | 1006
/ 0 -1 => 0 | 992
/ 0 1 => 0 | 992

; these results are incorrect.
; the result should be -1
; the / operator on negative numbers is deprecated because of this
; the mempool version of op_div disallows negative operands
/ -1 10 => 0 | 996
/ 1 -10 => 0 | 996

; wrong number of arguments
div_depr => FAIL
div_depr 1 => FAIL
div_depr 1 2 3 => FAIL

; division by zero
div_depr 0 0 => FAIL
div_depr 10 0 => FAIL
div_depr -10 0 => FAIL

; division round towards negative infinity
div_depr 10 3 => 3 | 1006
div_depr -10 3 => FAIL
div_depr -10 -3 => FAIL
div_depr 10 -3 => FAIL

div_depr 80001 73 => 1095 | 1024
div_depr -80001 73 => FAIL
div_depr 0x00000000000000000a 0x000000000000000005 => 2 | 1070

div_depr 1 10 => 0 | 996
div_depr -1 -10 => FAIL

div_depr 1 1 => 1 | 1006
div_depr 1 -1 =>  FAIL
div_depr -1 -1 => FAIL
div_depr -1 1 => FAIL
div_depr 0 -1 => FAIL
div_depr 0 1 => 0 | 992

; these results are incorrect.
; the result should be -1
; the div_depr operator is deprecated because of this
div_depr -1 10 => FAIL
div_depr 1 -10 => FAIL

; wrong number of arguments
divmod => FAIL
divmod ( 2 ) => FAIL
divmod 1 => FAIL
divmod 1 ( 2 ) => FAIL
divmod ( 2 ) 1 => FAIL
divmod 1 2 3 => FAIL
divmod ( 200 80001 ) 73 => FAIL
divmod 80001 ( 200 73 ) => FAIL

; division by zero
divmod 0 0 => FAIL
divmod 10 0 => FAIL
divmod -10 0 => FAIL
divmod 80001 0 => FAIL

; division round towards negative infinity
divmod 10 3 => ( 3 . 1 ) | 1148
divmod -10 3 => ( -4 . 2 ) | 1148
divmod -10 -3 => ( 3 . -1 ) | 1148
divmod 10 -3 => ( -4 . -2 ) | 1148

divmod 1 3 => ( 0 . 1 ) | 1138
divmod -1 3 => ( -1 . 2 ) | 1148
divmod -1 -3 => ( 0 . -1 ) | 1138
divmod 1 -3 => ( -1 . -2 ) | 1148

divmod 1 1 => ( 1 . 0 ) | 1138
divmod -1 1 => ( -1 . 0 ) | 1138
divmod -1 -1 => ( 1 . 0 ) | 1138
divmod 1 -1 => ( -1 . 0 ) | 1138

divmod 1 10 => ( 0 . 1 ) | 1138
divmod 1 -10 => ( -1 . -9 ) | 1148
divmod -1 -10 => ( 0 . -1 ) | 1138
divmod -1 10 => ( -1 . 9 ) | 1148
divmod 1 -1000000000000 => ( -1 . -999999999999 ) | 1228
divmod -1 1000000000000 => ( -1 . 999999999999 ) | 1228

divmod 80001 73 => ( 1095 . 66 ) | 1170
divmod -80001 73 => ( -1096 . 7 ) | 1170
divmod -80001 -73 => ( 1095 . -66 ) | 1170
divmod 80001 -73 => ( -1096 . -7 ) | 1170

divmod 80000 -10 => ( -8000 . 0 ) | 1160
divmod 80000 10 => ( 8000 . 0 ) | 1160
divmod -80000 10 => ( -8000 . 0 )  | 1160

divmod 0x00000000000000000a 0x000000000000000005 => ( 2 . 0 ) | 1234
divmod 0x000000000000000000000000000000000000000000000000000000000000013881 0x000000000000000000000000000000000000000000000000000049 => ( 1095 . 66 ) | 1506

divmod -10 -7 => ( 1 . -3 ) | 1148
divmod -10 7 => ( -2 . 4 ) | 1148
divmod 10 -7 => ( -2 . -4 ) | 1148
divmod 10 7 => ( 1 . 3 ) | 1148
divmod -10 -70 => ( ( ) . -10 ) | 1138
divmod -10 70 => ( -1 . 60 ) | 1148
divmod 10 -70 => ( -1 . -60 ) | 1148
divmod 10 70 => ( ( ) . 10 ) | 1138
divmod -100 -7 => ( 14 . -2 ) | 1148
divmod -100 7 => ( -15 . 5 ) | 1148
divmod 100 -7 => ( -15 . -5 ) | 1148
divmod 100 7 => ( 14 . 2 ) | 1148
divmod -100 -70 => ( 1 . -30 ) | 1148
divmod -100 70 => ( -2 . 40 ) | 1148
divmod 100 -70 => ( -2 . -40 ) | 1148
divmod 100 70 => ( 1 . 30 ) | 1148

; cost argument is required
softfork => FAIL

; cost must be an integer
softfork ( 50 ) => FAIL

; cost must be > 0
softfork 0 => FAIL
softfork -1 => FAIL

softfork 50 => 0 | 50
softfork 51 110 => 0 | 51
softfork => FAIL
softfork 3121 => 0 | 3121
softfork 0x00000000000000000000000000000000000050 => 0 | 80
softfork 0xffffffffffffffff => FAIL
; technically, this is a valid cost, but it still exceeds the limit we set for the tests
softfork 0xffffffffffffff => FAIL
softfork 0 => FAIL

softfork 51 ( 1 60 50 ) => ( ) | 51
softfork 3121 ( 1 60 50 ) =>  () | 3121
softfork 0 ( 1 60 50 ) => FAIL
softfork 0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000050 => ( ) | 80

strlen => FAIL
strlen ( "list" ) => FAIL
strlen "" => 0 | 173
strlen "a" => 1 | 184
strlen "foobar" => 6 | 189
; this is just 0xff
strlen -1 => 1 | 184

; tests ported from clvm
strlen "foo-bar" => 7 | 190
strlen ( "foo-bar" ) => FAIL
strlen ( ) => 0 | 173
strlen "the quick brown fox jumps over the lazy dogs" => 44 | 227

concat ( "ab" ) => FAIL
concat ( "ab" ) "1" => FAIL
concat "" => "" | 277
concat "abc" => "abc" | 316
concat "a" => "a" | 290
concat "a" "b" => "ab" | 438
concat "a" "b" "c" => "abc" | 586
concat "abc" "" => "abc" | 451
concat "" "ab" "c" => "abc" | 586
concat 0xff 0x00 => 0xff00 | 438
concat 0x00 0x00 => 0x0000 | 438
concat 0x00 0xff => 0x00ff | 438
concat 0xbaad 0xf00d => 0xbaadf00d | 464
concat "foo" "bar" => "foobar" | 490

substr => FAIL
substr "abc" => FAIL
substr "foo" ( "bar" ) => FAIL
substr ( "abc" ) 1 => FAIL
substr "abc" 1 => "bc" | 1
substr "foobar" 1 => "oobar" | 1
substr "foobar" 1 1 => "" | 1
substr "foobar" 1 2 => "o" | 1
substr "foobar" 3 => "bar" | 1
substr "foobar" 3 4 => "b" | 1
substr "foobar" 1 1 => "" | 1
substr 0x112233445566778899aabbccddeeff 1 2 => 0x22 | 1
substr 0x112233445566778899aabbccddeeff 5 7 => 0x6677 | 1

; one-past-end is a valid index
substr "foobar" 6 6 => "" | 1

; begin must be >= end
substr "foobar" 1 0 => FAIL
substr "foobar" 3 1 => FAIL
substr "foobar" 6 0 => FAIL

; begin must be a valid index
substr "foobar" -1 0 => FAIL
substr "foobar" -1 1 => FAIL
substr "foobar" 7 0 => FAIL
substr "foobar" ( 0 ) 1 => FAIL

; end must be a valid index
substr "foobar" 2 10 => FAIL
substr "foobar" 2 -10 => FAIL
substr "foobar" 5 7 => FAIL
substr "foobar" 0 ( 1 ) => FAIL

; indices must not be narrower than 32 bits
substr "foobar" 0x0000000001 2 => FAIL
substr "foobar" 2 0x0000000003 => FAIL
substr "foobar" 2 0x00000003 => "o" | 1
substr "foobar" 0x00000002 3 => "o" | 1

substr "foobar" 0xffffffff 0xffffffff => FAIL
substr "foobar" 0x00ffffffff 0x00ffffffff => FAIL
substr "foobar" 0x7fffffff 0x7fffffff => FAIL
substr "foobar" 0xffffffff => FAIL
substr "foobar" 0x00ffffffff => FAIL
substr "foobar" 0x7fffffff => FAIL

; test cases ported from clvm
substr "abcdefghijkl" 14 => FAIL
substr "abcdefghijkl" 0 => "abcdefghijkl" | 1
substr "abcdefghijkl" -1 => FAIL
substr "abcdefghijkl" 12 => ( ) | 1
substr "abcdefghijkl" 11 => 108 | 1
substr "abcdefghijkl" 0 4 => "abcd" | 1
substr "abcdefghijkl" 0 12 => "abcdefghijkl" | 1
substr "abcdefghijkl" -1 12 => FAIL
substr "abcdefghijkl" 0 13 => FAIL
substr "abcdefghijkl" 10 10 => ( ) | 1
substr "abcdefghijkl" 10 9 => FAIL
substr "abcdefghijkl" 1 4 => "bcd" | 1
substr "abcdefghijkl" 8 12 => "ijkl" | 1
substr ( "abcdefghijkl" ) 0 4 => FAIL
substr "abcdefghijkl" ( 0 ) 4 => FAIL
substr "abcdefghijkl" 0 ( 4 ) => FAIL
substr "abcdefghijkl" 0x000000000000000000000000000000000000000000000000000000000000000002 0x0000000000000000000000000000000000000000000000000000000000000005 => FAIL
substr "abcdefghijkl" 0 -1 => FAIL
substr "abcdefghijkl" 4294967297 3 => FAIL

i ( ) => FAIL
i ( 1 ) => FAIL
i => FAIL
i 1 => FAIL
i 1 1 => FAIL
i 1 1 1 1 => FAIL
i 1 "true" "false" => "true" | 33
i 0 "true" "false" => "false" | 33
i 0 "true" "false" => "false" | 33
i "" "true" "false" => "false" | 33
i 10 "true" "false" => "true" | 33
i -1 "true" "false" => "true" | 33

; tests ported from clvm
i 100 200 300 => 200 | 33
i ( ) 200 300 => 300 | 33
i 1 200 300 => 200 | 33

sha256 ( "hello" ) => FAIL
sha256 ( "foo" "bar" ) => FAIL
sha256 "hello.there.my.dear.friend" => 0x5272821c151fdd49f19cc58cf8833da5781c7478a36d500e8dc2364be39f8216 | 593
sha256 "hell" "o.there.my.dear.friend" => 0x5272821c151fdd49f19cc58cf8833da5781c7478a36d500e8dc2364be39f8216 | 727
; test vectors from https://www.di-mgt.com.au/sha_testvectors.html
sha256 0x616263 => 0xba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad | 547
sha256 0x61 0x62 0x63 => 0xba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad | 815
sha256 => 0xe3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855 | 407
sha256 "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq" => 0x248d6a61d20638b8e5c026930c3e6039a33ce45964ff2167f6ecedd419db06c1 | 653

c => FAIL
c 1 => FAIL
c 1 ( 2 ) "garbage" => FAIL
c 100 ( ) => ( 100 ) | 50
c 1 ( 2 ) => ( 1 2 ) | 50
c 0 ( 2 ) => ( 0 2 ) | 50
c 1 2 => ( 1 . 2 ) | 50
c 1 ( 2 3 4 ) => ( 1 2 3 4 ) | 50
c ( 1 2 3 ) ( 4 5 6 ) => ( ( 1 2 3 ) 4 5 6 ) | 50
c 100 ( ( 500 ( 200 300 400 ) ) ) => ( 100 ( 500 ( 200 300 400 ) ) ) | 50

f 0 => FAIL
f 1 => FAIL
f ( ) => FAIL
f ( 1 2 3 ) 1 => FAIL
f ( 1 2 3 ) => 1 | 30
f ( ( 1 2 ) 3 ) => ( 1 2 ) | 30
f ( 100 ) => 100 | 30
f ( 1 2 3 ) => 1 | 30

r 1 => FAIL
r => FAIL
r ( 1 2 3 ) 12 => FAIL
r 0 => FAIL
r ( 1 2 3 ) => ( 2 3 ) | 30
r ( 1 . 2 ) => 2 | 30

; tests ported from clvm
r ( 100 ) => ( ) | 30
r ( 100 200 300 ) => ( 200 300 ) | 30
r ( ) => FAIL

l => FAIL
l ( 1 2 ) 1 => FAIL
l ( 1 2 3 ) => 1 | 19
l 1 => 0 | 19
l 0 => 0 | 19
l ( 0 . 0 ) => 1 | 19
l ( 1 . 2 ) => 1 | 19

; tests ported from clvm
l 100 =>  ( ) | 19
l ( 100 ) => 1 | 19
l => FAIL
l 100 200 => FAIL
l 50 => ( ) | 19

point_add 0x97f1d3a73197d7942695638c4fa9ac0fc3688c4f9774b905a14e3a3f171bac586c55e83ff97a1aeffb3af00adb22c6bb 0xa572cbea904d67468808c8eb50a9450c9721db309128012543902d0ac358a62ae28f75bb8f1c7c42c39a8c5529bf0f4e => 0x89ece308f9d1f0131765212deca99697b112d61f9be9a5f1f3780a51335b3ff981747a0b2ca2179b96d2c0c9024e5224 | 2789534
point_add => 0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000 | 101574
; the point must be 40 bytes
point_add 0x97f1d3a73197d7942695638c4fa9ac0fc3688c4f9774b905a14e3a3f171bac586c55e83ff97a1aeffb3af00adb22c6 => FAIL
point_add 0x97f1d3a73197d7942695638c4fa9ac0fc3688c4f9774b905a14e3a3f171bac586c55e83ff97a1aeffb3af00adb22c6bb00 => FAIL
point_add 0 => FAIL

; the point must be an atom
point_add ( 1 2 3 ) => FAIL

pubkey_for_exp 1 => 0x97f1d3a73197d7942695638c4fa9ac0fc3688c4f9774b905a14e3a3f171bac586c55e83ff97a1aeffb3af00adb22c6bb | 1326248
pubkey_for_exp 2 => 0xa572cbea904d67468808c8eb50a9450c9721db309128012543902d0ac358a62ae28f75bb8f1c7c42c39a8c5529bf0f4e | 1326248
pubkey_for_exp 3 => 0x89ece308f9d1f0131765212deca99697b112d61f9be9a5f1f3780a51335b3ff981747a0b2ca2179b96d2c0c9024e5224 | 1326248
pubkey_for_exp 5 => 0xb0e7791fb972fe014159aa33a98622da3cdc98ff707965e536d8636b5fcc5ac7a91a8c46e59a00dca575af0f18fb13dc | 1326248

pubkey_for_exp -1 => 0xb7f1d3a73197d7942695638c4fa9ac0fc3688c4f9774b905a14e3a3f171bac586c55e83ff97a1aeffb3af00adb22c6bb | 1326248
pubkey_for_exp -2 => 0x8572cbea904d67468808c8eb50a9450c9721db309128012543902d0ac358a62ae28f75bb8f1c7c42c39a8c5529bf0f4e | 1326248
pubkey_for_exp -3 => 0xa9ece308f9d1f0131765212deca99697b112d61f9be9a5f1f3780a51335b3ff981747a0b2ca2179b96d2c0c9024e5224 | 1326248
pubkey_for_exp -5 => 0x90e7791fb972fe014159aa33a98622da3cdc98ff707965e536d8636b5fcc5ac7a91a8c46e59a00dca575af0f18fb13dc | 1326248

; This is GROUP_ORDER (and surroundings)
pubkey_for_exp 0x73eda753299d7d483339d80809a1d80553bda402fffe5bfeffffffff00000002 => 0x97f1d3a73197d7942695638c4fa9ac0fc3688c4f9774b905a14e3a3f171bac586c55e83ff97a1aeffb3af00adb22c6bb | 1327426
pubkey_for_exp 0x73eda753299d7d483339d80809a1d80553bda402fffe5bfeffffffff00000001 => 0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000 | 1327426
pubkey_for_exp 0x73eda753299d7d483339d80809a1d80553bda402fffe5bfeffffffff00000000 => 0xb7f1d3a73197d7942695638c4fa9ac0fc3688c4f9774b905a14e3a3f171bac586c55e83ff97a1aeffb3af00adb22c6bb | 1327426
pubkey_for_exp 0x73eda753299d7d483339d80809a1d80553bda402fffe5bfeffffffff00f00000 => 0xb88845f6b070026e15fa44490ad925348ce445eaf4e8bc907cbfab30c5474d20f10f56a18fd0f25f2e18c33fba11d6ce | 1327426

; This is -GROUP_ORDER (and surroundings)
pubkey_for_exp 0x8c1258acd66282b7ccc627f7f65e27faac425bfd0001a40100000000fffffffe => 0xb7f1d3a73197d7942695638c4fa9ac0fc3688c4f9774b905a14e3a3f171bac586c55e83ff97a1aeffb3af00adb22c6bb | 1327426
pubkey_for_exp 0x8c1258acd66282b7ccc627f7f65e27faac425bfd0001a40100000000ffffffff => 0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000 | 1327426
pubkey_for_exp 0x8c1258acd66282b7ccc627f7f65e27faac425bfd0001a4010000000000000000 => 0x847f5fcce0b9aa0f2bb3de6847337c9ed1bc2184a125c232721e1c81b0f0fee78506790a78c98abff2dd4b01a0756352 | 1327426
"#;

fn parse_atom(a: &mut Allocator, v: &str) -> NodePtr {
    if v == "0" {
        return a.null();
    }

    assert!(v.len() > 0);

    if v.starts_with("0x") {
        let buf = Vec::from_hex(v.strip_prefix("0x").unwrap()).unwrap();
        return a.new_atom(&buf).unwrap();
    }

    if v.starts_with("\"") {
        assert!(v.ends_with("\""));
        let buf = v
            .strip_prefix("\"")
            .unwrap()
            .strip_suffix("\"")
            .unwrap()
            .as_bytes();
        return a.new_atom(&buf).unwrap();
    }

    if let Ok(num) = Number::from_str_radix(v, 10) {
        ptr_from_number(a, &num).unwrap()
    } else {
        let v = if v.starts_with("#") { &v[1..] } else { v };
        match v {
            "q" => a.new_atom(&[1]).unwrap(),
            "a" => a.new_atom(&[2]).unwrap(),
            "i" => a.new_atom(&[3]).unwrap(),
            "c" => a.new_atom(&[4]).unwrap(),
            "f" => a.new_atom(&[5]).unwrap(),
            "r" => a.new_atom(&[6]).unwrap(),
            "l" => a.new_atom(&[7]).unwrap(),
            "x" => a.new_atom(&[8]).unwrap(),
            "=" => a.new_atom(&[9]).unwrap(),
            ">s" => a.new_atom(&[10]).unwrap(),
            "sha256" => a.new_atom(&[11]).unwrap(),
            "substr" => a.new_atom(&[12]).unwrap(),
            "strlen" => a.new_atom(&[13]).unwrap(),
            "concat" => a.new_atom(&[14]).unwrap(),

            "+" => a.new_atom(&[16]).unwrap(),
            "-" => a.new_atom(&[17]).unwrap(),
            "*" => a.new_atom(&[18]).unwrap(),
            "/" => a.new_atom(&[19]).unwrap(),
            "divmod" => a.new_atom(&[20]).unwrap(),
            ">" => a.new_atom(&[21]).unwrap(),
            "ash" => a.new_atom(&[22]).unwrap(),
            "lsh" => a.new_atom(&[23]).unwrap(),
            "logand" => a.new_atom(&[24]).unwrap(),
            "logior" => a.new_atom(&[25]).unwrap(),
            "logxor" => a.new_atom(&[26]).unwrap(),
            "lognot" => a.new_atom(&[27]).unwrap(),

            "point_add" => a.new_atom(&[29]).unwrap(),
            "pubkey_for_exp" => a.new_atom(&[30]).unwrap(),

            "not" => a.new_atom(&[32]).unwrap(),
            "any" => a.new_atom(&[33]).unwrap(),
            "all" => a.new_atom(&[34]).unwrap(),

            "softfork" => a.new_atom(&[36]).unwrap(),
            _ => {
                panic!("atom not supported \"{}\"", v);
            }
        }
    }
}

fn pop_token<'a>(s: &'a str) -> (&'a str, &'a str) {
    let s = s.trim();
    if s.starts_with("\"") {
        if let Some(second_quote) = &s[1..].find("\"") {
            let (first, rest) = s.split_at(second_quote + 2);
            (first.trim(), rest.trim())
        } else {
            panic!("mismatching quote")
        }
    } else if s.starts_with("(") || s.starts_with(")") {
        let (first, rest) = s.split_at(1);
        (first, rest.trim())
    } else {
        let space = s.find(' ');
        let close = s.find(')');

        let split_pos = if space.is_some() && close.is_some() {
            min(space.unwrap(), close.unwrap())
        } else if let Some(pos) = space {
            pos
        } else if let Some(pos) = close {
            pos
        } else {
            s.len()
        };

        let (first, rest) = s.split_at(split_pos);
        (first.trim(), rest.trim())
    }
}

pub fn parse_list<'a>(a: &mut Allocator, v: &'a str) -> (NodePtr, &'a str) {
    let v = v.trim();
    let (first, rest) = pop_token(v);
    if first.len() == 0 {
        return (a.null(), rest);
    }
    if first == ")" {
        return (a.null(), rest);
    }
    if first == "(" {
        let (head, new_rest) = parse_list(a, rest);
        let (tail, new_rest) = parse_list(a, new_rest);
        (a.new_pair(head, tail).unwrap(), new_rest)
    } else if first == "." {
        let (node, new_rest) = parse_exp(a, rest);
        let (end_list, new_rest) = pop_token(new_rest);
        assert_eq!(end_list, ")");
        (node, new_rest)
    } else {
        let head = parse_atom(a, first);
        let (tail, new_rest) = parse_list(a, rest);
        (a.new_pair(head, tail).unwrap(), new_rest)
    }
}

pub fn parse_exp<'a>(a: &mut Allocator, v: &'a str) -> (NodePtr, &'a str) {
    let (first, rest) = pop_token(v);
    if first == "(" {
        parse_list(a, rest)
    } else {
        (parse_atom(a, first), rest)
    }
}

pub fn node_eq(a: &Allocator, a0: NodePtr, a1: NodePtr) -> bool {
    match a.sexp(a0) {
        SExp::Pair(left0, right0) => {
            if let SExp::Pair(left1, right1) = a.sexp(a1) {
                node_eq(a, left0, left1) && node_eq(a, right0, right1)
            } else {
                false
            }
        }
        SExp::Atom(_) => {
            if let SExp::Atom(_) = a.sexp(a1) {
                a.atom(a0) == a.atom(a1)
            } else {
                false
            }
        }
    }
}

type Opf = fn(&mut Allocator, NodePtr, Cost) -> Response;

// the input is a list of test cases, each item is a tuple of:
// (function pointer to test, list of arguments, optional result)
// if the result is None, the call is expected to fail
fn run_op_test(op: &Opf, args_str: &str, expected: &str, expected_cost: u64) {
    let mut a = Allocator::new();

    let (args, rest) = parse_list(&mut a, args_str);
    assert_eq!(rest, "");
    let result = op(&mut a, args, 10000000000 as Cost);
    match result {
        Err(_) => {
            assert_eq!(expected, "FAIL");
        }
        Ok(Reduction(cost, ret_value)) => {
            assert_eq!(cost, expected_cost);
            let (expected, rest) = parse_exp(&mut a, expected);
            assert_eq!(rest, "");
            assert!(node_eq(&a, ret_value, expected));
        }
    }
}

#[test]
fn test_ops() {
    let funs = HashMap::from([
        ("i", op_if as Opf),
        ("c", op_cons as Opf),
        ("f", op_first as Opf),
        ("r", op_rest as Opf),
        ("l", op_listp as Opf),
        ("x", op_raise as Opf),
        ("=", op_eq as Opf),
        ("sha256", op_sha256 as Opf),
        ("+", op_add as Opf),
        ("-", op_subtract as Opf),
        ("*", op_multiply as Opf),
        ("/", op_div as Opf),
        ("div_depr", op_div_deprecated as Opf),
        ("divmod", op_divmod as Opf),
        ("substr", op_substr as Opf),
        ("strlen", op_strlen as Opf),
        ("point_add", op_point_add as Opf),
        ("pubkey_for_exp", op_pubkey_for_exp as Opf),
        ("concat", op_concat as Opf),
        (">", op_gr as Opf),
        (">s", op_gr_bytes as Opf),
        ("logand", op_logand as Opf),
        ("logior", op_logior as Opf),
        ("logxor", op_logxor as Opf),
        ("lognot", op_lognot as Opf),
        ("ash", op_ash as Opf),
        ("lsh", op_lsh as Opf),
        ("not", op_not as Opf),
        ("any", op_any as Opf),
        ("all", op_all as Opf),
        ("softfork", op_softfork as Opf),
    ]);

    for t in TEST_CASES.split("\n") {
        let t = t.trim();
        if t.len() == 0 {
            continue;
        }
        // ignore comments
        if t.starts_with(";") {
            continue;
        }
        let (op_name, t) = t.split_once(" ").unwrap();
        let op = funs.get(op_name).unwrap();
        let (args, out) = t.split_once("=>").unwrap();
        let (expected, expected_cost) = if out.contains("|") {
            out.split_once("|").unwrap()
        } else {
            (out, "0")
        };

        println!("({} {}) => {}", op_name, args.trim(), expected.trim());
        run_op_test(
            op,
            args.trim(),
            expected.trim(),
            expected_cost.trim().parse().unwrap(),
        );
    }
}

#[test]
fn test_single_argument_raise_atom() {
    let mut allocator = Allocator::new();
    let a1 = allocator.new_atom(&[65]).unwrap();
    let args = allocator.new_pair(a1, allocator.null()).unwrap();
    let result = op_raise(&mut allocator, args, 100000);
    assert_eq!(result, Err(EvalErr(a1, "clvm raise".to_string())));
}

#[test]
fn test_single_argument_raise_pair() {
    let mut allocator = Allocator::new();
    let a1 = allocator.new_atom(&[65]).unwrap();
    let a2 = allocator.new_atom(&[66]).unwrap();
    // (a2)
    let mut args = allocator.new_pair(a2, allocator.null()).unwrap();
    // (a1 a2)
    args = allocator.new_pair(a1, args).unwrap();
    // ((a1 a2))
    args = allocator.new_pair(args, allocator.null()).unwrap();
    let result = op_raise(&mut allocator, args, 100000);
    assert_eq!(result, Err(EvalErr(args, "clvm raise".to_string())));
}

#[test]
fn test_multi_argument_raise() {
    let mut allocator = Allocator::new();
    let a1 = allocator.new_atom(&[65]).unwrap();
    let a2 = allocator.new_atom(&[66]).unwrap();
    // (a1)
    let mut args = allocator.new_pair(a2, allocator.null()).unwrap();
    // (a1 a2)
    args = allocator.new_pair(a1, args).unwrap();
    let result = op_raise(&mut allocator, args, 100000);
    assert_eq!(result, Err(EvalErr(args, "clvm raise".to_string())));
}
