window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"pynkowski": {"fullname": "pynkowski", "modulename": "pynkowski", "type": "module", "doc": "<h1 id=\"welcome-to-pynkowskis-documentation\">Welcome to Pynkowski's documentation!</h1>\n\n<p>A Python package to compute Minkowski Functionals of input fields, as well as their expected values in the case of Gaussian isotropic fields.</p>\n\n<p>The formats supported for <strong>input data</strong> are the following:</p>\n\n<ul>\n<li>Scalar HEALPix maps, as the ones used by <a href=\"https://healpy.readthedocs.io/\">healpy</a> (see paper).</li>\n</ul>\n\n<p>...and more to come, feel free to contact us (by <a href=\"mailto:javier.carron@roma2.infn.it\">email</a> or opening an issue) to implement more schemes.</p>\n\n<p>The <strong>theoretical expectation</strong> for Gaussian isotropic fields are implemented in the following cases:</p>\n\n<ul>\n<li>Gaussian scalar maps on the sphere (such as CMB $T$, see paper).</li>\n<li>$\\chi^2$ maps on the sphere (such as CMB $P^2$, see paper).</li>\n</ul>\n\n<p>...and more to come, feel free to contact us (by <a href=\"mailto:javier.carron@roma2.infn.it\">email</a> or opening an issue) to implement more theoretical expectations.</p>\n\n<h2 id=\"installation\">Installation</h2>\n\n<p>This package can be installed with: </p>\n\n<pre><code>pip install pynkowski\n</code></pre>\n\n<p>The dependencies are:</p>\n\n<ul>\n<li><a href=\"https://numpy.org/\">numpy</a></li>\n<li><a href=\"https://scipy.org/\">scipy</a></li>\n<li><a href=\"https://healpy.readthedocs.io/\">healpy</a></li>\n<li><a href=\"https://github.com/tqdm/tqdm\">tqdm</a> (optional, notebook only)</li>\n</ul>\n\n<h2 id=\"example-notebooks\">Example notebooks</h2>\n\n<ul>\n<li>Get the Minkowski Functionals of a CMB temperature $T$ map and compare with theory.</li>\n<li>Get the Minkowski Functionals of a CMB polarization $P^2=Q^2+U^2$ map and compare with theory.</li>\n</ul>\n"}, "pynkowski.data": {"fullname": "pynkowski.data", "modulename": "pynkowski.data", "type": "module", "doc": "<p>This module contains all the classes to compute Minkowski Functionals on data. So far, they are the following:</p>\n\n<ul>\n<li><p><a href=\"data/scalar.html\"><code>scalar</code></a>: scalar maps on the sphere, in the healpix convention,</p></li>\n<li><p>There is also a general utilities submodule called <a href=\"data/utils.html\"><code>utils</code></a>.</p></li>\n</ul>\n"}, "pynkowski.data.scalar": {"fullname": "pynkowski.data.scalar", "modulename": "pynkowski.data.scalar", "type": "module", "doc": "<p></p>\n"}, "pynkowski.data.scalar.Scalar": {"fullname": "pynkowski.data.scalar.Scalar", "modulename": "pynkowski.data.scalar", "qualname": "Scalar", "type": "class", "doc": "<p>Class to compute Minkowski functionals (MFs) and extrema of Healpix scalar maps. It computes and stores spatial first and\nsecond derivatives of Healpix scalar maps.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>Smap</strong> (np.array):\nThe input Healpix map where all the statistics will be computed.</li>\n<li><strong>normalise</strong> (bool, optional):\nIf True, divide input Smap by its standard deviation. Default: True.</li>\n<li><strong>mask</strong> (np.array, optional):\nAn input Healpix mask. All the statiscal quantities will be computed only within this mask. Default: None (all sky is considered).</li>\n</ul>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>Smap</strong> (np.array):\nThe Healpix map where all the statistics are computed.</li>\n<li><strong>nside</strong> (int):\nThe Nside parameter of Smap</li>\n<li><strong>mask</strong> (np.array):\nA Healpix mask whithin which all the statiscal quantities are computed.</li>\n<li><strong>grad_phi</strong> (np.array):\nThe phi covariant first derivative of Smap (only if first or second MFs are computed).</li>\n<li><strong>grad_theta</strong> (np.array):\nThe theta covariant first derivative of Smap (only if first or second MFs are computed).</li>\n<li><strong>der_phi</strong> (np.array):\nThe phi partial first derivative of Smap (only if first or second MFs are computed).</li>\n<li><strong>der_theta_phi</strong> (np.array):\nThe second covariant derivative wrt theta and phi of Smap (only if second MF is computed).</li>\n<li><strong>der_phi_phi</strong> (np.array):\nThe second covariant derivative wrt phi of Smap (only if second MF is computed).</li>\n<li><strong>der_theta_theta</strong> (np.array):\nThe second covariant derivative wrt theta of Smap (only if second MF is computed).</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>The derivatives are always computed full-sky regardless of input mask.</p>\n"}, "pynkowski.data.scalar.Scalar.__init__": {"fullname": "pynkowski.data.scalar.Scalar.__init__", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.__init__", "type": "function", "doc": "<p>Initialise the class to compute Minkowski functionals (MFs) and extrema of Healpix scalar maps. </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>Smap</strong> (np.array):\nThe input Healpix map where all the statistics will be computed.</li>\n<li><strong>normalise</strong> (bool, optional):\nIf True, divide input Smap by its standard deviation. Default: True.</li>\n<li><strong>mask</strong> (np.array, optional):\nAn input Healpix mask. All the statiscal quantities will be computed only within this mask. Default: None (all sky is considered).</li>\n</ul>\n", "signature": "(self, Smap, normalise=True, mask=None)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.get_variance": {"fullname": "pynkowski.data.scalar.Scalar.get_variance", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.get_variance", "type": "function", "doc": "<p>compute the variance of the input Healpix scalar map within the input mask. </p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>var</strong> (float):\nThe variance of the input Healpix map within the input mask.</li>\n</ul>\n", "signature": "(self)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.set_pix": {"fullname": "pynkowski.data.scalar.Scalar.set_pix", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.set_pix", "type": "function", "doc": "<p>return the values of the input Healpix scalar map in pixels pixs. </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>pixs</strong> (np.array):\nThe indices of the input map pixels whose values of the map are returned.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>values</strong> (np.array):\nThe values of the input Healpix scalar map in pixels pixs.</li>\n</ul>\n", "signature": "(self, pixs)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.get_gradient": {"fullname": "pynkowski.data.scalar.Scalar.get_gradient", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.get_gradient", "type": "function", "doc": "<p>Compute the covariant and partial first derivatives of the input Healpix scalar map. \nIt stores:</p>\n\n<ul>\n<li>first covariant derivative wrt theta in self.grad_theta</li>\n<li>first partial derivative wrt phi in self.der_phi</li>\n<li>first covariant derivative wrt phi in self.grad_phi</li>\n</ul>\n", "signature": "(self)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.get_hessian": {"fullname": "pynkowski.data.scalar.Scalar.get_hessian", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.get_hessian", "type": "function", "doc": "<p>compute the covariant second derivatives of the input Healpix scalar map. \nIt stores:</p>\n\n<ul>\n<li>second covariant derivative wrt theta in self.der_theta_theta</li>\n<li>second covariant derivative wrt phi in self.der_phi_phi</li>\n<li>second covariant derivative wrt theta and phi in self.der_theta_phi</li>\n</ul>\n", "signature": "(self)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"fullname": "pynkowski.data.scalar.Scalar.get_\u03ba", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.get_\u03ba", "type": "function", "doc": "<p>Compute the geodesic curvature multiplied by the modulus of the gradient in pixels pixs. If not already computed, it computes \nthe first and second covariant derivatives of the input map.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>pixs</strong> (np.array):\nThe indices of the input map pixels where geodesic curvature is computed.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>k</strong> (np.array):\nThe geodesic curvature in pixels <code>pixs</code>.</li>\n</ul>\n", "signature": "(self, pixs)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.V0_pixel": {"fullname": "pynkowski.data.scalar.Scalar.V0_pixel", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.V0_pixel", "type": "function", "doc": "<p>Determine where input Healpix scalar map Smap is greater than threshold u. </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>u</strong> (float):\nThe threshold considered for the computation of first Minkowski functional V0.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>v0map</strong> (np.array):\na bool array with the same shape as the input map, with False where input map values are lower than threshold u.</li>\n</ul>\n", "signature": "(self, u)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.V0_iter": {"fullname": "pynkowski.data.scalar.Scalar.V0_iter", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.V0_iter", "type": "function", "doc": "<p>Compute the normalised first Minkowski functional v0 at the threshold u within the given mask. </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>u</strong> (float):\nThe threshold considered for the computation of v0.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>v0</strong> (np.array):\nFirst normalised Minkowski functional evaluated at threshold u within the given mask.</li>\n</ul>\n", "signature": "(self, u)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.V0": {"fullname": "pynkowski.data.scalar.Scalar.V0", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.V0", "type": "function", "doc": "<p>Compute the normalised first Minkowski functional v0 at the different thresholds us within the given mask.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>us</strong> (np.array):\nThe thresholds considered for the computation of v0.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>v0s</strong> (np.array):\nFirst normalised Minkowski functional evaluated at thresholds us within the given mask.</li>\n</ul>\n", "signature": "(self, us)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.V1_pixel": {"fullname": "pynkowski.data.scalar.Scalar.V1_pixel", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.V1_pixel", "type": "function", "doc": "<p>Compute the modulus of the gradient where the values of the input map are between <code>u-du/2</code> and <code>u+du/2</code>. </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>u</strong> (float):\nThe centered value of the bin considered for the computation.</li>\n<li><strong>du</strong> (float):\nThe width of the bin considered for the computation.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>v1map</strong> (np.array):\nModulus of the gradient where <code>u-du/2 &lt; Smap &lt; u+du/2</code>.</li>\n</ul>\n", "signature": "(self, u, du)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.V1_iter": {"fullname": "pynkowski.data.scalar.Scalar.V1_iter", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.V1_iter", "type": "function", "doc": "<p>Compute the normalised second Minkowski functional v1 in the bin <code>u-du/2</code> and <code>u+du/2</code> within the given mask. </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>u</strong> (float):\nThe centered value of the bin considered for the computation of v1.</li>\n<li><strong>du</strong> (float):\nThe width of the bin considered for the computation of v1.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>v1</strong> (float):\nSecond normalised Minkowski functional evaluated in the bin u-du/2 and u+du/2 within the given mask.</li>\n</ul>\n", "signature": "(self, u, du)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.V1": {"fullname": "pynkowski.data.scalar.Scalar.V1", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.V1", "type": "function", "doc": "<p>Compute the normalised second Minkowski functional v1 at the different thresholds us within the given mask.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>us</strong> (np.array):\nThe thresholds considered for the computation of v2. See 'edges' for details.</li>\n<li><strong>edges</strong> (bool, optional):\nIf False, us is considered as an array of uniformly distributed thresholds. \nIf True, us is considered as a monotonically increasing array of bin edges, including the rightmost edge, allowing for non-uniform distributions of thresholds. \nIn this last case, the thresholds are the central value of the given bins.\nDefault: False.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>v1s</strong> (np.array):\nSecond normalised Minkowski functional evaluated at thresholds us within the given mask.</li>\n</ul>\n", "signature": "(self, us, edges=False)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.V2_pixel": {"fullname": "pynkowski.data.scalar.Scalar.V2_pixel", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.V2_pixel", "type": "function", "doc": "<p>Compute the geodesic curvature multiplied by the modulus of the gradient where the values of the input map are between <code>u-du/2</code> and <code>u+du/2</code>. </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>u</strong> (float):\nThe centered value of the bin considered for the computation.</li>\n<li><strong>du</strong> (float):\nThe width of the bin considered for the computation.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>v2map</strong> (np.array):\nGeodesic curvature multiplied by the modulus of the gradient where <code>u-du/2 &lt; Smap &lt; u+du/2</code>.</li>\n</ul>\n", "signature": "(self, u, du)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.V2_iter": {"fullname": "pynkowski.data.scalar.Scalar.V2_iter", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.V2_iter", "type": "function", "doc": "<p>Compute the normalised third Minkowski functional v2 in the bin <code>u-du/2</code> and <code>u+du/2</code> within the given mask. </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>u</strong> (float):\nThe centered value of the bin considered for the computation of v2.</li>\n<li><strong>du</strong> (float):\nThe width of the bin considered for the computation of v2.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>v2</strong> (np.array):\nThird normalised Minkowski functional evaluated in the bin u-du/2 and u+du/2 within the given mask.</li>\n</ul>\n", "signature": "(self, u, du)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.V2": {"fullname": "pynkowski.data.scalar.Scalar.V2", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.V2", "type": "function", "doc": "<p>Compute the normalised third Minkowski functional v2 at the different thresholds us within the given mask.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>us</strong> (np.array):\nThe thresholds considered for the computation of v2. See 'edges' for details.</li>\n<li><strong>edges</strong> (bool, optional):\nIf False, us is considered as an array of uniformly distributed thresholds. \nIf True, us is considered as a monotonically increasing array of bin edges, including the rightmost edge, allowing for non-uniform distributions of thresholds. \nIn this last case, the thresholds are the central value of the given bins.\nDefault: False.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>v2s</strong> (np.array):\nThird normalised Minkowski functional evaluated at thresholds us within the given mask.</li>\n</ul>\n", "signature": "(self, us, edges=False)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.get_maxima": {"fullname": "pynkowski.data.scalar.Scalar.get_maxima", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.get_maxima", "type": "function", "doc": "<p>Find the local maxima of the input scalar map.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>pixels</strong> (np.array):\nIndices of the pixels which are local maxima.</li>\n<li><strong>values</strong> (np.array):\nValues of input map which are local maxima.</li>\n</ul>\n", "signature": "(self)", "funcdef": "def"}, "pynkowski.data.scalar.Scalar.get_minima": {"fullname": "pynkowski.data.scalar.Scalar.get_minima", "modulename": "pynkowski.data.scalar", "qualname": "Scalar.get_minima", "type": "function", "doc": "<p>Find the local minima of the input scalar map.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>pixels</strong> (np.array):\nIndices of the pixels which are local minima</li>\n<li><strong>values</strong> (np.array):\nValues of input map which are local minima</li>\n</ul>\n", "signature": "(self)", "funcdef": "def"}, "pynkowski.data.utils": {"fullname": "pynkowski.data.utils", "modulename": "pynkowski.data.utils", "type": "module", "doc": "<p></p>\n"}, "pynkowski.data.utils.get_theta": {"fullname": "pynkowski.data.utils.get_theta", "modulename": "pynkowski.data.utils", "qualname": "get_theta", "type": "function", "doc": "<p>Define a HEALPix map with the value of \u03b8 in each pixel at the input <code>nside</code></p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>nside</strong> (int):\nThe <code>nside</code> of the map</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>theta</strong> (np.array):\nA healpix map with the value of theta in each pixel, in radians.</li>\n</ul>\n", "signature": "(nside)", "funcdef": "def"}, "pynkowski.data.utils.derivatives": {"fullname": "pynkowski.data.utils.derivatives", "modulename": "pynkowski.data.utils", "qualname": "derivatives", "type": "function", "doc": "<p>Find the derivatives d_theta, d_phi of a Healpix map. It uses the healpy alm2map_der1 function.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>mapp</strong> (np.array):\nThe Healpix map to find its derivatives.</li>\n<li><strong>lmax</strong> (int, optional):\nMaximum multipole to get the alm and the derivatives. It can create numerical errors if it is too high. Default: 3*nside-1.</li>\n<li><strong>gradient</strong> (bool, optional):\nIf True, return the covariant derivatives. If False, return the partial derivatives. Default: False.</li>\n<li><strong>**kwargs :</strong>: Extra keywords to pass to the map2alm function.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>d_theta</strong> (np.array):\nA healpix map with the derivative with respect to theta.</li>\n<li><strong>d_phi</strong> (np.array):\nA healpix map with the derivatives with respect to phi, without normalizing.</li>\n</ul>\n", "signature": "(mapp, lmax=None, gradient=False, **kwargs)", "funcdef": "def"}, "pynkowski.data.utils.second_derivatives": {"fullname": "pynkowski.data.utils.second_derivatives", "modulename": "pynkowski.data.utils", "qualname": "second_derivatives", "type": "function", "doc": "<p>Find the Second derivatives for every pixel of a Healpix map given the first partial derivatives.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>d_theta</strong> (np.array):\nThe partial theta derivative of the Healpix map.</li>\n<li><strong>d_phi</strong> (np.array):\nThe partial phi derivative of the Healpix map.</li>\n<li><strong>lmax</strong> (int, optional):\nMaximum multipole to get the alm and the derivatives. It can create numerical errors if it is too high. Default: 3*nside-1.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>d_thetatheta</strong> (np.array):\nA Healpix map of the second partial derivative wrt theta.</li>\n<li><strong>d_phiphi</strong> (np.array):\nA Healpix map of the second partial derivative wrt phi.</li>\n<li><strong>d_phitheta</strong> (np.array):\nA Healpix map of the second partial derivative wrt theta and phi.</li>\n</ul>\n", "signature": "(d_theta, d_phi, lmax=None, **kwargs)", "funcdef": "def"}, "pynkowski.theory": {"fullname": "pynkowski.theory", "modulename": "pynkowski.theory", "type": "module", "doc": "<p>This module contains all the theoretical predictions for the implemented fields. So far, they are the following:</p>\n\n<ul>\n<li><a href=\"theory/temperature.html\"><code>temperature</code></a>: Gaussian fields such as CMB temperature.</li>\n<li><p><a href=\"theory/p2.html\"><code>p2</code></a>: $\\chi^2$ fields, such as the modulus of the CMB polarization.</p></li>\n<li><p>There is also a general utilities submodule called <a href=\"theory/utils.html\"><code>utils</code></a>.</p></li>\n</ul>\n"}, "pynkowski.theory.p2": {"fullname": "pynkowski.theory.p2", "modulename": "pynkowski.theory.p2", "type": "module", "doc": "<p></p>\n"}, "pynkowski.theory.p2.TheoryP2": {"fullname": "pynkowski.theory.p2.TheoryP2", "modulename": "pynkowski.theory.p2", "qualname": "TheoryP2", "type": "class", "doc": "<p>Class to compute the expected values of Minkowski functionals (MFs) for the sum of two squared Gaussian isotropic fields normalised for their standard deviations defined on the sphere \nlike the polarised intensity of the CMB ($P^2 = Q^2 + U^2$).</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>us</strong> (np.array, optional):\nThe thresholds at which the theoretical MFs will be computed. \nIf not given, a range between 0 and 5\u03c3 with steps of 0.1\u03c3 is considered, \nwith \u03c3=1 the expected standard deviation of the fields U and Q.</li>\n<li><strong>cls</strong> (np.array, optional):\nThe angular power spectrum associated to the Gaussian isotropic fields. \nShape '(..., lmax+1)'. '...' can be 2 (EE, BB) or absent (assumed to be EE+BB).\nDefault : None</li>\n<li><strong>\u03bc</strong> (float, optional):\nThe derivative of the covariance function at the origin for each of the two independent Gaussian isotropic fields (i.e., U and Q in the cosmological case).\nIf both \u03bc and cls are given, an error will be raised.\nIf only cls is given, \u03bc will be computed from input cls.\nIf neither \u03bc nor cls are given, \u03bc is assumed to be 1.\nDefault : None</li>\n<li><strong>average_bin</strong> (bool, optional):\nIf True, the results of V1 and V2 are the average on each bin, to be compared with binned computations on maps.\nIf False, the results are the evaluation on the center of each bin.\nThe value is always exactly computed for V0, as the computation on maps does not imply binning.\nDefaul : True</li>\n<li><strong>edges</strong> (bool, optional):\nIf False, the given 'us' is considered as an array of uniformly distributed thresholds. \nIf True, input 'us' is considered as a monotonically increasing array of bin edges, including the rightmost edge, allowing for non-uniform distributions of thresholds. \nIn this last case, the thresholds are the central value of the given bins.\nNeglected if 'us' is not given.\nDefault : False.</li>\n</ul>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>us</strong> (np.array):\nThe thresholds at which the theoretical MFs are computed.</li>\n<li><strong>\u03bc</strong> (float):\nThe derivative of the covariance function at the origin for the sum of two squared Gaussian isotropic fields.</li>\n</ul>\n"}, "pynkowski.theory.p2.TheoryP2.__init__": {"fullname": "pynkowski.theory.p2.TheoryP2.__init__", "modulename": "pynkowski.theory.p2", "qualname": "TheoryP2.__init__", "type": "function", "doc": "<p>Class to compute the expected values of Minkowski functionals (MFs) for a Gaussian isotropic scalar field defined on the sphere.</p>\n", "signature": "(self, us=None, Cls=None, \u03bc=None, average_bin=True, edges=False)", "funcdef": "def"}, "pynkowski.theory.p2.TheoryP2.V0": {"fullname": "pynkowski.theory.p2.TheoryP2.V0", "modulename": "pynkowski.theory.p2", "qualname": "TheoryP2.V0", "type": "function", "doc": "<p>Compute the expected values of the normalised first MF v0 at the different thresholds us.</p>\n\n<p>$$\\mathbb{E}[{v_{0}(u)}] = \\exp (-u/2)$$</p>\n", "signature": "(self)", "funcdef": "def"}, "pynkowski.theory.p2.TheoryP2.V1": {"fullname": "pynkowski.theory.p2.TheoryP2.V1", "modulename": "pynkowski.theory.p2", "qualname": "TheoryP2.V1", "type": "function", "doc": "<p>Compute the expected values of the normalised second MF v1 at the different thresholds us.</p>\n\n<p>$$\\mathbb{E}[{v_{1}(u)}] = {\\sqrt{2\\pi } \\over 8} \\sqrt{\\mu u}\\exp (-{u \\over 2})$$</p>\n", "signature": "(self)", "funcdef": "def"}, "pynkowski.theory.p2.TheoryP2.V2": {"fullname": "pynkowski.theory.p2.TheoryP2.V2", "modulename": "pynkowski.theory.p2", "qualname": "TheoryP2.V2", "type": "function", "doc": "<p>Compute the expected values of the normalised third MF v2 at the different thresholds us.</p>\n\n<p>$$\\mathbb{E}[{v_{2}(u)}] = \\mu {(u-1)\\exp (-u/2) \\over 2\\pi }$$</p>\n", "signature": "(self)", "funcdef": "def"}, "pynkowski.theory.temperature": {"fullname": "pynkowski.theory.temperature", "modulename": "pynkowski.theory.temperature", "type": "module", "doc": "<p></p>\n"}, "pynkowski.theory.temperature.TheoryTemperature": {"fullname": "pynkowski.theory.temperature.TheoryTemperature", "modulename": "pynkowski.theory.temperature", "qualname": "TheoryTemperature", "type": "class", "doc": "<p>Class to compute the expected values of Minkowski functionals (MFs) for a Gaussian isotropic scalar field normalised for its standard deviation defined on the sphere \nlike the temperature anisotropies of the CMB.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>us</strong> (np.array, optional):\nThe thresholds at which the theoretical MFs will be computed. \nIf not given, a range between -5\u03c3 and 5\u03c3 with steps of 0.1\u03c3 is considered, \nwith \u03c3=1 the expected standard deviation of the field.</li>\n<li><strong>cls</strong> (np.array, optional):\nThe angular power spectrum of the Gaussian isotropic scalar field. \nDefault : None</li>\n<li><strong>\u03bc</strong> (float, optional):\nThe derivative of the covariance function at the origin for the Gaussian isotropic scalar field.\nIf both \u03bc and cls are given, an error will be raised.\nIf only cls is given, \u03bc will be computed from input cls.\nIf neither \u03bc nor cls are given, \u03bc is assumed to be 1.\nDefault : None</li>\n<li><strong>average_bin</strong> (bool, optional):\nIf True, the results of V1 and V2 are the average on each bin, to be compared with binned computations on maps.\nIf False, the results are the evaluation on the center of each bin.\nThe value is always exactly computed for V0, as the computation on maps does not imply binning.\nDefaul : True</li>\n<li><strong>edges</strong> (bool, optional):\nIf False, the given 'us' is considered as an array of uniformly distributed thresholds. \nIf True, input 'us' is considered as a monotonically increasing array of bin edges, including the rightmost edge, allowing for non-uniform distributions of thresholds. \nIn this last case, the thresholds are the central value of the given bins.\nNeglected if 'us' is not given.\nDefault : False.</li>\n</ul>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>us</strong> (np.array):\nThe thresholds at which the theoretical MFs are computed.</li>\n<li><strong>\u03bc</strong> (float):\nThe derivative of the covariance function at the origin for the Gaussian isotropic scalar field.</li>\n</ul>\n"}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"fullname": "pynkowski.theory.temperature.TheoryTemperature.__init__", "modulename": "pynkowski.theory.temperature", "qualname": "TheoryTemperature.__init__", "type": "function", "doc": "<p>Class to compute the expected values of Minkowski functionals (MFs) for a Gaussian isotropic scalar field defined on the sphere.</p>\n", "signature": "(self, us=None, cls=None, \u03bc=None, average_bin=True, edges=False)", "funcdef": "def"}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"fullname": "pynkowski.theory.temperature.TheoryTemperature.V0", "modulename": "pynkowski.theory.temperature", "qualname": "TheoryTemperature.V0", "type": "function", "doc": "<p>Compute the expected values of the normalised first MF v0 at the different thresholds us.\n$$\\mathbb{E}[ v_{0} ] =1 -\\Phi (u)$$\nwhere $\\Phi$ is the cumulative normal distribution.</p>\n", "signature": "(self)", "funcdef": "def"}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"fullname": "pynkowski.theory.temperature.TheoryTemperature.V1", "modulename": "pynkowski.theory.temperature", "qualname": "TheoryTemperature.V1", "type": "function", "doc": "<p>Compute the expected values of the normalised second MF v1 at the different thresholds us.</p>\n\n<p>$$\\mathbb{E}[ v_{1}(u) ] = {1 \\over 8} \\exp{(- {u^2 \\over 2})} \\mu^{1/2}$$</p>\n", "signature": "(self)", "funcdef": "def"}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"fullname": "pynkowski.theory.temperature.TheoryTemperature.V2", "modulename": "pynkowski.theory.temperature", "qualname": "TheoryTemperature.V2", "type": "function", "doc": "<p>Compute the expected values of the normalised third MF v2 at the different thresholds us.</p>\n\n<p>$$\\mathbb{E}[v_{2}(u)] = {2 \\over \\sqrt{(2\\pi)^{3}}} \\exp(-{u^{2} \\over 2}) u$$</p>\n", "signature": "(self)", "funcdef": "def"}, "pynkowski.theory.utils": {"fullname": "pynkowski.theory.utils", "modulename": "pynkowski.theory.utils", "type": "module", "doc": "<p></p>\n"}, "pynkowski.theory.utils.get_\u03bc": {"fullname": "pynkowski.theory.utils.get_\u03bc", "modulename": "pynkowski.theory.utils", "qualname": "get_\u03bc", "type": "function", "doc": "<p>Compute the first derivative of the covariance function at the origin for a Gaussian field \ndefined on the sphere with angular power spectrum 'cls'.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>cls</strong> (np.array):\nThe angular power spectrum of the Gaussian field.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>\u03bc</strong> (float):\nThe first derivative of the covariance function of a field at the origin.</li>\n</ul>\n", "signature": "(cls)", "funcdef": "def"}, "pynkowski.theory.utils.define_mu": {"fullname": "pynkowski.theory.utils.define_mu", "modulename": "pynkowski.theory.utils", "qualname": "define_mu", "type": "function", "doc": "<p>Return the first derivative of the covariance function at the origin for a field \ncomputed accordingly to which input variable is given.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>cls</strong> (np.array, optional):\nThe angular power spectrum of the field.\nDefault : None</li>\n<li><strong>\u03bc</strong> (scalar, optional):\nThe first derivative of the covariance function at the origin for the field. If None, \u03bc=1 is assumed.\nDefault : None</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>\u03bc</strong> (scalar):\nThe first derivative of the covariance function of the field at the origin.</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>The derivatives are always computed full-sky regardless of input mask.</p>\n", "signature": "(cls, \u03bc)", "funcdef": "def"}, "pynkowski.theory.utils.define_us_for_V": {"fullname": "pynkowski.theory.utils.define_us_for_V", "modulename": "pynkowski.theory.utils", "qualname": "define_us_for_V", "type": "function", "doc": "<p>Return the thresholds where MFs (except for v0) are computed before averaging within the bins 'dus'.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>us</strong> (np.array):\nThe thresholds at which MFs have to be computed.</li>\n<li><strong>dus</strong> (np.array):\nThe width of the bins associated to the thresholds 'us'.</li>\n<li><strong>iters</strong> (int, optional):\nthe number of thresholds to consider within each bin.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>us_</strong> (np.array):\nThe sequence of thresholds where MFs are computed before averaging within each bin, with shape (us.shape, iters)</li>\n<li><strong>iters</strong> (int, optional):\nthe number of thresholds considered within each bin.</li>\n</ul>\n", "signature": "(us, dus, iters=1000)", "funcdef": "def"}}, "docInfo": {"pynkowski": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 263}, "pynkowski.data": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 61}, "pynkowski.data.scalar": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "pynkowski.data.scalar.Scalar": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 332}, "pynkowski.data.scalar.Scalar.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 8, "bases": 0, "doc": 95}, "pynkowski.data.scalar.Scalar.get_variance": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 42}, "pynkowski.data.scalar.Scalar.set_pix": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 72}, "pynkowski.data.scalar.Scalar.get_gradient": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 54}, "pynkowski.data.scalar.Scalar.get_hessian": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 57}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 85}, "pynkowski.data.scalar.Scalar.V0_pixel": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 79}, "pynkowski.data.scalar.Scalar.V0_iter": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 69}, "pynkowski.data.scalar.Scalar.V0": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 71}, "pynkowski.data.scalar.Scalar.V1_pixel": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 5, "bases": 0, "doc": 97}, "pynkowski.data.scalar.Scalar.V1_iter": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 5, "bases": 0, "doc": 102}, "pynkowski.data.scalar.Scalar.V1": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 6, "bases": 0, "doc": 136}, "pynkowski.data.scalar.Scalar.V2_pixel": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 5, "bases": 0, "doc": 107}, "pynkowski.data.scalar.Scalar.V2_iter": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 5, "bases": 0, "doc": 103}, "pynkowski.data.scalar.Scalar.V2": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 6, "bases": 0, "doc": 136}, "pynkowski.data.scalar.Scalar.get_maxima": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 53}, "pynkowski.data.scalar.Scalar.get_minima": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 51}, "pynkowski.data.utils": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "pynkowski.data.utils.get_theta": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 70}, "pynkowski.data.utils.derivatives": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 8, "bases": 0, "doc": 162}, "pynkowski.data.utils.second_derivatives": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 162}, "pynkowski.theory": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 75}, "pynkowski.theory.p2": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "pynkowski.theory.p2.TheoryP2": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 394}, "pynkowski.theory.p2.TheoryP2.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 23}, "pynkowski.theory.p2.TheoryP2.V0": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 27}, "pynkowski.theory.p2.TheoryP2.V1": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 34}, "pynkowski.theory.p2.TheoryP2.V2": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 33}, "pynkowski.theory.temperature": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "pynkowski.theory.temperature.TheoryTemperature": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 356}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 23}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 33}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 34}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 34}, "pynkowski.theory.utils": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "pynkowski.theory.utils.get_\u03bc": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 3, "bases": 0, "doc": 79}, "pynkowski.theory.utils.define_mu": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 126}, "pynkowski.theory.utils.define_us_for_V": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 6, "bases": 0, "doc": 133}}, "length": 42, "save": true}, "index": {"qualname": {"root": {"docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}}, "df": 5, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}}, "df": 18}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}}, "df": 3}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}}, "df": 8}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}}, "df": 1}}}}}}}}, "v": {"0": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}}, "df": 5}, "1": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}}, "df": 5}, "2": {"docs": {"pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 5}, "docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}}, "df": 3}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {"pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.utils.get_theta": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"2": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}}, "df": 5}, "docs": {}, "df": 0}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 2}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1}}}}}, "fullname": {"root": {"docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}}, "df": 5, "p": {"2": {"docs": {"pynkowski.theory.p2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}}, "df": 6}, "docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.data": {"tf": 1}, "pynkowski.data.scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}, "pynkowski.data.utils": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory": {"tf": 1}, "pynkowski.theory.p2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}, "pynkowski.theory.utils": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 42}}}}}}}}, "i": {"docs": {}, "df": 0, "x": {"docs": {"pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}}, "df": 3}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.data.scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}, "pynkowski.data.utils": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 24}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.data.scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.4142135623730951}}, "df": 19}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}}, "df": 3}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}}, "df": 8}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}}, "df": 1}}}}}}}}, "v": {"0": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}}, "df": 5}, "1": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}}, "df": 5}, "2": {"docs": {"pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 5}, "docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {"pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.utils": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.utils": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 8}}}}, "s": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.utils.get_theta": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski.theory": {"tf": 1}, "pynkowski.theory.p2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}, "pynkowski.theory.utils": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 17, "p": {"2": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}}, "df": 5}, "docs": {}, "df": 0}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.temperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 6}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1}}}}}, "annotation": {"root": {"docs": {}, "df": 0}}, "default_value": {"root": {"docs": {}, "df": 0}}, "signature": {"root": {"1": {"0": {"0": {"0": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.4142135623730951}, "pynkowski.data.utils.get_theta": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 1.4142135623730951}, "pynkowski.data.utils.second_derivatives": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1.7320508075688772}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.4142135623730951}}, "df": 31, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 25}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1.7320508075688772}}, "df": 5}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.utils.get_theta": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}}, "df": 3}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "p": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}}, "df": 2}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {"pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 1}}}, "u": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}}, "df": 6, "s": {"docs": {"pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 6}}, "d": {"docs": {"pynkowski.data.utils.second_derivatives": {"tf": 1.4142135623730951}}, "df": 1, "u": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}}, "df": 4, "s": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}}, "df": 4}}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}}, "df": 5}}}}}, "l": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}}}}}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 4}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}}, "df": 2}}}}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1}}}}}}}, "bases": {"root": {"docs": {}, "df": 0}}, "doc": {"root": {"0": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}}, "df": 4}, "1": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 9}, "2": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1.7320508075688772}}, "df": 5, "\\": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 2}}}}, "3": {"docs": {"pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 1, "*": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}}}}}}, "5": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}}, "df": 2}, "8": {"docs": {"pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}}, "df": 2}, "docs": {"pynkowski": {"tf": 9.433981132056603}, "pynkowski.data": {"tf": 4.898979485566356}, "pynkowski.data.scalar": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar": {"tf": 9.539392014169456}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 5.196152422706632}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 3.872983346207417}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 5.196152422706632}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 3.4641016151377544}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 3.4641016151377544}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 5.385164807134504}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 5.196152422706632}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 5.196152422706632}, "pynkowski.data.scalar.Scalar.V0": {"tf": 5.196152422706632}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 6.244997998398398}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 6.082762530298219}, "pynkowski.data.scalar.Scalar.V1": {"tf": 5.744562646538029}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 6.244997998398398}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 6.082762530298219}, "pynkowski.data.scalar.Scalar.V2": {"tf": 5.744562646538029}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 4.58257569495584}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 4.358898943540674}, "pynkowski.data.utils": {"tf": 1.7320508075688772}, "pynkowski.data.utils.get_theta": {"tf": 5.477225575051661}, "pynkowski.data.utils.derivatives": {"tf": 7.14142842854285}, "pynkowski.data.utils.second_derivatives": {"tf": 7.14142842854285}, "pynkowski.theory": {"tf": 5.5677643628300215}, "pynkowski.theory.p2": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2": {"tf": 8.12403840463596}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 2.6457513110645907}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 2.8284271247461903}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 2.8284271247461903}, "pynkowski.theory.temperature": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 8.06225774829855}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 2.23606797749979}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 2.6457513110645907}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 2.449489742783178}, "pynkowski.theory.utils": {"tf": 1.7320508075688772}, "pynkowski.theory.utils.get_\u03bc": {"tf": 5.291502622129181}, "pynkowski.theory.utils.define_mu": {"tf": 6.4031242374328485}, "pynkowski.theory.utils.define_us_for_V": {"tf": 6.782329983125268}}, "df": 42, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"pynkowski": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.utils.get_theta": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 2}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 8, "i": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_us_for_V": {"tf": 2}}, "df": 10}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}}, "df": 4}}, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 5}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.4142135623730951}}, "df": 8}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 7}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1.7320508075688772}, "pynkowski.data.utils.second_derivatives": {"tf": 1.7320508075688772}}, "df": 4}}}, "t": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1, "o": {"docs": {"pynkowski": {"tf": 2.8284271247461903}, "pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 2.449489742783178}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.23606797749979}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.7320508075688772}}, "df": 12, "o": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 3.3166247903554}, "pynkowski.data": {"tf": 2}, "pynkowski.data.scalar.Scalar": {"tf": 3.7416573867739413}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 2}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 2.449489742783178}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 2.6457513110645907}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 2.8284271247461903}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 2}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 2.449489742783178}, "pynkowski.data.scalar.Scalar.V0": {"tf": 2.449489742783178}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 3.3166247903554}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 3.3166247903554}, "pynkowski.data.scalar.Scalar.V1": {"tf": 3.1622776601683795}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 3.605551275463989}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 3.3166247903554}, "pynkowski.data.scalar.Scalar.V2": {"tf": 3.1622776601683795}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.7320508075688772}, "pynkowski.data.utils.get_theta": {"tf": 2.23606797749979}, "pynkowski.data.utils.derivatives": {"tf": 3.1622776601683795}, "pynkowski.data.utils.second_derivatives": {"tf": 3.3166247903554}, "pynkowski.theory": {"tf": 2.23606797749979}, "pynkowski.theory.p2.TheoryP2": {"tf": 5.830951894845301}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 5.656854249492381}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 2}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1.7320508075688772}, "pynkowski.theory.utils.get_\u03bc": {"tf": 3}, "pynkowski.theory.utils.define_mu": {"tf": 3.7416573867739413}, "pynkowski.theory.utils.define_us_for_V": {"tf": 3}}, "df": 37, "i": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.theory": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}}, "df": 4}}}}}}, "y": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1}}}, "y": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 2.6457513110645907}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 2.23606797749979}, "pynkowski.data.utils.get_theta": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 1.7320508075688772}, "pynkowski.data.utils.second_derivatives": {"tf": 2}}, "df": 6, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 9}, "r": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 4}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1.4142135623730951}}, "df": 1}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.7320508075688772}}, "df": 2, "s": {"docs": {"pynkowski.data.scalar.Scalar.V0": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V1": {"tf": 2.449489742783178}, "pynkowski.data.scalar.Scalar.V2": {"tf": 2.449489742783178}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.23606797749979}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.23606797749979}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 2.449489742783178}}, "df": 12}}}}}}}}}, "q": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "m": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.theory": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 3}}}}}}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}}, "df": 7}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}}, "df": 1}}}, "p": {"2": {"docs": {"pynkowski.theory": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski": {"tf": 1.7320508075688772}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}}, "df": 1, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 21}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 2.449489742783178}}, "df": 4}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}}, "^": {"2": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "i": {"docs": {}, "df": 0, "p": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.utils.get_theta": {"tf": 1.4142135623730951}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2, "s": {"docs": {"pynkowski.data.scalar.Scalar.set_pix": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.4142135623730951}}, "df": 4}}}, "s": {"docs": {"pynkowski.data.scalar.Scalar.set_pix": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.7320508075688772}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1}}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 4}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 3}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 2}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 2.23606797749979}, "pynkowski.data.utils.derivatives": {"tf": 1.7320508075688772}, "pynkowski.data.utils.second_derivatives": {"tf": 2}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1.4142135623730951}}, "df": 6, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {"pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.theory": {"tf": 1}}, "df": 1}}}}}}}}}}}, "s": {"docs": {"pynkowski": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.theory": {"tf": 1.4142135623730951}}, "df": 2}}, "b": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}}}}}}}, "m": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}}, "df": 1}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1.4142135623730951}}, "df": 15}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}}, "df": 3}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 3.1622776601683795}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 2}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.utils.second_derivatives": {"tf": 2}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}}, "df": 8}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1.7320508075688772}}, "df": 2}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}}, "df": 7}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 4}}}}}}}, "o": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}}, "df": 2}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}}, "df": 4}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 3.1622776601683795}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}}, "df": 5}}}, "k": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 3}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.4142135623730951}}, "df": 3}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 1, "{": {"2": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}}, "df": 1}}}}, "docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {"pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}}, "df": 1}}}}}}}}, "d": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 2}, "pynkowski.data.utils.second_derivatives": {"tf": 2.23606797749979}}, "df": 2, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.data": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}}}}}}}, "r": {"1": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}, "docs": {"pynkowski.data.scalar.Scalar": {"tf": 2}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1.7320508075688772}}, "df": 3, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 2.449489742783178}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1.7320508075688772}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 2.23606797749979}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1.7320508075688772}}, "df": 9, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 2.449489742783178}, "pynkowski.data.utils.second_derivatives": {"tf": 1.7320508075688772}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 7}}}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2, "t": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1.4142135623730951}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}, "pynkowski.theory.utils.define_mu": {"tf": 1.4142135623730951}}, "df": 9}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.utils.get_theta": {"tf": 1}}, "df": 1, "d": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}}, "df": 5}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}}, "df": 2}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 9}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}}, "df": 1, "s": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "u": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}}, "df": 4, "/": {"2": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}}, "df": 4}, "docs": {}, "df": 0}, "s": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1.4142135623730951}}, "df": 1}}}, "a": {"docs": {"pynkowski": {"tf": 1.7320508075688772}, "pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 1.7320508075688772}, "pynkowski.data.utils.second_derivatives": {"tf": 2}, "pynkowski.theory": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 16, "s": {"docs": {"pynkowski": {"tf": 2.23606797749979}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.theory": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}}, "df": 7, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 2}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 3}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1.7320508075688772}, "pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 2.449489742783178}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.4142135623730951}, "pynkowski.theory": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.449489742783178}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.449489742783178}, "pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.4142135623730951}}, "df": 16}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 3.1622776601683795}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 2}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 2}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.4142135623730951}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1.7320508075688772}, "pynkowski.data.utils.second_derivatives": {"tf": 2.23606797749979}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.23606797749979}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.23606797749979}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.7320508075688772}}, "df": 22}}}}, "n": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}}, "df": 7, "d": {"docs": {"pynkowski": {"tf": 2}, "pynkowski.data.scalar.Scalar": {"tf": 2}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.23606797749979}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}}, "df": 14}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 4}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 1}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 2.23606797749979}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.7320508075688772}, "pynkowski.theory": {"tf": 1}}, "df": 4, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 4}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}}, "df": 1}}}}}, "m": {"2": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}}}, "docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}, "t": {"docs": {"pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 2}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1.7320508075688772}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 16, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 3}}}}}}}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 1}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}}, "df": 27, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}}, "df": 2}, "d": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 3.3166247903554}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 2}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2}, "pynkowski.theory.utils.define_mu": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.7320508075688772}}, "df": 7}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 11, "s": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1, "d": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 14}}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 2.23606797749979}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 2}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 5}, "c": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1.7320508075688772}}, "df": 4}}}}}}}}, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 5, "s": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 4}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}}}}}, "m": {"docs": {}, "df": 0, "b": {"docs": {"pynkowski": {"tf": 2}, "pynkowski.theory": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "^": {"2": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}}, "df": 6, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 2.23606797749979}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.23606797749979}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 4}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}}, "df": 4}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {"pynkowski": {"tf": 1.7320508075688772}, "pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}}, "df": 15}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "p": {"2": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "m": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}}}, "docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 2}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.4142135623730951}, "pynkowski.data.utils.get_theta": {"tf": 1.7320508075688772}, "pynkowski.data.utils.derivatives": {"tf": 2}, "pynkowski.data.utils.second_derivatives": {"tf": 2.449489742783178}}, "df": 16, "s": {"docs": {"pynkowski": {"tf": 1.7320508075688772}, "pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}}, "df": 6}, "p": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "k": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 2.449489742783178}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 10}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.7320508075688772}}, "df": 1}, "u": {"docs": {}, "df": 0, "m": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}}, "df": 2, "}": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "v": {"docs": {"pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}}, "df": 3}}, "v": {"docs": {"pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 1}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 2}}, "df": 1}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}, "u": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.theory": {"tf": 1}}, "df": 4}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "f": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 7, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 2}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.7320508075688772}}, "df": 7}}, "u": {"docs": {"pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}}}}}}, "^": {"docs": {}, "df": 0, "{": {"1": {"docs": {}, "df": 0, "/": {"2": {"docs": {"pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}}}}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1.7320508075688772}}, "df": 5, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}}, "df": 7, "s": {"docs": {"pynkowski": {"tf": 1.7320508075688772}, "pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}}, "df": 8}}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.23606797749979}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.7320508075688772}, "pynkowski.theory.utils.define_mu": {"tf": 2}}, "df": 5, "s": {"docs": {"pynkowski": {"tf": 1.7320508075688772}, "pynkowski.theory": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.23606797749979}}, "df": 3}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 2.6457513110645907}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 2}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1.7320508075688772}}, "df": 11}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1.4142135623730951}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 4}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.7320508075688772}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.449489742783178}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.449489742783178}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 19, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 3}}}}}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1}}, "o": {"docs": {}, "df": 0, "m": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}}, "df": 6}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}}, "df": 10}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {"pynkowski": {"tf": 2}, "pynkowski.data.scalar.Scalar": {"tf": 3.1622776601683795}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 2}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 2.23606797749979}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 2}, "pynkowski.data.scalar.Scalar.V1": {"tf": 2.23606797749979}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 2.23606797749979}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 2}, "pynkowski.data.scalar.Scalar.V2": {"tf": 2.23606797749979}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.7320508075688772}, "pynkowski.data.utils.get_theta": {"tf": 1.7320508075688772}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 2.449489742783178}, "pynkowski.theory": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 3.872983346207417}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 3.605551275463989}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 2}, "pynkowski.theory.utils.define_mu": {"tf": 2.449489742783178}, "pynkowski.theory.utils.define_us_for_V": {"tf": 2}}, "df": 36}, "n": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.23606797749979}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.23606797749979}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}}, "df": 7, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 2.6457513110645907}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 5}}}, "r": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1.7320508075688772}}, "df": 4}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1.4142135623730951}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.23606797749979}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.23606797749979}, "pynkowski.theory.utils.define_mu": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.4142135623730951}}, "df": 11}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.theory.p2.TheoryP2.V1": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1.4142135623730951}}, "df": 4}}}}, "i": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1, "n": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 13, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar": {"tf": 2}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 2}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.4142135623730951}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1.4142135623730951}}, "df": 17}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.4142135623730951}}, "df": 5, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}}, "df": 4}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1}}}}}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}}}}}}}, "s": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 2}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.6457513110645907}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.6457513110645907}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1.4142135623730951}}, "df": 14, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 2}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}}, "df": 5}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}}}}}}}, "y": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1.7320508075688772}, "pynkowski.data.utils.second_derivatives": {"tf": 1.4142135623730951}}, "df": 6, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1.7320508075688772}}, "df": 1}}}}, "f": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 2.6457513110645907}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 1.7320508075688772}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 3}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 3}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 10}}, "e": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1, "x": {"docs": {}, "df": 0, "p": {"docs": {"pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 11}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski": {"tf": 1}}, "df": 1, "s": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}}, "df": 2}}}, "a": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski": {"tf": 1.4142135623730951}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}}, "df": 6}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4, "s": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"pynkowski.data.utils.get_theta": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.7320508075688772}}, "df": 4}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2, "s": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1, "+": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "b": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1}}}}}, "v": {"0": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 8, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"pynkowski.data.scalar.Scalar.V0": {"tf": 1}}, "df": 1}}, "1": {"docs": {"pynkowski.data.scalar.Scalar.V1_iter": {"tf": 2}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}}, "df": 6, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}}, "df": 1}}, "2": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 2}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 7, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"pynkowski.data.scalar.Scalar.V2": {"tf": 1}}, "df": 1}}, "docs": {"pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}}, "df": 9, "s": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 2}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 17}}}}, "r": {"docs": {"pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar.get_variance": {"tf": 1.4142135623730951}}, "df": 1}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski": {"tf": 1.7320508075688772}, "pynkowski.theory": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 2}, "pynkowski.theory.p2.TheoryP2.__init__": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2}, "pynkowski.theory.temperature.TheoryTemperature.__init__": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 3}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1.4142135623730951}}, "df": 2, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 4}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.7320508075688772}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.6457513110645907}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.6457513110645907}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 10}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.data": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 2.449489742783178}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_variance": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_gradient": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_hessian": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 2}, "pynkowski.data.utils.second_derivatives": {"tf": 2.449489742783178}}, "df": 12}}, "y": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.7320508075688772}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1.4142135623730951}}, "df": 13, "s": {"docs": {"pynkowski": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.V1": {"tf": 2.23606797749979}, "pynkowski.data.scalar.Scalar.V2": {"tf": 2.23606797749979}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.23606797749979}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.23606797749979}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 2}}, "df": 13, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}, "s": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {"pynkowski.data": {"tf": 1}, "pynkowski.theory": {"tf": 1}}, "df": 2}}}}, "+": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "/": {"2": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}}, "df": 4}, "docs": {}, "df": 0}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4, "l": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}}}}}}}, "^": {"2": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0, "{": {"2": {"docs": {"pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "/": {"2": {"docs": {"pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "}": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "p": {"docs": {"pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}}, "df": 5}, "e": {"docs": {"pynkowski": {"tf": 1}, "pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 2.6457513110645907}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2.23606797749979}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 6, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}}, "df": 8}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 2}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 2}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 2}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 2}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.7320508075688772}}, "df": 9, "s": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.4142135623730951}}, "df": 5}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}}}}, "b": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2}}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.theory.utils.define_us_for_V": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}}, "df": 3, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {"pynkowski": {"tf": 1}}, "df": 1, "s": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 2}}}, "r": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}}, "df": 2, "d": {"docs": {"pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V0": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V1": {"tf": 1}, "pynkowski.theory.p2.TheoryP2.V2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V0": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V1": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature.V2": {"tf": 1}}, "df": 14}}}, "z": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4, "e": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1.7320508075688772}}, "df": 5}}}, "p": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 3.1622776601683795}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.4142135623730951}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1.7320508075688772}, "pynkowski.data.utils.second_derivatives": {"tf": 2.23606797749979}, "pynkowski.theory.p2.TheoryP2": {"tf": 1.7320508075688772}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.7320508075688772}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1.7320508075688772}}, "df": 22}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.utils.get_theta": {"tf": 1.7320508075688772}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}}}, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}}}}}}}, "q": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}}, "df": 1, "^": {"2": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1, "+": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "^": {"2": {"docs": {"pynkowski": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}}}, "docs": {}, "df": 0}, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.scalar.Scalar": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}}, "df": 2}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1.4142135623730951}, "pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 4, "s": {"docs": {"pynkowski.data.scalar.Scalar.get_variance": {"tf": 1}, "pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V0": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2_iter": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1}, "pynkowski.data.utils.get_theta": {"tf": 1}, "pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}, "pynkowski.theory.utils.get_\u03bc": {"tf": 1}, "pynkowski.theory.utils.define_mu": {"tf": 1}, "pynkowski.theory.utils.define_us_for_V": {"tf": 1}}, "df": 20}, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.data.scalar.Scalar.set_pix": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1.4142135623730951}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1.4142135623730951}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.utils.get_theta": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}}}}, "k": {"docs": {"pynkowski.data.scalar.Scalar.get_\u03ba": {"tf": 1}}, "df": 1, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"pynkowski.data.scalar.Scalar.V0_pixel": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"pynkowski.data.scalar.Scalar.get_maxima": {"tf": 1.7320508075688772}, "pynkowski.data.scalar.Scalar.get_minima": {"tf": 1.7320508075688772}}, "df": 2}}}}, "t": {"docs": {"pynkowski.data.scalar.Scalar.V1_pixel": {"tf": 1.4142135623730951}, "pynkowski.data.scalar.Scalar.V2_pixel": {"tf": 1.4142135623730951}}, "df": 2}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"pynkowski.data.scalar.Scalar.V1": {"tf": 1}, "pynkowski.data.scalar.Scalar.V2": {"tf": 1}, "pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 4}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"pynkowski.data.utils.derivatives": {"tf": 1}, "pynkowski.data.utils.second_derivatives": {"tf": 1}}, "df": 2, "+": {"1": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}}}, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"pynkowski.theory.p2.TheoryP2": {"tf": 1}, "pynkowski.theory.temperature.TheoryTemperature": {"tf": 1}}, "df": 2}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();