# coding: utf-8

"""
  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from .languages import Languages  # noqa: F401,E501
from .single_integer_valued_attribute import SingleIntegerValuedAttribute  # noqa: F401,E501
from .single_string_valued_attribute import SingleStringValuedAttribute  # noqa: F401,E501


class ContentInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'edition': 'SingleStringValuedAttribute',
        'languages': 'Languages',
        'pages_count': 'SingleIntegerValuedAttribute',
        'publication_date': 'SingleStringValuedAttribute'
    }

    attribute_map = {
        'edition': 'Edition',
        'languages': 'Languages',
        'pages_count': 'PagesCount',
        'publication_date': 'PublicationDate'
    }

    def __init__(self, edition=None, languages=None, pages_count=None, publication_date=None):  # noqa: E501
        """ContentInfo - a model defined in Swagger"""  # noqa: E501

        self._edition = None
        self._languages = None
        self._pages_count = None
        self._publication_date = None
        self.discriminator = None

        if edition is not None:
            self.edition = edition
        if languages is not None:
            self.languages = languages
        if pages_count is not None:
            self.pages_count = pages_count
        if publication_date is not None:
            self.publication_date = publication_date

    @property
    def edition(self):
        """Gets the edition of this ContentInfo.  # noqa: E501


        :return: The edition of this ContentInfo.  # noqa: E501
        :rtype: SingleStringValuedAttribute
        """
        return self._edition

    @edition.setter
    def edition(self, edition):
        """Sets the edition of this ContentInfo.


        :param edition: The edition of this ContentInfo.  # noqa: E501
        :type: SingleStringValuedAttribute
        """

        self._edition = edition

    @property
    def languages(self):
        """Gets the languages of this ContentInfo.  # noqa: E501


        :return: The languages of this ContentInfo.  # noqa: E501
        :rtype: Languages
        """
        return self._languages

    @languages.setter
    def languages(self, languages):
        """Sets the languages of this ContentInfo.


        :param languages: The languages of this ContentInfo.  # noqa: E501
        :type: Languages
        """

        self._languages = languages

    @property
    def pages_count(self):
        """Gets the pages_count of this ContentInfo.  # noqa: E501


        :return: The pages_count of this ContentInfo.  # noqa: E501
        :rtype: SingleIntegerValuedAttribute
        """
        return self._pages_count

    @pages_count.setter
    def pages_count(self, pages_count):
        """Sets the pages_count of this ContentInfo.


        :param pages_count: The pages_count of this ContentInfo.  # noqa: E501
        :type: SingleIntegerValuedAttribute
        """

        self._pages_count = pages_count

    @property
    def publication_date(self):
        """Gets the publication_date of this ContentInfo.  # noqa: E501


        :return: The publication_date of this ContentInfo.  # noqa: E501
        :rtype: SingleStringValuedAttribute
        """
        return self._publication_date

    @publication_date.setter
    def publication_date(self, publication_date):
        """Sets the publication_date of this ContentInfo.


        :param publication_date: The publication_date of this ContentInfo.  # noqa: E501
        :type: SingleStringValuedAttribute
        """

        self._publication_date = publication_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ContentInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContentInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
