# Welcome to stplanpy

Welcom to the Sustainable Transportation Planner for Python. This package is
inspired by [stplanr](https://docs.ropensci.org/stplanr/), a package for
sustainable transport planning with R [1] and can be used to analyze American
community survey (ACS) origin-destination (OD) data. This
[data](https://ctpp.transportation.org/2012-2016-5-year-ctpp/) is provided by
the American Association of State Highway and Transportation Officials (AASHTO)
through their Census Transportation Planning Products Program (CTPP).

Documentation for this package can be found on
[github.io](https://pctbayarea.github.io/stplanpy/source/stplanpy.html) and an
example of how to use the various functions in this package can be found in a
[Jupyter Notebook](https://pctbayarea.github.io/stplanpy-book/).

This library is also hosted on [PyPi](https://pypi.org/project/stplanpy/) and
can be installed using pip:

`pip install stplanpy`

An online interactive version of this code for the San Francisco Bay Area can be
found on [heroku](https://pctbayarea.herokuapp.com/). 

## References

[1] Robin Lovelace, Anna Goodman, Rachel Aldred, et al., "The Propensity
    to Cycle Tool: An open source online system for sustainable transport
    planning", Journal of transport and land use, vol 10, no 1, pp 505-528,
    2017, url: [https://www.jstor.org/stable/26211742](https://www.jstor.org/stable/26211742)
