
OSCN_CASE_URL = "https://www.oscn.net/dockets/GetCaseInformation.aspx"
OSCN_SEARCH_URL = "https://www.oscn.net/dockets/Results.aspx"
OSCN_PARTY_URL = "https://www.oscn.net/dockets/GetPartyRecord.aspx"
OSCN_DOCKET_URL ="https://www.oscn.net/applications/oscn/report.asp"


# https://stage.oscn.net/swagger/#/
OSCN_API_URL = "https://stage.oscn.net/api"
OSCN_API_HEADER = {"accept": "application/json; charset=utf-8"}


OSCN_REQUEST_HEADER = {
    "User-Agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36",
    "Accept-Encoding": "gzip, deflate, br",
    "Accept-Language": "en-US,en;q=0.9",
}

REMOVE_TITLES = ["HONORABLE"]

INVALID_CASE_MESSAGES = [
    "Case Number is Invalid",
]

UNUSED_CASE_MESSAGES = [
    "SKIPPED IN ERROR",
    "Something went wrong",
    "THIS CASE NUMBER WAS NOT USED",
    "is formatted incorrectly or is not found within",
    ">No Record.</td>",
]

# How many empty cases in a row to decide we're at the end of the case list?
MAX_EMPTY_CASES = 10


ALL_COURTS = [
    "adair",
    "alfalfa",
    "appellate",
    "atoka",
    "beaver",
    "beckham",
    "blaine",
    "bryan",
    "caddo",
    "canadian",
    "carter",
    "cherokee",
    "choctaw",
    "cimarron",
    "cleveland",
    "coal",
    "comanche",
    "cotton",
    "craig",
    "creek",
    "bristow",
    "drumright",
    "custer",
    "delaware",
    "dewey",
    "ellis",
    "garfield",
    "garvin",
    "grady",
    "grant",
    "greer",
    "harmon",
    "harper",
    "haskell",
    "hughes",
    "jackson",
    "jefferson",
    "johnston",
    "kay",
    "poncacity",
    "kingfisher",
    "kiowa",
    "latimer",
    "leflore",
    "lincoln",
    "logan",
    "love",
    "major",
    "marshall",
    "mayes",
    "mcclain",
    "mccurtain",
    "mcintosh",
    "murray",
    "muskogee",
    "noble",
    "nowata",
    "okfuskee",
    "oklahoma",
    "okmulgee",
    "henryetta",
    "osage",
    "ottawa",
    "payne",
    "pawnee",
    "pittsburg",
    "pontotoc",
    "pottawatomie",
    "pushmataha",
    "rogermills",
    "rogers",
    "seminole",
    "sequoyah",
    "stephens",
    "texas",
    "tillman",
    "tulsa",
    "wagoner",
    "washington",
    "washita",
    "woods",
    "woodward",
]

OCIS_COURTS = [
    "adair",
    "canadian",
    "cleveland",
    "comanche",
    "ellis",
    "garfield",
    "logan",
    "oklahoma",
    "payne",
    "pushmataha",
    "rogermills",
    "rogers",
    "tulsa",
]

ALL_TYPES = {
    "AO": "CIVIL ADMINISTRATIVE",
    "BL": "BONDSMAN LICENSE",
    "BV": "BEVERAGE LICENSE",
    "CA": "COST ADMINISTRATION",
    "CF": "CRIMINAL FELONY",
    "CJ": "CIVIL RELIEF MORE THAN $10,000",
    "CM": "CRIMINAL MISDEMEANOR",
    "CO": "CLOSING OUT SALE",
    "CP": "CRIMINAL PROPERTY RECOVERY",
    "CS": "CIVIL RELIEF LESS THAN $10,000",
    "CV": "CIVIL MISC.",
    "FA": "ADOPTION",
    "FD": "FAMILY AND DOMESTIC",
    "FMI": "FAMILY AND DOMESTIC MISCELLANEOUS PROCEEDINGS",
    "FI": "INCOME ASSIGNMENT",
    "FP": "PATERNITY",
    "FR": "RECIPROCAL CHILD SUPPORT",
    "GJ": "GRAND JURY/MULTICOUNTY GRAND JURY",
    "MC": "MINISTER'S CREDENTIALS",
    "MH": "MENTAL HEALTH",
    "MI": "CRIMINAL MISCELLANEOUS",
    "ML": "MARRIAGE LICENSE",
    "PB": "PROBATE",
    "PC": "CONSERVATORSHIPS",
    "PG": "GUARDIANSHIPS",
    "PO": "PROTECTIVE ORDER",
    "PP": "PASSPORTS",
    "PT": "TRUSTS",
    "SC": "SMALL CLAIMS",
    "SD": "SURFACE DAMAGE",
    "SW": "SEARCH WARRANT",
    "TC": "TEST CASE",
    "TL": "TAX LIENS",
    "TM": "TRANSIENT MERCHANT LICENSE",
    "TR": "TRAFFIC",
    "WH": "WRIT (HABEAS)",
    "WL": "WILDLIFE",
    "YO": "YOUTHFUL OFFENDER",
    }

ALL_JUDGES = [{'number': '1040', 'name': 'Adair, Ken'}, {'number': '196', 'name': 'Adair, Robin W.'}, {'number': '110', 'name': 'Adams, Glenn D.'}, {'number': '574', 'name': 'Adams, Milbern J.'}, {'number': '575', 'name': 'Addicott, Michael'}, {'number': '672', 'name': 'Administrative Law Judges,'}, {'number': '502', 'name': 'Albert, Greg'}, {'number': '904', 'name': 'Alcorn, Stephen'}, {'number': '576', 'name': 'Alexander, Albert V.'}, {'number': '111', 'name': 'Alford, Oteka L.'}, {'number': '112', 'name': 'Alford, Thomas H.'}, {'number': '359', 'name': 'Allen, Dan G.'}, {'number': '937', 'name': 'Allen, Gordon'}, {'number': '197', 'name': 'Allen, W M.'}, {'number': '1113', 'name': 'Alley, Aric'}, {'number': '33', 'name': 'Amick, John M.'}, {'number': '1187', 'name': 'Anderson, Christopher'}, {'number': '927', 'name': 'Anderson, Russell'}, {'number': '1050', 'name': 'Andrews, Don'}, {'number': '849', 'name': 'Angle, Loren'}, {'number': '911', 'name': 'Arnold, Gayla M'}, {'number': '682', 'name': 'Arraignment Docket'}, {'number': '1036', 'name': 'Ashwood, Cindy Ferrell'}, {'number': '689', 'name': 'Associate Judge- General'}, {'number': '744', 'name': 'Austin, M. Fred'}, {'number': '625', 'name': 'Aycock, Keith Byron'}, {'number': '17', 'name': 'Bacon, Kenneth D.'}, {'number': '306', 'name': 'Bailey, Robert L.'}, {'number': '199', 'name': 'Bailey, Temple H.'}, {'number': '1235', 'name': 'Baird, Becky'}, {'number': '1001', 'name': 'Baldwin, Thomas K.'}, {'number': '491', 'name': 'Balkenbush, Joseph P.'}, {'number': '1081', 'name': 'Balkman, Thad'}, {'number': '1049', 'name': 'Bandy, David R'}, {'number': '751', 'name': 'Barcus, Mark'}, {'number': '450', 'name': 'Barefoot, N. Vince'}, {'number': '809', 'name': 'Barger, Gary D'}, {'number': '980', 'name': 'Barnes, Deborah B'}, {'number': '1', 'name': 'Barnes, Don'}, {'number': '326', 'name': 'Barnett, David A.'}, {'number': '437', 'name': 'Bartheld, Thomas'}, {'number': '476', 'name': 'Bass, Jerry D.'}, {'number': '1087', 'name': 'Baze, Bill'}, {'number': '1137', 'name': 'Beare, Mindy'}, {'number': '117', 'name': 'Beasley, B. R.'}, {'number': '201', 'name': 'Belden, Lois L.'}, {'number': '919', 'name': 'Bell, Robert Dick'}, {'number': '577', 'name': 'Bennett, Richard A.'}, {'number': '1010', 'name': 'Benson, Brad L.'}, {'number': '118', 'name': 'Benson, John A.'}, {'number': '579', 'name': 'Bishop, Burk'}, {'number': '670', 'name': 'Bitting, Terry H.'}, {'number': '850', 'name': 'Black, Mary'}, {'number': '415', 'name': 'Black, Mary A.'}, {'number': '398', 'name': 'Black, Virgil Charles'}, {'number': '900', 'name': 'Blake, John A'}, {'number': '441', 'name': 'Blalock, Candace L.'}, {'number': '479', 'name': 'Blanchard, Richard L.'}, {'number': '421', 'name': 'Bland, Jim D.'}, {'number': '120', 'name': 'Bledsoe, Charles C.'}, {'number': '36', 'name': 'Blevins, James B.'}, {'number': '434', 'name': 'Blythe, Doyle E.'}, {'number': '38', 'name': 'Boatman, Edgar R.'}, {'number': '851', 'name': 'Boggs, John S.'}, {'number': '662', 'name': 'Bohanon, Richard'}, {'number': '1069', 'name': 'Bomhoff, Margaret A.'}, {'number': '681', 'name': 'Bond Forfeiture (Clerk) Docket'}, {'number': '892', 'name': 'Bonner, Stephen'}, {'number': '581', 'name': 'Boose, Arthur J.'}, {'number': '39', 'name': 'Boudreau, Daniel J.'}, {'number': '691', 'name': 'Bowd, Dwayne D.'}, {'number': '202', 'name': 'Bowie, Carroll J.'}, {'number': '203', 'name': 'Box, David A.'}, {'number': '697', 'name': 'Box, Dwayne D.'}, {'number': '473', 'name': 'Boyd, D. W.'}, {'number': '582', 'name': 'Boydston, John'}, {'number': '955', 'name': 'Bozarth, Rick'}, {'number': '583', 'name': 'Braly, James O.'}, {'number': '383', 'name': 'Branam, Richard E.'}, {'number': '499', 'name': 'Brauer, Timothy A.'}, {'number': '645', 'name': 'Brawner, J. J.'}, {'number': '289', 'name': 'Breaune, Joseph G.'}, {'number': '635', 'name': 'Bridges, Anita'}, {'number': '636', 'name': 'Bridges, Anita'}, {'number': '1207', 'name': 'Bridges, Brendon'}, {'number': '19', 'name': 'Brightmire, Paul W.'}, {'number': '817', 'name': 'Brock, Gary L'}, {'number': '41', 'name': 'Brock, Jack L.'}, {'number': '1132', 'name': 'Brock, Jennifer'}, {'number': '1169', 'name': 'Brockman, Scott'}, {'number': '1129', 'name': 'Brooks, Carson M.'}, {'number': '452', 'name': 'Brooks, Larry R.'}, {'number': '584', 'name': 'Brown, Jack'}, {'number': '585', 'name': 'Brown, James'}, {'number': '873', 'name': 'Brown, L. Elizabeth'}, {'number': '586', 'name': 'Brown, Paul C.'}, {'number': '587', 'name': 'Brown, Wesley'}, {'number': '1058', 'name': 'Bruce, Tammy'}, {'number': '589', 'name': 'Bryant, Herbert'}, {'number': '205', 'name': 'Bubenik, Sharron M.'}, {'number': '472', 'name': 'Buettner, Kenneth L.'}, {'number': '506', 'name': 'Bugg, David C.'}, {'number': '853', 'name': 'Burgess, Lowell R.'}, {'number': '590', 'name': 'Burke, Carroll J.'}, {'number': '309', 'name': 'Burkett, William R.'}, {'number': '44', 'name': 'Burris, Lyle'}, {'number': '1188', 'name': 'Butner, Brett'}, {'number': '606', 'name': 'Butner, George W.'}, {'number': '921', 'name': 'Campbell, Mark'}, {'number': '1041', 'name': 'Canavan, John G.'}, {'number': '46', 'name': 'Cannon, Joe'}, {'number': '671', 'name': 'Cantrell, Daman  H.'}, {'number': '1043', 'name': 'Caputo, James M.'}, {'number': '291', 'name': 'Card, Lee'}, {'number': '125', 'name': 'Carden, Edwin D.'}, {'number': '47', 'name': 'Carter, Glenn D.'}, {'number': '1048', 'name': 'Carter, Martha Rupp'}, {'number': '602', 'name': 'Caswell, Susan P.'}, {'number': '901', 'name': 'Cawthon, David'}, {'number': '1013', 'name': 'CF Docket A,'}, {'number': '1014', 'name': 'CF Docket B,'}, {'number': '1015', 'name': 'CF Docket C,'}, {'number': '1016', 'name': 'CF Docket D,'}, {'number': '1017', 'name': 'CF Docket E,'}, {'number': '1123', 'name': 'CF F Docket'}, {'number': '1141', 'name': 'CF FDV Docket'}, {'number': '1160', 'name': 'CF-Cleveland Vacant'}, {'number': '404', 'name': 'Chapel, Charles S.'}, {'number': '126', 'name': 'Chappell, Glenn H.'}, {'number': '469', 'name': 'Chappelle, Carlos'}, {'number': '845', 'name': 'Chief Special Judge,'}, {'number': '915', 'name': 'Chionopoulos, Michael E'}, {'number': '1216', 'name': 'Civil Docket A,'}, {'number': '1217', 'name': 'Civil Docket B,'}, {'number': '1218', 'name': 'Civil Docket C,'}, {'number': '1179', 'name': 'Civil Special Judge'}, {'number': '127', 'name': 'Clanton Jr, Jess B.'}, {'number': '1018', 'name': 'Clark, Stephen R'}, {'number': '329', 'name': 'Clarke, Richard'}, {'number': '446', 'name': 'Claver, H. Michael'}, {'number': '661', 'name': 'Clinton, Peter'}, {'number': '454', 'name': 'Coats, Nancy L.'}, {'number': '632', 'name': 'Coffey, Alan'}, {'number': '633', 'name': 'Coffey, Alan'}, {'number': '128', 'name': 'Colbert, Timothy K.'}, {'number': '718', 'name': 'Colbert, Tom'}, {'number': '429', 'name': 'Colclazier, Jerry L.'}, {'number': '1206', 'name': 'Coleman, Kendra'}, {'number': '129', 'name': 'Collier, Robert W.'}, {'number': '1174', 'name': 'Collins, April'}, {'number': '449', 'name': 'Combs, Douglas L.'}, {'number': '1007', 'name': 'Community Sentencing,'}, {'number': '747', 'name': 'Condren, Sheila A.'}, {'number': '425', 'name': 'Conyers, Susan Witt'}, {'number': '49', 'name': 'Cook, David M.'}, {'number': '1028', 'name': 'Coppedge, Wallace'}, {'number': '1168', 'name': 'Corbin, Laura'}, {'number': '626', 'name': 'Corley, Phillip C.'}, {'number': '609', 'name': 'Cornish, Tom R.'}, {'number': '754', 'name': 'Corporation Commission Judge'}, {'number': '678', 'name': 'Cost Admin. Judge (General)'}, {'number': '679', 'name': 'Cost Admin. Review Docket'}, {'number': '690', 'name': 'COURT CLERK (TRAFFIC PLEAS)'}, {'number': '656', 'name': 'Cox, Mary Elizabeth'}, {'number': '1202', 'name': 'Coyle, Heather'}, {'number': '50', 'name': 'Craig, Milton C.'}, {'number': '978', 'name': 'Crawford, Dan'}, {'number': '51', 'name': 'Craytor, G. Gail'}, {'number': '208', 'name': 'Crewson, Thomas S.'}, {'number': '131', 'name': 'Criswell, Loys'}, {'number': '485', 'name': 'Crosslin, Sandy'}, {'number': '983', 'name': 'Crosson, Terrell S'}, {'number': '275', 'name': 'Croy, James B.'}, {'number': '1193', 'name': 'Crutchfield, Dave'}, {'number': '1171', 'name': 'CS Docket - Vacant,'}, {'number': '288', 'name': 'Cullen, David P.'}, {'number': '618', 'name': 'Culver, William E.'}, {'number': '52', 'name': 'Cunningham, Edward C.'}, {'number': '677', 'name': 'D.U.I. Court Judge (General)'}, {'number': '53', 'name': 'Dalton, Jay D.'}, {'number': '303', 'name': 'Darby, Richard'}, {'number': '591', 'name': 'Daugherty, Fred'}, {'number': '875', 'name': 'Davis, Robert E.'}, {'number': '281', 'name': 'Dayton, Michael R.'}, {'number': '665', 'name': 'DDB-TEMP COA ENTRY,  DO NOT REMOVE'}, {'number': '611', 'name': 'Dean, Gary J.'}, {'number': '629', 'name': 'Deason, Donald L.'}, {'number': '855', 'name': 'Deaver, Danny R.'}, {'number': '857', 'name': 'DeBerry, Michael D.'}, {'number': '511', 'name': 'Delaney, Patrick O.'}, {'number': '607', 'name': 'Denney, Barry V.'}, {'number': '895', 'name': 'Detention Docket,'}, {'number': '394', 'name': 'DeWitt, John W.'}, {'number': '731', 'name': 'Dexter, Deirdre O'}, {'number': '1022', 'name': 'DHS Judge,'}, {'number': '321', 'name': 'Dickerson, Kenneth W.'}, {'number': '1000', 'name': 'Dirickson, Donna L'}, {'number': '688', 'name': 'District Judge- General'}, {'number': '270', 'name': 'Dixon, Bryan C.'}, {'number': '1034', 'name': 'Dixon, Greg'}, {'number': '628', 'name': 'Doak, D. Fred'}, {'number': '439', 'name': 'Dobbins, Mark L.'}, {'number': '54', 'name': 'Doggett, Lowell'}, {'number': '2', 'name': 'Doolin, John B.'}, {'number': '1219', 'name': 'Doss, Julie'}, {'number': '134', 'name': 'Douthit, John D.'}, {'number': '135', 'name': 'Dreiling, Janice P.'}, {'number': '952', 'name': 'Dreiling, Theresa'}, {'number': '453', 'name': 'Driesel, Willard'}, {'number': '699', 'name': 'Drivers License Appeals Docket'}, {'number': '676', 'name': 'Drug Court Judge (General)'}, {'number': '1119', 'name': 'Drummond, Douglas E.'}, {'number': '1038', 'name': 'Duck, Aaron'}, {'number': '999', 'name': 'Duel, Louis A'}, {'number': '212', 'name': 'Duncan, Jacqueline P.'}, {'number': '843', 'name': 'Durocher, Daniel L.'}, {'number': '512', 'name': 'Dycus, Edward B.'}, {'number': '982', 'name': 'Easter, Donald L'}, {'number': '55', 'name': 'Edmondson, James E.'}, {'number': '513', 'name': 'Edwards, Charles'}, {'number': '478', 'name': 'Edwards, Ellen C.'}, {'number': '136', 'name': 'Edwards, John C.'}, {'number': '1136', 'name': 'Edwards, Leah'}, {'number': '1115', 'name': 'Eilers, Justin P.'}, {'number': '944', 'name': 'Eldridge, C. Kent'}, {'number': '649', 'name': 'Elkouri, Joe Mark'}, {'number': '600', 'name': 'Elliott, Ray C.'}, {'number': '622', 'name': 'Emergency Appellate'}, {'number': '137', 'name': 'Emerson, Ralph W.'}, {'number': '514', 'name': 'Emmitt, Willie'}, {'number': '630', 'name': 'En Banc,'}, {'number': '631', 'name': 'En Banc,'}, {'number': '138', 'name': 'Enos, Joe H.'}, {'number': '1024', 'name': 'Evans, Owen'}, {'number': '139', 'name': 'Ewing, Noah Howard'}, {'number': '700', 'name': 'F.E.D. Docket'}, {'number': '140', 'name': 'Fancher, William M.'}, {'number': '1076', 'name': 'Farley, Kenneth R.'}, {'number': '752', 'name': 'Farrar, Cherri'}, {'number': '990', 'name': 'FD Docket A,'}, {'number': '991', 'name': 'FD Docket B,'}, {'number': '992', 'name': 'FD Docket C,'}, {'number': '993', 'name': 'FD Docket D,'}, {'number': '994', 'name': 'FD Docket E,'}, {'number': '1215', 'name': 'FD Docket F,'}, {'number': '668', 'name': 'FD-TEMP COA ENTRY,  DO NOT REMOVE'}, {'number': '515', 'name': 'Ferris, Weldon'}, {'number': '214', 'name': 'Field, Jesse R.'}, {'number': '489', 'name': 'Filosa, Jimmy D.'}, {'number': '973', 'name': 'Fischer, John F'}, {'number': '516', 'name': 'Fister, Russel B.'}, {'number': '898', 'name': 'Fitzgerald, Mary'}, {'number': '954', 'name': 'Flanagan, Michael C'}, {'number': '517', 'name': 'Foglesong, Doris L.'}, {'number': '401', 'name': 'Foss, Janet A.'}, {'number': '142', 'name': 'Foster, Robert L.'}, {'number': '985', 'name': 'Foster, William R'}, {'number': '402', 'name': 'Franklin, Ronald G.'}, {'number': '890', 'name': 'Franks, Kyra K'}, {'number': '458', 'name': 'Fransein, Doris L.'}, {'number': '56', 'name': 'Freeman, Leamon'}, {'number': '216', 'name': 'Freeman, Sr., Richard W.'}, {'number': '494', 'name': 'Frizzell, Gregory K.'}, {'number': '1120', 'name': 'Fry, Marion D.'}, {'number': '664', 'name': 'FT-TEMP COA ENTRY,  DO NOT REMOVE'}, {'number': '57', 'name': 'Fullerton, III, Sam C.'}, {'number': '481', 'name': 'Fulton, Kenton W.'}, {'number': '143', 'name': 'Fulton, William R.'}, {'number': '893', 'name': 'Funderburk, Carl'}, {'number': '58', 'name': 'Gabbard, II, Doug'}, {'number': '492', 'name': 'Galbraith, Robert H.'}, {'number': '358', 'name': 'Gambill, Bruce David'}, {'number': '387', 'name': 'Gardner, John D.'}, {'number': '1195', 'name': 'Gardner, Joseph'}, {'number': '144', 'name': 'Garrett, John C.'}, {'number': '1213', 'name': 'Gass, Charles'}, {'number': '218', 'name': 'Gassett, J. Michael'}, {'number': '405', 'name': 'Gaston, Reginald D.'}, {'number': '1035', 'name': 'Gay, Dennis'}, {'number': '509', 'name': 'Gelvin, Pete'}, {'number': '59', 'name': 'George, Woodrow'}, {'number': '934', 'name': 'Gerkin, John M.'}, {'number': '858', 'name': 'Gibson, Carl G.'}, {'number': '432', 'name': 'Gillert, Tom C.'}, {'number': '518', 'name': 'Gingras, Stephen'}, {'number': '1002', 'name': 'Glassco, Kurt G'}, {'number': '909', 'name': 'Golden, Douglas W'}, {'number': '424', 'name': 'Goodman, Jerry L.'}, {'number': '370', 'name': 'Goodpaster, James D.'}, {'number': '301', 'name': 'Goodwin, Charles L.'}, {'number': '1025', 'name': 'Gore, Rebecca J.'}, {'number': '1063', 'name': 'Goree, Brian Jack'}, {'number': '1116', 'name': 'Graham, Ken'}, {'number': '962', 'name': 'Graves, Bill'}, {'number': '959', 'name': 'Gray, Charles'}, {'number': '21', 'name': 'Gray, Karl R.'}, {'number': '520', 'name': 'Graytor, C. Gail'}, {'number': '146', 'name': 'Green, Fred D. (Jack)'}, {'number': '1154', 'name': 'Green, Lydia Y.'}, {'number': '1140', 'name': 'Greenough, Kelly'}, {'number': '882', 'name': 'Grey, Norman L'}, {'number': '220', 'name': 'Griffin, James H.'}, {'number': '221', 'name': 'Griffith, James Bradford'}, {'number': '986', 'name': 'Grove, Robert Lake'}, {'number': '62', 'name': 'Gullett, James L.'}, {'number': '339', 'name': 'Gurich, Noma D.'}, {'number': '1214', 'name': 'Guten, David'}, {'number': '813', 'name': 'Hadwiger, Mickey Jay'}, {'number': '947', 'name': 'Hafar, Barry L'}, {'number': '1199', 'name': 'Hake, Kelly'}, {'number': '1227', 'name': 'Hall, Rafe'}, {'number': '317', 'name': 'Hall, Russell D.'}, {'number': '1139', 'name': 'Hamilton, Walter'}, {'number': '1155', 'name': 'Hammers, Pamela B.'}, {'number': '808', 'name': 'Hammond, Lisa K.'}, {'number': '820', 'name': 'Hammontree, Jack'}, {'number': '63', 'name': 'Hampton, Don H.'}, {'number': '604', 'name': 'Haney, Robert G.'}, {'number': '1019', 'name': 'Haralson, Howard R'}, {'number': '327', 'name': 'Harbour, David M.'}, {'number': '1029', 'name': 'Harbuck, Preston'}, {'number': '3', 'name': 'Hargrave, Rudolph'}, {'number': '943', 'name': 'Harkey, Michael J'}, {'number': '1184', 'name': 'Harrel, Celo'}, {'number': '942', 'name': 'Harrington, Jay L.'}, {'number': '521', 'name': 'Harris, Carmon C.'}, {'number': '319', 'name': 'Harris, Jesse S.'}, {'number': '624', 'name': 'Harris, Kenny D.'}, {'number': '293', 'name': 'Harris, T. David'}, {'number': '523', 'name': 'Harrison, David'}, {'number': '612', 'name': 'Haskins, Kyle B.'}, {'number': '224', 'name': 'Hass, Russell P.'}, {'number': '407', 'name': 'Hatch, Farrell M.'}, {'number': '1046', 'name': 'Hatfield, Barbara'}, {'number': '150', 'name': 'Haught, Floyd Douglas'}, {'number': '1037', 'name': 'Haworth, Tim'}, {'number': '1110', 'name': 'Hays, Laurie E.'}, {'number': '151', 'name': 'Headrick, Charles H.'}, {'number': '510', 'name': 'Heggy, Suzanne'}, {'number': '503', 'name': 'Helms, Louise A.'}, {'number': '956', 'name': 'Henderson, Brian'}, {'number': '391', 'name': 'Henderson, John N.'}, {'number': '1033', 'name': 'Henderson, Lester'}, {'number': '1060', 'name': 'Henderson, Timothy R'}, {'number': '64', 'name': 'Henderson, William H.'}, {'number': '507', 'name': 'Henley, L. Gaylene'}, {'number': '433', 'name': 'Henry, Matthew D.'}, {'number': '226', 'name': 'Henshaw, Jr., A. J.'}, {'number': '1052', 'name': 'Herberger, Jerry'}, {'number': '413', 'name': 'Herndon, John E.'}, {'number': '1045', 'name': 'Hert, R. L.'}, {'number': '1158', 'name': 'Hesse, Paul'}, {'number': '227', 'name': 'Hetherington, Jr., William C.'}, {'number': '1121', 'name': 'Hicks, Todd'}, {'number': '228', 'name': 'Hicks, III, Edward J.'}, {'number': '525', 'name': 'Hiddle, Bill'}, {'number': '468', 'name': 'Hill, Charles G.'}, {'number': '905', 'name': 'Hill, S. Wyatt'}, {'number': '526', 'name': 'Hines, Jim'}, {'number': '1233', 'name': 'Hixon, Stacie'}, {'number': '941', 'name': 'Hladik, Dennis'}, {'number': '4', 'name': 'Hodges, Ralph B.'}, {'number': '920', 'name': 'Hofmeister, Gerald'}, {'number': '1152', 'name': 'Hogan, Mike'}, {'number': '500', 'name': 'Hogshead, Charles'}, {'number': '1118', 'name': 'Holmes, Sharon'}, {'number': '66', 'name': 'Hopper, Clifford E.'}, {'number': '388', 'name': 'Hovis, Richard E.'}, {'number': '527', 'name': 'Hown, Not'}, {'number': '459', 'name': 'Hubbard, Carol Ann'}, {'number': '1224', 'name': 'Huber, Jim'}, {'number': '1071', 'name': 'Hudson, Rob'}, {'number': '442', 'name': 'Huey, Clark E.'}, {'number': '1176', 'name': 'Huggins, Gary'}, {'number': '981', 'name': 'Hughey, Bob'}, {'number': '230', 'name': 'Humphrey, III, Charles M.'}, {'number': '1124', 'name': 'IDV (General)'}, {'number': '918', 'name': 'Ihrig, Mark'}, {'number': '1073', 'name': 'Inge, Paula'}, {'number': '651', 'name': 'Ivy, Karen'}, {'number': '440', 'name': 'Jackson, Joe L.'}, {'number': '1122', 'name': 'Jackson, Lori L.'}, {'number': '232', 'name': 'Jackson, Niles L.'}, {'number': '153', 'name': 'Jackson, Ray Don'}, {'number': '745', 'name': 'Jackson, T. Michael'}, {'number': '1051', 'name': 'Jacobsen, John M'}, {'number': '746', 'name': 'James, Philippa C.'}, {'number': '696', 'name': 'James, Richard D.'}, {'number': '1104', 'name': 'JD Docket A,'}, {'number': '1105', 'name': 'JD Docket B,'}, {'number': '1106', 'name': 'JD Docket C,'}, {'number': '1107', 'name': 'JD Docket D,'}, {'number': '1100', 'name': 'JDH Docket A,'}, {'number': '1101', 'name': 'JDH Docket B,'}, {'number': '1102', 'name': 'JDH Docket C,'}, {'number': '1103', 'name': 'JDH Docket D,'}, {'number': '1092', 'name': 'JDL Docket A,'}, {'number': '1093', 'name': 'JDL Docket B,'}, {'number': '1094', 'name': 'JDL Docket C,'}, {'number': '1095', 'name': 'JDL Docket D,'}, {'number': '647', 'name': 'Jefferies, Jaque'}, {'number': '67', 'name': 'Jennings, Joe'}, {'number': '1056', 'name': 'Jett, Clark'}, {'number': '914', 'name': 'Johnson, Arlene J'}, {'number': '354', 'name': 'Johnson, Charles A.'}, {'number': '1054', 'name': 'Johnson, Gregory L'}, {'number': '1074', 'name': 'Johnson, Susan K'}, {'number': '497', 'name': 'Johnston, D. Craig'}, {'number': '1066', 'name': 'Jones, Bernard M'}, {'number': '417', 'name': 'Jones, Glenn M.'}, {'number': '1042', 'name': 'Jones, Jeffrey B.'}, {'number': '416', 'name': 'Jones, Larry A.'}, {'number': '1209', 'name': 'Jones, Stephanie'}, {'number': '428', 'name': 'Joplin, Larry E.'}, {'number': '1096', 'name': 'JS Docket A,'}, {'number': '1097', 'name': 'JS Docket B,'}, {'number': '1098', 'name': 'JS Docket C,'}, {'number': '1099', 'name': 'JS Docket D,'}, {'number': '841', 'name': 'Judge Not Listed'}, {'number': '913', 'name': 'Kane, John'}, {'number': '505', 'name': 'Karim, Daniel'}, {'number': '654', 'name': 'Kasper, Kris D'}, {'number': '5', 'name': 'Kauger, Yvonne'}, {'number': '1210', 'name': 'Keele, Ann'}, {'number': '1091', 'name': 'Keeley, James W.'}, {'number': '949', 'name': 'Kellough, William C'}, {'number': '969', 'name': 'Kelly, Christopher'}, {'number': '1082', 'name': 'Kendall, Steven'}, {'number': '652', 'name': 'Kennedy, Karen K'}, {'number': '1190', 'name': 'Kerr, Elizabeth'}, {'number': '984', 'name': 'Kessinger, Steven'}, {'number': '529', 'name': 'Kessler, William C.'}, {'number': '859', 'name': 'Key, Craig'}, {'number': '1144', 'name': 'Kiffin, Donald'}, {'number': '356', 'name': 'Kilgore, Martha K.'}, {'number': '456', 'name': 'Kincannon, Ronald L.'}, {'number': '1198', 'name': 'King, Josh'}, {'number': '1226', 'name': 'King, Timothy'}, {'number': '963', 'name': 'Kirby, Richard'}, {'number': '958', 'name': 'Kirk, Sheila'}, {'number': '1157', 'name': 'Kirkland, Kory'}, {'number': '979', 'name': 'Kirkley, Douglas A'}, {'number': '1234', 'name': 'Kirksey, Erin'}, {'number': '989', 'name': 'Kistler, Stephen R'}, {'number': '487', 'name': 'Kite, Charles T.'}, {'number': '530', 'name': 'Kizner, David'}, {'number': '235', 'name': 'Klein, Allen'}, {'number': '154', 'name': 'Knight, Ted A.'}, {'number': '950', 'name': 'Kuehn, Dana'}, {'number': '1221', 'name': 'Kulling, Michael'}, {'number': '531', 'name': 'Ladd, Billy Earnest'}, {'number': '1191', 'name': 'Lafferty, Allison'}, {'number': '408', 'name': 'LaFortune, William D.'}, {'number': '532', 'name': 'Lamm, Margaret'}, {'number': '451', 'name': 'Landrith, Tom S.'}, {'number': '69', 'name': 'Lane, Donald C.'}, {'number': '155', 'name': 'Lane, James F.'}, {'number': '328', 'name': 'Langley, Lawrence L.'}, {'number': '70', 'name': 'Lanning, John G.'}, {'number': '156', 'name': 'Largent Jr, P C.'}, {'number': '1222', 'name': 'Larson, Christine Marie'}, {'number': '899', 'name': 'Last Name Here, First Name Here'}, {'number': '533', 'name': 'Laughlin, James'}, {'number': '6', 'name': 'Lavender, Robert E.'}, {'number': '71', 'name': 'Layden, Robert A.'}, {'number': '933', 'name': 'Layden, William H.'}, {'number': '157', 'name': 'Leach, George H.'}, {'number': '1084', 'name': 'Leach, Nikki G'}, {'number': '237', 'name': 'Lee, Michael D.'}, {'number': '932', 'name': 'Leonard, H. Thomas'}, {'number': '534', 'name': 'Levally, Earl C'}, {'number': '975', 'name': 'Leverett, Brad D'}, {'number': '393', 'name': 'Lewis, David B.'}, {'number': '72', 'name': 'Linder, Ray Dean'}, {'number': '73', 'name': 'Lindley, George W.'}, {'number': '627', 'name': 'Little, Brad'}, {'number': '535', 'name': 'Little, Bradley'}, {'number': '483', 'name': 'Littlefield, Alicia'}, {'number': '639', 'name': 'Livingston, Clint'}, {'number': '536', 'name': 'Lonian, Emily Kaye'}, {'number': '74', 'name': 'Love, J. Kenneth'}, {'number': '1047', 'name': 'Lovell, Brian N'}, {'number': '159', 'name': 'Lovell, Robert C.'}, {'number': '537', 'name': 'Lowerimore, G. Gail'}, {'number': '438', 'name': 'Lucas, Tom A.'}, {'number': '1012', 'name': 'Ludi Leitch, Deborrah'}, {'number': '75', 'name': 'Lumpkin, Gary L.'}, {'number': '1197', 'name': 'Luton, John'}, {'number': '29', 'name': 'MacGuigan, Patricia Dougherty'}, {'number': '538', 'name': 'Maddox, John'}, {'number': '539', 'name': 'Madison, Gary D.'}, {'number': '1204', 'name': 'Mai, Natalie'}, {'number': '76', 'name': 'Maley, John'}, {'number': '659', 'name': 'Mancillas, Michael'}, {'number': '614', 'name': 'Manger, William J.'}, {'number': '160', 'name': 'Marak, Jr, Joseph P.'}, {'number': '161', 'name': 'Markum, Alan D.'}, {'number': '540', 'name': 'Maroney, Anne'}, {'number': '1186', 'name': 'Marsh, Rick'}, {'number': '295', 'name': 'Martin, Billy L.'}, {'number': '386', 'name': 'Martin, David N.'}, {'number': '342', 'name': 'Mathews, Eugene H.'}, {'number': '304', 'name': 'Mattingly, William H.'}, {'number': '283', 'name': 'Maxey, Gary L.'}, {'number': '380', 'name': 'Mayberry, Jack K.'}, {'number': '390', 'name': 'Mayhue, G. C.'}, {'number': '1194', 'name': 'McAffrey, Jennifer'}, {'number': '239', 'name': 'McAllister, Jr., Gordon D.'}, {'number': '78', 'name': 'McBee, George H.'}, {'number': '1078', 'name': 'McBee, Jennifer H'}, {'number': '422', 'name': 'McBride, Terry H.'}, {'number': '79', 'name': 'McCalister, M L.'}, {'number': '240', 'name': 'McCall, C. Allen'}, {'number': '384', 'name': 'McClain, Richard B.'}, {'number': '595', 'name': 'McClain, Sherrilyn'}, {'number': '945', 'name': 'McCormick, John M'}, {'number': '1162', 'name': 'McCormick, Mark'}, {'number': '1192', 'name': 'McCoy, Kassie'}, {'number': '1145', 'name': 'McCray, Kevin C.'}, {'number': '1108', 'name': 'McCune, Mitchell'}, {'number': '816', 'name': 'McCurdy, Gary D'}, {'number': '976', 'name': 'McCurdy, Jack'}, {'number': '693', 'name': 'McDaniel, Edward M.'}, {'number': '1151', 'name': 'McDaniel, Tracy'}, {'number': '1143', 'name': 'McElwee, Michele D.'}, {'number': '465', 'name': 'McElwee, Roma M.'}, {'number': '541', 'name': 'McFall, Gordon'}, {'number': '1067', 'name': 'McGivern, Michael W'}, {'number': '508', 'name': 'McGuire, Linda'}, {'number': '1004', 'name': 'McGuire, Lynne'}, {'number': '1200', 'name': 'McLaughlin, Brian'}, {'number': '1163', 'name': 'Meaders, Scott D.'}, {'number': '25', 'name': 'Means, William W.'}, {'number': '403', 'name': 'Mefford, Howard R.'}, {'number': '592', 'name': 'Meisgh, Herb'}, {'number': '82', 'name': 'Melson, Gordon R.'}, {'number': '894', 'name': 'Merriott, Neal'}, {'number': '542', 'name': 'Mesigh, Herb  J.'}, {'number': '362', 'name': 'Messler, J. Peter'}, {'number': '543', 'name': 'Meyers, William S.'}, {'number': '1177', 'name': 'MHC Court Judge (General)'}, {'number': '164', 'name': 'Michael, John W.'}, {'number': '1053', 'name': 'Migliorino, Charles J'}, {'number': '411', 'name': 'Miller, Gary E.'}, {'number': '1079', 'name': 'Miller, J. Anthony'}, {'number': '241', 'name': 'Miller, John David'}, {'number': '276', 'name': 'Miller, Richard A.'}, {'number': '490', 'name': 'Miller, Russell C.'}, {'number': '544', 'name': 'Mills, Clarence'}, {'number': '1061', 'name': 'Mills, Tim'}, {'number': '83', 'name': 'Miracle, Jess I.'}, {'number': '939', 'name': 'Misak, Trisha A'}, {'number': '929', 'name': 'Misdemeanor Domestic Violence,'}, {'number': '821', 'name': 'Mitchell, E. Bay'}, {'number': '389', 'name': 'Mollison, C. Suzanne'}, {'number': '951', 'name': 'Moody, Dawn'}, {'number': '406', 'name': 'Moore, Mark A.'}, {'number': '365', 'name': 'Moore, Roy D.'}, {'number': '545', 'name': 'Morgan, Page Price'}, {'number': '168', 'name': 'Moroney, Anne E.'}, {'number': '1031', 'name': 'Morris, Dennis'}, {'number': '1229', 'name': 'Morrison, Charles Kevin'}, {'number': '546', 'name': 'Morrison, Suzanne'}, {'number': '462', 'name': 'Morrissey, Linda G.'}, {'number': '953', 'name': 'Mowdy, D. Clay'}, {'number': '385', 'name': 'Mowery, Gene F.'}, {'number': '1225', 'name': 'Mueller, Emily'}, {'number': '840', 'name': 'Municipal Judge'}, {'number': '419', 'name': 'Murphy, Jr., Robert M.'}, {'number': '726', 'name': 'MURRAY, SHERMAN D.'}, {'number': '322', 'name': 'Musseman, William J.'}, {'number': '84', 'name': 'Myers, William S.'}, {'number': '482', 'name': 'Napoli, Jequita H.'}, {'number': '547', 'name': 'Nelson, E. C.'}, {'number': '460', 'name': 'Nelson, Forrest D'}, {'number': '938', 'name': 'Neuwirth, Gerald F.'}, {'number': '1147', 'name': 'Newburn, Irma'}, {'number': '940', 'name': 'Newby, Tom'}, {'number': '852', 'name': 'Nightingale, Rebecca B.'}, {'number': '597', 'name': 'Nix, Cindy'}, {'number': '603', 'name': 'Norman, Mike'}, {'number': '1009', 'name': 'Oakes, Martha'}, {'number': '1125', 'name': 'Ogden, Richard'}, {'number': '967', 'name': 'Olsen, Timothy L'}, {'number': '1133', 'name': 'Orendorff, Matt'}, {'number': '548', 'name': 'Otey, Millie'}, {'number': '87', 'name': 'Owens, Charles L.'}, {'number': '243', 'name': 'Owens, Daniel L.'}, {'number': '930', 'name': 'Pace, Kirsten'}, {'number': '477', 'name': 'Paddleford, James H.'}, {'number': '244', 'name': 'Page, Leslie D.'}, {'number': '968', 'name': 'Palmer, Wilma'}, {'number': '1205', 'name': 'Palumbo, Amy'}, {'number': '908', 'name': 'Parish, Lawrence W'}, {'number': '549', 'name': 'Parker, Richard W'}, {'number': '344', 'name': 'Parks, Ed'}, {'number': '658', 'name': 'Parks, Melanie K'}, {'number': '88', 'name': 'Parr, Jack R.'}, {'number': '872', 'name': 'Parrish, Patricia G.'}, {'number': '1088', 'name': 'Parsley, Jon'}, {'number': '379', 'name': 'Patton, Nan J.'}, {'number': '1089', 'name': 'Payment Plan,'}, {'number': '815', 'name': 'Payton, J. Jeffrey'}, {'number': '1027', 'name': 'Pazzo, Stephen R'}, {'number': '667', 'name': 'PC-TEMP COA ENTRY,  DO NOT REMOVE'}, {'number': '245', 'name': 'Pearman, J. R.'}, {'number': '1156', 'name': 'Pemberton, Trevor'}, {'number': '364', 'name': 'Perry, Richard McBee'}, {'number': '361', 'name': 'Perugino, Robert'}, {'number': '89', 'name': 'Peterson, David L.'}, {'number': '90', 'name': 'Pickens, Richard W.'}, {'number': '1228', 'name': 'Pickerill, Cindy'}, {'number': '1083', 'name': 'Pickerill, Patrick'}, {'number': '974', 'name': 'Pickering, Cindy'}, {'number': '1181', 'name': 'Pipes, Robert Trent'}, {'number': '666', 'name': 'PNL-TEMP COA ENTRY,  DO NOT REMOVE'}, {'number': '1131', 'name': 'Pollard, Greg'}, {'number': '350', 'name': 'Post, Dynda R.'}, {'number': '173', 'name': 'Potter, Mermon H.'}, {'number': '174', 'name': 'Powell, David E.'}, {'number': '550', 'name': 'Powers, Bradford E.'}, {'number': '551', 'name': 'Powers, Donald E.'}, {'number': '247', 'name': 'Powers, Rocky L.'}, {'number': '960', 'name': 'Pratt, Jim'}, {'number': '680', 'name': 'Preliminary Hearing Docket,'}, {'number': '91', 'name': 'Price, Robert E.'}, {'number': '1185', 'name': 'Priddy, Tracy'}, {'number': '608', 'name': 'Prigmore, Carol Gene'}, {'number': '1057', 'name': 'Prince, Thomas E'}, {'number': '447', 'name': 'Pritchett, M. Susie'}, {'number': '1055', 'name': 'Probate Docket A,'}, {'number': '1180', 'name': 'Probate Special Judge'}, {'number': '902', 'name': 'Protective Order,'}, {'number': '1148', 'name': 'Puckett, Lori A'}, {'number': '249', 'name': 'Pyle, Kirk B.'}, {'number': '987', 'name': 'Quandt, Eric'}, {'number': '250', 'name': 'Quarles, R B.'}, {'number': '92', 'name': 'Raburn, J. Winston'}, {'number': '175', 'name': 'Rahhal, Franklin D.'}, {'number': '643', 'name': 'Rambo, G. Dan'}, {'number': '1130', 'name': 'Ramirez, Pandee'}, {'number': '26', 'name': 'Rapp, W. Keith'}, {'number': '457', 'name': 'Reavis, II, Robert E.'}, {'number': '806', 'name': 'Reddick, Ryan D.'}, {'number': '177', 'name': 'Reeder, Lloyd R.'}, {'number': '970', 'name': 'Reeves, Joe B'}, {'number': '663', 'name': 'REF-TEMP COA ENTRY,  DO NOT REMOVE'}, {'number': '874', 'name': 'Referee,'}, {'number': '1023', 'name': 'Reid, David'}, {'number': '27', 'name': 'Reif, John F.'}, {'number': '1170', 'name': 'Reilly, Maxey'}, {'number': '1134', 'name': 'ReMerge Judge,'}, {'number': '552', 'name': 'Replin, Ricki'}, {'number': '178', 'name': 'Revard, Douglas C.'}, {'number': '280', 'name': 'Ricks, Carolyn R.'}, {'number': '1175', 'name': 'Riesen, Tom'}, {'number': '349', 'name': 'Riffe, Gerald H.'}, {'number': '369', 'name': 'Ring, Rod D'}, {'number': '360', 'name': 'Roberts, Charles E.'}, {'number': '695', 'name': 'Roberts, Ted'}, {'number': '94', 'name': 'Roberts, William M.'}, {'number': '475', 'name': 'Robertson, Vicki L.'}, {'number': '495', 'name': 'Robinson, A. Carl'}, {'number': '1189', 'name': 'Rogers, Abby'}, {'number': '95', 'name': 'Rogers, Bill Ed'}, {'number': '1030', 'name': 'Roper, Michelle Kirby'}, {'number': '922', 'name': 'Ross, Philip A'}, {'number': '1230', 'name': 'Rowe, Dustin P.'}, {'number': '1173', 'name': 'Rowland, Scott'}, {'number': '641', 'name': 'Russell, David L.'}, {'number': '935', 'name': 'Russell, G. Brent'}, {'number': '1127', 'name': 'Russell, Lara M'}, {'number': '498', 'name': 'Russell, Norman L.'}, {'number': '807', 'name': 'Ryan, Gregory J'}, {'number': '660', 'name': 'Ryan, Patrick C.'}, {'number': '96', 'name': 'Saied, William R.'}, {'number': '336', 'name': 'Salyer, Jerry L.'}, {'number': '1167', 'name': 'Savage, Kathryn'}, {'number': '931', 'name': 'Savage, Malcolm'}, {'number': '347', 'name': 'Scaggs, John H.'}, {'number': '1203', 'name': 'Schneiter, Lance'}, {'number': '596', 'name': 'Schott, Debbie'}, {'number': '1032', 'name': 'Schumacher, Tracy'}, {'number': '377', 'name': 'Schwabe, Charles L.'}, {'number': '297', 'name': 'Scroggins, Danny L.'}, {'number': '553', 'name': 'Seay, Frank H.'}, {'number': '1161', 'name': 'Seibert, April'}, {'number': '1149', 'name': 'Seigars, Jason'}, {'number': '409', 'name': 'Sellers, Jefferson D.'}, {'number': '254', 'name': 'Settle, J R.'}, {'number': '181', 'name': 'Sewell, G. Bruce'}, {'number': '98', 'name': 'Shaffer, Ronald L.'}, {'number': '255', 'name': 'Shallcross, Deborah C.'}, {'number': '410', 'name': 'Shaw, Bill M.'}, {'number': '880', 'name': 'Shaw, Larry'}, {'number': '1117', 'name': 'Shaw, Lisa'}, {'number': '1212', 'name': 'Sheperd, Grant'}, {'number': '431', 'name': 'Shepherd, Darrell G.'}, {'number': '810', 'name': 'Sherrill, George D.'}, {'number': '414', 'name': 'Sherrill, Trace C.'}, {'number': '1128', 'name': 'Shilling, Leland'}, {'number': '1011', 'name': 'Shook, Dennis N'}, {'number': '1231', 'name': 'Siderias, James M.'}, {'number': '1150', 'name': 'Sigler, Jared'}, {'number': '182', 'name': 'Simmons, Paul E.'}, {'number': '8', 'name': 'Simms, Robert D.'}, {'number': '1062', 'name': 'Simpson, Megan'}, {'number': '471', 'name': 'Singer, Todd W.'}, {'number': '381', 'name': 'Skimbo, Janice Kay'}, {'number': '644', 'name': 'Sleeper, Gary'}, {'number': '846', 'name': 'Small Claims Judge,'}, {'number': '554', 'name': 'Smith, Allen F.'}, {'number': '1183', 'name': 'Smith, Bret'}, {'number': '426', 'name': 'Smith, Clancy C.'}, {'number': '617', 'name': 'Smith, Clifford J'}, {'number': '870', 'name': 'Smith, Clifford J.'}, {'number': '1080', 'name': 'Smith, David'}, {'number': '443', 'name': 'Smith, Gale'}, {'number': '183', 'name': 'Smith, Greggory M.'}, {'number': '650', 'name': 'Smith, Joseph'}, {'number': '474', 'name': 'Smith, L. Joe'}, {'number': '399', 'name': 'Smith, Mark R.'}, {'number': '556', 'name': 'Smith, Richard W.'}, {'number': '461', 'name': 'Smith, Sarah D.'}, {'number': '1146', 'name': 'Smith, Trisha D.'}, {'number': '184', 'name': 'Smith, Wayne B.'}, {'number': '256', 'name': 'Smith Jr, Thomas C.'}, {'number': '1070', 'name': 'Snipes, Carla'}, {'number': '848', 'name': 'Snow, Gary'}, {'number': '501', 'name': 'Snow, Wayne B.'}, {'number': '298', 'name': 'Sontag, James L.'}, {'number': '876', 'name': 'Sparkman, Rodney'}, {'number': '185', 'name': 'Speakman, Streeter'}, {'number': '557', 'name': 'Spears, Ken L.'}, {'number': '683', 'name': 'Special 1,'}, {'number': '684', 'name': 'Special 2'}, {'number': '685', 'name': 'Special 3'}, {'number': '686', 'name': 'Special 4'}, {'number': '687', 'name': 'Special 5'}, {'number': '284', 'name': 'Sprouse, Dennis M.'}, {'number': '1208', 'name': 'Stallings, Susan'}, {'number': '897', 'name': 'Stano, Michael'}, {'number': '352', 'name': 'Staton, Jon Tom'}, {'number': '616', 'name': 'Steidley, J. Dwayne'}, {'number': '910', 'name': 'Stephens, David A'}, {'number': '258', 'name': 'Stephens, E E.'}, {'number': '1021', 'name': 'Stice, Steve'}, {'number': '259', 'name': 'Stilwell, Lee G.'}, {'number': '1159', 'name': 'Stinson, Sheila'}, {'number': '1172', 'name': 'Stoner, Kenneth M.'}, {'number': '1220', 'name': 'Stout, Jacqueline'}, {'number': '1072', 'name': 'Stout, Weldon'}, {'number': '423', 'name': 'Stratton, C. William'}, {'number': '1182', 'name': 'Strubhar, Khristan K.'}, {'number': '188', 'name': 'Strubhar, Reta M.'}, {'number': '445', 'name': 'Stuart, Roger H.'}, {'number': '30', 'name': 'Stubblefield, Ronald J.'}, {'number': '593', 'name': 'Stucky, Melanie'}, {'number': '957', 'name': 'Sullivan, Jon'}, {'number': '558', 'name': 'Swanson, Russell'}, {'number': '488', 'name': 'Swinton, Barbara G.'}, {'number': '470', 'name': 'Tate, Charles G.'}, {'number': '1026', 'name': 'Tate, Stuart'}, {'number': '755', 'name': 'Tax Commission Judge'}, {'number': '1086', 'name': 'Tayloe, Emmit'}, {'number': '99', 'name': 'Taylor, Joe C.'}, {'number': '1068', 'name': 'Taylor, L. Brad'}, {'number': '998', 'name': 'Taylor, Shawn S.'}, {'number': '189', 'name': 'Taylor, Steven W.'}, {'number': '559', 'name': 'Theus, Harold J.'}, {'number': '1044', 'name': 'Thomas, Katherine E.'}, {'number': '1201', 'name': 'Thomas, Linda'}, {'number': '190', 'name': 'Thomas, William M.'}, {'number': '100', 'name': 'Thompson, Donald D.'}, {'number': '493', 'name': 'Thornbrugh, P. Thomas'}, {'number': '903', 'name': 'Thygesen, Norman D.'}, {'number': '1109', 'name': 'Timmons, Aletia Haynes'}, {'number': '395', 'name': 'Tipton, Virgil R.'}, {'number': '1138', 'name': 'Tolson, Steven L.'}, {'number': '560', 'name': 'Townsend, Charles'}, {'number': '675', 'name': 'Traffic Court Judge (General),'}, {'number': '1165', 'name': 'Traffic Plea - by Mail'}, {'number': '1164', 'name': 'Traffic Plea - In Person'}, {'number': '1166', 'name': 'Traffic Plea - Online'}, {'number': '692', 'name': 'Trial Court Docket,'}, {'number': '1075', 'name': 'Truancy Docket,'}, {'number': '1039', 'name': 'Truong, Cindy H.'}, {'number': '637', 'name': 'Tucker, Caroline'}, {'number': '638', 'name': 'Tucker, Caroline'}, {'number': '997', 'name': 'Tupper, Michael D'}, {'number': '561', 'name': 'Turner, John S.'}, {'number': '1059', 'name': 'Turner, Lee'}, {'number': '448', 'name': 'Upp, Brian H.'}, {'number': '965', 'name': 'Vaclaw, Russell'}, {'number': '467', 'name': 'Van Dyck, Richard'}, {'number': '562', 'name': 'Van Meter, A. P.'}, {'number': '619', 'name': 'Vassar, Joe Sam'}, {'number': '430', 'name': 'Vassar, Paul'}, {'number': '988', 'name': 'VerSteeg, F. Pat'}, {'number': '1077', 'name': 'Virgin, Jeff'}, {'number': '701', 'name': 'VPO Docket'}, {'number': '760', 'name': 'Walke, Geary L.'}, {'number': '191', 'name': 'Walker, Thomas S.'}, {'number': '891', 'name': 'Walkley, Lori'}, {'number': '861', 'name': 'Wall, Caroline'}, {'number': '102', 'name': 'Wall, Ray L.'}, {'number': '1003', 'name': 'Wallace, Jana Kay'}, {'number': '263', 'name': 'Wallace, Joe S.'}, {'number': '563', 'name': 'Wampler, John N.'}, {'number': '564', 'name': 'Ward, Bob'}, {'number': '877', 'name': 'Ward, Farley W.'}, {'number': '392', 'name': 'Warren, W. Mike'}, {'number': '1112', 'name': 'Waters, Kyle E.'}, {'number': '961', 'name': 'Watson, Kenneth C'}, {'number': '348', 'name': 'Watson, Jr., Leo A.'}, {'number': '279', 'name': 'Watt, Joseph M.'}, {'number': '674', 'name': 'Wayne, J "Duke"'}, {'number': '623', 'name': 'Weedon, Jill Carpenter'}, {'number': '907', 'name': 'Welch, Allen J'}, {'number': '615', 'name': 'Welch, Bill D.'}, {'number': '277', 'name': 'Welch, David'}, {'number': '966', 'name': 'Wells, Holli'}, {'number': '594', 'name': 'Werueke, Vicky'}, {'number': '565', 'name': 'West, Lee R.'}, {'number': '353', 'name': 'Wheeler, William W.'}, {'number': '103', 'name': 'Whistler, William J.'}, {'number': '264', 'name': 'White, April Sellers'}, {'number': '566', 'name': 'Whitebook, Merl'}, {'number': '599', 'name': 'Whitecotton, Patty'}, {'number': '1211', 'name': 'Wilkie, David'}, {'number': '194', 'name': 'Wilkinson, James A.'}, {'number': '567', 'name': 'Williams, Andrew'}, {'number': '1085', 'name': 'Williams, Cassandra M'}, {'number': '847', 'name': 'Williams, Danita G.'}, {'number': '266', 'name': 'Williamson, Creston B.'}, {'number': '340', 'name': 'Willis, Ozella M.'}, {'number': '568', 'name': 'Wilson, George H.'}, {'number': '105', 'name': 'Winchester, James R.'}, {'number': '106', 'name': 'Winslow, David E.'}, {'number': '107', 'name': 'Wiseman, Jane'}, {'number': '195', 'name': 'Wolfe, James R.'}, {'number': '268', 'name': 'Wolking, John L.'}, {'number': '569', 'name': 'Woodliff, Duane'}, {'number': '570', 'name': 'Woodrow, George'}, {'number': '108', 'name': 'Woodson, Charles Scott'}, {'number': '972', 'name': 'Woodward, Paul K'}, {'number': '486', 'name': 'Woolery, Richard A.'}, {'number': '996', 'name': 'Work, Don A'}, {'number': '302', 'name': 'Worthington, Donald L.'}, {'number': '1135', 'name': 'Worthington, Susan C.'}, {'number': '571', 'name': 'Wright, Thornton'}, {'number': '287', 'name': 'Wrigley, Joseph'}, {'number': '496', 'name': 'Wyatt, III, Harry M.'}, {'number': '916', 'name': 'Wynn, Donnita'}, {'number': '1153', 'name': 'Wyrick, Patrick R.'}, {'number': '1114', 'name': 'Yarborough, Eric G.'}, {'number': '572', 'name': 'Yeagley, Laurence A.'}, {'number': '655', 'name': 'York, Leon J'}, {'number': '1196', 'name': 'Young, Z. Joseph'}, {'number': '109', 'name': 'Youngblood, Kenneth L.'}, {'number': '376', 'name': 'Zigler, Greg A.'}, {'number': '1111', 'name': 'Zwaan, Susan'}, {'number': '573', 'name': 'Zynda, Thomas R.'}]
