# Generated by Django 2.0.4 on 2018-04-27 00:11

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('calaccess_processed_filings', '0008_auto_20180426_2358'),
    ]

    operations = [
        migrations.CreateModel(
            name='Form461Part5Item',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('line_item', models.IntegerField(help_text='Line number of the filing form where the payment is itemized (from EXPN_CD.LINE_ITEM)', verbose_name='line item')),
                ('payee_code', models.CharField(blank=True, choices=[('BNM', "Ballot measure's name/title"), ('CAO', 'Candidate/officeholder'), ('COM', 'Committee'), ('IND', 'Individual'), ('MBR', 'Member of Associaton'), ('OFF', 'Officer'), ('OTH', 'Other'), ('PTY', 'Political Party'), ('RCP', 'Recipient committee'), ('SCC', 'Small Contributor Committee'), ('???', 'Unknown value')], help_text='Code describing the payee (from EXPN_CD.ENTITY_CD)', max_length=3, verbose_name='payee code')),
                ('payee_committee_id', models.CharField(blank=True, help_text="Payee's filer identification number, if it is a committee (from EXPN_CD.CMTE_ID)", max_length=9, verbose_name='payee committee id')),
                ('payee_title', models.CharField(blank=True, help_text='Name title of the payee (from EXPN_CD.PAYEE_NAMT)', max_length=10, verbose_name='payee title')),
                ('payee_lastname', models.CharField(blank=True, help_text='Last name of the payee or business name (from EXPN_CD.PAYEE_NAML)', max_length=200, verbose_name='payee lastname')),
                ('payee_firstname', models.CharField(help_text='First name of the payee (from EXPN_CD.PAYEE_NAMF)', max_length=45, verbose_name='payee firstname')),
                ('payee_name_suffix', models.CharField(blank=True, help_text='Name suffix of the payee (from EXPN_CD.PAYEE_NAMS)', max_length=10, verbose_name='payee name suffix')),
                ('payee_city', models.CharField(blank=True, help_text='City of the payee (from EXPN_CD.PAYEE_CITY)', max_length=30, verbose_name='payee city')),
                ('payee_state', models.CharField(blank=True, help_text='State of the payee (from EXPN_CD.PAYEE_ST)', max_length=2, verbose_name='payee state')),
                ('payee_zip', models.CharField(blank=True, help_text='Zip code (usually zip5, sometimes zip9) of the payee (from EXPN_CD.PAYEE_ZIP4)', max_length=10, verbose_name='payee zip')),
                ('treasurer_title', models.CharField(blank=True, help_text="Name title of the payee committee's treasurer (from EXPN_CD.TRES_NAMT)", max_length=10, verbose_name='treasurer title')),
                ('treasurer_lastname', models.CharField(blank=True, help_text="Last name of the payee committee's treasurer (from EXPN_CD.TRES_NAML)", max_length=200, verbose_name='treasurer lastname')),
                ('treasurer_firstname', models.CharField(help_text="First name of the payee committee's treasurer (from EXPN_CD.TRES_NAMF)", max_length=45, verbose_name='treasurer firstname')),
                ('treasurer_name_suffix', models.CharField(blank=True, help_text="Name suffix of the payee committee's treasurer (from EXPN_CD.TRES_NAMS)", max_length=10, verbose_name='treasurer name suffix')),
                ('treasurer_city', models.CharField(blank=True, help_text="City of the payee committee's treasurer (from EXPN_CD.TRES_CITY)", max_length=30, verbose_name='treasurer city')),
                ('treasurer_state', models.CharField(blank=True, help_text="State of the payee committee's treasurer (from EXPN_CD.TRES_ST)", max_length=2, verbose_name='treasurer state')),
                ('treasurer_zip', models.CharField(blank=True, help_text="Zip code (usually zip5, sometimes zip9) of the payee committee's treasurer (from EXPN_CD.TRES_ZIP4)", max_length=10, verbose_name='treasurer zip')),
                ('payment_code', models.CharField(blank=True, choices=[('CMP', 'Campaign paraphernalia/miscellaneous'), ('CNS', 'Campaign consultants'), ('CTB', 'Contribution (if nonmonetary, explain)*'), ('CVC', 'Civic donations'), ('FIL', 'Candidate filing/ballot feeds'), ('FND', 'Fundraising events'), ('IKD', 'In-kind contribution (nonmonetary)'), ('IND', 'Independent expenditure supporting/opposing others (explain)*'), ('LEG', 'Legal defense'), ('LIT', 'Campaign literature and mailings'), ('LON', 'Loan'), ('MBR', 'Member communications'), ('MON', 'Monetary contribution'), ('MTG', 'Meetings and appearances'), ('OFC', 'Office expenses'), ('PET', 'Petition circulating'), ('PHO', 'Phone banks'), ('POL', 'Polling and survey research'), ('POS', 'Postage, delivery and messenger services'), ('PRO', 'Professional services (legal, accounting)'), ('PRT', 'Print ads'), ('RAD', 'Radio airtime and production costs'), ('RFD', 'Returned contributions'), ('SAL', 'Campaign workers salaries'), ('TEL', 'T.V. or cable airtime and production costs'), ('TRC', 'Candidate travel, lodging and meals (explain)'), ('TRS', 'Staff/spouse travel, lodging and meals (explain)'), ('TSF', 'Transfer between committees of the same candidate/sponsor'), ('VOT', 'Voter registration'), ('WEB', 'Information technology costs (internet, e-mail)'), ('???', 'Unknown value')], help_text='Code describing the payment (from EXPN_CD.EXPN_CODE)', max_length=3, verbose_name='payment code')),
                ('payment_description', models.CharField(blank=True, help_text='Purpose of payment and/or description/explanation (from EXPN_CD.EXPN_DSCR)', max_length=400, verbose_name='payment description')),
                ('amount', models.DecimalField(decimal_places=2, help_text='Amount paid to the payee in the period covered by the filing (from EXPN_CD.AMOUNT)', max_digits=14, verbose_name='amount')),
                ('cumulative_ytd_amount', models.DecimalField(decimal_places=2, help_text="Cumulative year-to-date amount given or spent by the filer in support or opposition of the candidate or ballot measure as of the Form 460's filing date (from EXPN_CD.CUM_YTD)", max_digits=14, null=True)),
                ('expense_date', models.DateField(help_text='Date or expense (from EXPN_CD.EXPN_DATE)', null=True, verbose_name='expense date')),
                ('check_number', models.CharField(blank=True, help_text='Optional check number for the payment made by the campaign filer (from EXPN_CD.EXPN_CHKNO)', max_length=20, verbose_name='expense check number')),
                ('support_oppose_code', models.CharField(blank=True, choices=[('S', 'Support'), ('O', 'Oppose'), ('?', 'Unknown value')], help_text='If applicable, code indicating whether the payment went toward supporting or opposing a candidate/ballot measure (from EXPN_CD.SUP_OPP_CD)', max_length=1, verbose_name='support oppose code')),
                ('ballot_measure_jurisdiction', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a ballot measure, the jurisdiction subject to the ballot measure (from EXPN_CD.BAL_JURIS)', max_length=40, verbose_name='ballot measure jurisdiction')),
                ('ballot_measure_name', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a ballot measure, name of the ballot measure (from EXPN_CD.BAL_NAME  or EXPN_CD.CAND_NAML)', max_length=200, verbose_name='ballot measure name')),
                ('ballot_measure_num', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a ballot measure, ballot number or letter (from EXPN_CD.BAL_NUM)', max_length=7, verbose_name='ballot measure number')),
                ('candidate_title', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate, name title of the candidate (from EXPN_CD.CAND_NAMT)', max_length=10, verbose_name='candidate title')),
                ('candidate_lastname', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate, last name of the candidate or business name (from EXPN_CD.CAND_NAML)', max_length=200, verbose_name='candidate lastname')),
                ('candidate_firstname', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate, first name of the candidate (from EXPN_CD.CAND_NAMF)', max_length=45, verbose_name='candidate firstname')),
                ('candidate_name_suffix', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate, name suffix of the candidate (from EXPN_CD.CAND_NAMS)', max_length=10, verbose_name='candidate name suffix')),
                ('candidate_jurisdiction_code', models.CharField(blank=True, choices=[('ASM', 'Assembly District'), ('BOE', 'Board of Equalization District'), ('CIT', 'City'), ('CTY', 'County'), ('LOC', 'Local'), ('OTH', 'Other'), ('SEN', 'Senate District'), ('STW', 'Statewide'), ('???', 'Statewide')], help_text='If the payment went toward supporting/opposing a candidate,code indicating the jurisdiction of the office (from EXPN_CD.JURIS_CD)', max_length=3, verbose_name='candidate jurisdiction')),
                ('candidate_jurisdiction_description', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a county, city or local candidate, full description of the office (from EXPN_CD.JURIS_DSCR)', max_length=40, verbose_name='candidate jurisdiciton description')),
                ('candidate_district', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate,for state senate, assembly or local board of education, thedistrict of the office (from EXPN_CD.DIST_NO)', max_length=3, verbose_name='candidate district')),
                ('office_sought_held', models.CharField(blank=True, choices=[('S', 'SOUGHT'), ('H', 'HELD')], help_text='If the payment went toward supporting/opposing a candidate,code indicating if the candidate is seeking or currently holds the office (from EXPN_CD.OFF_S_H_CD)', max_length=1, verbose_name='office sought or held')),
                ('office_code', models.CharField(blank=True, choices=[('APP', 'State Appellate Court Justice'), ('ASM', 'State Assembly Person'), ('ASR', 'Assessor'), ('ATT', 'Attorney General'), ('BED', 'Board of Education'), ('BOE', 'Board of Equalization Member'), ('BSU', 'Board of Supervisors'), ('CAT', 'City Attorney'), ('CCB', 'Community College Board'), ('CCM', 'City Council Member'), ('CON', 'State Controller'), ('COU', 'County Counsel'), ('CSU', 'County Supervisor'), ('CTR', 'Local Controller'), ('DAT', 'District Attorney'), ('GOV', 'Governor'), ('INS', 'Insurance Commissioner'), ('LTG', 'Lieutenant Governor'), ('MAY', 'Mayor'), ('OTH', 'Other'), ('PDR', 'Public Defender'), ('PER', 'Public Employees Retirement System'), ('PLN', 'Planning Commissioner'), ('SCJ', 'Superior Court Judge'), ('SEN', 'State Senator'), ('SHC', 'Sheriff-Coroner'), ('SOS', 'Secretary of State'), ('SPM', 'Supreme Court Justice'), ('SUP', 'Superintendent of Public Instruction'), ('TRE', 'State Treasurer'), ('TRS', 'Local Treasurer'), ('???', 'Unknown value')], help_text='If the payment went toward supporting/opposing a candidate,code describing the office (from EXPN_CD.OFFICE_CD)', max_length=3, verbose_name='office code')),
                ('office_description', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate,description of the office (from EXPN_CD.OFFIC_DSCR)', max_length=40, verbose_name='office description')),
                ('transaction_id', models.CharField(help_text='Identifies a unique transaction across versions of the a given Form 460 filing (from EXPN_CD.TRAN_ID)', max_length=20, verbose_name='transaction id')),
                ('memo_reference_number', models.CharField(blank=True, help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from EXPN_CD.MEMO_REFNO)", max_length=20, verbose_name='memo reference number')),
                ('filing', models.ForeignKey(help_text='Foreign key referring to the Form 461 on which the payment was reported (from EXPN_CD.FILING_ID)', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='part_5_items', to='calaccess_processed_filings.Form461Filing')),
            ],
            options={
                'verbose_name': 'Form 461 (Campaign Disclosure) Part 5 item',
            },
        ),
        migrations.CreateModel(
            name='Form461Part5ItemVersion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('line_item', models.IntegerField(help_text='Line number of the filing form where the payment is itemized (from EXPN_CD.LINE_ITEM)', verbose_name='line item')),
                ('payee_code', models.CharField(blank=True, choices=[('BNM', "Ballot measure's name/title"), ('CAO', 'Candidate/officeholder'), ('COM', 'Committee'), ('IND', 'Individual'), ('MBR', 'Member of Associaton'), ('OFF', 'Officer'), ('OTH', 'Other'), ('PTY', 'Political Party'), ('RCP', 'Recipient committee'), ('SCC', 'Small Contributor Committee'), ('???', 'Unknown value')], help_text='Code describing the payee (from EXPN_CD.ENTITY_CD)', max_length=3, verbose_name='payee code')),
                ('payee_committee_id', models.CharField(blank=True, help_text="Payee's filer identification number, if it is a committee (from EXPN_CD.CMTE_ID)", max_length=9, verbose_name='payee committee id')),
                ('payee_title', models.CharField(blank=True, help_text='Name title of the payee (from EXPN_CD.PAYEE_NAMT)', max_length=10, verbose_name='payee title')),
                ('payee_lastname', models.CharField(blank=True, help_text='Last name of the payee or business name (from EXPN_CD.PAYEE_NAML)', max_length=200, verbose_name='payee lastname')),
                ('payee_firstname', models.CharField(help_text='First name of the payee (from EXPN_CD.PAYEE_NAMF)', max_length=45, verbose_name='payee firstname')),
                ('payee_name_suffix', models.CharField(blank=True, help_text='Name suffix of the payee (from EXPN_CD.PAYEE_NAMS)', max_length=10, verbose_name='payee name suffix')),
                ('payee_city', models.CharField(blank=True, help_text='City of the payee (from EXPN_CD.PAYEE_CITY)', max_length=30, verbose_name='payee city')),
                ('payee_state', models.CharField(blank=True, help_text='State of the payee (from EXPN_CD.PAYEE_ST)', max_length=2, verbose_name='payee state')),
                ('payee_zip', models.CharField(blank=True, help_text='Zip code (usually zip5, sometimes zip9) of the payee (from EXPN_CD.PAYEE_ZIP4)', max_length=10, verbose_name='payee zip')),
                ('treasurer_title', models.CharField(blank=True, help_text="Name title of the payee committee's treasurer (from EXPN_CD.TRES_NAMT)", max_length=10, verbose_name='treasurer title')),
                ('treasurer_lastname', models.CharField(blank=True, help_text="Last name of the payee committee's treasurer (from EXPN_CD.TRES_NAML)", max_length=200, verbose_name='treasurer lastname')),
                ('treasurer_firstname', models.CharField(help_text="First name of the payee committee's treasurer (from EXPN_CD.TRES_NAMF)", max_length=45, verbose_name='treasurer firstname')),
                ('treasurer_name_suffix', models.CharField(blank=True, help_text="Name suffix of the payee committee's treasurer (from EXPN_CD.TRES_NAMS)", max_length=10, verbose_name='treasurer name suffix')),
                ('treasurer_city', models.CharField(blank=True, help_text="City of the payee committee's treasurer (from EXPN_CD.TRES_CITY)", max_length=30, verbose_name='treasurer city')),
                ('treasurer_state', models.CharField(blank=True, help_text="State of the payee committee's treasurer (from EXPN_CD.TRES_ST)", max_length=2, verbose_name='treasurer state')),
                ('treasurer_zip', models.CharField(blank=True, help_text="Zip code (usually zip5, sometimes zip9) of the payee committee's treasurer (from EXPN_CD.TRES_ZIP4)", max_length=10, verbose_name='treasurer zip')),
                ('payment_code', models.CharField(blank=True, choices=[('CMP', 'Campaign paraphernalia/miscellaneous'), ('CNS', 'Campaign consultants'), ('CTB', 'Contribution (if nonmonetary, explain)*'), ('CVC', 'Civic donations'), ('FIL', 'Candidate filing/ballot feeds'), ('FND', 'Fundraising events'), ('IKD', 'In-kind contribution (nonmonetary)'), ('IND', 'Independent expenditure supporting/opposing others (explain)*'), ('LEG', 'Legal defense'), ('LIT', 'Campaign literature and mailings'), ('LON', 'Loan'), ('MBR', 'Member communications'), ('MON', 'Monetary contribution'), ('MTG', 'Meetings and appearances'), ('OFC', 'Office expenses'), ('PET', 'Petition circulating'), ('PHO', 'Phone banks'), ('POL', 'Polling and survey research'), ('POS', 'Postage, delivery and messenger services'), ('PRO', 'Professional services (legal, accounting)'), ('PRT', 'Print ads'), ('RAD', 'Radio airtime and production costs'), ('RFD', 'Returned contributions'), ('SAL', 'Campaign workers salaries'), ('TEL', 'T.V. or cable airtime and production costs'), ('TRC', 'Candidate travel, lodging and meals (explain)'), ('TRS', 'Staff/spouse travel, lodging and meals (explain)'), ('TSF', 'Transfer between committees of the same candidate/sponsor'), ('VOT', 'Voter registration'), ('WEB', 'Information technology costs (internet, e-mail)'), ('???', 'Unknown value')], help_text='Code describing the payment (from EXPN_CD.EXPN_CODE)', max_length=3, verbose_name='payment code')),
                ('payment_description', models.CharField(blank=True, help_text='Purpose of payment and/or description/explanation (from EXPN_CD.EXPN_DSCR)', max_length=400, verbose_name='payment description')),
                ('amount', models.DecimalField(decimal_places=2, help_text='Amount paid to the payee in the period covered by the filing (from EXPN_CD.AMOUNT)', max_digits=14, verbose_name='amount')),
                ('cumulative_ytd_amount', models.DecimalField(decimal_places=2, help_text="Cumulative year-to-date amount given or spent by the filer in support or opposition of the candidate or ballot measure as of the Form 460's filing date (from EXPN_CD.CUM_YTD)", max_digits=14, null=True)),
                ('expense_date', models.DateField(help_text='Date or expense (from EXPN_CD.EXPN_DATE)', null=True, verbose_name='expense date')),
                ('check_number', models.CharField(blank=True, help_text='Optional check number for the payment made by the campaign filer (from EXPN_CD.EXPN_CHKNO)', max_length=20, verbose_name='expense check number')),
                ('support_oppose_code', models.CharField(blank=True, choices=[('S', 'Support'), ('O', 'Oppose'), ('?', 'Unknown value')], help_text='If applicable, code indicating whether the payment went toward supporting or opposing a candidate/ballot measure (from EXPN_CD.SUP_OPP_CD)', max_length=1, verbose_name='support oppose code')),
                ('ballot_measure_jurisdiction', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a ballot measure, the jurisdiction subject to the ballot measure (from EXPN_CD.BAL_JURIS)', max_length=40, verbose_name='ballot measure jurisdiction')),
                ('ballot_measure_name', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a ballot measure, name of the ballot measure (from EXPN_CD.BAL_NAME  or EXPN_CD.CAND_NAML)', max_length=200, verbose_name='ballot measure name')),
                ('ballot_measure_num', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a ballot measure, ballot number or letter (from EXPN_CD.BAL_NUM)', max_length=7, verbose_name='ballot measure number')),
                ('candidate_title', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate, name title of the candidate (from EXPN_CD.CAND_NAMT)', max_length=10, verbose_name='candidate title')),
                ('candidate_lastname', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate, last name of the candidate or business name (from EXPN_CD.CAND_NAML)', max_length=200, verbose_name='candidate lastname')),
                ('candidate_firstname', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate, first name of the candidate (from EXPN_CD.CAND_NAMF)', max_length=45, verbose_name='candidate firstname')),
                ('candidate_name_suffix', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate, name suffix of the candidate (from EXPN_CD.CAND_NAMS)', max_length=10, verbose_name='candidate name suffix')),
                ('candidate_jurisdiction_code', models.CharField(blank=True, choices=[('ASM', 'Assembly District'), ('BOE', 'Board of Equalization District'), ('CIT', 'City'), ('CTY', 'County'), ('LOC', 'Local'), ('OTH', 'Other'), ('SEN', 'Senate District'), ('STW', 'Statewide'), ('???', 'Statewide')], help_text='If the payment went toward supporting/opposing a candidate,code indicating the jurisdiction of the office (from EXPN_CD.JURIS_CD)', max_length=3, verbose_name='candidate jurisdiction')),
                ('candidate_jurisdiction_description', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a county, city or local candidate, full description of the office (from EXPN_CD.JURIS_DSCR)', max_length=40, verbose_name='candidate jurisdiciton description')),
                ('candidate_district', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate,for state senate, assembly or local board of education, thedistrict of the office (from EXPN_CD.DIST_NO)', max_length=3, verbose_name='candidate district')),
                ('office_sought_held', models.CharField(blank=True, choices=[('S', 'SOUGHT'), ('H', 'HELD')], help_text='If the payment went toward supporting/opposing a candidate,code indicating if the candidate is seeking or currently holds the office (from EXPN_CD.OFF_S_H_CD)', max_length=1, verbose_name='office sought or held')),
                ('office_code', models.CharField(blank=True, choices=[('APP', 'State Appellate Court Justice'), ('ASM', 'State Assembly Person'), ('ASR', 'Assessor'), ('ATT', 'Attorney General'), ('BED', 'Board of Education'), ('BOE', 'Board of Equalization Member'), ('BSU', 'Board of Supervisors'), ('CAT', 'City Attorney'), ('CCB', 'Community College Board'), ('CCM', 'City Council Member'), ('CON', 'State Controller'), ('COU', 'County Counsel'), ('CSU', 'County Supervisor'), ('CTR', 'Local Controller'), ('DAT', 'District Attorney'), ('GOV', 'Governor'), ('INS', 'Insurance Commissioner'), ('LTG', 'Lieutenant Governor'), ('MAY', 'Mayor'), ('OTH', 'Other'), ('PDR', 'Public Defender'), ('PER', 'Public Employees Retirement System'), ('PLN', 'Planning Commissioner'), ('SCJ', 'Superior Court Judge'), ('SEN', 'State Senator'), ('SHC', 'Sheriff-Coroner'), ('SOS', 'Secretary of State'), ('SPM', 'Supreme Court Justice'), ('SUP', 'Superintendent of Public Instruction'), ('TRE', 'State Treasurer'), ('TRS', 'Local Treasurer'), ('???', 'Unknown value')], help_text='If the payment went toward supporting/opposing a candidate,code describing the office (from EXPN_CD.OFFICE_CD)', max_length=3, verbose_name='office code')),
                ('office_description', models.CharField(blank=True, help_text='If the payment went toward supporting/opposing a candidate,description of the office (from EXPN_CD.OFFIC_DSCR)', max_length=40, verbose_name='office description')),
                ('transaction_id', models.CharField(help_text='Identifies a unique transaction across versions of the a given Form 460 filing (from EXPN_CD.TRAN_ID)', max_length=20, verbose_name='transaction id')),
                ('memo_reference_number', models.CharField(blank=True, help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from EXPN_CD.MEMO_REFNO)", max_length=20, verbose_name='memo reference number')),
                ('filing_version', models.ForeignKey(help_text='Foreign key referring to the version of the Form 461 that includes the payment made', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='part_5_items', to='calaccess_processed_filings.Form461FilingVersion')),
            ],
            options={
                'verbose_name': 'Form 461 (Campaign Disclosure) Part 5 item version',
            },
        ),
        migrations.AlterUniqueTogether(
            name='form461part5itemversion',
            unique_together={('filing_version', 'line_item')},
        ),
        migrations.AlterIndexTogether(
            name='form461part5itemversion',
            index_together={('filing_version', 'line_item')},
        ),
        migrations.AlterUniqueTogether(
            name='form461part5item',
            unique_together={('filing', 'line_item')},
        ),
    ]
