# Generated by Django 2.0.4 on 2018-04-26 17:31

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('calaccess_processed_filings', '0004_form496part1item_form496part1itemversion'),
    ]

    operations = [
        migrations.CreateModel(
            name='Form496Part3Item',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('line_item', models.IntegerField(help_text='Line number of the filing form where the contribution is itemized (from RCPT_CD.LINE_ITEM)', verbose_name='line item')),
                ('date_received', models.DateField(help_text='Date the contribution was received (from RCPT_CD.RCPT_DATE)', null=True, verbose_name='date received')),
                ('date_received_thru', models.DateField(help_text='End date for late contributions received over a range of days (from RCPT_CD.DATE_THRU)', null=True, verbose_name='date received thru')),
                ('transaction_type', models.CharField(choices=[('F', 'Forgiven Loan'), ('I', 'Intermediary'), ('R', 'Returned (Negative Amount?)'), ('T', 'Third Party Repayment'), ('X', 'Transfer'), ('', 'Unknown'), ('INC16168', 'INC16168')], help_text='Type of transaction (from RCPT_CD.TRAN_TYPE)', max_length=255, verbose_name='transaction type')),
                ('transaction_id', models.CharField(help_text='Identifies a unique transaction across versions of the a given Form 460 filing (from RCPT_CD.TRAN_ID)', max_length=20, verbose_name='transaction id')),
                ('memo_reference_number', models.CharField(blank=True, help_text='Reference number for the memo attached to the contribution (from RCPT_CD.MEMO_REFNO)', max_length=20, verbose_name='memo reference number')),
                ('contributor_code', models.CharField(blank=True, choices=[('COM', 'Committee'), ('IND', 'Individual'), ('OFF', 'Officer'), ('OTH', 'Other'), ('PTY', 'Political Party'), ('RCP', 'Recipient committee'), ('SCC', 'Small Contributor Committee')], help_text='Code describing the contributor (from RCPT_CD.ENTITY_CD)', max_length=3, verbose_name='contributor code')),
                ('contributor_committee_id', models.CharField(blank=True, help_text="Contributor's filer identification number, if it is a committee (from RCPT_CD.CMTE_ID)", max_length=9, verbose_name='contributor committee id')),
                ('contributor_title', models.CharField(blank=True, help_text='Name title of the contributor (from RCPT_CD.CTRIB_NAMT)', max_length=10, verbose_name='contributor title')),
                ('contributor_lastname', models.CharField(blank=True, help_text='Last name of the contributor or business name (from RCPT_CD.CTRIB_NAML)', max_length=200, verbose_name='contributor lastname')),
                ('contributor_firstname', models.CharField(help_text='First name of the contributor (from RCPT_CD.CTRIB_NAMF)', max_length=45, verbose_name='contributor firstname')),
                ('contributor_name_suffix', models.CharField(blank=True, help_text='Name suffix of the contributor (from RCPT_CD.CTRIB_NAMS)', max_length=10, verbose_name='contributor name suffix')),
                ('contributor_city', models.CharField(blank=True, help_text='City of the contributor (from RCPT_CD.CTRIB_CITY)', max_length=30, verbose_name='contributor city')),
                ('contributor_state', models.CharField(blank=True, help_text='State of the contributor (from RCPT_CD.CTRIB_ST)', max_length=2, verbose_name='contributor state')),
                ('contributor_zip', models.CharField(blank=True, help_text='Zip code (usually zip5, sometimes zip9) of the contributor (from RCPT_CD.CTRIB_ZIP4)', max_length=10, verbose_name='contributor zip')),
                ('contributor_employer', models.CharField(blank=True, help_text='Employer of the contributor (from RCPT_CD.CTRIB_EMP)', max_length=200, verbose_name='contributor employer')),
                ('contributor_occupation', models.CharField(blank=True, help_text='Occupation of the contributor (from RCPT_CD.CTRIB_OCC)', max_length=60, verbose_name='contributor occupation')),
                ('contributor_is_self_employed', models.BooleanField(default=False, help_text='Indicates whether or not the contributor is self-employed(from RCPT_CD.CTRIB_SELF)', verbose_name='contributor is self employed')),
                ('intermediary_committee_id', models.CharField(blank=True, help_text="Intermediary's filer identification number, if it is a committee (from RCPT_CD.INTR_CMTEID)", max_length=9, verbose_name='intermediary committee id')),
                ('intermediary_title', models.CharField(blank=True, help_text='Name title of the intermediary (from RCPT_CD.INTR_NAMT)', max_length=10, verbose_name='intermediary title')),
                ('intermediary_lastname', models.CharField(blank=True, help_text='Last name of the intermediary or business name (from RCPT_CD.INTR_NAML)', max_length=200, verbose_name='intermediary lastname')),
                ('intermediary_firstname', models.CharField(help_text='First name of the intermediary (from RCPT_CD.INTR_NAMF)', max_length=45, verbose_name='intermediary firstname')),
                ('intermediary_name_suffix', models.CharField(blank=True, help_text='Name suffix of the intermediary (from RCPT_CD.INTR_NAMS)', max_length=10, verbose_name='intermediary name suffix')),
                ('intermediary_city', models.CharField(blank=True, help_text='City of the intermediary (from RCPT_CD.INTR_CITY)', max_length=30, verbose_name='intermediary city')),
                ('intermediary_state', models.CharField(blank=True, help_text='State of the intermediary (from RCPT_CD.INTR_ST)', max_length=2, verbose_name='intermediary state')),
                ('intermediary_zip', models.CharField(blank=True, help_text='Zip code (usually zip5, sometimes zip9) of the intermediary (from RCPT_CD.INTR_ZIP4)', max_length=10, verbose_name='intermediary zip')),
                ('intermediary_employer', models.CharField(blank=True, help_text='Employer of the intermediary (from RCPT_CD.INTR_EMP)', max_length=200, verbose_name='intermediary employer')),
                ('intermediary_occupation', models.CharField(blank=True, help_text='Occupation of the intermediary (from RCPT_CD.INTR_OCC)', max_length=60, verbose_name='intermediary occupation')),
                ('intermediary_is_self_employed', models.BooleanField(default=False, help_text='(from S497_CD.INTR_SELF)', verbose_name='intermediary is self employed')),
                ('cumulative_ytd_amount', models.DecimalField(decimal_places=2, help_text='Cumulative year-to-date amount given by the contributor as of the given Form 460 filing (from RCPT_CD.CUM_YTD)', max_digits=14, null=True)),
                ('cumulative_election_amount', models.DecimalField(decimal_places=2, help_text='For filers subject to contribution limits, cumulative amount given by the contributor during the election cycle as of the given Form 460 filing (from RCPT_CD.CUM_OTH)', max_digits=14, null=True)),
                ('amount', models.DecimalField(decimal_places=2, help_text='Amount received from the contributor in the period covered by the filing (from RCPT_CD.AMOUNT)', max_digits=14, verbose_name='amount')),
                ('interest_rate', models.CharField(blank=True, help_text='Interest rate of a loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from RCPT_CD.INT_RATE)', max_length=30, verbose_name='interest rate')),
                ('filing', models.ForeignKey(help_text='Foreign key referring to the Form 496 on which the monetary contribution was reported (from RCPT_CD.FILING_ID)', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='part3_items', to='calaccess_processed_filings.Form496Filing')),
            ],
            options={
                'verbose_name': 'Form 496 (Late Independent Expenditure) Part 3 item',
            },
        ),
        migrations.CreateModel(
            name='Form496Part3ItemVersion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('line_item', models.IntegerField(help_text='Line number of the filing form where the contribution is itemized (from RCPT_CD.LINE_ITEM)', verbose_name='line item')),
                ('date_received', models.DateField(help_text='Date the contribution was received (from RCPT_CD.RCPT_DATE)', null=True, verbose_name='date received')),
                ('date_received_thru', models.DateField(help_text='End date for late contributions received over a range of days (from RCPT_CD.DATE_THRU)', null=True, verbose_name='date received thru')),
                ('transaction_type', models.CharField(choices=[('F', 'Forgiven Loan'), ('I', 'Intermediary'), ('R', 'Returned (Negative Amount?)'), ('T', 'Third Party Repayment'), ('X', 'Transfer'), ('', 'Unknown'), ('INC16168', 'INC16168')], help_text='Type of transaction (from RCPT_CD.TRAN_TYPE)', max_length=255, verbose_name='transaction type')),
                ('transaction_id', models.CharField(help_text='Identifies a unique transaction across versions of the a given Form 460 filing (from RCPT_CD.TRAN_ID)', max_length=20, verbose_name='transaction id')),
                ('memo_reference_number', models.CharField(blank=True, help_text='Reference number for the memo attached to the contribution (from RCPT_CD.MEMO_REFNO)', max_length=20, verbose_name='memo reference number')),
                ('contributor_code', models.CharField(blank=True, choices=[('COM', 'Committee'), ('IND', 'Individual'), ('OFF', 'Officer'), ('OTH', 'Other'), ('PTY', 'Political Party'), ('RCP', 'Recipient committee'), ('SCC', 'Small Contributor Committee')], help_text='Code describing the contributor (from RCPT_CD.ENTITY_CD)', max_length=3, verbose_name='contributor code')),
                ('contributor_committee_id', models.CharField(blank=True, help_text="Contributor's filer identification number, if it is a committee (from RCPT_CD.CMTE_ID)", max_length=9, verbose_name='contributor committee id')),
                ('contributor_title', models.CharField(blank=True, help_text='Name title of the contributor (from RCPT_CD.CTRIB_NAMT)', max_length=10, verbose_name='contributor title')),
                ('contributor_lastname', models.CharField(blank=True, help_text='Last name of the contributor or business name (from RCPT_CD.CTRIB_NAML)', max_length=200, verbose_name='contributor lastname')),
                ('contributor_firstname', models.CharField(help_text='First name of the contributor (from RCPT_CD.CTRIB_NAMF)', max_length=45, verbose_name='contributor firstname')),
                ('contributor_name_suffix', models.CharField(blank=True, help_text='Name suffix of the contributor (from RCPT_CD.CTRIB_NAMS)', max_length=10, verbose_name='contributor name suffix')),
                ('contributor_city', models.CharField(blank=True, help_text='City of the contributor (from RCPT_CD.CTRIB_CITY)', max_length=30, verbose_name='contributor city')),
                ('contributor_state', models.CharField(blank=True, help_text='State of the contributor (from RCPT_CD.CTRIB_ST)', max_length=2, verbose_name='contributor state')),
                ('contributor_zip', models.CharField(blank=True, help_text='Zip code (usually zip5, sometimes zip9) of the contributor (from RCPT_CD.CTRIB_ZIP4)', max_length=10, verbose_name='contributor zip')),
                ('contributor_employer', models.CharField(blank=True, help_text='Employer of the contributor (from RCPT_CD.CTRIB_EMP)', max_length=200, verbose_name='contributor employer')),
                ('contributor_occupation', models.CharField(blank=True, help_text='Occupation of the contributor (from RCPT_CD.CTRIB_OCC)', max_length=60, verbose_name='contributor occupation')),
                ('contributor_is_self_employed', models.BooleanField(default=False, help_text='Indicates whether or not the contributor is self-employed(from RCPT_CD.CTRIB_SELF)', verbose_name='contributor is self employed')),
                ('intermediary_committee_id', models.CharField(blank=True, help_text="Intermediary's filer identification number, if it is a committee (from RCPT_CD.INTR_CMTEID)", max_length=9, verbose_name='intermediary committee id')),
                ('intermediary_title', models.CharField(blank=True, help_text='Name title of the intermediary (from RCPT_CD.INTR_NAMT)', max_length=10, verbose_name='intermediary title')),
                ('intermediary_lastname', models.CharField(blank=True, help_text='Last name of the intermediary or business name (from RCPT_CD.INTR_NAML)', max_length=200, verbose_name='intermediary lastname')),
                ('intermediary_firstname', models.CharField(help_text='First name of the intermediary (from RCPT_CD.INTR_NAMF)', max_length=45, verbose_name='intermediary firstname')),
                ('intermediary_name_suffix', models.CharField(blank=True, help_text='Name suffix of the intermediary (from RCPT_CD.INTR_NAMS)', max_length=10, verbose_name='intermediary name suffix')),
                ('intermediary_city', models.CharField(blank=True, help_text='City of the intermediary (from RCPT_CD.INTR_CITY)', max_length=30, verbose_name='intermediary city')),
                ('intermediary_state', models.CharField(blank=True, help_text='State of the intermediary (from RCPT_CD.INTR_ST)', max_length=2, verbose_name='intermediary state')),
                ('intermediary_zip', models.CharField(blank=True, help_text='Zip code (usually zip5, sometimes zip9) of the intermediary (from RCPT_CD.INTR_ZIP4)', max_length=10, verbose_name='intermediary zip')),
                ('intermediary_employer', models.CharField(blank=True, help_text='Employer of the intermediary (from RCPT_CD.INTR_EMP)', max_length=200, verbose_name='intermediary employer')),
                ('intermediary_occupation', models.CharField(blank=True, help_text='Occupation of the intermediary (from RCPT_CD.INTR_OCC)', max_length=60, verbose_name='intermediary occupation')),
                ('intermediary_is_self_employed', models.BooleanField(default=False, help_text='(from S497_CD.INTR_SELF)', verbose_name='intermediary is self employed')),
                ('cumulative_ytd_amount', models.DecimalField(decimal_places=2, help_text='Cumulative year-to-date amount given by the contributor as of the given Form 460 filing (from RCPT_CD.CUM_YTD)', max_digits=14, null=True)),
                ('cumulative_election_amount', models.DecimalField(decimal_places=2, help_text='For filers subject to contribution limits, cumulative amount given by the contributor during the election cycle as of the given Form 460 filing (from RCPT_CD.CUM_OTH)', max_digits=14, null=True)),
                ('amount', models.DecimalField(decimal_places=2, help_text='Amount received from the contributor in the period covered by the filing (from RCPT_CD.AMOUNT)', max_digits=14, verbose_name='amount')),
                ('interest_rate', models.CharField(blank=True, help_text='Interest rate of a loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from RCPT_CD.INT_RATE)', max_length=30, verbose_name='interest rate')),
                ('filing_version', models.ForeignKey(help_text='Foreign key referring to the version of the Form 496 that includes the received contribution', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='part3_items', to='calaccess_processed_filings.Form496FilingVersion')),
            ],
            options={
                'verbose_name': 'Form 496 (Late Independent Expenditure) Part 3 item version',
            },
        ),
        migrations.AlterUniqueTogether(
            name='form496part3itemversion',
            unique_together={('filing_version', 'line_item')},
        ),
        migrations.AlterIndexTogether(
            name='form496part3itemversion',
            index_together={('filing_version', 'line_item')},
        ),
        migrations.AlterUniqueTogether(
            name='form496part3item',
            unique_together={('filing', 'line_item')},
        ),
    ]
