#!/usr/bin/env python

import os
import setuptools

import gdrivefs

_APP_PATH = os.path.dirname(gdrivefs.__file__)

with open(os.path.join(_APP_PATH, 'resources', 'README.rst')) as f:
      long_description = f.read()

with open(os.path.join(_APP_PATH, 'resources', 'requirements.txt')) as f:
      install_requires = [s.strip() for s in f.readlines()]

setuptools.setup(
    name='googleDriveFuse',
    version=gdrivefs.__version__,
    description="Mount your Google Drive.",
    long_description=long_description,
    long_description_content_type='text/x-rst',
    classifiers=[
        'Topic :: System :: Filesystems',
        'Environment :: Console',
        'Intended Audience :: End Users/Desktop',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: BSD License',
        'Natural Language :: English',
        'Operating System :: POSIX',
        'Programming Language :: Python',
        'Topic :: Internet',
        'Topic :: Utilities'
    ],

    url='https://github.com/JoviVon/googleDriveFuse',
    license='GPL 2',
    packages=setuptools.find_packages(exclude=['tests']),
    include_package_data=True,
    package_data={
        'gdrivefs': [
            'resources/README.rst',
            'resources/requirements.txt',
        ],
    },
    zip_safe=False,
    install_requires=install_requires,
    scripts=[
        'gdrivefs/resources/scripts/gdfs',
        'gdrivefs/resources/scripts/gdfstool',
        'gdrivefs/resources/scripts/gdfsdumpentry',
    ],
)
