# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['gilot']

package_data = \
{'': ['*']}

install_requires = \
['DateTime>=4.3,<5.0',
 'GitPython>=3.1.20,<4.0.0',
 'argparse>=1.4.0,<2.0.0',
 'matplotlib>=3.4.3,<4.0.0',
 'networkx>=2.6.2,<3.0.0',
 'numpy>=1.21.2,<2.0.0',
 'pandas>=1.3.2,<2.0.0',
 'pyfpgrowth>=1.0,<2.0',
 'python-Levenshtein>=0.12.2,<0.13.0',
 'python-louvain>=0.15,<0.16',
 'seaborn>=0.11.2,<0.12.0',
 'timeout-decorator>=0.5.0,<0.6.0']

entry_points = \
{'console_scripts': ['gilot = gilot.app:main']}

setup_kwargs = {
    'name': 'gilot',
    'version': '0.2.6',
    'description': 'a git log visual analyzer',
    'long_description': '# gilot\n![image](./sample/react.png)\n![image](./sample/react.hotgraph.png)\n"gilot" is a tool to analyze and visualize git logs.\n\nOne of the most reliable records of a software project\'s activity is the history of the version control system. This information is then used to create graphs to visualize the state of the software development team in a mechanical way.\n\n``gilot plot``  creates four graphs.\n\n- The first graph shows the bias in the amount of code changes for a given time slot as a Gini coefficient and a Lorentz curve. The closer the Gini coefficient is to 1, the more unequal it is, and the closer it is to 0, the more perfect equality it is an indicator of economics. It tends to go down when a project has stable agility, and the more volatile and planaristic the project, the closer it is to 1.\n\n- The second graph shows a histogram of the bias in the amount of code changes in a given time slot.\n\n- The third graph shows the change in the amount of code changes per time slot. It is displayed in green when the total amount of codes is increasing and in red when the total amount of codes is decreasing.\n\n- The fourth graph shows the number of authors who committed per given time slot. The effective team size is estimated.\n \n ``gilot hotgraph`` visualizes the hidden connections between files in a repository and allows you to see the hidden connections in the and refactoring. Assuming that there is a structural connection between the files committed at the same time, the Analyze the network structure. The "shopping cart" and "products" are often used as examples of association analysis, but in this case, we will use The "shopping cart" is "1 commit" and "products" is "modified files".\n\n\n\n\n## Installation\n\njust:\n\n    pip install gilot\n\nor \n\n    pip install git+https://github.com/hirokidaichi/gilot\n\n## Usage\n\n### simple way (1 liner using pipe)\n    gilot log REPO_DIR | gilot plot\n\n### 2-phase way\n\n    gilot log REPO_DIR > repo.csv\n    gilot plot -i repo.csv -o graph.png\n\n## Command \n``gilot`` has 5 commands, ``log`` , ``plot`` , ``info`` , ``hotgraph`` and ``hotspot`` \n+  ``log`` command generates a csv from the repository information\n\n+  ``plot``  command generates a graph image (or matplotlib window) from that csv.\n\n+ ``info``  command, like the plot command, takes a csv file as input and outputs only JSON format statistical information.\n\n+ ``hotspot``  command displays the files that are likely to contain bugs in ranking. We judge that the most recently modified files are likely to contain bugs.( like ``bugspots``)\n\n+ ``hotgraph`` command is able to visualize hidden file connections from a given CSV.\n\n### gilot log (generate csv)\nThe simplest way to use the ``gilot log`` command is to specify the repository directory as follows. This means saving the output as a CSV file.\n\n    gilot log REPO > REPO.csv\n    gilot log REPO -o REPO.csv\n\nThe default period is six months, but you can specify the time.\n\n    gilot log REPO --since 2020-01-20 -o REPO.csv\n    gilot log REPO --month 18 -o REPO.csv\n\nBy specifying a period of time, such as when you want to see the stability of the service after the launch, you can eliminate the impact of commits during the initial release.\n\n    gilot log REPO --branch develop -o REPO.csv\n\nYou can use the branch option to see what the development branch looks like, or to see the results for each branch. By default, ``origin/HEAD`` is specified. This is because we want to see how well we can develop in a trunk-based way.\n\n## --full option \n\nAlso, with the ``--full`` option, detailed information such as the committed file name and the number of lines will be output. It is used for verification including file names such as hotspot command and ignore-files/allow-files.\n\n    gilot log REPO --full | gilot plot --ignore-files "*.lock" "package.json"\n\nIf you want to count so that a specific file is not included, use the --full option and --ignore-files together as follows.\n\n    gilot log REPO --full | gilot hotspot\n\n\nAll options are here\n\n    usage: gilot log [-h] [-b BRANCH] [-o OUTPUT] [--since SINCE] [--until UNTIL] [--month MONTH] [--full] repo\n\n    positional arguments:\n    repo                  REPO must be a root dir of git repository\n\n    optional arguments:\n    -h, --help            show this help message and exit\n    -b BRANCH, --branch BRANCH\n                            target branch name. default \'origin/HEAD\'\n    -o OUTPUT, --output OUTPUT\n    --since SINCE         SINCE must be ISO format like 2020-01-01.\n    --until UNTIL         UNTIL must be ISO format like 2020-06-01.\n    --month MONTH         MONTH is how many months of log data to output. default is 6\n    --full                If this flag is enabled, detailed data including the commuted file name will be output.\n\n\n### gilot plot (generate graph)\n\nThe simplest way to use the ``gilot plot`` command is to take the CSV file output from the gilot log command as input and specify the name of the file you want to save as output, as shown below.\n\n\n    gilot plot -i TARGET.csv -o TARGET_REPORT.png\n    gilot plot --input TARGET.csv -o TARGET_REPORT.png\n\nAlso, since the input from the standard input is also interpreted as a CSV, it can be connected to a pipe as shown below.\n\n\n    cat target.csv | gilot plot \n    gilot repo . | gilot plot\n\nFor example, if one team is working in a *multi-repository* services, you may want to know the activity of multiple repositories as a whole, instead of focusing on one repository. In this case, you can combine multiple inputs into a graph as follows.\n\n\n    gilot log repo-a > repo-a.csv\n    gilot log repo-b > repo-b.csv\n    gilot plot -i repo*.csv\n\nAll options are here:\n\n    usage: gilot plot [-h] [-i [INPUT [INPUT ...]]] [-t TIMESLOT] [-o OUTPUT] [-n NAME] [--allow-files [ALLOW_FILES [ALLOW_FILES ...]]] [--ignore-files [IGNORE_FILES [IGNORE_FILES ...]]]\n\n    optional arguments:\n    -h, --help            show this help message and exit\n    -i [INPUT [INPUT ...]], --input [INPUT [INPUT ...]]\n    -t TIMESLOT, --timeslot TIMESLOT\n                            resample period like 2W or 7D or 1M\n    -o OUTPUT, --output OUTPUT\n                            OUTPUT FILE\n    -n NAME, --name NAME  name\n    --allow-files [ALLOW_FILES [ALLOW_FILES ...]]\n                            Specify the files to allow. You can specify more than one like \'src/*\' \'*.rb\'. Only data with the --full flag is valid.\n    --ignore-files [IGNORE_FILES [IGNORE_FILES ...]]\n                            Specifies files to ignore. You can specify more than one like \'dist/*\' \'*.gen.java\'. Only data with the --full flag is valid.\n\n\n\n### gilot info (dump statistical infomation)\n\n``info``  command, like the plot command, takes a csv file as input and outputs only JSON format statistical information.\n\n\n    # gilot info -i sample/react.csv\n    {\n        "gini": 0.42222013847205725,\n        "output": {\n            "lines": 242999,\n            "added": 70765,\n            "refactor": 0.7087848098140321\n        },\n        "since": "2019-12-03T10:53:08.000000000",\n        "until": "2020-05-30T06:34:43.000000000",\n        "timeslot": "2 Weeks",\n        "insertions": {\n            "mean": 11205.857142857143,\n            "std": 10565.324647217372,\n            "min": 781.0,\n            "25%": 3788.75,\n            "50%": 8544.0,\n            "75%": 16761.25,\n            "max": 39681.0\n        },\n        "deletions": {\n            "mean": 6151.214285714285,\n            "std": 4437.0289466743825,\n            "min": 327.0,\n            "25%": 3397.0,\n            "50%": 5076.0,\n            "75%": 9333.75,\n            "max": 13477.0\n        },\n        "lines": {\n            "mean": 17357.071428571428,\n            "std": 14236.531424279776,\n            "min": 1108.0,\n            "25%": 7383.25,\n            "50%": 12860.0,\n            "75%": 26531.75,\n            "max": 52914.0\n        },\n        "files": {\n            "mean": 377.7857142857143,\n            "std": 271.95196933718574,\n            "min": 70.0,\n            "25%": 155.75,\n            "50%": 402.0,\n            "75%": 450.0,\n            "max": 1062.0\n        },\n        "authors": {\n            "mean": 13.357142857142858,\n            "std": 4.70036238958302,\n            "min": 4.0,\n            "25%": 10.0,\n            "50%": 15.0,\n            "75%": 16.0,\n            "max": 21.0\n        },\n        "addedlines": {\n            "mean": 5054.642857142857,\n            "std": 7742.596112089604,\n            "min": -1210.0,\n            "25%": 266.5,\n            "50%": 2062.5,\n            "75%": 5770.75,\n            "max": 26448.0\n        }\n    }\nIntegration with ``jq`` command makes it easy to get only the information you need.\n\n### When only the Gini coefficient is required\n    # gilot info -i sample/react.csv | jq .gini\n    > 0.42222013847205725\n\n### If you want to find the total number of lines in all commits in a period\n\n    # gilot info -i sample/react.csv | jq .output.lines\n\nAll options are here :\n\n    usage: gilot info [-h] [-i [INPUT [INPUT ...]]] [-t TIMESLOT] [--allow-files [ALLOW_FILES [ALLOW_FILES ...]]] [--ignore-files [IGNORE_FILES [IGNORE_FILES ...]]]\n\n    optional arguments:\n    -h, --help            show this help message and exit\n    -i [INPUT [INPUT ...]], --input [INPUT [INPUT ...]]\n    -t TIMESLOT, --timeslot TIMESLOT\n                            resample period like 2W or 7D or 1M\n    --allow-files [ALLOW_FILES [ALLOW_FILES ...]]\n                            Specify the files to allow. You can specify more than one like \'src/*\' \'*.rb\'. Only data with the --full flag is valid.\n    --ignore-files [IGNORE_FILES [IGNORE_FILES ...]]\n                            Specifies files to ignore. You can specify more than one like \'dist/*\' \'*.gen.java\'. Only data with the --full flag is valid.\n## gilot hotspot \n``hotspot``  command displays the files that are likely to contain bugs in ranking. We judge that the most recently modified files are likely to contain bugs.( like ``bugspots``)\n\n    gilot hotspot -i react-full.csv --ignore-files "*/__tests__/*" "*.lock" -n 10\n\noutput \n\n    ------------------------------------------------------------\n        gilot hotspot ( https://github.com/hirokidaichi/gilot )\n    ------------------------------------------------------------\n\n    hotspot  commits  authors file_name\n        8.81       29        4 packages/react-reconciler/src/ReactFiberWorkLoop.new.js\n        7.14       25        4 packages/react-reconciler/src/ReactFiberWorkLoop.old.js\n        7.01       44        3 packages/react-dom/src/events/DOMModernPluginEventSystem.js\n        5.50       44        8 packages/react-dom/src/client/ReactDOMHostConfig.js\n        4.85       29        8 scripts/rollup/bundles.js\n        4.47       17        5 packages/react-reconciler/src/ReactFiberBeginWork.new.js\n        3.73       17        5 packages/react-reconciler/src/ReactFiberCommitWork.new.js\n        3.32       13        4 packages/react-reconciler/src/ReactFiberHooks.new.js\n        3.28       17        5 packages/react-reconciler/src/ReactFiberCompleteWork.new.js\n        3.18       15        5 packages/react-reconciler/src/ReactFiberCommitWork.old.js\n\nAll options are here :\n\n    usage: gilot hotspot [-h] [-i [INPUT [INPUT ...]]] [--csv] [-o OUTPUT] [--allow-files [ALLOW_FILES [ALLOW_FILES ...]]] [--ignore-files [IGNORE_FILES [IGNORE_FILES ...]]]\n\n    optional arguments:\n    -h, --help            show this help message and exit\n    -i [INPUT [INPUT ...]], --input [INPUT [INPUT ...]]\n    --csv                 dump csv\n    -o OUTPUT, --output OUTPUT\n    --allow-files [ALLOW_FILES [ALLOW_FILES ...]]\n                            Specify the files to allow. You can specify more than one like \'src/*\' \'*.rb\'. Only data with the --full flag is valid.\n    --ignore-files [IGNORE_FILES [IGNORE_FILES ...]]\n                            Specifies files to ignore. You can specify more than one like \'dist/*\' \'*.gen.java\'. Only data with the --full flag is valid.\n\n# gilot hotgraph\n ``gilot hotgraph`` visualizes the hidden connections between files in a repository and allows you to see the hidden connections in the and refactoring. Assuming that there is a structural connection between the files committed at the same time, the Analyze the network structure. The "shopping cart" and "products" are often used as examples of association analysis, but in this case, we will use The "shopping cart" is "1 commit" and "products" is "modified files".\n\n    gilot hotgraph -i this.csv --allow-files "*.ts"\n\n\n![image](./sample/TypeScript.hotgraph.png)\n\n\nAll options are here :\n\n    usage: gilot hotgraph [-h] [-v] [-i [INPUT [INPUT ...]]] [-r RANK] [--stop-retry] [--csv] [-o OUTPUT] [--allow-files [ALLOW_FILES [ALLOW_FILES ...]]]\n                        [--ignore-files [IGNORE_FILES [IGNORE_FILES ...]]]\n\n    optional arguments:\n    -h, --help            show this help message and exit\n    -v, --verbose         increase log level\n    -i [INPUT [INPUT ...]], --input [INPUT [INPUT ...]]\n    -r RANK, --rank RANK\n    --stop-retry\n    --csv                 dump csv\n    -o OUTPUT, --output OUTPUT\n    --allow-files [ALLOW_FILES [ALLOW_FILES ...]]\n                            Specify the files to allow. You can specify more than one like \'src/*\' \'*.rb\'. Only data with the --full flag is valid.\n    --ignore-files [IGNORE_FILES [IGNORE_FILES ...]]\n                            Specifies files to ignore. You can specify more than one like \'dist/*\' \'*.gen.java\'. Only data with the --full flag is valid.\n\n# gilot author\nTODO\n\n![image](./sample/TypeScript.author.png)\n\n## Example Output\n\n### facebook/react\n![image](./sample/react.png)\n![image](./sample/react.hotgraph.png)\n![image](./sample/react.author.png)\n\n### tensorflow/tensorflow\n![image](./sample/tensorflow.png)\n![image](./sample/tensorflow.hotgraph.png)\n![image](./sample/tensorflow.author.png)\n### pytorch/pytorch\n![image](./sample/pytorch.png)\n![image](./sample/pytorch.hotgraph.png)\n![image](./sample/pytorch.author.png)\n### optuna/optuna\n![image](./sample/optuna.png)\n![image](./sample/optuna.hotgraph.png)\n![image](./sample/optuna.author.png)\n\n### microsoft/TypeScript\n![image](./sample/TypeScript.png)\n![image](./sample/TypeScript.hotgraph.png)\n![image](./sample/TypeScript.author.png)\n\n### microsoft/vscode\n![image](./sample/vscode.png)\n![image](./sample/vscode.hotgraph.png)\n![image](./sample/vscode.author.png)\n\n\n\n\n \n',
    'author': 'hirokidaichi',
    'author_email': 'hirokidaichi@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/hirokidaichi/gilot',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.11,<3.11',
}


setup(**setup_kwargs)
