# Copyright 2020 BlueCat Networks (USA) Inc. and its affiliates.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
"""Values for types of objects in BlueCat Address Manager."""
from ._enum import StrEnum


class ObjectType(StrEnum):
    """Values for types of objects in BlueCat Address Manager."""

    ACL = "ACL"  # Access Control List (ACL)
    ALIAS_RECORD = "AliasRecord"
    CONFIGURATION = "Configuration"
    CUSTOM_OPTION_DEF = "CustomOptionDef"
    DENY_MAC_POOL = "DenyMACPool"
    DEPLOYMENT_ROLE = "DNSDeploymentRole"
    DEPLOYMENT_SCHEDULER = "DeploymentScheduler"
    DEVICE = "Device"
    DEVICE_SUBTYPE = "DeviceSubtype"
    DEVICE_TYPE = "DeviceType"
    DHCP_DEPLOYMENT_ROLE = "DHCPDeploymentRole"
    DHCP_MATCH_CLASS = "DHCPMatchClass"
    DHCP_RAW_OPTION = "DHCP_RAW"
    DHCP_SERVICE_OPTION = "DHCPServiceOption"
    DHCP_SUBCLASS = "DHCPSubClass"
    DHCP_VENDOR_CLIENT = "DHCPVendorClient"
    DHCP4_CLIENT_OPTION = "DHCPV4ClientOption"
    DHCP4_RANGE = "DHCP4Range"
    DHCP6_CLIENT_OPTION = "DHCPV6ClientOption"
    DHCP6_RANGE = "DHCP6Range"
    DHCP6_RAW_OPTION = "DHCPV6_RAW"  # DHCPV6 Raw Option
    DHCP6_SERVICE_OPTION = "DHCPV6ServiceOption"
    DNS = "DNS"
    DNS_OPTION = "DNSOption"
    DNS_RAW_OPTION = "DNS_RAW"  # DNS Raw Option
    DNSSEC_SIGNING_POLICY = "DNSSECSigningPolicy"
    ENTITY = "Entity"  # Generic type
    ENUM_NUMBER = "EnumNumber"
    ENUM_ZONE = "EnumZone"
    EXTERNAL_HOST_RECORD = "ExternalHostRecord"
    GENERIC_RECORD = "GenericRecord"
    HINFO_RECORD = "HINFORecord"
    HOST_RECORD = "HostRecord"
    INTERFACE_ID = "InterfaceID"
    INTERNAL_ROOT_ZONE = "InternalRootZone"
    IP4_ADDRESS = "IP4Address"
    IP4_BLOCK = "IP4Block"
    IP4_IP_GROUP = "IP4IPGroup"
    IP4_NETWORK = "IP4Network"
    IP4_NETWORK_TEMPLATE = "IP4NetworkTemplate"
    IP4_RECONCILIATION_POLICY = "IP4ReconciliationPolicy"
    IP6_ADDRESS = "IP6Address"
    IP6_BLOCK = "IP6Block"
    IP6_NETWORK = "IP6Network"
    KERBEROS = "Kerberos"
    KERBEROS_REALM = "KerberosRealm"
    LDAP = "LDAP"
    LOCATION = "Location"
    MAC_ADDRESS = "MACAddress"
    MAC_POOL = "MACPool"
    MX_RECORD = "MXRecord"
    NAPTR_RECORD = "NAPTRRecord"
    NETWORK_INTERFACE = "NetworkInterface"
    NETWORK_SERVER_INTERFACE = "NetworkServerInterface"
    PUBLISHED_SERVER_INTERFACE = "PublishedServerInterface"
    RADIUS = "Radius"
    RECORD_WITH_LINK = "RecordWithLink"
    RESPONSE_POLICY = "ResponsePolicy"
    RP_ZONE = "RPZone"
    SERVER = "Server"
    SRV_RECORD = "SRVRecord"
    START_OF_AUTHORITY = "StartOfAuthority"
    TAG = "Tag"
    TAG_GROUP = "TagGroup"
    TFTP_DEPLOYMENT_ROLE = "TFTPDeploymentRole"
    TFTP_FILE = "TFTPFile"
    TFTP_FOLDER = "TFTPFolder"
    TFTP_GROUP = "TFTPGroup"
    TSIG_KEY = "TSIGKey"
    TXT_RECORD = "TXTRecord"
    USER = "User"
    USER_GROUP = "UserGroup"
    VENDOR_CLIENT_OPTION = "VendorClientOption"
    VENDOR_PROFILE = "VendorProfile"
    VENDOR_PROFILE_DEF = "VendorOptionDef"
    VIEW = "View"
    VIRTUAL_INTERFACE = "VirtualInterface"
    ZONE = "Zone"
    ZONE_TEMPLATE = "ZoneTemplate"
