import logging
LOG=logging.getLogger(__name__)
def configure_systemd(revert:bool):
 from subprocess import CalledProcessError
 from localstack import config
 from localstack.utils.container_utils.container_client import ContainerException
 from localstack.utils.docker_utils import DOCKER_CLIENT
 from localstack.utils.run import is_linux,run,to_str
 if not is_linux():
  LOG.warning("Command only supported on GNU/Linux")
 try:
  container_ip=DOCKER_CLIENT.get_container_ip(config.MAIN_CONTAINER_NAME)
  container_network=DOCKER_CLIENT.get_networks(config.MAIN_CONTAINER_NAME)
  container_network=container_network[0]
  network_inspect=DOCKER_CLIENT.inspect_network(container_network)
  network_interface=network_inspect["Options"].get("com.docker.network.bridge.name")
  network_interface=network_interface or f"br-{network_inspect['Id'][:12]}"
  if revert:
   cmd=["sudo","resolvectl","revert",network_interface]
   run(cmd,shell=False,print_error=False)
   LOG.info("Reverting DNS config completed!")
  else:
   cmd=["sudo","resolvectl","dns",network_interface,container_ip]
   run(cmd,shell=False,print_error=False)
   cmd=["sudo","resolvectl","domain",network_interface,"~amazonaws.com","~aws.amazon.com","~cloudfront.net","~localhost.localstack.cloud"]
   run(cmd,shell=False,print_error=False)
   LOG.info("Setting DNS config completed!")
 except ContainerException:
  if config.DEBUG:
   LOG.exception("Error while getting container information")
  LOG.warning("LocalStack container might not be running. Is container %s running?",config.MAIN_CONTAINER_NAME)
  LOG.warning("Is $MAIN_CONTAINER_NAME set correctly?")
 except CalledProcessError as e:
  LOG.warning("Error while configuring systemd-resolved: %s",to_str(e.output).strip())
# Created by pyminifier (https://github.com/liftoff/pyminifier)
