import logging
import os
import shutil
import zipfile
from typing import Dict
from localstack.utils.common import new_tmp_dir,rm_rf
from localstack_ext.bootstrap.cpvcs.constants import COMPRESSION_FORMAT
from localstack_ext.bootstrap.cpvcs.obj_storage import default_storage as object_storage
from localstack_ext.bootstrap.cpvcs.utils.common import CPVCSConfigContext,config_context
LOG=logging.getLogger(__name__)
def extract_meta_and_state_archives(meta_archives:Dict[str,str],state_archives:Dict[str,str]):
 for product_space_archive in[meta_archives,state_archives]:
  for version_no,archive in product_space_archive.items():
   with zipfile.ZipFile(archive)as meta_zip:
    if product_space_archive==meta_archives:
     archive_dest=config_context.get_version_meta_archive_path(version=version_no,with_format=False)
    else:
     archive_dest=config_context.get_version_state_archive_path(version=version_no,with_format=False)
    meta_zip.extractall(archive_dest)
    shutil.make_archive(base_name=archive_dest,format=COMPRESSION_FORMAT,root_dir=archive_dest)
    rm_rf(archive_dest)
    rm_rf(archive)
    LOG.debug(f"Successfully extracted archive {product_space_archive} for version {version_no}")
def register_remote(remote_info:Dict[str,str]):
 if config_context.is_remotly_managed():
  LOG.warning("Pod is already remotely managed")
  return
 with open(config_context.get_remote_info_path(),"w")as fp:
  storage_uuid=remote_info.get("storage_uuid")
  qualifying_name=remote_info.get("qualifying_name")
  fp.write(f"storage_uuid={storage_uuid}\n")
  fp.write(f"qualifying_name={qualifying_name}\n")
def merge_version_space(version_space_archive):
 remote_version_space_dir=new_tmp_dir()
 remote_config_context=CPVCSConfigContext(pod_root_dir=remote_version_space_dir)
 with zipfile.ZipFile(version_space_archive)as version_space_zip:
  version_space_zip.extractall(remote_config_context.get_pod_root_dir())
 shutil.copy(remote_config_context.get_known_ver_path(),config_context.get_known_ver_path())
 shutil.copy(remote_config_context.get_max_ver_path(),config_context.get_max_ver_path())
 remote_rev_obj_store_path=remote_config_context.get_rev_obj_store_path()
 local_rev_obj_store_path=config_context.get_rev_obj_store_path()
 for revision_file in os.listdir(remote_rev_obj_store_path):
  remote_revision_file_path=os.path.join(remote_rev_obj_store_path,revision_file)
  local_revision_file_path=os.path.join(local_rev_obj_store_path,revision_file)
  shutil.copy(remote_revision_file_path,local_revision_file_path)
 for version_ref_file in os.listdir(remote_config_context.get_ver_refs_path()):
  remote_version_ref_file_path=remote_config_context.get_version_ref_file_path(version_ref_file)
  local_version_ref_file_path=config_context.get_version_ref_file_path(version_ref_file)
  with open(remote_version_ref_file_path,"r")as fp:
   key=fp.readline().strip()
  if os.path.isfile(local_version_ref_file_path):
   object_storage.merge_remote_into_local_version(remote_config_context.get_ver_obj_store_path(),key)
  else:
   remote_version_file_path=os.path.join(remote_config_context.get_ver_obj_store_path(),key)
   local_version_file_path=os.path.join(config_context.get_ver_obj_store_path(),key)
   shutil.copy(remote_version_ref_file_path,local_version_ref_file_path)
   shutil.copy(remote_version_file_path,local_version_file_path)
 rm_rf(remote_version_space_dir)
 rm_rf(version_space_archive)
# Created by pyminifier (https://github.com/liftoff/pyminifier)
