# coding: utf-8

"""
    Component Database API

    The API that provides access to Component Database data.  # noqa: E501

    The version of the OpenAPI document: 3.8.0
    Contact: djarosz@anl.gov
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from cdbApi.configuration import Configuration


class ItemElement(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'name': 'str',
        'is_required': 'bool',
        'description': 'str',
        'sort_order': 'float',
        'list_list': 'list[ListTbl]',
        'property_value_list': 'list[PropertyValue]',
        'log_list': 'list[Log]',
        'derived_from_item_element_list': 'list[ItemElement]',
        'derived_from_item_element': 'ItemElement',
        'item_element_history_list': 'list[ItemElementHistory]',
        'row_style': 'str',
        'parent_item_id': 'int',
        'contained_item1_id': 'int',
        'contained_item2_id': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'is_required': 'isRequired',
        'description': 'description',
        'sort_order': 'sortOrder',
        'list_list': 'listList',
        'property_value_list': 'propertyValueList',
        'log_list': 'logList',
        'derived_from_item_element_list': 'derivedFromItemElementList',
        'derived_from_item_element': 'derivedFromItemElement',
        'item_element_history_list': 'itemElementHistoryList',
        'row_style': 'rowStyle',
        'parent_item_id': 'parentItemId',
        'contained_item1_id': 'containedItem1Id',
        'contained_item2_id': 'containedItem2Id'
    }

    def __init__(self, id=None, name=None, is_required=None, description=None, sort_order=None, list_list=None, property_value_list=None, log_list=None, derived_from_item_element_list=None, derived_from_item_element=None, item_element_history_list=None, row_style=None, parent_item_id=None, contained_item1_id=None, contained_item2_id=None, local_vars_configuration=None):  # noqa: E501
        """ItemElement - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._is_required = None
        self._description = None
        self._sort_order = None
        self._list_list = None
        self._property_value_list = None
        self._log_list = None
        self._derived_from_item_element_list = None
        self._derived_from_item_element = None
        self._item_element_history_list = None
        self._row_style = None
        self._parent_item_id = None
        self._contained_item1_id = None
        self._contained_item2_id = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if is_required is not None:
            self.is_required = is_required
        if description is not None:
            self.description = description
        if sort_order is not None:
            self.sort_order = sort_order
        if list_list is not None:
            self.list_list = list_list
        if property_value_list is not None:
            self.property_value_list = property_value_list
        if log_list is not None:
            self.log_list = log_list
        if derived_from_item_element_list is not None:
            self.derived_from_item_element_list = derived_from_item_element_list
        if derived_from_item_element is not None:
            self.derived_from_item_element = derived_from_item_element
        if item_element_history_list is not None:
            self.item_element_history_list = item_element_history_list
        if row_style is not None:
            self.row_style = row_style
        if parent_item_id is not None:
            self.parent_item_id = parent_item_id
        if contained_item1_id is not None:
            self.contained_item1_id = contained_item1_id
        if contained_item2_id is not None:
            self.contained_item2_id = contained_item2_id

    @property
    def id(self):
        """Gets the id of this ItemElement.  # noqa: E501


        :return: The id of this ItemElement.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ItemElement.


        :param id: The id of this ItemElement.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this ItemElement.  # noqa: E501


        :return: The name of this ItemElement.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ItemElement.


        :param name: The name of this ItemElement.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 64):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 0):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `0`")  # noqa: E501

        self._name = name

    @property
    def is_required(self):
        """Gets the is_required of this ItemElement.  # noqa: E501


        :return: The is_required of this ItemElement.  # noqa: E501
        :rtype: bool
        """
        return self._is_required

    @is_required.setter
    def is_required(self, is_required):
        """Sets the is_required of this ItemElement.


        :param is_required: The is_required of this ItemElement.  # noqa: E501
        :type: bool
        """

        self._is_required = is_required

    @property
    def description(self):
        """Gets the description of this ItemElement.  # noqa: E501


        :return: The description of this ItemElement.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ItemElement.


        :param description: The description of this ItemElement.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 256):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) < 0):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `0`")  # noqa: E501

        self._description = description

    @property
    def sort_order(self):
        """Gets the sort_order of this ItemElement.  # noqa: E501


        :return: The sort_order of this ItemElement.  # noqa: E501
        :rtype: float
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order):
        """Sets the sort_order of this ItemElement.


        :param sort_order: The sort_order of this ItemElement.  # noqa: E501
        :type: float
        """

        self._sort_order = sort_order

    @property
    def list_list(self):
        """Gets the list_list of this ItemElement.  # noqa: E501


        :return: The list_list of this ItemElement.  # noqa: E501
        :rtype: list[ListTbl]
        """
        return self._list_list

    @list_list.setter
    def list_list(self, list_list):
        """Sets the list_list of this ItemElement.


        :param list_list: The list_list of this ItemElement.  # noqa: E501
        :type: list[ListTbl]
        """

        self._list_list = list_list

    @property
    def property_value_list(self):
        """Gets the property_value_list of this ItemElement.  # noqa: E501


        :return: The property_value_list of this ItemElement.  # noqa: E501
        :rtype: list[PropertyValue]
        """
        return self._property_value_list

    @property_value_list.setter
    def property_value_list(self, property_value_list):
        """Sets the property_value_list of this ItemElement.


        :param property_value_list: The property_value_list of this ItemElement.  # noqa: E501
        :type: list[PropertyValue]
        """

        self._property_value_list = property_value_list

    @property
    def log_list(self):
        """Gets the log_list of this ItemElement.  # noqa: E501


        :return: The log_list of this ItemElement.  # noqa: E501
        :rtype: list[Log]
        """
        return self._log_list

    @log_list.setter
    def log_list(self, log_list):
        """Sets the log_list of this ItemElement.


        :param log_list: The log_list of this ItemElement.  # noqa: E501
        :type: list[Log]
        """

        self._log_list = log_list

    @property
    def derived_from_item_element_list(self):
        """Gets the derived_from_item_element_list of this ItemElement.  # noqa: E501


        :return: The derived_from_item_element_list of this ItemElement.  # noqa: E501
        :rtype: list[ItemElement]
        """
        return self._derived_from_item_element_list

    @derived_from_item_element_list.setter
    def derived_from_item_element_list(self, derived_from_item_element_list):
        """Sets the derived_from_item_element_list of this ItemElement.


        :param derived_from_item_element_list: The derived_from_item_element_list of this ItemElement.  # noqa: E501
        :type: list[ItemElement]
        """

        self._derived_from_item_element_list = derived_from_item_element_list

    @property
    def derived_from_item_element(self):
        """Gets the derived_from_item_element of this ItemElement.  # noqa: E501


        :return: The derived_from_item_element of this ItemElement.  # noqa: E501
        :rtype: ItemElement
        """
        return self._derived_from_item_element

    @derived_from_item_element.setter
    def derived_from_item_element(self, derived_from_item_element):
        """Sets the derived_from_item_element of this ItemElement.


        :param derived_from_item_element: The derived_from_item_element of this ItemElement.  # noqa: E501
        :type: ItemElement
        """

        self._derived_from_item_element = derived_from_item_element

    @property
    def item_element_history_list(self):
        """Gets the item_element_history_list of this ItemElement.  # noqa: E501


        :return: The item_element_history_list of this ItemElement.  # noqa: E501
        :rtype: list[ItemElementHistory]
        """
        return self._item_element_history_list

    @item_element_history_list.setter
    def item_element_history_list(self, item_element_history_list):
        """Sets the item_element_history_list of this ItemElement.


        :param item_element_history_list: The item_element_history_list of this ItemElement.  # noqa: E501
        :type: list[ItemElementHistory]
        """

        self._item_element_history_list = item_element_history_list

    @property
    def row_style(self):
        """Gets the row_style of this ItemElement.  # noqa: E501


        :return: The row_style of this ItemElement.  # noqa: E501
        :rtype: str
        """
        return self._row_style

    @row_style.setter
    def row_style(self, row_style):
        """Sets the row_style of this ItemElement.


        :param row_style: The row_style of this ItemElement.  # noqa: E501
        :type: str
        """

        self._row_style = row_style

    @property
    def parent_item_id(self):
        """Gets the parent_item_id of this ItemElement.  # noqa: E501


        :return: The parent_item_id of this ItemElement.  # noqa: E501
        :rtype: int
        """
        return self._parent_item_id

    @parent_item_id.setter
    def parent_item_id(self, parent_item_id):
        """Sets the parent_item_id of this ItemElement.


        :param parent_item_id: The parent_item_id of this ItemElement.  # noqa: E501
        :type: int
        """

        self._parent_item_id = parent_item_id

    @property
    def contained_item1_id(self):
        """Gets the contained_item1_id of this ItemElement.  # noqa: E501


        :return: The contained_item1_id of this ItemElement.  # noqa: E501
        :rtype: int
        """
        return self._contained_item1_id

    @contained_item1_id.setter
    def contained_item1_id(self, contained_item1_id):
        """Sets the contained_item1_id of this ItemElement.


        :param contained_item1_id: The contained_item1_id of this ItemElement.  # noqa: E501
        :type: int
        """

        self._contained_item1_id = contained_item1_id

    @property
    def contained_item2_id(self):
        """Gets the contained_item2_id of this ItemElement.  # noqa: E501


        :return: The contained_item2_id of this ItemElement.  # noqa: E501
        :rtype: int
        """
        return self._contained_item2_id

    @contained_item2_id.setter
    def contained_item2_id(self, contained_item2_id):
        """Sets the contained_item2_id of this ItemElement.


        :param contained_item2_id: The contained_item2_id of this ItemElement.  # noqa: E501
        :type: int
        """

        self._contained_item2_id = contained_item2_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ItemElement):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ItemElement):
            return True

        return self.to_dict() != other.to_dict()
