# coding: utf-8

"""
    Component Database API

    The API that provides access to Component Database data.  # noqa: E501

    The version of the OpenAPI document: 3.8.0
    Contact: djarosz@anl.gov
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from cdbApi.configuration import Configuration


class Connector(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'name': 'str',
        'description': 'str',
        'property_value_list': 'list[PropertyValue]',
        'item_connector_list': 'list[ItemConnector]',
        'connector_type': 'ConnectorType',
        'resource_type': 'ResourceType',
        'is_male': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'property_value_list': 'propertyValueList',
        'item_connector_list': 'itemConnectorList',
        'connector_type': 'connectorType',
        'resource_type': 'resourceType',
        'is_male': 'isMale'
    }

    def __init__(self, id=None, name=None, description=None, property_value_list=None, item_connector_list=None, connector_type=None, resource_type=None, is_male=None, local_vars_configuration=None):  # noqa: E501
        """Connector - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._description = None
        self._property_value_list = None
        self._item_connector_list = None
        self._connector_type = None
        self._resource_type = None
        self._is_male = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if property_value_list is not None:
            self.property_value_list = property_value_list
        if item_connector_list is not None:
            self.item_connector_list = item_connector_list
        if connector_type is not None:
            self.connector_type = connector_type
        if resource_type is not None:
            self.resource_type = resource_type
        self.is_male = is_male

    @property
    def id(self):
        """Gets the id of this Connector.  # noqa: E501


        :return: The id of this Connector.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Connector.


        :param id: The id of this Connector.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this Connector.  # noqa: E501


        :return: The name of this Connector.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Connector.


        :param name: The name of this Connector.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 64):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 0):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `0`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this Connector.  # noqa: E501


        :return: The description of this Connector.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Connector.


        :param description: The description of this Connector.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 256):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) < 0):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `0`")  # noqa: E501

        self._description = description

    @property
    def property_value_list(self):
        """Gets the property_value_list of this Connector.  # noqa: E501


        :return: The property_value_list of this Connector.  # noqa: E501
        :rtype: list[PropertyValue]
        """
        return self._property_value_list

    @property_value_list.setter
    def property_value_list(self, property_value_list):
        """Sets the property_value_list of this Connector.


        :param property_value_list: The property_value_list of this Connector.  # noqa: E501
        :type: list[PropertyValue]
        """

        self._property_value_list = property_value_list

    @property
    def item_connector_list(self):
        """Gets the item_connector_list of this Connector.  # noqa: E501


        :return: The item_connector_list of this Connector.  # noqa: E501
        :rtype: list[ItemConnector]
        """
        return self._item_connector_list

    @item_connector_list.setter
    def item_connector_list(self, item_connector_list):
        """Sets the item_connector_list of this Connector.


        :param item_connector_list: The item_connector_list of this Connector.  # noqa: E501
        :type: list[ItemConnector]
        """

        self._item_connector_list = item_connector_list

    @property
    def connector_type(self):
        """Gets the connector_type of this Connector.  # noqa: E501


        :return: The connector_type of this Connector.  # noqa: E501
        :rtype: ConnectorType
        """
        return self._connector_type

    @connector_type.setter
    def connector_type(self, connector_type):
        """Sets the connector_type of this Connector.


        :param connector_type: The connector_type of this Connector.  # noqa: E501
        :type: ConnectorType
        """

        self._connector_type = connector_type

    @property
    def resource_type(self):
        """Gets the resource_type of this Connector.  # noqa: E501


        :return: The resource_type of this Connector.  # noqa: E501
        :rtype: ResourceType
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this Connector.


        :param resource_type: The resource_type of this Connector.  # noqa: E501
        :type: ResourceType
        """

        self._resource_type = resource_type

    @property
    def is_male(self):
        """Gets the is_male of this Connector.  # noqa: E501


        :return: The is_male of this Connector.  # noqa: E501
        :rtype: bool
        """
        return self._is_male

    @is_male.setter
    def is_male(self, is_male):
        """Sets the is_male of this Connector.


        :param is_male: The is_male of this Connector.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_male is None:  # noqa: E501
            raise ValueError("Invalid value for `is_male`, must not be `None`")  # noqa: E501

        self._is_male = is_male

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Connector):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Connector):
            return True

        return self.to_dict() != other.to_dict()
