import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * (experimental) Properties for updating Amazon SageMaker endpoint.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 * @experimental
 */
export interface SageMakerUpdateEndpointProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The name of the new endpoint configuration.
     *
     * @experimental
     */
    readonly endpointConfigName: string;
    /**
     * (experimental) The name of the endpoint whose configuration you want to update.
     *
     * @experimental
     */
    readonly endpointName: string;
}
/**
 * (experimental) A Step Functions Task to update a SageMaker endpoint.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 * @experimental
 */
export declare class SageMakerUpdateEndpoint extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SageMakerUpdateEndpointProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
    private renderParameters;
    private makePolicyStatements;
}
