"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallApiGatewayHttpApiEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const base_1 = require("./base");
/**
 * Call HTTP API endpoint as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 * @stability stable
 */
class CallApiGatewayHttpApiEndpoint extends base_1.CallApiGatewayEndpointBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.apiEndpoint = this.getApiEndpoint();
        this.arnForExecuteApi = this.getArnForExecuteApi();
        this.taskPolicies = this.createPolicyStatements();
    }
    getApiEndpoint() {
        const apiStack = cdk.Stack.of(this.props.api);
        return `${this.props.api.apiId}.execute-api.${apiStack.region}.${apiStack.urlSuffix}`;
    }
    getArnForExecuteApi() {
        const { api, stageName, method, apiPath } = this.props;
        return cdk.Stack.of(api).formatArn({
            service: 'execute-api',
            resource: api.apiId,
            sep: '/',
            resourceName: `${stageName}/${method}${apiPath}`,
        });
    }
}
exports.CallApiGatewayHttpApiEndpoint = CallApiGatewayHttpApiEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CallApiGatewayHttpApiEndpoint[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.CallApiGatewayHttpApiEndpoint", version: "1.95.0" };
//# sourceMappingURL=data:application/json;base64,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