# HyperContagion

HyperContagion is a Python package for the simulation and visualization of contagion processes on complex systems with group (higher-order) interactions.

* [**Source**](../../)
* [**Bug reports**](../../issues)
* [**GitHub Discussions**](../../discussions)

## Table of Contents:
  - [Installation](#installation)
  - [Getting Started](#getting-started)
  - [Documentation](#documentation)
  - [Contributing](#contributing)
  - [How to Cite](#how-to-cite)
  - [Code of Conduct](#code-of-conduct)
  - [License](#license)
  - [Funding](#funding)
  - [Other Resources](#other-resources)

## Installation
HyperContagion runs on Python 3.7 or higher.

To install the latest version of HyperContagion, run the following command:
```sh
pip install hypercontagion
```

To install this package locally:
* Clone this repository
* Navigate to the folder on your local machine
* Run the following command:
```sh
pip install -e .["all"]
```
* If that command does not work, you may try the following instead
````zsh
pip install -e .\[all\]
````

## Getting Started

To get started, take a look at the [demos](/demos/) illustrating the library's basic functionality.

## Documentation

## Contributing
Contributions are always welcome. Please report any bugs that you find [here](../../issues). Or, even better, fork the repository on [GitHub](../../) and create a pull request (PR). We welcome all changes, big or small, and we will help you make the PR if you are new to `git` (just ask on the issue and/or see our [contributing guidelines](CONTRIBUTING.md)).

## How to Cite

We acknowledge the importance of good software to support research, and we note
that research becomes more valuable when it is communicated effectively. To
demonstrate the value of HyperContagion, we ask that you cite HyperContagion in your work.
Currently, the best way to cite HyperContagion is to go to our
[repository page](../../) (if you haven't already) and
click the "cite this repository" button on the right sidebar. This will generate
a citation in your preferred format, and will also integrate well with citation managers.

## Code of Conduct

## License
Released under the 3-Clause BSD license (see [`LICENSE.md`](LICENSE.md))

Copyright (C) 2021 HyperContagion Developers

Nicholas Landry <nicholas.landry@colorado.edu>

The HyperContagion library has copied or modified code from the EoN and Epipack libraries, the licenses of which can be found in our [license file](LICENSE.md)

## Funding
The HyperContagion package has been supported by NSF Grant 2121905, ["HNDS-I: Using Hypergraphs to Study Spreading Processes in Complex Social Networks"](https://www.nsf.gov/awardsearch/showAward?AWD_ID=2121905).