# Code of Conduct

   > TL;DR Be excellent to each other; we're a community after all. If you run into issues with others in our community, please contact a HyperContagion Community Dev or Moderator.

## Purpose

The HyperContagion Community includes members of varying skills, languages, personalities, cultural backgrounds, and experiences from around the globe. Through these differences, we continue to grow and collectively improve upon an open-source animation engine. When working in a community, it is important to remember that you are interacting with humans on the other end of your screen. This code of conduct will guide your interactions and keep HyperContagion a positive environment for our developers, users, and fundamentally our growing community.



## Our Community

Members of the HyperContagion Community are respectful, open, and considerate. Behaviors that reinforce these values contribute to our positive environment, and include:

- **Being respectful.** Respectful of others, their positions, experiences, viewpoints, skills, commitments, time, and efforts.

- **Being open.** Open to collaboration, whether it's on problems, Pull Requests, issues, or otherwise.

- **Being considerate.** Considerate of their peers -- other HyperContagion users and developers.

- **Focusing on what is best for the community.** We're respectful of the processes set forth in the community, and we work within them.

- **Showing empathy towards other community members.** We're attentive in our communications, whether in person or online, and we're tactful when approaching differing views.

- **Gracefully accepting constructive criticism.** When we disagree, we are courteous in raising our issues.

- **Using welcoming and inclusive language.** We're accepting of all who wish to take part in our activities, fostering an environment where anyone can participate and everyone can make a difference.



## Our Standards

Every member of our community has the right to have their identity respected. The HyperContagion Community is dedicated to providing a positive environment for everyone, regardless of age, gender identity and expression, sexual orientation, disability, physical appearance, body size, ethnicity, nationality, race, religion (or lack thereof), education, or socioeconomic status.



## Inappropriate Behavior

Examples of unacceptable behavior by participants include:

   * Harassment of any participants in any form
   * Deliberate intimidation, stalking, or following
   * Logging or taking screenshots of online activity for harassment purposes
   * Publishing others' private information, such as a physical or electronic address, without explicit permission
   * Violent threats or language directed against another person
   * Incitement of violence or harassment towards any individual, including encouraging a person to commit suicide or to engage in self-harm
   * Creating additional online accounts in order to harass another person or circumvent a ban
   * Sexual language and imagery in online communities or any conference venue, including talks
   * Insults, put-downs, or jokes that are based upon stereotypes, that are exclusionary, or that hold others up for ridicule
   * Excessive swearing
   * Unwelcome sexual attention or advances
   * Unwelcome physical contact, including simulated physical contact (eg, textual descriptions like "hug" or "backrub") without consent or after a request to stop
   * Pattern of inappropriate social contact, such as requesting/assuming inappropriate levels of intimacy with others
   * Sustained disruption of online community discussions, in-person presentations, or other in-person events
   * Continued one-on-one communication after requests to cease
   * Other conduct that is inappropriate for a professional audience including people of many different backgrounds
Community members asked to stop any inappropriate behavior are expected to comply immediately.


## HyperContagion Community Online Spaces

This Code of Conduct applies to the following online spaces:

- The [HyperContagion GitHub Project](https://github.com/nwlandry/hypercontagion)

This Code of Conduct applies to every member in official HyperContagion Community online spaces, including:

- Moderators

- Maintainers

- Developers

- Reviewers

- Contributors

- Users

- All community members



## Consequences

If a member's behavior violates this code of conduct, the HyperContagion Community Code of Conduct team may take any action they deem appropriate, including, but not limited to: warning the offender, temporary bans, deletion of offending messages, and expulsion from the community and its online spaces. The full list of consequences for inappropriate behavior is listed below in the Enforcement Procedures.

Thank you for helping make this a welcoming, friendly community for everyone.


## Contact Information

If you believe someone is violating the code of conduct, or have any other concerns, please contact a HyperContagion Community Dev or Moderator immediately. They can be reached via email (See the README).

<hr style="border:2px solid gray"> </hr>

## Enforcement Procedures

This document summarizes the procedures the HyperContagion Community Code of Conduct team uses to enforce the Code of Conduct.

### Summary of processes

When the team receives a report of a possible Code of Conduct violation, it will:

   1. Acknowledge the receipt of the report.
   1. Evaluate conflicts of interest.
   1. Call a meeting of code of conduct team members without a conflict of interest.
   1. Evaluate the reported incident.
   1. Propose a behavioral modification plan.
   1. Propose consequences for the reported behavior.
   1. Vote on behavioral modification plan and consequences for the reported person.
   1. Contact HyperContagion Community moderators to approve the behavioral modification plan and consequences.
   1. Follow up with the reported person.
   1. Decide further responses.
   1. Follow up with the reporter.


### Acknowledge the report

Reporters should receive an acknowledgment of the receipt of their report within 48 hours.


### Conflict of interest policy

Examples of conflicts of interest include:

   * You have a romantic or platonic relationship with either the reporter or the reported person. It's fine to participate if they are an acquaintance.
   * The reporter or reported person is someone you work closely with. This could be someone on your team or someone who works on the same project as you.
   * The reporter or reported person is a maintainer who regularly reviews your contributions
   * The reporter or reported person is your metamour.
   * The reporter or reported person is your family member
Committee members do not need to state why they have a conflict of interest, only that one exists. Other team members should not ask why the person has a conflict of interest.

Anyone who has a conflict of interest will remove themselves from the discussion of the incident, and recluse themselves from voting on a response to the report.



### Evaluating a report

#### Jurisdiction

   * *Is this a Code of Conduct violation?* Is this behavior on our list of inappropriate behavior? Is it borderline inappropriate behavior? Does it violate our community norms?
   * *Did this occur in a space that is within our Code of Conduct's scope?* If the incident occurred outside the community, but a community member's mental health or physical safety may be negatively impacted if no action is taken, the incident may be in scope. Private conversations in community spaces are also in scope.
#### Impact

   * *Did this incident occur in a private conversation or a public space?* Incidents that all community members can see will have a more negative impact.
   * *Does this behavior negatively impact a marginalized group in our community?* Is the reporter a person from a marginalized group in our community? How is the reporter being negatively impacted by the reported person's behavior? Are members of the marginalized group likely to disengage with the community if no action was taken on this report?
   * *Does this incident involve a community leader?* Community members often look up to community leaders to set the standard of acceptable behavior
#### Risk

   * *Does this incident include sexual harassment?*
   * *Does this pose a safety risk?* Does the behavior put a person's physical safety at risk? Will this incident severely negatively impact someone's mental health?
   * *Is there a risk of this behavior being repeated?* Does the reported person understand why their behavior was inappropriate? Is there an established pattern of behavior from past reports?


Reports which involve higher risk or higher impact may face more severe consequences than reports which involve lower risk or lower impact.



### Propose consequences

What follows are examples of possible consequences to an incident report. This consequences list is not inclusive, and the HyperContagion Community Code of Conduct team reserves the right to take any action it deems necessary.

Possible private responses to an incident include:

   * Nothing, if the behavior was determined to not be a Code of Conduct violation
   * A warning
   * A final warning
   * Temporarily removing the reported person from the community's online space(s)
   * Permanently removing the reported person from the community's online space(s)
   * Publishing an account of the incident


### Team vote

Some team members may have a conflict of interest and may be excluded from discussions of a particular incident report. Excluding those members, decisions on the behavioral modification plans and consequences will be determined by a two-thirds majority vote of the HyperContagion Community Code of Conduct team.



### Moderators approval

Once the team has approved the behavioral modification plans and consequences, they will communicate the recommended response to the HyperContagion Community moderators. The team should not state who reported this incident. They should attempt to anonymize any identifying information from the report.

Moderators are required to respond with whether they accept the recommended response to the report. If they disagree with the recommended response, they should provide a detailed response or additional context as to why they disagree. Moderators are encouraged to respond within a week.

In cases where the moderators disagree on the suggested resolution for a report, the HyperContagion Community Code of Conduct team may choose to notify the HyperContagion Community Moderators.



### Follow up with the reported person

The HyperContagion Community Code of Conduct team will work with the HyperContagion Community moderators to draft a response to the reported person. The response should contain:

   * A description of the person's behavior in neutral language
   * The negative impact of that behavior
   * A concrete behavioral modification plan
   * Any consequences of their behavior
The team should not state who reported this incident. They should attempt to anonymize any identifying information from the report. The reported person should be discouraged from contacting the reporter to discuss the report. If they wish to apologize to the reporter, the team can accept the apology on behalf of the reporter.



### Decide further responses

If the reported person provides additional context, the HyperContagion Community Code of Conduct team may need to re-evaluate the behavioral modification plan and consequences.

### Follow up with the reporter

A person who makes a report should receive a follow-up response stating what action was taken in response to the report. If the team decided no response was needed, they should provide an explanation why it was not a Code of Conduct violation. Reports that are not made in good faith (such as "reverse sexism" or "reverse racism") may receive no response.

The follow-up should be sent no later than one week after the receipt of the report. If deliberation or follow-up with the reported person takes longer than one week, the team should send a status update to the reporter.



### Changes to Code of Conduct

When discussing a change to the HyperContagion Community code of conduct or enforcement procedures, the HyperContagion Community Code of Conduct team will follow this decision-making process:

   * **Brainstorm options.** Team members should discuss any relevant context and brainstorm a set of possible options. It is important to provide constructive feedback without getting side-tracked from the main question.
   * **Vote.** Proposed changes to the code of conduct will be decided by a two-thirds majority of all voting members of the Code of Conduct team. Team members are listed in the charter. Currently active voting members are listed in the following section.
   * **Board Vote.** Once a working draft is in place for the Code of Conduct and procedures, the Code of Conduct team shall provide the HyperContagion Community Moderators with a draft of the changes. The HyperContagion Community Moderators will vote on the changes at a board meeting.


### Current list of voting members

- All available Community Developers (i.e. those with "write" permissions, or above, on the HyperContagion Community GitHub organization).



## License

This Code of Conduct is licensed under the [Creative Commons Attribution-ShareAlike 3.0 Unported License](https://creativecommons.org/licenses/by-sa/3.0/).



## Attributions

This Code of Conduct was forked from the code of conduct from the [Python Software Foundation](https://www.python.org/psf/conduct/) and the Manim community and adapted by the HyperContagion Community.