"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const mediastore_helper_1 = require("../lib/mediastore-helper");
test('MediaStore container override params', () => {
    const stack = new core_1.Stack();
    const mediaStoreContainerProps = {
        containerName: 'TestContainer',
        policy: '{}',
        lifecyclePolicy: '{}',
        metricPolicy: {
            containerLevelMetrics: 'DISABLED'
        }
    };
    mediastore_helper_1.MediaStoreContainer(stack, mediaStoreContainerProps);
    expect(stack).toHaveResourceLike('AWS::MediaStore::Container', {
        AccessLoggingEnabled: true,
        CorsPolicy: [
            {
                AllowedHeaders: ['*'],
                AllowedMethods: ['GET'],
                AllowedOrigins: ['*'],
                ExposeHeaders: ['*'],
                MaxAgeSeconds: 3000
            }
        ],
        MetricPolicy: {
            ContainerLevelMetrics: 'DISABLED'
        },
        Policy: '{}',
        LifecyclePolicy: '{}',
        ContainerName: 'TestContainer'
    });
});
//# sourceMappingURL=data:application/json;base64,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