"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const kinesisfirehose = require("@aws-cdk/aws-kinesisfirehose");
const defaults = require("../index");
const utils_1 = require("../lib/utils");
require("@aws-cdk/assert/jest");
const kms = require("@aws-cdk/aws-kms");
test('test kinesisanalytics override buffer conditions', () => {
    const stack = new core_1.Stack();
    const inProps = {
        extendedS3DestinationConfiguration: {
            bufferingHints: {
                intervalInSeconds: 600,
                sizeInMBs: 10
            },
        }
    };
    const awsManagedKey = kms.Alias.fromAliasName(stack, 'aws-managed-key', 'alias/aws/s3');
    const defaultProps = defaults.DefaultCfnDeliveryStreamProps('bucket_arn', 'role_arn', 'log_group', 'log_stream', awsManagedKey);
    const outProps = utils_1.overrideProps(defaultProps, inProps);
    new kinesisfirehose.CfnDeliveryStream(stack, 'KinesisFirehose', outProps);
    expect(stack).toHaveResource("AWS::KinesisFirehose::DeliveryStream", {
        ExtendedS3DestinationConfiguration: {
            BucketARN: "bucket_arn",
            BufferingHints: {
                IntervalInSeconds: 600,
                SizeInMBs: 10
            },
            CloudWatchLoggingOptions: {
                Enabled: true,
                LogGroupName: "log_group",
                LogStreamName: "log_stream"
            },
            CompressionFormat: "GZIP",
            EncryptionConfiguration: {
                KMSEncryptionConfig: {
                    AWSKMSKeyARN: {
                        "Fn::Join": [
                            "",
                            [
                                "arn:",
                                {
                                    Ref: "AWS::Partition"
                                },
                                ":kms:",
                                {
                                    Ref: "AWS::Region"
                                },
                                ":",
                                {
                                    Ref: "AWS::AccountId"
                                },
                                ":alias/aws/s3"
                            ]
                        ]
                    }
                }
            },
            RoleARN: "role_arn"
        }
    });
});
//# sourceMappingURL=data:application/json;base64,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