"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const iot = require("@aws-cdk/aws-iot");
const defaults = require("../index");
const utils_1 = require("../lib/utils");
require("@aws-cdk/assert/jest");
test('test TopicRuleProps override sql and description', () => {
    const stack = new core_1.Stack();
    const action1 = {
        lambda: {
            functionArn: 'xyz'
        }
    };
    const defaultProps = defaults.DefaultCfnTopicRuleProps([action1]);
    const inProps = {
        topicRulePayload: {
            ruleDisabled: true,
            description: "Processing of vehicle messages",
            sql: "SELECT * FROM 'connectedcar/#'",
            actions: []
        }
    };
    const outProps = utils_1.overrideProps(defaultProps, inProps, true);
    new iot.CfnTopicRule(stack, 'IotTopic', outProps);
    expect(stack).toHaveResource('AWS::IoT::TopicRule', {
        TopicRulePayload: {
            Actions: [
                {
                    Lambda: {
                        FunctionArn: "xyz"
                    }
                }
            ],
            Description: "Processing of vehicle messages",
            RuleDisabled: true,
            Sql: "SELECT * FROM 'connectedcar/#'"
        }
    });
});
test('test TopicRuleProps override actions', () => {
    const stack = new core_1.Stack();
    const defaultProps = defaults.DefaultCfnTopicRuleProps([], '');
    const action = {
        lambda: {
            functionArn: 'abc'
        }
    };
    const inProps = {
        topicRulePayload: {
            ruleDisabled: true,
            sql: '',
            actions: [action]
        }
    };
    const outProps = utils_1.overrideProps(defaultProps, inProps);
    new iot.CfnTopicRule(stack, 'IotTopic', outProps);
    expect(stack).toHaveResource('AWS::IoT::TopicRule', {
        TopicRulePayload: {
            Actions: [
                {
                    Lambda: {
                        FunctionArn: "abc"
                    }
                }
            ],
            RuleDisabled: true,
            Sql: ""
        }
    });
});
//# sourceMappingURL=data:application/json;base64,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