"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultWafwebaclProps = exports.wrapManagedRuleSet = exports.DefaultWafRules = void 0;
function DefaultWafRules() {
    return [
        wrapManagedRuleSet("AWSManagedRulesBotControlRuleSet", "AWS", 0),
        wrapManagedRuleSet("AWSManagedRulesKnownBadInputsRuleSet", "AWS", 1),
        wrapManagedRuleSet("AWSManagedRulesCommonRuleSet", "AWS", 2),
        wrapManagedRuleSet("AWSManagedRulesAnonymousIpList", "AWS", 3),
        wrapManagedRuleSet("AWSManagedRulesAmazonIpReputationList", "AWS", 4),
        wrapManagedRuleSet("AWSManagedRulesAdminProtectionRuleSet", "AWS", 5),
        wrapManagedRuleSet("AWSManagedRulesSQLiRuleSet", "AWS", 6)
    ];
}
exports.DefaultWafRules = DefaultWafRules;
function wrapManagedRuleSet(managedGroupName, vendorName, priority) {
    return {
        name: `${vendorName}-${managedGroupName}`,
        priority,
        overrideAction: { none: {} },
        statement: {
            managedRuleGroupStatement: {
                name: managedGroupName,
                vendorName,
            }
        },
        visibilityConfig: {
            cloudWatchMetricsEnabled: true,
            metricName: managedGroupName,
            sampledRequestsEnabled: true
        }
    };
}
exports.wrapManagedRuleSet = wrapManagedRuleSet;
function DefaultWafwebaclProps(webaclScope) {
    return {
        defaultAction: {
            allow: {}
        },
        scope: webaclScope,
        visibilityConfig: {
            cloudWatchMetricsEnabled: true,
            metricName: 'webACL',
            sampledRequestsEnabled: true
        },
        rules: DefaultWafRules()
    };
}
exports.DefaultWafwebaclProps = DefaultWafwebaclProps;
//# sourceMappingURL=data:application/json;base64,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