/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as ec2 from "@aws-cdk/aws-ec2";
import { Construct } from "@aws-cdk/core";
export interface BuildVpcProps {
    /**
     * Existing instance of a VPC, if this is set then the all Props are ignored
     */
    readonly existingVpc?: ec2.IVpc;
    /**
     * One of the default VPC configurations available in vpc-defaults
     */
    readonly defaultVpcProps: ec2.VpcProps;
    /**
     * User provided props to override the default props for the VPC.
     */
    readonly userVpcProps?: ec2.VpcProps;
    /**
     * Construct specified props that override both the default props
     * and user props for the VPC.
     */
    readonly constructVpcProps?: ec2.VpcProps;
}
export declare function buildVpc(scope: Construct, props: BuildVpcProps): ec2.IVpc;
export declare enum ServiceEndpointTypes {
    DYNAMODB = "DDB",
    SNS = "SNS",
    SQS = "SQS",
    S3 = "S3",
    STEP_FUNCTIONS = "STEP_FUNCTIONS",
    SAGEMAKER_RUNTIME = "SAGEMAKER_RUNTIME",
    SECRETS_MANAGER = "SECRETS_MANAGER",
    SSM = "SSM",
    ECR_API = "ECR_API",
    ECR_DKR = "ECR_DKR",
    EVENTS = "CLOUDWATCH_EVENTS"
}
export declare function AddAwsServiceEndpoint(scope: Construct, vpc: ec2.IVpc, interfaceTag: ServiceEndpointTypes): void;
//# sourceMappingURL=vpc-helper.d.ts.map