/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as sagemaker from '@aws-cdk/aws-sagemaker';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
export interface BuildSagemakerNotebookProps {
    /**
     * Optional user provided props for CfnNotebookInstanceProps
     *
     * @default - Default props are used
     */
    readonly sagemakerNotebookProps?: sagemaker.CfnNotebookInstanceProps | any;
    /**
     * Optional user provided props to deploy inside vpc
     *
     * @default - true
     */
    readonly deployInsideVpc?: boolean;
    /**
     * An optional, Existing instance of notebook object.
     * If this is set then the sagemakerNotebookProps is ignored
     *
     * @default - None
     */
    readonly existingNotebookObj?: sagemaker.CfnNotebookInstance;
    /**
     * IAM Role Arn for Sagemaker NoteBookInstance
     *
     * @default - None
     */
    readonly role: iam.Role;
}
export declare function buildSagemakerNotebook(scope: Construct, props: BuildSagemakerNotebookProps): [sagemaker.CfnNotebookInstance, ec2.IVpc?, ec2.SecurityGroup?];
export interface BuildSagemakerEndpointProps {
    /**
     * Existing Sagemaker Enpoint object, if this is set then the modelProps, endpointConfigProps, and endpointProps are ignored
     *
     * @default - None
     */
    readonly existingSagemakerEndpointObj?: sagemaker.CfnEndpoint;
    /**
     * User provided props to create Sagemaker Model
     *
     * @default - None
     */
    readonly modelProps?: sagemaker.CfnModelProps | any;
    /**
     * User provided props to create Sagemaker Endpoint Configuration
     *
     * @default - None
     */
    readonly endpointConfigProps?: sagemaker.CfnEndpointConfigProps;
    /**
     * User provided props to create Sagemaker Endpoint
     *
     * @default - None
     */
    readonly endpointProps?: sagemaker.CfnEndpointProps;
    /**
     * A VPC where the Sagemaker Endpoint will be placed
     *
     * @default - None
     */
    readonly vpc?: ec2.IVpc;
}
export declare function BuildSagemakerEndpoint(scope: Construct, props: BuildSagemakerEndpointProps): [sagemaker.CfnEndpoint, sagemaker.CfnEndpointConfig?, sagemaker.CfnModel?];
export declare function deploySagemakerEndpoint(scope: Construct, props: BuildSagemakerEndpointProps): [sagemaker.CfnEndpoint, sagemaker.CfnEndpointConfig?, sagemaker.CfnModel?];
export declare function createSagemakerModel(scope: Construct, modelProps: sagemaker.CfnModelProps, role: iam.Role, vpc?: ec2.IVpc): sagemaker.CfnModel;
export declare function createSagemakerEndpointConfig(scope: Construct, modelName: string, endpointConfigProps?: sagemaker.CfnEndpointConfigProps): sagemaker.CfnEndpointConfig;
export declare function createSagemakerEndpoint(scope: Construct, endpointConfigName: string, endpointProps?: sagemaker.CfnEndpointProps): sagemaker.CfnEndpoint;
//# sourceMappingURL=sagemaker-helper.d.ts.map