"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildEncryptionKey = void 0;
const kms = require("@aws-cdk/aws-kms");
const kms_defaults_1 = require("./kms-defaults");
const utils_1 = require("./utils");
function buildEncryptionKey(scope, keyProps) {
    // Setup the key properties
    let encryptionKeyProps;
    // If property overrides have been provided, incorporate them and deploy
    encryptionKeyProps = utils_1.consolidateProps(kms_defaults_1.DefaultEncryptionProps, keyProps);
    // Create the encryption key and return
    return new kms.Key(scope, 'EncryptionKey', encryptionKeyProps);
}
exports.buildEncryptionKey = buildEncryptionKey;
//# sourceMappingURL=data:application/json;base64,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