"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetMemcachedDefaults = exports.GetDefaultCachePort = void 0;
function GetDefaultCachePort() {
    // Best practice not to use default port 11211
    return 11222;
}
exports.GetDefaultCachePort = GetDefaultCachePort;
function GetMemcachedDefaults(id, port) {
    return {
        clusterName: `${id}-cdk-cluster`,
        cacheNodeType: "cache.t3.medium",
        engine: "memcached",
        numCacheNodes: 2,
        port,
        azMode: 'cross-az'
    };
}
exports.GetMemcachedDefaults = GetMemcachedDefaults;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWxhc3RpY2FjaGUtZGVmYXVsdHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbGFzdGljYWNoZS1kZWZhdWx0cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7Ozs7Ozs7O0dBV0c7OztBQUVILFNBQWdCLG1CQUFtQjtJQUNqQyw4Q0FBOEM7SUFDOUMsT0FBTyxLQUFLLENBQUM7QUFDZixDQUFDO0FBSEQsa0RBR0M7QUFFRCxTQUFnQixvQkFBb0IsQ0FBQyxFQUFVLEVBQUUsSUFBWTtJQUMzRCxPQUFPO1FBQ0wsV0FBVyxFQUFFLEdBQUcsRUFBRSxjQUFjO1FBQ2hDLGFBQWEsRUFBRSxpQkFBaUI7UUFDaEMsTUFBTSxFQUFFLFdBQVc7UUFDbkIsYUFBYSxFQUFFLENBQUM7UUFDaEIsSUFBSTtRQUNKLE1BQU0sRUFBRSxVQUFVO0tBQ25CLENBQUM7QUFDSixDQUFDO0FBVEQsb0RBU0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgMjAyMiBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmV4cG9ydCBmdW5jdGlvbiBHZXREZWZhdWx0Q2FjaGVQb3J0KCkge1xuICAvLyBCZXN0IHByYWN0aWNlIG5vdCB0byB1c2UgZGVmYXVsdCBwb3J0IDExMjExXG4gIHJldHVybiAxMTIyMjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIEdldE1lbWNhY2hlZERlZmF1bHRzKGlkOiBzdHJpbmcsIHBvcnQ6IG51bWJlcikge1xuICByZXR1cm4ge1xuICAgIGNsdXN0ZXJOYW1lOiBgJHtpZH0tY2RrLWNsdXN0ZXJgLFxuICAgIGNhY2hlTm9kZVR5cGU6IFwiY2FjaGUudDMubWVkaXVtXCIsXG4gICAgZW5naW5lOiBcIm1lbWNhY2hlZFwiLFxuICAgIG51bUNhY2hlTm9kZXM6IDIsXG4gICAgcG9ydCxcbiAgICBhek1vZGU6ICdjcm9zcy1heidcbiAgfTtcbn1cbiJdfQ==