"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCloudFrontDisributionForMediaStoreProps = exports.DefaultCloudFrontWebDistributionForS3Props = exports.DefaultCloudFrontWebDistributionForApiGatewayProps = void 0;
const cloudfront = require("@aws-cdk/aws-cloudfront");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
function DefaultCloudFrontWebDistributionForApiGatewayProps(apiEndPoint, loggingBucket, setHttpSecurityHeaders, cfFunction) {
    const apiEndPointUrlWithoutProtocol = cdk.Fn.select(1, cdk.Fn.split("://", apiEndPoint.url));
    const apiEndPointDomainName = cdk.Fn.select(0, cdk.Fn.split("/", apiEndPointUrlWithoutProtocol));
    return {
        defaultBehavior: {
            origin: new origins.HttpOrigin(apiEndPointDomainName, {
                originPath: `/${apiEndPoint.deploymentStage.stageName}`
            }),
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction),
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS
        },
        enableLogging: true,
        logBucket: loggingBucket,
    };
}
exports.DefaultCloudFrontWebDistributionForApiGatewayProps = DefaultCloudFrontWebDistributionForApiGatewayProps;
function DefaultCloudFrontWebDistributionForS3Props(sourceBucket, loggingBucket, setHttpSecurityHeaders, originPath, cfFunction) {
    let origin;
    if (originPath) {
        origin = new origins.S3Origin(sourceBucket, { originPath });
    }
    else {
        origin = new origins.S3Origin(sourceBucket);
    }
    return {
        defaultBehavior: {
            origin,
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction)
        },
        enableLogging: true,
        logBucket: loggingBucket,
        defaultRootObject: 'index.html'
    };
}
exports.DefaultCloudFrontWebDistributionForS3Props = DefaultCloudFrontWebDistributionForS3Props;
function DefaultCloudFrontDisributionForMediaStoreProps(mediastoreContainer, loggingBucket, originRequestPolicy, setHttpSecurityHeaders, customHeaders, cfFunction) {
    const mediaStoreContainerUrlWithoutProtocol = cdk.Fn.select(1, cdk.Fn.split('://', mediastoreContainer.attrEndpoint));
    const mediaStoreContainerDomainName = cdk.Fn.select(0, cdk.Fn.split('/', mediaStoreContainerUrlWithoutProtocol));
    const httpOrigin = customHeaders ?
        new origins.HttpOrigin(mediaStoreContainerDomainName, { customHeaders }) :
        new origins.HttpOrigin(mediaStoreContainerDomainName);
    return {
        defaultBehavior: {
            origin: httpOrigin,
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            allowedMethods: cloudfront.AllowedMethods.ALLOW_GET_HEAD_OPTIONS,
            cachedMethods: cloudfront.CachedMethods.CACHE_GET_HEAD_OPTIONS,
            originRequestPolicy,
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction)
        },
        enableLogging: true,
        logBucket: loggingBucket
    };
}
exports.DefaultCloudFrontDisributionForMediaStoreProps = DefaultCloudFrontDisributionForMediaStoreProps;
function getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction) {
    return (setHttpSecurityHeaders && cfFunction) ? {
        functionAssociations: [
            {
                eventType: aws_cloudfront_1.FunctionEventType.VIEWER_RESPONSE,
                function: cfFunction
            }
        ]
    } : {};
}
//# sourceMappingURL=data:application/json;base64,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