/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as api from '@aws-cdk/aws-apigateway';
import * as cloudfront from '@aws-cdk/aws-cloudfront';
import * as mediastore from '@aws-cdk/aws-mediastore';
import * as s3 from '@aws-cdk/aws-s3';
export declare function DefaultCloudFrontWebDistributionForApiGatewayProps(apiEndPoint: api.RestApi, loggingBucket: s3.Bucket | undefined, setHttpSecurityHeaders: boolean, cfFunction?: cloudfront.IFunction): cloudfront.DistributionProps;
export declare function DefaultCloudFrontWebDistributionForS3Props(sourceBucket: s3.IBucket, loggingBucket: s3.Bucket | undefined, setHttpSecurityHeaders: boolean, originPath?: string, cfFunction?: cloudfront.IFunction): cloudfront.DistributionProps;
export declare function DefaultCloudFrontDisributionForMediaStoreProps(mediastoreContainer: mediastore.CfnContainer, loggingBucket: s3.Bucket | undefined, originRequestPolicy: cloudfront.OriginRequestPolicy, setHttpSecurityHeaders: boolean, customHeaders?: Record<string, string>, cfFunction?: cloudfront.IFunction): cloudfront.DistributionProps;
//# sourceMappingURL=cloudfront-distribution-defaults.d.ts.map