/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as logs from '@aws-cdk/aws-logs';
import * as lambda from '@aws-cdk/aws-lambda';
import * as api from '@aws-cdk/aws-apigateway';
import * as iam from '@aws-cdk/aws-iam';
import { IRole } from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
/**
 * Builds and returns a global api.RestApi designed to be used with an AWS Lambda function.
 * @param scope - the construct to which the RestApi should be attached to.
 * @param _existingLambdaObj - an existing AWS Lambda function.
 * @param apiGatewayProps - (optional) user-specified properties to override the default properties.
 */
export declare function GlobalLambdaRestApi(scope: Construct, _existingLambdaObj: lambda.Function, apiGatewayProps?: api.LambdaRestApiProps, logGroupProps?: logs.LogGroupProps): [api.RestApi, iam.Role | undefined, logs.LogGroup];
/**
 * Builds and returns a regional api.RestApi designed to be used with an AWS Lambda function.
 * @param scope - the construct to which the RestApi should be attached to.
 * @param _existingLambdaObj - an existing AWS Lambda function.
 * @param apiGatewayProps - (optional) user-specified properties to override the default properties.
 */
export declare function RegionalLambdaRestApi(scope: Construct, _existingLambdaObj: lambda.Function, apiGatewayProps?: api.LambdaRestApiProps, logGroupProps?: logs.LogGroupProps): [api.RestApi, iam.Role | undefined, logs.LogGroup];
/**
 * Builds and returns a standard api.RestApi.
 * @param scope - the construct to which the RestApi should be attached to.
 * @param apiGatewayProps - (optional) user-specified properties to override the default properties.
 */
export declare function GlobalRestApi(scope: Construct, apiGatewayProps?: api.RestApiProps, logGroupProps?: logs.LogGroupProps): [api.RestApi, iam.Role | undefined, logs.LogGroup];
/**
 * Builds and returns a Regional api.RestApi.
 * @param scope - the construct to which the RestApi should be attached to.
 * @param apiGatewayProps - (optional) user-specified properties to override the default properties.
 */
export declare function RegionalRestApi(scope: Construct, apiGatewayProps?: api.RestApiProps, logGroupProps?: logs.LogGroupProps): [api.RestApi, iam.Role | undefined, logs.LogGroup];
export interface AddProxyMethodToApiResourceInputParams {
    readonly service: string;
    readonly action?: string;
    readonly path?: string;
    readonly apiResource: api.IResource;
    readonly apiMethod: string;
    readonly apiGatewayRole: IRole;
    readonly requestTemplate: string;
    readonly contentType?: string;
    readonly requestValidator?: api.IRequestValidator;
    readonly requestModel?: {
        [contentType: string]: api.IModel;
    };
    readonly awsIntegrationProps?: api.AwsIntegrationProps | any;
    readonly methodOptions?: api.MethodOptions;
}
export declare function addProxyMethodToApiResource(params: AddProxyMethodToApiResourceInputParams): api.Method;
//# sourceMappingURL=apigateway-helper.d.ts.map