/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as elb from "@aws-cdk/aws-elasticloadbalancingv2";
import { Construct } from "@aws-cdk/core";
import * as ec2 from "@aws-cdk/aws-ec2";
import * as s3 from "@aws-cdk/aws-s3";
import * as ecs from "@aws-cdk/aws-ecs";
import * as lambda from "@aws-cdk/aws-lambda";
export declare function ObtainAlb(scope: Construct, id: string, vpc: ec2.IVpc, publicApi: boolean, existingLoadBalancerObj?: elb.ApplicationLoadBalancer, loadBalancerProps?: elb.ApplicationLoadBalancerProps | any, logAccessLogs?: boolean, loggingBucketProps?: s3.BucketProps): elb.ApplicationLoadBalancer;
export declare function AddListener(scope: Construct, id: string, loadBalancer: elb.ApplicationLoadBalancer, listenerProps: elb.ApplicationListenerProps | any): elb.ApplicationListener;
export declare function AddLambdaTarget(scope: Construct, id: string, currentListener: elb.ApplicationListener, lambdaFunction: lambda.IFunction, ruleProps?: elb.AddRuleProps, targetProps?: elb.ApplicationTargetGroupProps): elb.ApplicationTargetGroup;
export declare function AddFargateTarget(scope: Construct, id: string, currentListener: elb.ApplicationListener, fargateService: ecs.FargateService, ruleProps?: elb.AddRuleProps, targetProps?: elb.ApplicationTargetGroupProps): elb.ApplicationTargetGroup;
export declare function GetActiveListener(listeners: elb.ApplicationListener[]): elb.ApplicationListener;
export declare function CheckAlbProps(props: any): void;
//# sourceMappingURL=alb-helper.d.ts.map