"""
    Cosmo Tech Plaform API

    Cosmo Tech Platform API  # noqa: E501

    The version of the OpenAPI document: 0.0.13-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cosmotech_api.api_client import ApiClient, Endpoint as _Endpoint
from cosmotech_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cosmotech_api.model.scenario_run import ScenarioRun
from cosmotech_api.model.scenario_run_logs import ScenarioRunLogs
from cosmotech_api.model.scenario_run_search import ScenarioRunSearch
from cosmotech_api.model.scenario_run_start_containers import ScenarioRunStartContainers
from cosmotech_api.model.scenario_run_status import ScenarioRunStatus


class ScenariorunApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.delete_scenario_run_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/scenarioruns/{scenariorun_id}',
                'operation_id': 'delete_scenario_run',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'required': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'scenariorun_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'scenariorun_id': 'scenariorun_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'scenariorun_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.find_scenario_run_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioRun,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/scenarioruns/{scenariorun_id}',
                'operation_id': 'find_scenario_run_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'required': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'scenariorun_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'scenariorun_id': 'scenariorun_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'scenariorun_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_scenario_run_cumulated_logs_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/scenarioruns/{scenariorun_id}/cumulatedlogs',
                'operation_id': 'get_scenario_run_cumulated_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'required': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'scenariorun_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'scenariorun_id': 'scenariorun_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'scenariorun_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_scenario_run_logs_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioRunLogs,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/scenarioruns/{scenariorun_id}/logs',
                'operation_id': 'get_scenario_run_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'required': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'scenariorun_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'scenariorun_id': 'scenariorun_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'scenariorun_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_scenario_run_status_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioRunStatus,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/scenarioruns/{scenariorun_id}/status',
                'operation_id': 'get_scenario_run_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'required': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'scenariorun_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'scenariorun_id': 'scenariorun_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'scenariorun_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_scenario_runs_endpoint = _Endpoint(
            settings={
                'response_type': ([ScenarioRun],),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/scenarioruns',
                'operation_id': 'get_scenario_runs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_workspace_scenario_runs_endpoint = _Endpoint(
            settings={
                'response_type': ([ScenarioRun],),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarioruns',
                'operation_id': 'get_workspace_scenario_runs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.run_scenario_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioRun,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/run',
                'operation_id': 'run_scenario',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.search_scenario_runs_endpoint = _Endpoint(
            settings={
                'response_type': ([ScenarioRun],),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/scenarioruns/search',
                'operation_id': 'search_scenario_runs',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'scenario_run_search',
                ],
                'required': [
                    'organization_id',
                    'scenario_run_search',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'scenario_run_search':
                        (ScenarioRunSearch,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'scenario_run_search': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/yaml'
                ]
            },
            api_client=api_client
        )
        self.start_scenario_run_containers_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioRun,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/scenarioruns/startcontainers',
                'operation_id': 'start_scenario_run_containers',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'scenario_run_start_containers',
                ],
                'required': [
                    'organization_id',
                    'scenario_run_start_containers',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'scenario_run_start_containers':
                        (ScenarioRunStartContainers,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'scenario_run_start_containers': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/yaml'
                ]
            },
            api_client=api_client
        )
        self.stop_scenario_run_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioRunStatus,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/scenarioruns/{scenariorun_id}/stop',
                'operation_id': 'stop_scenario_run',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'required': [
                    'organization_id',
                    'scenariorun_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'scenariorun_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'scenariorun_id': 'scenariorun_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'scenariorun_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def delete_scenario_run(
        self,
        organization_id,
        scenariorun_id,
        **kwargs
    ):
        """Delete a scenariorun  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_scenario_run(organization_id, scenariorun_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            scenariorun_id (str): the ScenarioRun identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['scenariorun_id'] = \
            scenariorun_id
        return self.delete_scenario_run_endpoint.call_with_http_info(**kwargs)

    def find_scenario_run_by_id(
        self,
        organization_id,
        scenariorun_id,
        **kwargs
    ):
        """Get the details of a scenariorun  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_scenario_run_by_id(organization_id, scenariorun_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            scenariorun_id (str): the ScenarioRun identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioRun
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['scenariorun_id'] = \
            scenariorun_id
        return self.find_scenario_run_by_id_endpoint.call_with_http_info(**kwargs)

    def get_scenario_run_cumulated_logs(
        self,
        organization_id,
        scenariorun_id,
        **kwargs
    ):
        """Get the cumulated logs of a scenariorun  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scenario_run_cumulated_logs(organization_id, scenariorun_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            scenariorun_id (str): the ScenarioRun identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['scenariorun_id'] = \
            scenariorun_id
        return self.get_scenario_run_cumulated_logs_endpoint.call_with_http_info(**kwargs)

    def get_scenario_run_logs(
        self,
        organization_id,
        scenariorun_id,
        **kwargs
    ):
        """get the logs for the ScenarioRun  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scenario_run_logs(organization_id, scenariorun_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            scenariorun_id (str): the ScenarioRun identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioRunLogs
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['scenariorun_id'] = \
            scenariorun_id
        return self.get_scenario_run_logs_endpoint.call_with_http_info(**kwargs)

    def get_scenario_run_status(
        self,
        organization_id,
        scenariorun_id,
        **kwargs
    ):
        """get the status for the ScenarioRun  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scenario_run_status(organization_id, scenariorun_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            scenariorun_id (str): the ScenarioRun identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioRunStatus
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['scenariorun_id'] = \
            scenariorun_id
        return self.get_scenario_run_status_endpoint.call_with_http_info(**kwargs)

    def get_scenario_runs(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        **kwargs
    ):
        """get the list of ScenarioRuns for the Scenario  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scenario_runs(organization_id, workspace_id, scenario_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [ScenarioRun]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        return self.get_scenario_runs_endpoint.call_with_http_info(**kwargs)

    def get_workspace_scenario_runs(
        self,
        organization_id,
        workspace_id,
        **kwargs
    ):
        """get the list of ScenarioRuns for the Workspace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_workspace_scenario_runs(organization_id, workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [ScenarioRun]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_workspace_scenario_runs_endpoint.call_with_http_info(**kwargs)

    def run_scenario(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        **kwargs
    ):
        """run a ScenarioRun for the Scenario  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_scenario(organization_id, workspace_id, scenario_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioRun
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        return self.run_scenario_endpoint.call_with_http_info(**kwargs)

    def search_scenario_runs(
        self,
        organization_id,
        scenario_run_search,
        **kwargs
    ):
        """Search ScenarioRuns  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_scenario_runs(organization_id, scenario_run_search, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            scenario_run_search (ScenarioRunSearch): the ScenarioRun search parameters

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [ScenarioRun]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['scenario_run_search'] = \
            scenario_run_search
        return self.search_scenario_runs_endpoint.call_with_http_info(**kwargs)

    def start_scenario_run_containers(
        self,
        organization_id,
        scenario_run_start_containers,
        **kwargs
    ):
        """Start a new scenariorun with raw containers definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.start_scenario_run_containers(organization_id, scenario_run_start_containers, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            scenario_run_start_containers (ScenarioRunStartContainers): the raw containers definition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioRun
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['scenario_run_start_containers'] = \
            scenario_run_start_containers
        return self.start_scenario_run_containers_endpoint.call_with_http_info(**kwargs)

    def stop_scenario_run(
        self,
        organization_id,
        scenariorun_id,
        **kwargs
    ):
        """stop a ScenarioRun for the Scenario  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stop_scenario_run(organization_id, scenariorun_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            scenariorun_id (str): the scenariorun identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioRunStatus
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['scenariorun_id'] = \
            scenariorun_id
        return self.stop_scenario_run_endpoint.call_with_http_info(**kwargs)

