"""
    Cosmo Tech Plaform API

    Cosmo Tech Platform API  # noqa: E501

    The version of the OpenAPI document: 0.0.13-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cosmotech_api.api_client import ApiClient, Endpoint as _Endpoint
from cosmotech_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cosmotech_api.model.scenario import Scenario
from cosmotech_api.model.scenario_comparison_result import ScenarioComparisonResult
from cosmotech_api.model.scenario_data_download_info import ScenarioDataDownloadInfo
from cosmotech_api.model.scenario_data_download_job import ScenarioDataDownloadJob
from cosmotech_api.model.scenario_run_template_parameter_value import ScenarioRunTemplateParameterValue
from cosmotech_api.model.scenario_user import ScenarioUser
from cosmotech_api.model.scenario_validation_status import ScenarioValidationStatus


class ScenarioApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_or_replace_scenario_parameter_values_endpoint = _Endpoint(
            settings={
                'response_type': ([ScenarioRunTemplateParameterValue],),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/parameterValues',
                'operation_id': 'add_or_replace_scenario_parameter_values',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'scenario_run_template_parameter_value',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'scenario_run_template_parameter_value',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                    'scenario_run_template_parameter_value':
                        ([ScenarioRunTemplateParameterValue],),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                    'scenario_run_template_parameter_value': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.add_or_replace_users_in_scenario_endpoint = _Endpoint(
            settings={
                'response_type': ([ScenarioUser],),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/users',
                'operation_id': 'add_or_replace_users_in_scenario',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'scenario_user',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'scenario_user',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                    'scenario_user':
                        ([ScenarioUser],),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                    'scenario_user': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.compare_scenarios_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioComparisonResult,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/compare/{compared_scenario_id}',
                'operation_id': 'compare_scenarios',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'compared_scenario_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'compared_scenario_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                    'compared_scenario_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                    'compared_scenario_id': 'compared_scenario_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                    'compared_scenario_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_scenario_endpoint = _Endpoint(
            settings={
                'response_type': (Scenario,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios',
                'operation_id': 'create_scenario',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario':
                        (Scenario,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/yaml'
                ]
            },
            api_client=api_client
        )
        self.delete_all_scenarios_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios',
                'operation_id': 'delete_all_scenarios',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_scenario_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}',
                'operation_id': 'delete_scenario',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'wait_relationship_propagation',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                    'wait_relationship_propagation':
                        (bool,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                    'wait_relationship_propagation': 'wait_relationship_propagation',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                    'wait_relationship_propagation': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.download_scenario_data_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioDataDownloadJob,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/downloads',
                'operation_id': 'download_scenario_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.find_all_scenarios_endpoint = _Endpoint(
            settings={
                'response_type': ([Scenario],),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios',
                'operation_id': 'find_all_scenarios',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.find_all_scenarios_by_validation_status_endpoint = _Endpoint(
            settings={
                'response_type': ([Scenario],),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/{validationStatus}',
                'operation_id': 'find_all_scenarios_by_validation_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'validation_status',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'validation_status',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'validation_status':
                        (ScenarioValidationStatus,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'validation_status': 'validationStatus',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'validation_status': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.find_scenario_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (Scenario,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}',
                'operation_id': 'find_scenario_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_scenario_data_download_job_info_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioDataDownloadInfo,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/downloads/{download_id}',
                'operation_id': 'get_scenario_data_download_job_info',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'download_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'download_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                    'download_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                    'download_id': 'download_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                    'download_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_scenario_validation_status_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (ScenarioValidationStatus,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/ValidationStatus',
                'operation_id': 'get_scenario_validation_status_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_scenarios_tree_endpoint = _Endpoint(
            settings={
                'response_type': ([Scenario],),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/tree',
                'operation_id': 'get_scenarios_tree',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_all_scenario_parameter_values_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/parameterValues',
                'operation_id': 'remove_all_scenario_parameter_values',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_all_users_of_scenario_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/users',
                'operation_id': 'remove_all_users_of_scenario',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_user_from_scenario_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}/users/{user_id}',
                'operation_id': 'remove_user_from_scenario',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'user_id',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                    'user_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_scenario_endpoint = _Endpoint(
            settings={
                'response_type': (Scenario,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/workspaces/{workspace_id}/scenarios/{scenario_id}',
                'operation_id': 'update_scenario',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'scenario',
                ],
                'required': [
                    'organization_id',
                    'workspace_id',
                    'scenario_id',
                    'scenario',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'workspace_id':
                        (str,),
                    'scenario_id':
                        (str,),
                    'scenario':
                        (Scenario,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'workspace_id': 'workspace_id',
                    'scenario_id': 'scenario_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'workspace_id': 'path',
                    'scenario_id': 'path',
                    'scenario': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/yaml'
                ]
            },
            api_client=api_client
        )

    def add_or_replace_scenario_parameter_values(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        scenario_run_template_parameter_value,
        **kwargs
    ):
        """Add (or replace) Parameter Values for the Scenario specified  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_or_replace_scenario_parameter_values(organization_id, workspace_id, scenario_id, scenario_run_template_parameter_value, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier
            scenario_run_template_parameter_value ([ScenarioRunTemplateParameterValue]): the Parameter Value to add. Any Parameter Value with the same ID is overwritten

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [ScenarioRunTemplateParameterValue]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        kwargs['scenario_run_template_parameter_value'] = \
            scenario_run_template_parameter_value
        return self.add_or_replace_scenario_parameter_values_endpoint.call_with_http_info(**kwargs)

    def add_or_replace_users_in_scenario(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        scenario_user,
        **kwargs
    ):
        """Add (or replace) users in the Scenario specified  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_or_replace_users_in_scenario(organization_id, workspace_id, scenario_id, scenario_user, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier
            scenario_user ([ScenarioUser]): the Users to add. Any User with the same ID is overwritten

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [ScenarioUser]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        kwargs['scenario_user'] = \
            scenario_user
        return self.add_or_replace_users_in_scenario_endpoint.call_with_http_info(**kwargs)

    def compare_scenarios(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        compared_scenario_id,
        **kwargs
    ):
        """Compare the Scenario with another one and returns the difference for parameters values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.compare_scenarios(organization_id, workspace_id, scenario_id, compared_scenario_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier
            compared_scenario_id (str): the Scenario identifier to compare to

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioComparisonResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        kwargs['compared_scenario_id'] = \
            compared_scenario_id
        return self.compare_scenarios_endpoint.call_with_http_info(**kwargs)

    def create_scenario(
        self,
        organization_id,
        workspace_id,
        scenario,
        **kwargs
    ):
        """Create a new Scenario  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_scenario(organization_id, workspace_id, scenario, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario (Scenario): the Scenario to create

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Scenario
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario'] = \
            scenario
        return self.create_scenario_endpoint.call_with_http_info(**kwargs)

    def delete_all_scenarios(
        self,
        organization_id,
        workspace_id,
        **kwargs
    ):
        """Delete all Scenarios of the Workspace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_all_scenarios(organization_id, workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        return self.delete_all_scenarios_endpoint.call_with_http_info(**kwargs)

    def delete_scenario(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        **kwargs
    ):
        """Delete a scenario  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_scenario(organization_id, workspace_id, scenario_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier

        Keyword Args:
            wait_relationship_propagation (bool): whether to wait until child scenarios are effectively updated. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        return self.delete_scenario_endpoint.call_with_http_info(**kwargs)

    def download_scenario_data(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        **kwargs
    ):
        """Download Scenario data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_scenario_data(organization_id, workspace_id, scenario_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioDataDownloadJob
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        return self.download_scenario_data_endpoint.call_with_http_info(**kwargs)

    def find_all_scenarios(
        self,
        organization_id,
        workspace_id,
        **kwargs
    ):
        """List all Scenarios  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_all_scenarios(organization_id, workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Scenario]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        return self.find_all_scenarios_endpoint.call_with_http_info(**kwargs)

    def find_all_scenarios_by_validation_status(
        self,
        organization_id,
        workspace_id,
        validation_status,
        **kwargs
    ):
        """List all Scenarios by validation status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_all_scenarios_by_validation_status(organization_id, workspace_id, validation_status, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            validation_status (ScenarioValidationStatus): the Scenario Validation Status

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Scenario]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['validation_status'] = \
            validation_status
        return self.find_all_scenarios_by_validation_status_endpoint.call_with_http_info(**kwargs)

    def find_scenario_by_id(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        **kwargs
    ):
        """Get the details of an scenario  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_scenario_by_id(organization_id, workspace_id, scenario_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Scenario
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        return self.find_scenario_by_id_endpoint.call_with_http_info(**kwargs)

    def get_scenario_data_download_job_info(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        download_id,
        **kwargs
    ):
        """Get Scenario data download URL  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scenario_data_download_job_info(organization_id, workspace_id, scenario_id, download_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier
            download_id (str): the Scenario Download identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioDataDownloadInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        kwargs['download_id'] = \
            download_id
        return self.get_scenario_data_download_job_info_endpoint.call_with_http_info(**kwargs)

    def get_scenario_validation_status_by_id(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        **kwargs
    ):
        """Get the validation status of an scenario  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scenario_validation_status_by_id(organization_id, workspace_id, scenario_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ScenarioValidationStatus
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        return self.get_scenario_validation_status_by_id_endpoint.call_with_http_info(**kwargs)

    def get_scenarios_tree(
        self,
        organization_id,
        workspace_id,
        **kwargs
    ):
        """Get the Scenarios Tree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scenarios_tree(organization_id, workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Scenario]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_scenarios_tree_endpoint.call_with_http_info(**kwargs)

    def remove_all_scenario_parameter_values(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        **kwargs
    ):
        """Remove all Parameter Values from the Scenario specified  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_all_scenario_parameter_values(organization_id, workspace_id, scenario_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        return self.remove_all_scenario_parameter_values_endpoint.call_with_http_info(**kwargs)

    def remove_all_users_of_scenario(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        **kwargs
    ):
        """Remove all users from the Scenario specified  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_all_users_of_scenario(organization_id, workspace_id, scenario_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        return self.remove_all_users_of_scenario_endpoint.call_with_http_info(**kwargs)

    def remove_user_from_scenario(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        user_id,
        **kwargs
    ):
        """Remove the specified user from the given Scenario  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_user_from_scenario(organization_id, workspace_id, scenario_id, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier
            user_id (str): the User identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        kwargs['user_id'] = \
            user_id
        return self.remove_user_from_scenario_endpoint.call_with_http_info(**kwargs)

    def update_scenario(
        self,
        organization_id,
        workspace_id,
        scenario_id,
        scenario,
        **kwargs
    ):
        """Update a scenario  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_scenario(organization_id, workspace_id, scenario_id, scenario, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            workspace_id (str): the Workspace identifier
            scenario_id (str): the Scenario identifier
            scenario (Scenario): the new Scenario details.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Scenario
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['scenario_id'] = \
            scenario_id
        kwargs['scenario'] = \
            scenario
        return self.update_scenario_endpoint.call_with_http_info(**kwargs)

