"""
    Cosmo Tech Plaform API

    Cosmo Tech Platform API  # noqa: E501

    The version of the OpenAPI document: 0.0.13-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cosmotech_api.api_client import ApiClient, Endpoint as _Endpoint
from cosmotech_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cosmotech_api.model.dataset import Dataset
from cosmotech_api.model.dataset_compatibility import DatasetCompatibility
from cosmotech_api.model.dataset_copy_parameters import DatasetCopyParameters
from cosmotech_api.model.dataset_search import DatasetSearch


class DatasetApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_or_replace_dataset_compatibility_elements_endpoint = _Endpoint(
            settings={
                'response_type': ([DatasetCompatibility],),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/datasets/{dataset_id}/compatibility',
                'operation_id': 'add_or_replace_dataset_compatibility_elements',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'dataset_id',
                    'dataset_compatibility',
                ],
                'required': [
                    'organization_id',
                    'dataset_id',
                    'dataset_compatibility',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'dataset_compatibility':
                        ([DatasetCompatibility],),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'dataset_id': 'path',
                    'dataset_compatibility': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.copy_dataset_endpoint = _Endpoint(
            settings={
                'response_type': (DatasetCopyParameters,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/datasets/copy',
                'operation_id': 'copy_dataset',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'dataset_copy_parameters',
                ],
                'required': [
                    'organization_id',
                    'dataset_copy_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'dataset_copy_parameters':
                        (DatasetCopyParameters,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'dataset_copy_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/yaml'
                ]
            },
            api_client=api_client
        )
        self.create_dataset_endpoint = _Endpoint(
            settings={
                'response_type': (Dataset,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/datasets',
                'operation_id': 'create_dataset',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'dataset',
                ],
                'required': [
                    'organization_id',
                    'dataset',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'dataset':
                        (Dataset,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'dataset': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/yaml'
                ]
            },
            api_client=api_client
        )
        self.delete_dataset_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/datasets/{dataset_id}',
                'operation_id': 'delete_dataset',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'dataset_id',
                ],
                'required': [
                    'organization_id',
                    'dataset_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'dataset_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'dataset_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.find_all_datasets_endpoint = _Endpoint(
            settings={
                'response_type': ([Dataset],),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/datasets',
                'operation_id': 'find_all_datasets',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                ],
                'required': [
                    'organization_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                },
                'location_map': {
                    'organization_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.find_dataset_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (Dataset,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/datasets/{dataset_id}',
                'operation_id': 'find_dataset_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'dataset_id',
                ],
                'required': [
                    'organization_id',
                    'dataset_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'dataset_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'dataset_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_all_dataset_compatibility_elements_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/datasets/{dataset_id}/compatibility',
                'operation_id': 'remove_all_dataset_compatibility_elements',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'dataset_id',
                ],
                'required': [
                    'organization_id',
                    'dataset_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'dataset_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'dataset_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.search_datasets_endpoint = _Endpoint(
            settings={
                'response_type': ([Dataset],),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/datasets/search',
                'operation_id': 'search_datasets',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'dataset_search',
                ],
                'required': [
                    'organization_id',
                    'dataset_search',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'dataset_search':
                        (DatasetSearch,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'dataset_search': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/yaml'
                ]
            },
            api_client=api_client
        )
        self.update_dataset_endpoint = _Endpoint(
            settings={
                'response_type': (Dataset,),
                'auth': [
                    'oAuth2AuthCode'
                ],
                'endpoint_path': '/organizations/{organization_id}/datasets/{dataset_id}',
                'operation_id': 'update_dataset',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'dataset_id',
                    'dataset',
                ],
                'required': [
                    'organization_id',
                    'dataset_id',
                    'dataset',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'dataset':
                        (Dataset,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'dataset_id': 'path',
                    'dataset': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/yaml'
                ]
            },
            api_client=api_client
        )

    def add_or_replace_dataset_compatibility_elements(
        self,
        organization_id,
        dataset_id,
        dataset_compatibility,
        **kwargs
    ):
        """Add Dataset Compatibility elements.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_or_replace_dataset_compatibility_elements(organization_id, dataset_id, dataset_compatibility, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            dataset_id (str): the Dataset identifier
            dataset_compatibility ([DatasetCompatibility]): the Dataset Compatibility elements

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [DatasetCompatibility]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['dataset_compatibility'] = \
            dataset_compatibility
        return self.add_or_replace_dataset_compatibility_elements_endpoint.call_with_http_info(**kwargs)

    def copy_dataset(
        self,
        organization_id,
        dataset_copy_parameters,
        **kwargs
    ):
        """Copy a Dataset to another Dataset. Source must have a read capable connector and Target a write capable connector.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.copy_dataset(organization_id, dataset_copy_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            dataset_copy_parameters (DatasetCopyParameters): the Dataset copy parameters

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DatasetCopyParameters
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['dataset_copy_parameters'] = \
            dataset_copy_parameters
        return self.copy_dataset_endpoint.call_with_http_info(**kwargs)

    def create_dataset(
        self,
        organization_id,
        dataset,
        **kwargs
    ):
        """Create a new Dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_dataset(organization_id, dataset, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            dataset (Dataset): the Dataset to create

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dataset
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['dataset'] = \
            dataset
        return self.create_dataset_endpoint.call_with_http_info(**kwargs)

    def delete_dataset(
        self,
        organization_id,
        dataset_id,
        **kwargs
    ):
        """Delete a dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_dataset(organization_id, dataset_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            dataset_id (str): the Dataset identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['dataset_id'] = \
            dataset_id
        return self.delete_dataset_endpoint.call_with_http_info(**kwargs)

    def find_all_datasets(
        self,
        organization_id,
        **kwargs
    ):
        """List all Datasets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_all_datasets(organization_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Dataset]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        return self.find_all_datasets_endpoint.call_with_http_info(**kwargs)

    def find_dataset_by_id(
        self,
        organization_id,
        dataset_id,
        **kwargs
    ):
        """Get the details of a Dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_dataset_by_id(organization_id, dataset_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            dataset_id (str): the Dataset identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dataset
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['dataset_id'] = \
            dataset_id
        return self.find_dataset_by_id_endpoint.call_with_http_info(**kwargs)

    def remove_all_dataset_compatibility_elements(
        self,
        organization_id,
        dataset_id,
        **kwargs
    ):
        """Remove all Dataset Compatibility elements from the Dataset specified  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_all_dataset_compatibility_elements(organization_id, dataset_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            dataset_id (str): the Dataset identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['dataset_id'] = \
            dataset_id
        return self.remove_all_dataset_compatibility_elements_endpoint.call_with_http_info(**kwargs)

    def search_datasets(
        self,
        organization_id,
        dataset_search,
        **kwargs
    ):
        """Search Datasets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_datasets(organization_id, dataset_search, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            dataset_search (DatasetSearch): the Dataset search parameters

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Dataset]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['dataset_search'] = \
            dataset_search
        return self.search_datasets_endpoint.call_with_http_info(**kwargs)

    def update_dataset(
        self,
        organization_id,
        dataset_id,
        dataset,
        **kwargs
    ):
        """Update a dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_dataset(organization_id, dataset_id, dataset, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str): the Organization identifier
            dataset_id (str): the Dataset identifier
            dataset (Dataset): the new Dataset details.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dataset
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['dataset'] = \
            dataset
        return self.update_dataset_endpoint.call_with_http_info(**kwargs)

