from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.0.2'
DESCRIPTION = 'Library to learn git'
LONG_DESCRIPTION = 'A package that allows to query git commands easily'

# Setting up
setup(
    name="easygit1",
    version=VERSION,
    author="Sharan",
    author_email="sharanbabu2001@gmail.com",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=open('README.md').read(),
    packages=find_packages(),
    install_requires=['wit', 'colorama'],
    keywords=['python', 'wit', 'git'],
    classifiers=[
        "Development Status :: 1 - Planning",
    ]
)
