from enum import auto

from .auto_name import AutoName


class ParseMode(AutoName):
    """Parse mode enumeration used in various places to set a specific parse mode"""

    DEFAULT = auto()
    "Default mode. Markdown and HTML combined"

    MARKDOWN = auto()
    "Markdown only mode"

    HTML = auto()
    "HTML only mode"

    DISABLED = auto()
    "Disabled mode"
