"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk8s_1 = require("cdk8s");
const redis_1 = require("./redis");
test('defaults', () => {
    // GIVEN
    const app = cdk8s_1.Testing.app();
    const chart = new cdk8s_1.Chart(app, 'test');
    // WHEN
    const redis = new redis_1.Redis(chart, 'redis');
    // THEN
    expect(cdk8s_1.Testing.synth(chart)).toMatchSnapshot();
    expect(redis.masterHost).toEqual('test-redis-master-service-54ad70b8');
    expect(redis.slaveHost).toEqual('test-redis-slave-service-aad78a45');
});
test('no slave replicas will deploy only the master', () => {
    // GIVEN
    const app = cdk8s_1.Testing.app();
    const chart = new cdk8s_1.Chart(app, 'test');
    // WHEN
    const redis = new redis_1.Redis(chart, 'redis', {
        slaveReplicas: 0,
    });
    // THEN
    expect(cdk8s_1.Testing.synth(chart)).toMatchSnapshot();
    expect(redis.masterHost).toEqual('test-redis-master-service-54ad70b8');
    expect(redis.masterHost).toEqual(redis.slaveHost); // slave = master
});
test('labels can be added', () => {
    // GIVEN
    const app = cdk8s_1.Testing.app();
    const chart = new cdk8s_1.Chart(app, 'test');
    // WHEN
    new redis_1.Redis(chart, 'redis', {
        labels: {
            mylabel: '1234',
        },
    });
    // THEN
    const resources = cdk8s_1.Testing.synth(chart);
    for (const svc of resources.filter(r => r.kind === 'Service')) {
        expect(svc.metadata.labels.mylabel).toEqual('1234');
    }
    for (const dep of resources.filter(r => r.kind === 'Deployment')) {
        expect(dep.spec.selector.matchLabels.mylabel).toEqual('1234');
        expect(dep.spec.template.metadata.labels.mylabel).toEqual('1234');
    }
});
//# sourceMappingURL=data:application/json;base64,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