"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const license_list_1 = require("./backend/license-list");
const orchestration_1 = require("./backend/orchestration");
const package_stats_1 = require("./backend/package-stats");
const constants_1 = require("./backend/shared/constants");
const repository_1 = require("./codeartifact/repository");
const monitoring_1 = require("./monitoring");
const package_sources_1 = require("./package-sources");
const spdx_license_1 = require("./spdx-license");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        super(scope, id);
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
        });
        const packageData = new s3.Bucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                {
                    noncurrentVersionTransitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: core_1.Duration.days(31),
                        },
                    ],
                },
                // Permanently delete non-current object versions after 3 months
                {
                    noncurrentVersionExpiration: core_1.Duration.days(90),
                    expiredObjectDeleteMarker: true,
                },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const codeArtifact = new repository_1.Repository(this, 'CodeArtifact', {
            description: 'Proxy to npmjs.com for ConstructHub',
            domainName: (_b = props.codeArtifactDomain) === null || _b === void 0 ? void 0 : _b.name,
            domainExists: props.codeArtifactDomain != null,
            upstreams: (_c = props.codeArtifactDomain) === null || _c === void 0 ? void 0 : _c.upstreams,
        });
        const { vpc, vpcEndpoints, vpcSubnets } = this.createVpc(props, codeArtifact);
        const denyList = new backend_1.DenyList(this, 'DenyList', {
            rules: (_d = props.denyList) !== null && _d !== void 0 ? _d : [],
            packageDataBucket: packageData,
            packageDataKeyPrefix: constants_1.STORAGE_KEY_PREFIX,
            monitoring: monitoring,
        });
        // disable fetching package stats by default if a different package
        // source is configured
        const fetchPackageStats = (_e = props.fetchPackageStats) !== null && _e !== void 0 ? _e : (props.packageSources ? false : true);
        let packageStats;
        const statsKey = 'stats.json';
        if (fetchPackageStats) {
            packageStats = new package_stats_1.PackageStats(this, 'Stats', {
                bucket: packageData,
                monitoring,
                logRetention: props.logRetention,
                objectKey: statsKey,
            });
        }
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            denyList,
            logRetention: props.logRetention,
            monitoring,
            vpc,
            vpcEndpoints,
            vpcSubnets,
        });
        // rebuild the catalog when the deny list changes.
        denyList.prune.onChangeInvoke(orchestration.catalogBuilder.function);
        const packageTagsSerialized = (_g = (_f = props.packageTags) === null || _f === void 0 ? void 0 : _f.map((config) => {
            return {
                ...config,
                condition: config.condition.bind(),
            };
        })) !== null && _g !== void 0 ? _g : [];
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', {
            bucket: packageData,
            codeArtifact,
            orchestration,
            logRetention: props.logRetention,
            monitoring,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
        });
        const licenseList = new license_list_1.LicenseList(this, 'LicenseList', {
            licenses: (_h = props.allowedLicenses) !== null && _h !== void 0 ? _h : [
                ...spdx_license_1.SpdxLicense.apache(),
                ...spdx_license_1.SpdxLicense.bsd(),
                ...spdx_license_1.SpdxLicense.mit(),
            ],
        });
        const sources = new core_1.Construct(this, 'Sources');
        const packageSources = ((_j = props.packageSources) !== null && _j !== void 0 ? _j : [new package_sources_1.NpmJs()]).map((source) => source.bind(sources, {
            denyList,
            ingestion: this.ingestion,
            licenseList,
            monitoring,
            queue: this.ingestion.queue,
            repository: codeArtifact,
        }));
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, logRetention: props.logRetention, monitoring });
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', {
            packageData,
            dashboardName: props.backendDashboardName,
            packageSources,
            ingestion: this.ingestion,
            inventory,
            orchestration,
            denyList,
            packageStats,
        });
        new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
            featuredPackages: props.featuredPackages,
            packageStats,
            featureFlags: props.featureFlags,
        });
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
    createVpc(props, codeArtifact) {
        if (props.isolateSensitiveTasks === false) {
            return { vpc: undefined, vpcEndpoints: undefined, vpcSubnets: undefined };
        }
        const vpc = new ec2.Vpc(this, 'Lambda-VPC', {
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 0,
            // Pre-allocating PUBLIC / PRIVATE / INTERNAL subnets, regardless of use, so we don't create
            // a whole new VPC if we ever need to introduce subnets of these types.
            subnetConfiguration: [
                // If there is a PRIVATE subnet, there must also have a PUBLIC subnet (for NAT gateways).
                { name: 'Public', subnetType: ec2.SubnetType.PUBLIC, reserved: true },
                { name: 'Private', subnetType: ec2.SubnetType.PRIVATE, reserved: true },
                { name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED },
            ],
        });
        const vpcSubnets = { subnetType: ec2.SubnetType.ISOLATED };
        // We'll only use VPC endpoints if we are configured to run in an ISOLATED subnet.
        const vpcEndpoints = {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: vpcSubnets,
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: vpcSubnets,
            }),
            // This is needed so that ECS workloads can use the awslogs driver
            cloudWatchLogs: vpc.addInterfaceEndpoint('CloudWatch.Logs', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS,
                subnets: vpcSubnets,
            }),
            // These are needed for ECS workloads to be able to pull images
            ecrApi: vpc.addInterfaceEndpoint('ECR.API', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR,
                subnets: vpcSubnets,
            }),
            ecr: vpc.addInterfaceEndpoint('ECR.Docker', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER,
                subnets: vpcSubnets,
            }),
            // This is needed (among others) for CodeArtifact registry usage
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [vpcSubnets],
            }),
            // This is useful for getting results from ECS tasks within workflows
            stepFunctions: vpc.addInterfaceEndpoint('StepFunctions', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.STEP_FUNCTIONS,
                subnets: vpcSubnets,
            }),
        };
        // The S3 access is necessary for the CodeArtifact Repository and ECR Docker
        // endpoints to be used (they serve objects from S3).
        vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [
                // The in-region CodeArtifact S3 Bucket
                `${codeArtifact.s3BucketArn}/*`,
                // The in-region ECR layer bucket
                `arn:aws:s3:::prod-${core_1.Stack.of(this).region}-starport-layer-bucket/*`,
            ],
            // It doesn't seem we can constrain principals for these grants (unclear
            // which principal those calls are made from, or if that is something we
            // could name here).
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-and-ECR',
        }));
        return { vpc, vpcEndpoints, vpcSubnets };
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.3.36" };
//# sourceMappingURL=data:application/json;base64,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