"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reset = exports.codeArtifact = exports.lambda = exports.stepFunctions = exports.sqs = exports.s3ObjectExists = exports.s3 = void 0;
const _AWS = require("aws-sdk");
const AWSXRay = require("aws-xray-sdk-core");
// Do nothing if there is no XRay trace context
AWSXRay.setContextMissingStrategy(() => { });
const AWS = AWSXRay.captureAWS(_AWS);
let _s3;
let _sqs;
let _sfn;
let _lambda;
let _codeArtifact;
function s3() {
    if (_s3 == null) {
        _s3 = new AWS.S3();
    }
    return _s3;
}
exports.s3 = s3;
/**
 * Checks whether an object exists in S3 at the provided bucket and key.
 */
function s3ObjectExists(bucket, key) {
    return s3().headObject({
        Bucket: bucket,
        Key: key,
    }).promise()
        .then(() => true, (cause) => {
        if (cause.code === 'NotFound') {
            return false;
        }
        return Promise.reject(cause);
    });
}
exports.s3ObjectExists = s3ObjectExists;
function sqs() {
    if (_sqs == null) {
        _sqs = new AWS.SQS();
    }
    return _sqs;
}
exports.sqs = sqs;
function stepFunctions() {
    if (_sfn == null) {
        _sfn = new AWS.StepFunctions();
    }
    return _sfn;
}
exports.stepFunctions = stepFunctions;
function lambda() {
    if (_lambda == null) {
        _lambda = new AWS.Lambda();
    }
    return _lambda;
}
exports.lambda = lambda;
function codeArtifact() {
    if (_codeArtifact == null) {
        _codeArtifact = new AWS.CodeArtifact();
    }
    return _codeArtifact;
}
exports.codeArtifact = codeArtifact;
/**
 * Resets all clients vended by this module. This is useful in unit tests when
 * `aws-sdk-mocks` is used, so that new mocks are injected as intended.
 */
function reset() {
    _s3 = _sqs = _sfn = _lambda = _codeArtifact = undefined;
}
exports.reset = reset;
//# sourceMappingURL=data:application/json;base64,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