# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['base24_builder']

package_data = \
{'': ['*']}

modules = \
['base24']
install_requires = \
['PyYAML>=6.0,<7', 'aiofiles>=0.8.0,<2', 'pystache>=0.6.0,<2']

entry_points = \
{'console_scripts': ['base24 = base24_builder.cli:run']}

setup_kwargs = {
    'name': 'base24builder',
    'version': '2022',
    'description': 'A base 24 builder written in Python',
    'long_description': '[![Github top language](https://img.shields.io/github/languages/top/Base24/base24-builder-python.svg?style=for-the-badge)](../../)\n[![Codacy grade](https://img.shields.io/codacy/grade/3479c0638ef54d57839343ad4be367e0.svg?style=for-the-badge)](https://www.codacy.com/gh/Base24/base24-builder-python)\n[![Repository size](https://img.shields.io/github/repo-size/Base24/base24-builder-python.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/Base24/base24-builder-python.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/Base24/base24-builder-python.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/Base24/base24-builder-python.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/Base24/base24-builder-python.svg?style=for-the-badge)](../../commits/master)\n[![PyPI](https://img.shields.io/pypi/dm/base24builder.svg?style=for-the-badge)](https://pypi.org/project/base24builder/)\n\n<!-- omit in TOC -->\n# base24-builder-python\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nA base 24 builder written in Python\n\nThank you to https://github.com/InspectorMustache/base16-builder-python (MIT)\nfor the original base16-builder\n\n- [Installation](#installation)\n- [Install With PIP](#install-with-pip)\n- [Usage](#usage)\n\t- [Basic Usage](#basic-usage)\n\t- [Update](#update)\n\t- [Build](#build)\n\t- [Inject](#inject)\n\t- [Exit](#exit)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [How to update, build and publish](#how-to-update-build-and-publish)\n- [Download](#download-1)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\n## Installation\nAs this project uses async/await syntax, the lowest supported Python version is\n3.5.\n\n## Install With PIP\n\n```python\npip install base24builder\n```\n\nHead to https://pypi.org/project/base24builder/ for more info\n\n\n## Usage\nThere are three modes of operation:\n\n```bash\n./base24.py update\n./base24.py build\n./base24.py inject\n```\n\n### Basic Usage\n\nIf you just want to build all base24 colorschemes and then pick out the ones you\nneed, simply run:\n```bash\n./base24.py update\n./base24.py build\n```\n\nOnce the process is finished, you can find all colorschemes in a folder named\noutput located in the current working directory.\n\nFor a more detailed explanation of the individual commands, read on.\n\n### Update\n\nDownloads all base24/ base16 schemes and templates to the current working\ndirectory.\nThe source files, i.e. the files pointing to the scheme and template\nrepositories\n\n\nwill also be updated by default.  If you want to use your own versions of these\nfiles (to exclude specific repositories, for example), you can prevent the\nbuilder from updating the source files by using the `-c/--custom` option.\n\nYou can use `-v/--verbose` for more detailed output.\n\n### Build\n\nBuilds base24 colorschemes for all schemes and templates.  This requires the\ndirectory structure and files created by the update operation to be present in\nthe working directory.  This operation accepts four parameters:\n\n- `-s/--scheme` restricts building to specific schemes\n\n  Can be specified more than once.  Each argument must match a scheme.\n  Wildcards can be used but must be escaped properly so they are not expanded\n  by the shell.\n\n- `-t/--template` restricts building to specific templates\n\n  Can be specified more than once.  Each argument must correspond to a folder\n  name in the templates directory.\n\n- `-o/--output` specifies a path where built colorschemes will be placed\n\n  If this option is not specified, an "output" folder in the current working\n  directory will be created and used.\n\n- `-v/--verbose` increases verbosity\n\n  With this option specified the builder prints out the name of each scheme as\n  it\'s built.\n\nExample:\n```bash\n./base24.py build -t dunst -s atelier-heath-light -o /tmp/output\n```\n\n### Inject\n\nThis operation provides an easier way to quickly insert a specific colorscheme\ninto one or more config files.  In order for the builder to locate the necessary\nfiles, this command relies on the folder structure created by the update\ncommand.  The command accepts two parameters:\n\n- `-s/--scheme` specifies the scheme you wish to inject\n\n  Refers to the scheme that should be inserted.  You can use wildcards and the\n  same restrictions as with update apply.  A pattern that matches more than one\n  scheme will cause an error.\n\n- `-f/--file` specifies the file(s) into which you wish the scheme to be\n  inserted\n\n  Can be specified more than once.  Each argument must be specified as a path\n  to a config file that features proper injection markers (see below).\n\nYou will need to prepare your configuration files so that the script knows where\nto insert the colorscheme.  This is done by including two lines in the file\n```bash\n# %%base24_template: TEMPLATE_NAME##SUBTEMPLATE_NAME %%\n\nEverything in-between these two lines will be replaced with the colorscheme.\n\n# %%base24_template_end%%\n```\n\nBoth lines can feature arbitrary characters before the first two percentage\nsigns.  This is so as to accomodate different commenting styles.  Both lines\nneed to end exactly as demonstrated above, however.  "TEMPLATE_NAME" and\n"SUBTEMPLATE_NAME" are the exception to this.  Replace TEMPLATE_NAME with the\nname of the template you wish to insert, for example "gnome-terminal".  This\nmust correspond to a folder in the templates directory.  Replace\nSUBTEMPLATE_NAME with the name of the subtemplate as it is defined at the\ntop level of the template\'s config.yaml file (see\n`file.md <https://github.com/chriskempson/base16/blob/master/file.md>`_ for\ndetails), for example "default-256".  If you omit the subtemplate name (don\'t\nomit "##" though), "default" is assumed.\n\n\n\nSpecify the name of the scheme you wish to inject with the -s option.  Use the\n-f option for each file into which you want to inject the scheme.\n\nAs an example, here\'s the command I use to globally change the color scheme in\nall applications that support it:\n```bash\n./base24.py inject -s ocean -f ~/.gtkrc-2.0.mine -f ~/.config/dunst/dunstrc -f\n~/.config/i3/config -f ~/.config/termite/config -f ~/.config/zathura/zathurarc\n```\n\n### Exit\n\nThe program exits with exit code 1 if it encountered a general error and with\n2 if one or more build or update tasks produced a warning or an error.\n\n\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.8.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.8\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.8 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.8)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n## How to update, build and publish\n\n1. Ensure you have installed the following dependencies\n\tLinux\n\t```bash\n\twget dephell.org/install | python3.8\n\twget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python3.8\n\t```\n\tWindows\n\t```powershell\n\t(wget dephell.org/install -UseBasicParsing).Content | python\n\t(wget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py -UseBasicParsing).Content | python\n\t```\n2. Use poetry for the heavy lifting and dephell to generate requirements\n\t```bash\n\tpoetry update\n\tdephell deps convert\n\t```\n3. Build/ Publish\n\t```bash\n\tpoetry build\n\tpoetry publish\n\t```\n\tor\n\t```bash\n\tpoetry publish --build\n\t```\n\n\n## Download\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\n$ git clone https://github.com/Base24/base24-builder-python\n```\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\nIf you don\'t want to clutter your computer with something that you\'re just\ngoing to use once you can also just clone this repository and use the provided base24.py file.\n\n## Community Files\n### Licence\nMIT License\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nIn the interest of fostering an open and welcoming environment, we\nas contributors and maintainers pledge to make participation in our\nproject and our community a harassment-free experience for everyone.\nPlease see the\n[Code of Conduct](https://github.com/Base24/.github/blob/master/CODE_OF_CONDUCT.md) for more information.\n\n### Contributing\nContributions are welcome, please see the [Contributing Guidelines](https://github.com/Base24/.github/blob/master/CONTRIBUTING.md) for more information.\n\n### Security\nThank you for improving the security of the project, please see the [Security Policy](https://github.com/Base24/.github/blob/master/SECURITY.md) for more information.\n',
    'author': 'Base24',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Base24/base24-builder-python',
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
