      B        Xy  

import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from datetime import *
### Data api
import yfinance as yf


### calculate Beta and aplpha
from scipy.stats import linregress
### optimize the portfolio weight
from scipy.optimize import minimize
import requests
import os,sys
MC_URL="https://github.com/BabakEA/witcher/raw/master/Modern_portfolio/MC.pkl"
import pickle
import plotly.express as px
import plotly.graph_objects as go
from ipywidgets import HBox, Layout, VBox , Label
import ipywidgets as widgets
#pd.options.plotting.backend = "plotly"






class Modern_portfolio_optimizer:
    '''
    
        Help:
        portfolio=['COST', 'WMT', 'TGT', 'DG']
        report=Modern_portfolio_optimizer(portfolio,close="Adj Close",BASE="spy",start="2010-01-01",end="Today")
        
        to get raw data : Dataset.keys()
        dict_keys(['retail', 'COST', 'WMT', 'TGT', 'DG', 'spy',
        'Daily_return', 'cumul_return', 'cumul_return_percent',
        'log_return', 'log_rets_cov'])
        
        like to get :
            Daily cumulative Return value : Dataset["cumul_return"]
            Daily Log Return value : Dataset["log_return"] ,...
            
        to get the model report and analysis:
        New.PortFolio_Report.keys()
        dict_keys(['Gain', 'PLOT', 'Best_Weight', '__Optimized_MC', 
       'Volatility', 'Optimized_MC'])        
        
        to plot the repors use the ["PLOT"] key  like:
            PortFolio_Report["PLOT"].keys()
            dict_keys(['MC', 'Portfolio_vs_Market', 'Absolute', 'Percentage'])
            
            
            ### Portfolio Optimizer using Pareto front troy - Montgomery
            PortFolio_Report["PLOT"]["MC"]()
            
            get the best waight : 
            print(New.Portfolio,"
",
            PortFolio_Report["Best_Weight"]["Optimized_MC"])
            # ['COST', 'WMT', 'TGT', 'DG'] 
            # [7.58208406e-01 1.13570178e-17 7.29673180e-03 2.34494862e-01]
            
            to get the possible return / Gain
            
            PortFolio_Report["Gain"]
            #{'Absolute_Gain': 329.54077911376953, 'Percentage_Gain': 366.6077008076501}
            
        
    '''
        
    def __init__(self,portfolio,close="Adj Close",BASE="spy",start="2010-01-01",end="Today"):
        #self.BASE=BASE
        self.report=Portfolio_Analysis(portfolio,close,BASE,start,end)
        
        #report.help=


class Portfolio_Analysis:
    def __init__(self,portfolio,close="Adj Close",BASE="spy",start="2010-01-01",end="Today"):
        self.BASE=BASE
        if end in ["Today","today",""," ","TODAY"]:
            self.end=str(date.today())
        else:
            
            self.end=self.__Date_validatore(end,"0")#0 for last date


        self.start=self.__Date_validatore(start,"1")#1 for start
        
        
        if self.start>self.end:
            STR_date=self.start
            self.start=self.end
            self.end=STR_date 
            


        #self.SP500=yf.download("sp500",start='2010-01-01',end=str(Today))
        self.Portfolio=portfolio
        # initial portfolio weight
        self.Equal_weight=[1/len(self.Portfolio) for x in self.Portfolio]
        #portfolio report
        self.PortFolio_Report={"Gain":{},
            "PLOT":{},
            "Best_Weight":{},
            "Volatility":{},"IV":{}}
        #self.PortFolio_Report["Volatility"]={}
        
        #dataset
        self.Dataset={}
        #self.Dataset["retail"]=pd.DataFrame(columns=(["Date"]+self.Portfolio)).set_index("Date")
        self.Dataset["retail"]=pd.DataFrame(columns=(["Date"]+self.Portfolio)).set_index("Date")
        for Sym in portfolio+[BASE]:##### add closing value to retail dataset
            tem= yf.download(Sym,start=self.start,end=self.end)
            #tem=tem(index_col='Date',parse_dates=True)
            #self.PortFolio_Report[Sym]={}
            self.Dataset[Sym]=tem
            if len(self.Dataset["retail"])>2:
                self.Dataset["retail"][Sym]=tem[close]
            else:
                #self.Dataset["retail"].index=tem.index
                self.Dataset["retail"]=pd.DataFrame(index=tem.index.tolist(),columns=(self.Portfolio))
                self.Dataset["retail"][Sym]=tem[close]
            #self.Dataset["retail"]=self.Dataset["retail"].replace([np.inf, -np.inf,np.nan], 0)
                
            ### calulat the return values
            self.__Return_Analysis(Sym,close) ####### calculate the daily return percantage : 
        
        ### calculate Daily_return Value
        self.Dataset["Daily_return"] = self.Dataset["retail"].pct_change(1).dropna()
        #self.Dataset["Daily_return"]=self.Dataset["Daily_return"].replace([np.inf, -np.inf,np.nan], 0)
        ### cululative return percentage
        self.Dataset["cumul_return"]=(1 + self.Dataset["Daily_return"]).cumprod() - 1
        #self.Dataset["cumul_return"] = self.Dataset["cumul_return"].replace([np.inf, -np.inf,np.nan], 0)
        
        self.Dataset["cumul_return_percent"]=100*self.Dataset["cumul_return"]
        self.Dataset["cumul_return_percent"] = self.Dataset["cumul_return_percent"].replace([np.inf, -np.inf,np.nan], 0)
        ### Log return value
        #self.Dataset["log_return"]= np.log1p(self.Dataset["retail"]/self.Dataset["retail"].shift(1)).dropna()
        self.Dataset["log_return"]= np.log(self.Dataset["retail"]/self.Dataset["retail"].shift(1)).dropna()
        self.Dataset["log_return"]=self.Dataset["log_return"].replace([np.inf, -np.inf], 0)
        

        self.Dataset["log_rets_cov"]=self.Dataset["log_return"].cov()
        #self.Dataset.replace([np.inf, -np.inf], 0)
        ########################################
        self.__Dispatcher()

        self.PortFolio_Report["PLOT"]["Absolute"]=self.__Absolute_Plot
        self.PortFolio_Report["PLOT"]["Percentage"]=self.__Percentage_Plot
        self.PortFolio_Report["PLOT"]["Selected_Stock"]=self.__Selected_Stock
        
    def __Date_validatore(self,STR_date,ID):
        ID_IDCT={"1":str(date.today()),
                "0":str(STR_date)}

        Date_format = "%Y-%m-%d"
        # using try-except to check for truth value
        try:
            if bool(datetime.strptime(STR_date, Date_format)) and datetime.strptime(STR_date, Date_format) <= datetime.today():
                return str(datetime.strptime(STR_date, Date_format)).split(" ")[0]
            else:
                print("please make sure you are not selecting a day that not yet come")
                #break
                #return  ID_IDCT[ID]
                if ID ==1:
                    return  "2015-01-01"
                else:
                    return  ID_IDCT[ID]

        #except ValueError:
        except:
            print ("please make sure your selecting the correct format : year-month-day; like 2020-01-02")
            #return ID_IDCT[ID]
            return  "2020-01-01"
            #break

    ######## First Function 
    def __Gain_Return(self,weight,): ##### calculat gain, and portfolio, value
        # merge selected stocks using the optimised weight and extract a single portfolio daily price to analysis 
        self.Dataset["retail"]["Portfolio_dolar_value"]=(
                                                        np.dot(
                                                        weight,self.Dataset["retail"][self.Portfolio].transpose()
                                                        ))
        self.Dataset["retail"]["PortFolio_Cumulative_Absolute"]=(
                                                                self.Dataset["retail"]["Portfolio_dolar_value"] 
                                                                 - self.Dataset["retail"]["Portfolio_dolar_value"].iloc[0])
        self.Dataset["retail"]["PortFolio_Cumulative_Percentage"]=100* (
                                                                self.Dataset["retail"]["Portfolio_dolar_value"]
                                                       - self.Dataset["retail"]["Portfolio_dolar_value"].iloc[0]
                                                        )/self.Dataset["retail"]["Portfolio_dolar_value"].iloc[0]
        
        
        self.PortFolio_Report["Gain"]={
                                        "Absolute_Gain":self.Dataset["retail"]["Portfolio_dolar_value"].iloc[-1]
                                                        -self.Dataset["retail"]["Portfolio_dolar_value"].iloc[0],
            
                                        "Percentage_Gain":100*(self.Dataset["retail"]["Portfolio_dolar_value"].iloc[-1]-
                                        self.Dataset["retail"]["Portfolio_dolar_value"].iloc[0])/
                                                               (self.Dataset["retail"]["Portfolio_dolar_value"].iloc[0])
                                                               }  
        
        Market=self.BASE
#         self.Dataset["retail"]["Market_dolar_value"]=(
#                                                         np.dot(
#                                                         weight,self.Dataset["retail"][self.Portfolio].transpose()
#                                                         ))
        self.Dataset["retail"]["Market_Cumulative_Absolute"]=(
                                                                self.Dataset["retail"][self.BASE] 
                                                                 - self.Dataset["retail"][self.BASE].iloc[0])
        self.Dataset["retail"]["Market_Cumulative_Percentage"]=100* (
                                                                self.Dataset["retail"][self.BASE]
                                                       - self.Dataset["retail"][self.BASE].iloc[0]
                                                        )/self.Dataset["retail"][self.BASE].iloc[0]
        
        
        
        self.Dataset["retail"]["PortFolio_PCT"]=self.Dataset["retail"]["PortFolio_Cumulative_Percentage"]
        self.Dataset["retail"]["Market_PCT"]=self.Dataset["retail"]["Market_Cumulative_Percentage"]
        
        #####################   Portfolio VS market #####################
        self.Dataset["retail"]["Portfolio_Gain_over_Market"]=(
                                                            self.Dataset["retail"]["PortFolio_Cumulative_Absolute"]-
                                                            self.Dataset["retail"]["Market_Cumulative_Absolute"]
                                                                )
                                                            
        self.Dataset["retail"]["Portfolio_Percentage_over_Market"]=(
                                                            self.Dataset["retail"]["PortFolio_Cumulative_Percentage"]-
                                                            self.Dataset["retail"]["Market_Cumulative_Percentage"]
                                                                )
        self.Dataset["retail"]["Portfolio_vs_Market"]=(
                                                        self.Dataset["retail"]["PortFolio_Cumulative_Percentage"]-
                                                        self.Dataset["retail"]["Market_Cumulative_Percentage"]
                                                                )/(self.Dataset["retail"]["Market_Cumulative_Percentage"])
        self.Dataset["retail"]=self.Dataset["retail"].replace([np.inf, -np.inf,np.nan], 0)
        ##############################################################################################################
        
        
        self.PortFolio_Report["Gain"]={"Portfolio":{
                                        "Absolute_Gain":self.Dataset["retail"]["Portfolio_dolar_value"].iloc[-1]
                                                        -self.Dataset["retail"]["Portfolio_dolar_value"].iloc[0],
            
                                        "Percentage_Gain":100*(self.Dataset["retail"]["Portfolio_dolar_value"].iloc[-1]-
                                        self.Dataset["retail"]["Portfolio_dolar_value"].iloc[0])/
                                                               (self.Dataset["retail"]["Portfolio_dolar_value"].iloc[0])
                                                               },
                                       "Market":{
                                        "Absolute_Gain":self.Dataset["retail"][self.BASE].iloc[-1]
                                                        -self.Dataset["retail"][self.BASE].iloc[0],
            
                                        "Percentage_Gain":100*(self.Dataset["retail"][self.BASE].iloc[-1]-
                                        self.Dataset["retail"][self.BASE].iloc[0])/
                                                               (self.Dataset["retail"][self.BASE].iloc[0])
                                                               }
                                       }
                                      
        
        
        

    def __Return_Analysis(self,Sym,close):
        '''
        calculate the daily rerurn, 
        daily percenatage, 
        '''
        
        self.Dataset[Sym]["Cumulative_Absolute"]=(self.Dataset[Sym][close] 
                                                - self.Dataset[Sym][close].iloc[0]
                                                 )
        
        self.Dataset[Sym]["Cumulative_Percentage"]=100* (self.Dataset[Sym][close] - 
                                                       self.Dataset[Sym][close].iloc[0]
                                                        )/self.Dataset[Sym][close].iloc[0]
        self.Dataset[Sym]=self.Dataset[Sym].replace([np.inf, -np.inf,np.nan], 0)
        
        ##### Portfolio values must be added to the data set and then calulate the pos
        ##### possible gain/return and pesantage values
#         if Sym == "Portfolio":
            
#             self.PortFolio_Report["Gain"]={
#                                             "Absolute_Gain":self.Dataset[Sym][close].iloc[-1]-self.Dataset[Sym][close].iloc[0],
#                                             "Percentage_Gain":100*(self.Dataset[Sym][close].iloc[-1]-self.Dataset[Sym][close].iloc[0])/self.Dataset[Sym][close].iloc[0]}        
            
            
    ######## disparcher function to to generat the pain IV and sharp ration using equal weight        
    def __Dispatcher(self):
        ##### volitility : initially : calcualte the IV for each Stocks with the eqiual weight
        ### self.__Calculate_Volatility(self.Equal_weight) ## no need the equal wight 
        #### __Monte_Carlo Portfolio 
        self.__Monte_Carlo()
        #### Optimized:
        self.__Optimized_MC()
        ##### calculate the possible gain:
        self.__Gain_Return(self.PortFolio_Report["Best_Weight"]["Optimized_MC"])
        
        
    def __Calculate_Volatility(self,weights): ##### IV or Volatility 1st 
        #print(self.Dataset["log_rets_cov"][self.Portfolio])
        #print(np.dot(self.Dataset["log_rets_cov"][self.Portfolio]*252,weights))
        
        annualized_cov = np.dot(self.Dataset["log_rets_cov"][self.Portfolio].iloc[:-1]*252,weights)
        weights=np.array(weights)
        #print(annualized_cov)
        #print(self.Portfolio)
        vol = np.dot(weights.transpose(),annualized_cov)
        IV=np.sqrt(vol)
        #### keep Portfolio IV
        self.PortFolio_Report["Volatility"][str(weights)]= IV #####
        
        #self.PortFolio_Report["IV"][IV]=dict(zip(self.Portfolio,weights)) #### Iv , and shows it's components
        return IV        
        

    def __Monte_Carlo(self):
        self.mc_portfolio_returns = []
        self.mc_portfolio_vol = []
        self.mc_weights = []
        self.test={}
        for sim in range(2000):
            # This may take awhile!
            #weights = self.__Gen_Weights(N=4)
            weights = self.__Gen_Weights() #### generate new random weight
            self.mc_weights.append(weights)#### collect the weight
            
            self.mc_portfolio_returns.append(self.__Calculate_Returns(weights))
            
            #self.mc_portfolio_vol.append(self.__Calculate_Volatility(weights))
            IV=self.__Calculate_Volatility(weights)
            self.mc_portfolio_vol.append(IV)
            self.PortFolio_Report["IV"][IV]=dict(zip(self.Portfolio,weights)) #### Iv , and shows it's components


        self.mc_sharpe_ratios = np.array(self.mc_portfolio_returns)/np.array(self.mc_portfolio_vol)
        self.PortFolio_Report["PLOT"]["MC"]=self.__MC_plot
        self.PortFolio_Report["PLOT"]["_MC"]=self.__MC_PLT
        self.PortFolio_Report["Best_Weight"]["MC"]=self.mc_weights[np.argmax(self.mc_sharpe_ratios)]
        

    def __Gen_Weights(self):
        #### calculate the randome weight and normalise to sum(weight)==1
        weights = np.random.random(len(self.Portfolio))
        return weights/ np.sum(weights)
    
    def __Calculate_Returns(self,weights):
        
        return np.sum(self.Dataset["log_return"][self.Portfolio].iloc[:-1].mean()*weights) * 252 #Annualized Returns
        

    ####### Optimized sharp rashio:
    def __Optimized_MC(self):
        bounds = tuple((0,1) for n in range(len(self.Portfolio)))
        equal_weights=self.Equal_weight
        sum_constraint = ({'type': 'eq', 'fun': lambda weights: np.sum(weights)-1})
        report=minimize(fun=self.__Function_to_Minimize,x0=equal_weights,bounds=bounds,constraints=sum_constraint)
        self.PortFolio_Report["Optimized_MC"]=report
        self.PortFolio_Report["Best_Weight"]["Optimized_MC"]=np.around(report.x , decimals=3)  
        
        ##### round up the explored weights
        self.PortFolio_Report["Best_Weight"]["Report"]=dict(zip(self.Portfolio,np.round(report.x,3)))
        
        self.__Portfolio_vs_Market_Calculator()
        #__Portfolio_vs_Market(self)
        self.PortFolio_Report["PLOT"]["Portfolio_vs_Market"]=self.__Portfolio_vs_Market
        #self.OPT=report
        
        


        #report
        
        
    def __Function_to_Minimize(self,weights):
        # Note -1* because we need to minimize this
        ### BY MINIMIZING THE min sharp ration , we will maxmizing the positive sharp ration 
        # Its the same as maximizing the positive sharpe ratio
        ### -1* sharp_ratio/valitility
        return -1 * (self.__Calculate_Returns(weights)/self.__Calculate_Volatility(weights))
        

    
    
    def __Portfolio_vs_Market_Calculator(self):
        #np.sum(self.Dataset["log_return"][self.Portfolio].iloc[:-1].mean()*weights) * 252 #Annualized Returns
        Portfolio_weight = np.dot(self.PortFolio_Report["Best_Weight"]["Optimized_MC"],
                               self.Dataset["Daily_return"][self.Portfolio].transpose())
        
        cum_Portfolio_weight_returns =   (1 + Portfolio_weight).cumprod() - 1
        CUM_P_W_R_Prec=pd.Series(100 * cum_Portfolio_weight_returns)
        CUM_P_W_R_Prec.index=self.Dataset["Daily_return"][self.Portfolio].index
        #"cumul_return_percent"
        self.Dataset["Daily_return"]["Port_folio_cumul_return_percent"]=CUM_P_W_R_Prec
        self.Dataset["Daily_return"]["Port_folio_Bol_MA"]=self.Dataset["Daily_return"]["Port_folio_cumul_return_percent"].rolling(20).mean()
        self.Dataset["Daily_return"]["Port_folio_Bol_STD"]=self.Dataset["Daily_return"]["Port_folio_cumul_return_percent"].rolling(20).std()
        self.Dataset["Daily_return"]["Bol_Lower"]=self.Dataset["Daily_return"]["Port_folio_Bol_MA"]-2*self.Dataset["Daily_return"]["Port_folio_Bol_STD"]
        self.Dataset["Daily_return"]["Bol_Upper"]=self.Dataset["Daily_return"]["Port_folio_Bol_MA"]+2*self.Dataset["Daily_return"]["Port_folio_Bol_STD"]
        
        
        #### to calculate the buy-sell signal 
        self.Dataset["Daily_return"]["Port_folio_MA_60"]=self.Dataset["Daily_return"]["Port_folio_cumul_return_percent"].rolling(60).mean()
        self.Dataset["Daily_return"]["Port_folio_MA_14"]=self.Dataset["Daily_return"]["Port_folio_cumul_return_percent"].rolling(15).mean()

        
    ###################################################################################
    ###############################  PLOT  ############################################
    ############ Plots #######    
    def __Absolute_Plot(self,DF_list=[],Mode="Absolute"):

        Portfolio = px.line(
                      self.Dataset["retail"]["PortFolio_Cumulative_Absolute"],
                       labels="PortFolio_Profit" )
        Portfolio.update_traces(line=dict(color = 'rgba(255,155,5,0.9)'))
        Portfolio.data[0].name=="PortFolio_Profit"
        Portfolio.update_traces(
            customdata = self.Dataset["retail"][[
                                        "Portfolio_dolar_value","PortFolio_Cumulative_Absolute","PortFolio_Cumulative_Percentage",
                                        "Portfolio_Gain_over_Market","Portfolio_Percentage_over_Market"]].round(3).values,
                        hovertemplate = "<br>"+                           "<span style='font-weight:bold;color:blue'>Portfolio: </span> <span style='font-weight:bold;color:red'><b>%{y}</b></span><br>"+                           "<span style='font-weight:bold;color:blue'>Percentage_Gain:</span> <span style='font-weight:bold;color:red'>%{customdata[2]}</span><br>"+                           "<span style='font-weight:bold;color:blue'>Gain_over_Market:</span> <span style='font-weight:bold;color:red'><b> %{customdata[3]}</b> </span><br>"+                           "<span style='font-weight:bold;color:blue'>Percentage_over_Market:</span> <span style='font-weight:bold;color:red'><b> %{customdata[4]}</b></span><br>"+                           "<span style='font-weight:bold;color:blue'>Portfolio_value:</span> <span style='font-weight:bold;color:red'><b> %{customdata[0]}</b></span><br>");


        Market = px.area(self.Dataset["retail"]["Market_Cumulative_Absolute"])


        Market.update_traces(line=dict(color = 'rgba(0,250,0,0.9)')) 
                             

        Market.update_traces(
            customdata = self.Dataset["retail"][["spy","Market_Cumulative_Absolute","Market_Cumulative_Percentage"]].round(3).values,
                        hovertemplate = "<br>"+                           "<span style='font-weight:bold;color:blue'>Market: </span> <span style='font-weight:bold;color:red'><b>%{y}</b></span><br>"+                           "<span style='font-weight:bold;color:blue'>Percentage_Gain:</span> <span style='font-weight:bold;color:red'><b> %{customdata[2]}</b></span><br>"+                           "<span style='font-weight:bold;color:blue'>Market_value:</span> <span style='font-weight:bold;color:red'><b> %{customdata[0]}</b></span><br>");
        #fig2.update_yaxes(showspikes=True, spikecolor="orange", spikethickness=2)
        P_VS_M = go.Figure(data=Portfolio.data + Market.data)
        #P_VS_M.update_layout(title_text='Witcher Portfolio VS Market Cumulative Percantage Return')
        P_VS_M.update_layout( title={
                    'text' :'Witcher Portfolio VS Market Absolut Gain $',
                    'x':0.45,
                    'xanchor': 'center'})


        P_VS_M.update_layout(hovermode=("x unified"),hoverlabel=dict(bgcolor='rgba(160,170,180,0.50)'))

        P_VS_M.update_yaxes(showspikes=True, spikecolor="orange", spikethickness=2,title_text='Profit Absolut Gain')
        P_VS_M.update_xaxes(title_text='Date-Time/Daily')
        #P_VS_M.update_yaxes(title_text='Value A')
        P_VS_M.update_layout(legend=dict(
            yanchor="top",
            y=0.99,
            xanchor="left",
            x=0.01
        ),autosize=True,
                            width=900,
                            height=500
                            )

        P_VS_M.data[0].name = "PortFolio_Profit"
        P_VS_M.data[1].name = "Market_Profit"
        P_VS_M.show()
        
    def __Percentage_Plot(self,DF_list=[],Mode="Percentage"):

        
        Portfolio = px.line(
              self.Dataset["retail"]["PortFolio_PCT"],
              )
        Portfolio.update_traces(line=dict(color = 'rgba(255,155,5,0.9)'),
                               )

        Portfolio.update_traces(
            customdata = self.Dataset["retail"][[
                                        "Portfolio_dolar_value","PortFolio_Cumulative_Absolute","PortFolio_Cumulative_Percentage",
                                        "Portfolio_Gain_over_Market","Portfolio_Percentage_over_Market"]].round(3).values,
                        hovertemplate = "<br>"+                           "<span style='font-weight:bold;color:blue'>Portfolio: </span> <span style='font-weight:bold;color:red'><b>%{y}</b></span><br>"+                           "<span style='font-weight:bold;color:blue'>Absolut_Gain:</span> <span style='font-weight:bold;color:red'>%{customdata[1]}</span><br>"+                           "<span style='font-weight:bold;color:blue'>Gain_over_Market:</span> <span style='font-weight:bold;color:red'><b> %{customdata[3]}</b> </span><br>"+                           "<span style='font-weight:bold;color:blue'>Percentage_over_Market:</span> <span style='font-weight:bold;color:red'><b> %{customdata[4]}</b></span><br>"+                           "<span style='font-weight:bold;color:blue'>Portfolio_value:</span> <span style='font-weight:bold;color:red'><b> %{customdata[0]}</b></span><br>");


        Market = px.area(self.Dataset["retail"]["Market_PCT"])
        Market.update_traces(line=dict(color = 'rgba(0,250,0,0.9)'),
                              )

        Market.update_traces(
            customdata = self.Dataset["retail"][["spy","Market_Cumulative_Absolute","Market_Cumulative_Percentage"]].round(3).values,
                        hovertemplate = "<br>"+                           "<span style='font-weight:bold;color:blue'>Market: </span> <span style='font-weight:bold;color:red'><b>%{y}</b></span><br>"+                           "<span style='font-weight:bold;color:blue'>Absolut_Gain:</span> <span style='font-weight:bold;color:red'><b> %{customdata[1]}</b></span><br>"+                           "<span style='font-weight:bold;color:blue'>Market_value:</span> <span style='font-weight:bold;color:red'><b> %{customdata[0]}</b></span><br>");
        #fig2.update_yaxes(showspikes=True, spikecolor="orange", spikethickness=2)
        P_VS_M = go.Figure(data=Portfolio.data + Market.data)
        #P_VS_M.update_layout(title_text='Witcher Portfolio VS Market Cumulative Percantage Return')
        P_VS_M.update_layout( title={
                    'text' :'Witcher Portfolio VS Market Cumulative Percantage Return',
                    'x':0.45,
                    'xanchor': 'center'})


        P_VS_M.update_layout(hovermode=("x unified"),hoverlabel=dict(bgcolor='rgba(160,170,180,0.50)'))

        P_VS_M.update_yaxes(showspikes=True, spikecolor="orange", spikethickness=2,title_text='Profit Percentage')
        P_VS_M.update_xaxes(title_text='Date-Time/Daily')
        #P_VS_M.update_yaxes(title_text='Value A')
        P_VS_M.update_layout(legend=dict(
                        yanchor="top",
                        y=0.99,
                        xanchor="left",
                        x=0.01
                    ),autosize=True,
                            width=900,
                            height=500)
        P_VS_M.show()

        
    def __MC_plot(self):


        df = pd.DataFrame(columns=(["IV","P_Return","Sharp_ratio","Weight"]))
        df["IV"]=self.mc_portfolio_vol
        df["P_Return"]=self.mc_portfolio_returns
        df["Sharp_ratio"]=self.mc_sharpe_ratios
        df["Weight"]=self.PortFolio_Report["IV"]
        df=df.replace([np.inf, -np.inf,np.nan], 0)
        df=df.dropna()
        
        

        tem=pd.DataFrame(self.PortFolio_Report["IV"]).T
        for col in tem.columns:
            df[col]=tem[col].values
        
        df=df.round(4)

        self.DF=df



        #df
        MC_fic = px.scatter(df, x="IV", y="P_Return", color="Sharp_ratio",
                            size='P_Return', hover_data=['Weight']+self.Portfolio)
        MC_fic.update_layout(autosize=True)
        MC_fic.show()
        
    
    def __adjust(self,x):
        if x <=0:
            return (x+1)*0.03
        else:
            return x
        
    
    def __MC_PLT(self):
        df = pd.DataFrame(columns=(["IV","P_Return","Sharp_ratio","Weight"]))
        df["IV"]=self.mc_portfolio_vol
        df["P_Return"]=self.mc_portfolio_returns
        df["Sharp_ratio"]=self.mc_sharpe_ratios
        df["Weight"]=self.PortFolio_Report["IV"]
        df=df.replace([np.inf, -np.inf,np.nan], 0)
        df=df.dropna()
        
        

        tem=pd.DataFrame(self.PortFolio_Report["IV"]).T
        for col in tem.columns:
            df[col]=tem[col].values

        df=df.round(4)
        self.DF=df

        
        df["Adjust_P_Return"]=df.apply(lambda x: adjust(x.P_Return), axis=1)
        fig = px.scatter(df, x="IV", y="P_Return", color="Sharp_ratio",
                            size='Adjust_P_Return', hover_data=['Weight']+self.Portfolio)
        fig.show()






        
    def __Portfolio_vs_Market(self):
        


        P_VS_M_Gauge = go.Figure()

        P_VS_M_Gauge.add_trace(go.Indicator(
            value = self.PortFolio_Report["Gain"]["Portfolio"]["Absolute_Gain"],
            delta = {'reference': self.PortFolio_Report["Gain"]["Market"]["Absolute_Gain"]},
            gauge = {
                'axis': {'visible': True},

                'bar': {'color': "lawngreen",'thickness': 0.3},

                'bgcolor': "white",
                'borderwidth': 2,
                'bordercolor': "gray",
                'steps': [
                    {'range': [0, self.PortFolio_Report["Gain"]["Market"]["Absolute_Gain"]],
                     'color': 'gray'},
                    {'range': [self.PortFolio_Report["Gain"]["Market"]["Absolute_Gain"], 
                               self.PortFolio_Report["Gain"]["Market"]["Absolute_Gain"]*1.25],
                     'color': 'orange'}],
                'threshold': {
                    'line': {'color': "red", 'width': 4},
                    'thickness': 0.75,
                    }},
            domain = {'row': 0, 'column': 0},
            title = {'text': "Profit Absolut Gain ", 'font': {'size': 24}},
        ))

        P_VS_M_Gauge.add_trace(go.Indicator(
            value = self.PortFolio_Report["Gain"]["Portfolio"]["Percentage_Gain"],
            delta = {'reference': self.PortFolio_Report["Gain"]["Market"]["Percentage_Gain"]},
            gauge = {
                'axis': {'visible': True}},
            domain = {'row': 0, 'column': 1},
            title = {'text': "Profit Percentage", 'font': {'size': 24}},
        ))



        P_VS_M_Gauge.update_layout(autosize=True,
                       
            grid = {'rows': 1, 'columns': 2, 'pattern': "independent"},
            template = {'data' : {'indicator': [{
                #'title': {'text': "Speed"},
                'mode' : "number+delta+gauge",
                'delta' : {'reference': 90}}]
                                 }})
        P_VS_M_Gauge.show()
        
    ############################## stock percentage plot ###################
    def __Selected_Stock(self):
    
        print(self.PortFolio_Report["Best_Weight"]["Report"])


        Percent_stock_fig= px.pie(self.PortFolio_Report["Best_Weight"]["Report"].keys(),
                     values=self.PortFolio_Report["Best_Weight"]["Report"].values(),
                     names=self.PortFolio_Report["Best_Weight"]["Report"].keys(),       
                    #color_discrete_sequence=px.colors.sequential.Sunset
                    color_discrete_sequence=px.colors.cyclical.HSV
                      )
        Percent_stock_fig.update_layout( title={
                            'text' :'Witcher Portfolio selected stock percentage %',
                            'x':0.5,
                            'xanchor': 'center'})
        
        Percent_stock_fig.show()
        
        market=self.PortFolio_Report["Best_Weight"]["Report"]

        market_0=[i for i in market.keys() if market[i] >= 0.05]
        market_0
        
        for SYM in market_0:
            self.__OCLH(SYM)
            

        
    def __OCLH(self,SYM):
        Y_label=SYM + " Stock price "
        Title='       Witcher Open,Close,Low, High Graph.   '+SYM + "  stock %s is selected"%(self.PortFolio_Report["Best_Weight"]["Report"][SYM])
        tem=self.Dataset[SYM]
        SYM = go.Figure(data=go.Ohlc(x=tem.index,
                        open=tem['Open'],
                        high=tem['High'],
                        low=tem['Low'],
                        close=tem['Close']
                         ))
        SYM.update_layout(
        title=Title,
        yaxis_title=Y_label)
        SYM.update_yaxes(showspikes=True, spikecolor="orange", spikethickness=2,title_text=Y_label)
        SYM.update_xaxes(title_text='Date-Time/Daily',showspikes=True,)
        #P_VS_M.update_yaxes(title_text='Value A')
        SYM.update_layout(legend=dict(
                        yanchor="top",
                        y=0.99,
                        xanchor="left",
                        x=0.01
                    ))
        SYM.show()







..