# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['ColabStreamlit']

# Cell
import os
import subprocess
from pyngrok import ngrok

# Cell
class ColabStreamlit():
    def __init__(self, path, port=10000):
        self.port = port
        self.path = path
        self._start_server()
        self.run_app()

    def _start_server(self):
        active_tunnels = ngrok.get_tunnels()
        for tunnel in active_tunnels:
            public_url = tunnel.public_url
            ngrok.disconnect(public_url)
        url = ngrok.connect(port=self.port, **{"bind_tls": True}, return_ngrok_tunnel=True)
        print(f'Streamlit app can be accessed on: {url.public_url}')

    def run_app(self, debug=False):
        os.system(f"fuser -n tcp -k {self.port}")
        cmd = f'streamlit {self.path} --server.port {self.port}'
        with subprocess.Popen(
            [cmd],
            shell=True,
            stdout=subprocess.PIPE,
            bufsize=1,
            universal_newlines=True,
            ) as proc:
                for line in proc.stdout:
                    if debug: print(line, end="")