# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpgradeEngineVersionRequest(JDCloudRequest):
    """
    升级TiDB引擎版本，例如从4.0.6 升级到4.0.8. 目前支持小版本的升级，可升级到平台支持的最新的小版本
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(UpgradeEngineVersionRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:upgradeEngineVersion', 'POST', header, version)
        self.parameters = parameters


class UpgradeEngineVersionParameters(object):

    def __init__(self, regionId,instanceId,):
        """
        :param regionId: 地域代码
        :param instanceId: 实例ID
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.version = None
        self.timing = None

    def setVersion(self, version):
        """
        :param version: (Optional) 升级后的版本号
        """
        self.version = version

    def setTiming(self, timing):
        """
        :param timing: (Optional) 版本升级的时间点,时间格式yyyy-mm-dd hh:mm:ss。不传或者传入空表示取消升级
        """
        self.timing = timing

