# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ZoneResolveCountRequest(JDCloudRequest):
    """
    统计zone的解析量

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ZoneResolveCountRequest, self).__init__(
            '/regions/{regionId}/stat:zoneResolveCount', 'POST', header, version)
        self.parameters = parameters


class ZoneResolveCountParameters(object):

    def __init__(self, regionId, start, end, ):
        """
        :param regionId: 地域ID
        :param start: 查询时间段的起始时间, UTC时间格式，例如2017-11-10T23:00:00Z
        :param end: 查询时间段的终止时间, UTC时间格式，例如2017-11-10T23:00:00Z
        """

        self.regionId = regionId
        self.start = start
        self.end = end
        self.zoneIds = None
        self.vpcIds = None

    def setZoneIds(self, zoneIds):
        """
        :param zoneIds: (Optional) 查询的zone id，默认查询所有zone
        """
        self.zoneIds = zoneIds

    def setVpcIds(self, vpcIds):
        """
        :param vpcIds: (Optional) 查询的vpc id，默认查询所有vpc
        """
        self.vpcIds = vpcIds

