# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifyResourceRecordRequest(JDCloudRequest):
    """
    修改解析记录

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifyResourceRecordRequest, self).__init__(
            '/regions/{regionId}/zone/{zoneId}/resourceRecord/{resourceRecordId}', 'PUT', header, version)
        self.parameters = parameters


class ModifyResourceRecordParameters(object):

    def __init__(self, regionId, zoneId, resourceRecordId, ):
        """
        :param regionId: 地域ID
        :param zoneId: zone id
        :param resourceRecordId: 解析记录ID
        """

        self.regionId = regionId
        self.zoneId = zoneId
        self.resourceRecordId = resourceRecordId
        self.hostRecord = None
        self.hostValue = None
        self.recordType = None
        self.ttl = None
        self.priority = None
        self.port = None
        self.weight = None

    def setHostRecord(self, hostRecord):
        """
        :param hostRecord: (Optional) 主机记录
        """
        self.hostRecord = hostRecord

    def setHostValue(self, hostValue):
        """
        :param hostValue: (Optional) 主机记录值
        """
        self.hostValue = hostValue

    def setRecordType(self, recordType):
        """
        :param recordType: (Optional) 解析类型，目前支持类型 A AAAA CNAME TXT CAA SRV MX PTR
        """
        self.recordType = recordType

    def setTtl(self, ttl):
        """
        :param ttl: (Optional) TTL值
        """
        self.ttl = ttl

    def setPriority(self, priority):
        """
        :param priority: (Optional) 优先级，只存在于MX, SRV解析记录类型
        """
        self.priority = priority

    def setPort(self, port):
        """
        :param port: (Optional) 端口，只存在于SRV解析记录类型
        """
        self.port = port

    def setWeight(self, weight):
        """
        :param weight: (Optional) 解析记录的权重，目前支持权重的有：A/AAAA/CNAME，A/AAAA权重范围0-100，CNAME权重范围1-100。
        """
        self.weight = weight

