# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeLiveStreamPublishInfoByPageRequest(JDCloudRequest):
    """
    查询推流码率、帧率
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeLiveStreamPublishInfoByPageRequest, self).__init__(
            '/describeLiveStreamPublishInfoByPage', 'GET', header, version)
        self.parameters = parameters


class DescribeLiveStreamPublishInfoByPageParameters(object):

    def __init__(self, domainName, startTime, ):
        """
        :param domainName: 推流域名
        :param startTime: 起始时间
- UTC时间
  格式:yyyy-MM-dd'T'HH:mm:ss'Z'
  示例:2018-10-21T10:00:00Z

        """

        self.domainName = domainName
        self.appName = None
        self.streamName = None
        self.startTime = startTime
        self.endTime = None
        self.pageNumber = None
        self.pageSize = None

    def setAppName(self, appName):
        """
        :param appName: (Optional) 应用名称
        """
        self.appName = appName

    def setStreamName(self, streamName):
        """
        :param streamName: (Optional) 流名称
        """
        self.streamName = streamName

    def setEndTime(self, endTime):
        """
        :param endTime: (Optional) 结束时间:
- UTC时间
  格式:yyyy-MM-dd'T'HH:mm:ss'Z'
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间

        """
        self.endTime = endTime

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码，起始页码1

        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 每页最大记录数，取值：[10,1000]，默认：100

        """
        self.pageSize = pageSize

