# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class Backend(object):

    def __init__(self, backendId=None, backendName=None, loadBalancerId=None, loadBalancerType=None, protocol=None, port=None, algorithm=None, targetGroupIds=None, agIds=None, proxyProtocol=None, description=None, connectionDrainingSeconds=None, sessionStickiness=None, sessionStickyTimeout=None, httpCookieExpireSeconds=None, httpForwardedProtocol=None, httpForwardedPort=None, httpForwardedHost=None, httpForwardedVip=None, httpForwardedClientPort=None, healthCheck=None, createdTime=None):
        """
        :param backendId: (Optional) 后端服务的Id
        :param backendName: (Optional) 后端服务的名字
        :param loadBalancerId: (Optional) 后端服务所属loadBalancer的Id
        :param loadBalancerType: (Optional) 后端服务所属负载均衡类型，取值为：alb、nlb、dnlb
        :param protocol: (Optional) 后端服务的协议 <br>【alb】包括Http，Tcp <br>【nlb】包括Tcp，Udp <br>【dnlb】包括Tcp，Udp
        :param port: (Optional) 后端服务的端口，取值范围为[1, 65535]
        :param algorithm: (Optional) 调度算法 <br>【alb,nlb】取值范围为[IpHash, RoundRobin, LeastConn]（取值范围的含义：加权源Ip哈希，加权轮询和加权最小连接） <br>【dnlb】取值范围为[IpHash, QuintupleHash]（取值范围的含义分别为：加权源Ip哈希和加权五元组哈希）
        :param targetGroupIds: (Optional) 虚拟服务器组的Id列表，目前只支持一个，且与agIds不能同时存在
        :param agIds: (Optional) 高可用组的Id列表，目前只支持一个，且与targetGroupIds不能同时存在
        :param proxyProtocol: (Optional) 【alb Tcp/Udp协议】通过Proxy Protocol协议获取真实ip, 取值为False(不获取)或者True(获取,支持v1版本)
        :param description: (Optional) 后端服务的描述信息
        :param connectionDrainingSeconds: (Optional) 【nlb】连接耗尽超时，移除target前连接的最大保持时间，范围[0，3600]
        :param sessionStickiness: (Optional) 会话保持, 取值为false(不开启)或者true(开启) <br>【alb Http协议，RoundRobin算法】支持基于cookie的会话保持 <br>【nlb】支持基于报文源目的IP的会话保持
        :param sessionStickyTimeout: (Optional) 【nlb】会话保持超时时间，sessionStickiness开启时生效，默认300s, 范围[1-3600]
        :param httpCookieExpireSeconds: (Optional) 【alb Http协议】cookie的过期时间,sessionStickiness开启时生效，取值范围为[0,86400], 0表示cookie与浏览器同生命周期
        :param httpForwardedProtocol: (Optional) 【alb http协议】获取负载均衡的协议, 取值为False(不获取)或True(获取)
        :param httpForwardedPort: (Optional) 【alb http协议】获取负载均衡的端口, 取值为False(不获取)或True(获取)
        :param httpForwardedHost: (Optional) 【alb http协议】获取负载均衡的host信息, 取值为False(不获取)或True(获取)
        :param httpForwardedVip: (Optional) 【alb http协议】获取负载均衡的vip, 取值为False(不获取)或True(获取)
        :param httpForwardedClientPort: (Optional) 【alb Http协议】获取请求端使用的端口, 取值为False(不获取)或True(获取)
        :param healthCheck: (Optional) 健康检查,数据结构：<br>protocol（string）健康检查协议,【ALB、NLB】取值为Http, Tcp，【DNLB】取值为Tcp;<br>healthyThresholdCount（integer）健康阀值，取值范围为[1,5]，默认为3;<br>unhealthyThresholdCount（integer）不健康阀值，取值范围为[1,5], 默认为3;<br>checkTimeoutSeconds（integer）响应超时时间, 取值范围为[2,60]，默认为3s;<br>intervalSeconds（integer）健康检查间隔, 范围为[5,300], 默认为5s;<br>port（integer）检查端口, 取值范围为[0,65535], 默认为0，默认端口为每个后端服务器接收负载均衡流量的端口;<br>httpDomain（string）【Http协议】检查域名;<br>httpPath（string）【Http协议】检查路径, 健康检查的目标路径，必须以"/"开头，允许输入具体的文件路径，默认为根目录;<br>httpCode（[]string）【Http协议】检查来自后端服务器的成功响应时，要使用的HTTP状态码。您可以指定：单个数值（例如："200"，取值范围200-499）、一段连续数值（例如："201-205"，取值范围范围200-499，且前面的参数小于后面）和一类连续数值缩写（例如："3xx"，等价于"300-399"，取值范围2xx、3xx和4xx）。多个数值之间通过","分割（例如："200,202-207,302,4xx"）。目前仅支持2xx、3xx、4xx。
        :param createdTime: (Optional) 后端服务的创建时间
        """

        self.backendId = backendId
        self.backendName = backendName
        self.loadBalancerId = loadBalancerId
        self.loadBalancerType = loadBalancerType
        self.protocol = protocol
        self.port = port
        self.algorithm = algorithm
        self.targetGroupIds = targetGroupIds
        self.agIds = agIds
        self.proxyProtocol = proxyProtocol
        self.description = description
        self.connectionDrainingSeconds = connectionDrainingSeconds
        self.sessionStickiness = sessionStickiness
        self.sessionStickyTimeout = sessionStickyTimeout
        self.httpCookieExpireSeconds = httpCookieExpireSeconds
        self.httpForwardedProtocol = httpForwardedProtocol
        self.httpForwardedPort = httpForwardedPort
        self.httpForwardedHost = httpForwardedHost
        self.httpForwardedVip = httpForwardedVip
        self.httpForwardedClientPort = httpForwardedClientPort
        self.healthCheck = healthCheck
        self.createdTime = createdTime
