# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class TextTaskV2(object):

    def __init__(self, dataId=None, content=None, title=None, dataType=None, callback=None, publishTime=None, callbackUrl=None):
        """
        :param dataId: (Optional) 数据唯一标识，能够根据该值定位到该条数据
        :param content: (Optional) 待检测文本，最长10000个字符, 用户发表内容，建议对内容中JSON、表情符、HTML标签、UBB标签等做过滤，只传递纯文本，以减少误判概率。请注意为了检测效果和性能，如果该字段长度超过10000字符，会截取前面10000字符进行检测和存储。该字段不能为空，如果为空会返回参数错误。
        :param title: (Optional) 内容标题，适用于贴子、博客的文章标题等场景，建议抄送，辅助机审策略精准调优
        :param dataType: (Optional) 子数据类型
        :param callback: (Optional) 数据回调参数，调用方根据业务情况自行设计，当调用文本离线结果获取接口时，该接口会原样返回该字段，详细见文本离线检测结果获取。作为数据处理标识，因此该字段应该设计为能唯一定位到该次请求的数据结构，如对用户的昵称进行检测，dataId可设为用户标识（用户ID），用户修改多次，每次请求数据的dataId可能一致，但是callback参数可以设计成定位该次请求的数据结构，比如callback字段设计成json，包含dataId和请求的时间戳等信息，当然如果不想做区分，也可以直接把callback设置成dataId的值
        :param publishTime: (Optional) 用户发表时间，UNIX 时间戳(毫秒值)
        :param callbackUrl: (Optional) 人工审核结果回调通知到客户的URL。主动回调数据接口超时时间设置为2s，为了保证顺利接收数据，需保证接收接口性能稳定并且保证幂等性业务扩展参数
        """

        self.dataId = dataId
        self.content = content
        self.title = title
        self.dataType = dataType
        self.callback = callback
        self.publishTime = publishTime
        self.callbackUrl = callbackUrl
