# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class AddProtectedIpRequest(JDCloudRequest):
    """
    添加防护包防护 IP. <br>- 防护包仅能防护防护包实例所在区域的公网 IP, 且该公网 IP 未被其他防护包防护, 如果已经被其他防护包防护, 请先调用删除防护包防护 IP 接口删除防护 IP<br>- 防护包可添加的防护 IP 个数小于等于防护包的可防护 IP 数量减去已防护的 IP 数量<br>- 使用 <a href='http://docs.jdcloud.com/anti-ddos-protection-package/api/describeelasticipresources'>describeElasticIpResources</a> 接口查询防护包可防护的弹性公网 IP<br>- 使用 <a href='http://docs.jdcloud.com/anti-ddos-protection-package/api/describecpsipresources'>describeCpsIpResources</a> 接口查询防护包可防护的云物理服务器公网 IP<br>- 使用 <a href='http://docs.jdcloud.com/anti-ddos-protection-package/api/describewafipresources'>describeWafIpResources</a> 接口查询防护包可防护的Web应用防火墙公网 IP<br>- 使用 <a href='http://docs.jdcloud.com/anti-ddos-protection-package/api/describeccsipresources'>describeCcsIpResources</a> 接口查询防护包可防护的托管区公网 IP
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(AddProtectedIpRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:addProtectedIp', 'POST', header, version)
        self.parameters = parameters


class AddProtectedIpParameters(object):

    def __init__(self, regionId, instanceId, protectedIpSpec):
        """
        :param regionId: 地域 Id, DDoS 防护包目前支持华北-北京, 华东-宿迁, 华东-上海
        :param instanceId: 防护包实例 Id
        :param protectedIpSpec: 添加防护包防护 IP 请求参数
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.protectedIpSpec = protectedIpSpec

