# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Team(pulumi.CustomResource):
    description: pulumi.Output[str]
    """
    A description of the team.
    """
    etag: pulumi.Output[str]
    ldap_dn: pulumi.Output[str]
    """
    The LDAP Distinguished Name of the group where membership will be synchronized. Only available in GitHub Enterprise.
    """
    name: pulumi.Output[str]
    """
    The name of the team.
    """
    node_id: pulumi.Output[str]
    parent_team_id: pulumi.Output[float]
    """
    The ID of the parent team, if this is a nested team.
    """
    privacy: pulumi.Output[str]
    """
    The level of privacy for the team. Must be one of `secret` or `closed`.
    Defaults to `secret`.
    """
    slug: pulumi.Output[str]
    """
    The slug of the created team, which may or may not differ from `name`,
    depending on whether `name` contains "URL-unsafe" characters.
    Useful when referencing the team in [`.BranchProtection`](https://www.terraform.io/docs/providers/github/r/branch_protection.html).
    """
    def __init__(__self__, resource_name, opts=None, description=None, ldap_dn=None, name=None, parent_team_id=None, privacy=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a GitHub team resource.

        This resource allows you to add/remove teams from your organization. When applied,
        a new team will be created. When destroyed, that team will be removed.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_github as github

        # Add a team to the organization
        some_team = github.Team("someTeam",
            description="Some cool team",
            privacy="closed")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the team.
        :param pulumi.Input[str] ldap_dn: The LDAP Distinguished Name of the group where membership will be synchronized. Only available in GitHub Enterprise.
        :param pulumi.Input[str] name: The name of the team.
        :param pulumi.Input[float] parent_team_id: The ID of the parent team, if this is a nested team.
        :param pulumi.Input[str] privacy: The level of privacy for the team. Must be one of `secret` or `closed`.
               Defaults to `secret`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['ldap_dn'] = ldap_dn
            __props__['name'] = name
            __props__['parent_team_id'] = parent_team_id
            __props__['privacy'] = privacy
            __props__['etag'] = None
            __props__['node_id'] = None
            __props__['slug'] = None
        super(Team, __self__).__init__(
            'github:index/team:Team',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, description=None, etag=None, ldap_dn=None, name=None, node_id=None, parent_team_id=None, privacy=None, slug=None):
        """
        Get an existing Team resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the team.
        :param pulumi.Input[str] ldap_dn: The LDAP Distinguished Name of the group where membership will be synchronized. Only available in GitHub Enterprise.
        :param pulumi.Input[str] name: The name of the team.
        :param pulumi.Input[float] parent_team_id: The ID of the parent team, if this is a nested team.
        :param pulumi.Input[str] privacy: The level of privacy for the team. Must be one of `secret` or `closed`.
               Defaults to `secret`.
        :param pulumi.Input[str] slug: The slug of the created team, which may or may not differ from `name`,
               depending on whether `name` contains "URL-unsafe" characters.
               Useful when referencing the team in [`.BranchProtection`](https://www.terraform.io/docs/providers/github/r/branch_protection.html).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["etag"] = etag
        __props__["ldap_dn"] = ldap_dn
        __props__["name"] = name
        __props__["node_id"] = node_id
        __props__["parent_team_id"] = parent_team_id
        __props__["privacy"] = privacy
        __props__["slug"] = slug
        return Team(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

